(* Parser/lexer generation

 Windows
   cd H:\Desktop\HighFun
   bin\fslex --unicode FunLex.fsl
   bin\fsyacc --module FunPar FunPar.fsy

 Mac Os
   cd /Users/tinelli/Desktop/HighFun
   mono bin/fslex.exe --unicode FunLex.fsl
   mono bin/fsyacc.exe --module FunPar FunPar.fsy

*)

// Windows
   #r "H:\Desktop\HighFun\\bin\FsLexYacc.Runtime.dll"
   #load "H:\Desktop\HighFun\Absyn.fs" 
   #load "H:\Desktop\HighFun\FunPar.fs"
   #load "H:\Desktop\HighFun\FunLex.fs" 
   #load "H:\Desktop\HighFun\Parse.fs" 
   #load "H:\Desktop\HighFun\HighFun.fs"


// Mac Os
   #r "/Users/tinelli/Desktop/HighFun/bin/FsLexYacc.Runtime.dll"
   #load "/Users/tinelli/Desktop/HighFun/Absyn.fs" 
   #load "/Users/tinelli/Desktop/HighFun/FunPar.fs"
   #load "/Users/tinelli/Desktop/HighFun/FunLex.fs" 
   #load "/Users/tinelli/Desktop/HighFun/Parse.fs" 
   #load "/Users/tinelli/Desktop/HighFun/Inter.fs"

open Absyn

let fromString = Parse.fromString
let eval = HighFun.eval
let run = HighFun.run


let ex1 = fromString "
let add x = let addx y = x + y in addx end 
in
  add 3 4
end
"

run ex1


let ex2 = fromString "
let add x = let addx y = x + y in addx end 
in
  add 3
end
"

run ex2


let ex3 = fromString "
let twice f = let twicef x = f (f x) in twicef end
in
  let inc x = x + 1 
  in
    twice inc 3
  end 
end 
"

run ex3


let ex4 = fromString "
let compose f = 
  let composef g = 
    let composefg x = f (g x) in 
      composefg
    end 
  in
    composef 
  end
in
  let inc x = x + 1 in
  let square x = x * x in
    compose inc square 3
  end end
end 
"

run ex4

