﻿
(* Parser/lexer generation

   cd H:\Desktop\Expr
   bin\fslex --unicode ExprLex.fsl
   bin\fsyacc --module ExprPar ExprPar.fsy
*)


// Windows only
#r "H:\Desktop\Expr\\bin\FsLexYacc.Runtime.dll"
#load "H:\Desktop\Expr\Absyn.fs" 
#load "H:\Desktop\Expr\ExprPar.fs"
#load "H:\Desktop\Expr\ExprLex.fs" 
#load "H:\Desktop\Expr\Parse.fs" 
#load "H:\Desktop\Expr\Expr.fs"


// MacOs only
#r "/Users/tinelli/Desktop/Expr/bin/FsLexYacc.Runtime.dll"
#load "/Users/tinelli/Desktop/Expr/Absyn.fs" 
#load "/Users/tinelli/Desktop/Expr/ExprPar.fs"
#load "/Users/tinelli/Desktop/Expr/ExprLex.fs" 
#load "/Users/tinelli/Desktop/Expr/Parse.fs" 
#load "/Users/tinelli/Desktop/Expr/Expr.fs"


open Parse
open Expr



// interpreter for expressions with no free variables
let run p = eval (fromString p) []


run "2 + 3 * 4"


run "
 let x = 2 in 
   4 * let y = 3 in x + y end + 1
 end
"

run "
  let x = 1 in 
    let x = 2 in
      x
    end
  end
"

run "
  let x = 1 in 
    let x = 2 in x + x end + x
  end
"
// compiler for expressions with no free variables
let compile p = scomp (fromString p) []


let p1 = "2 + 3 * 4" 
let p2 = "let x = 2 in 2 + x * 4 end"
let p3 = "
  let x = 2 in 
    let y = 3 in 
      x + y
    end
  end
"
let p4 = "
 let x = 2 in 
   4 * let y = 3 in x + y end + 1
 end
"

let p5 = "
  let x = 1 in 
    let x = 2 in x + x end + x
  end
"

// program compilation and execution

let code1 = compile p1
seval code1 []

let code2 = compile p2
seval code2 []

let code3 = compile p3
seval code3 []

let code4 = compile p4
seval code4 []

let code5 = compile p5
seval code5 []


(compile "let x = 1 in x+1 end") = (compile "let y = 1 in y + 1 end")

