/*
 * Decompiled with CFR 0.152.
 */
package rvl.util;

import java.lang.reflect.Method;
import rvl.util.Utility;

public class NumAnal {
    static double aiFac = 10.0;
    static double AA = 0.0;
    static double BB = 1.0;
    static int fCount = 0;
    static int maxFcnCalls = 2000;
    static final Class[] oneDoubleArg = new Class[]{Double.TYPE};
    static Method fMethod;
    static Method gMethod;
    static Object caller;
    static Object gCaller;
    static /* synthetic */ Class class$rvl$util$NumAnal;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static double f(double d) {
        if (++fCount > maxFcnCalls) {
            return Utility.NaN("integral(): too many function calls");
        }
        try {
            return (Double)fMethod.invoke(caller, (Object[])new Double[]{new Double(d)});
        }
        catch (Exception exception) {
            Utility.warning("Error in f(): " + exception);
            Utility.warning("fMethod = " + fMethod + ", caller = " + caller);
            return Double.NaN;
        }
    }

    public static double fHalfLine(double d) {
        try {
            double d2 = AA + BB * d / (1.0 - d);
            double d3 = BB / (1.0 - d) / (1.0 - d);
            double d4 = (Double)gMethod.invoke(gCaller, (Object[])new Double[]{new Double(d2)});
            return d4 * d3;
        }
        catch (Exception exception) {
            return Utility.NaN("Error in fHalfLine(): " + exception);
        }
    }

    public static int getCallCount() {
        return fCount;
    }

    public static synchronized double integral(Class clazz, String string, double d, double d2, double d3) {
        return NumAnal.integral(clazz, string, d, d2, d3, false, Double.NaN, Double.NaN);
    }

    public static synchronized double integral(Class clazz, String string, double d, double d2, double d3, boolean bl) {
        return NumAnal.integral(clazz, string, d, d2, d3, bl, Double.NaN, Double.NaN);
    }

    public static synchronized double integral(Class clazz, String string, double d, double d2, double d3, boolean bl, double d4, double d5) {
        boolean bl2 = Double.isInfinite(d);
        boolean bl3 = Double.isInfinite(d2);
        if (bl2 || bl3) {
            if (bl2 && bl3) {
                double d6 = NumAnal.integral(clazz, string, d, AA, d3 / 2.0, true, 0.0, 0.0);
                int n = fCount;
                double d7 = NumAnal.integral(clazz, string, AA, d2, d3 / 2.0, true, 0.0, 0.0);
                fCount += n;
                return d6 + d7;
            }
            if (bl2) {
                AA = d2;
                BB = -Math.abs(BB);
                gMethod = NumAnal.setupMethod(clazz, string);
                return -NumAnal.integral(class$rvl$util$NumAnal != null ? class$rvl$util$NumAnal : (class$rvl$util$NumAnal = NumAnal.class$("rvl.util.NumAnal")), "fHalfLine", 0.0, 1.0, d3, true, 0.0, 0.0);
            }
            AA = d;
            BB = Math.abs(BB);
            gMethod = NumAnal.setupMethod(clazz, string);
            return NumAnal.integral(class$rvl$util$NumAnal != null ? class$rvl$util$NumAnal : (class$rvl$util$NumAnal = NumAnal.class$("rvl.util.NumAnal")), "fHalfLine", 0.0, 1.0, d3, true, 0.0, 0.0);
        }
        fMethod = NumAnal.setupMethod(clazz, string);
        fCount = 0;
        double d8 = (d + d2) / 2.0;
        double d9 = NumAnal.f(d8);
        if (Double.isNaN(d4 + d5 + d9)) {
            return Utility.NaN("integral: NaN in function evaluation");
        }
        if (bl) {
            double d10 = (d2 - d) / 4.0;
            double d11 = NumAnal.f(d + d10);
            double d12 = NumAnal.f(d2 - d10);
            double d13 = 4.0 * d10 * (2.0 * (d11 + d12) - d9) / 3.0;
            return NumAnal.openRefineIntegral(d, d8, d2, d11, d9, d12, d13, d3);
        }
        if (Double.isNaN(d4)) {
            d4 = NumAnal.f(d);
        }
        if (Double.isNaN(d5)) {
            d5 = NumAnal.f(d2);
        }
        double d14 = (d4 + 4.0 * d9 + d5) * (d2 - d) / 6.0;
        return NumAnal.refineIntegral(d, d8, d2, d4, d9, d5, d14, d3);
    }

    public static synchronized double integral(Object object, String string, double d, double d2, double d3) {
        return NumAnal.integral(object, string, d, d2, d3, false, Double.NaN, Double.NaN);
    }

    public static synchronized double integral(Object object, String string, double d, double d2, double d3, boolean bl) {
        return NumAnal.integral(object, string, d, d2, d3, bl, Double.NaN, Double.NaN);
    }

    public static synchronized double integral(Object object, String string, double d, double d2, double d3, boolean bl, double d4, double d5) {
        caller = object;
        return NumAnal.integral(object.getClass(), string, d, d2, d3, bl, d4, d5);
    }

    static double openRefineIntegral(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = (d3 - d) / 16.0;
        double d10 = 4.0 * d9 / 3.0;
        double d11 = NumAnal.f(d + d9);
        double d12 = NumAnal.f(d + 2.0 * d9);
        double d13 = NumAnal.f(d + 3.0 * d9);
        double d14 = NumAnal.f(d3 - 3.0 * d9);
        double d15 = NumAnal.f(d3 - 2.0 * d9);
        double d16 = NumAnal.f(d3 - d9);
        double d17 = d10 * (2.0 * (d11 + d13) - d12);
        double d18 = d10 * (d4 + 4.0 * d5 + d6);
        double d19 = d10 * (2.0 * (d14 + d16) - d15);
        double d20 = d17 + d18 + d19;
        if (Double.isNaN(d17 + d19)) {
            return Utility.NaN("openRefineIntegral: NaN in function evaluation");
        }
        if (Math.abs(d20 - d7) < aiFac * d8) {
            return d20;
        }
        return NumAnal.openRefineIntegral(d, d + 2.0 * d9, d + 4.0 * d9, d11, d12, d13, d17, d8 / 4.0) + NumAnal.refineIntegral(d + 4.0 * d9, d2, d3 - 4.0 * d9, d4, d5, d6, d18, d8 / 2.0) + NumAnal.openRefineIntegral(d3 - 4.0 * d9, d3 - 2.0 * d9, d3, d14, d15, d16, d19, d8 / 4.0);
    }

    static double refineIntegral(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = (d3 - d) / 4.0;
        double d10 = NumAnal.f(d + d9);
        double d11 = NumAnal.f(d3 - d9);
        double d12 = (d4 + 4.0 * d10 + d5) * d9 / 3.0;
        double d13 = (d5 + 4.0 * d11 + d6) * d9 / 3.0;
        if (Double.isNaN(d10 + d11)) {
            return Utility.NaN("refineIntegral: NaN in function evaluation");
        }
        if (Math.abs(d12 + d13 - d7) < aiFac * d8) {
            return d12 + d13;
        }
        return NumAnal.refineIntegral(d, d + d9, d2, d4, d10, d5, d12, d8 / 2.0) + NumAnal.refineIntegral(d2, d3 - d9, d3, d5, d11, d6, d13, d8 / 2.0);
    }

    private static Method setupMethod(Class clazz, String string) {
        try {
            Method method = clazz.getMethod(string, oneDoubleArg);
            if (method.getReturnType().equals(Double.TYPE)) {
                return method;
            }
            Utility.warning(String.valueOf(method.toString()) + ": Wrong return type");
        }
        catch (Exception exception) {
            Utility.warning("method \"" + string + "\" not found\n" + exception);
        }
        return null;
    }
}

