/*
 * Decompiled with CFR 0.152.
 */
package rvl.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import rvl.util.Utility;

public class Plot
extends Component {
    protected double[][] x;
    protected double[][] y;
    protected int defaultDotSize = 5;
    protected int[][] dotSize = new int[][]{{this.defaultDotSize}};
    protected Color[] defaultColor = new Color[]{Color.black, Color.blue, Color.red, Color.green.darker(), Color.orange, Color.darkGray, Color.red.darker(), Color.blue.darker()};
    protected Color[][] dotColor;
    protected Color[][] lineColor;
    protected Color scaleColor = Color.blue.darker();
    protected double[] xTick;
    protected double[] yTick;
    protected String[] xTickLab;
    protected String[] yTickLab;
    protected String[] title = null;
    protected String[] xAxisLab = null;
    protected String[] yAxisLab = null;
    protected boolean xCustomLab = false;
    protected boolean yCustomLab = false;
    protected boolean sameScale = false;
    protected double xMin;
    protected double xMax;
    protected double yMin;
    protected double yMax;
    protected double h0;
    protected double v0;
    protected double h1;
    protected double v1;
    protected double mh;
    protected double mv;
    protected double hMin;
    protected double hMax;
    protected double vMin;
    protected double vMax;
    protected boolean needsRescaling = true;
    protected boolean swap = false;

    public Plot(double[] dArray, double[] dArray2) {
        this(new double[][]{dArray}, (double[][])new double[][]{dArray2});
    }

    public Plot(double[] dArray, double[][] dArray2) {
        this(new double[][]{dArray}, dArray2);
    }

    public Plot(double[][] dArray, double[][] dArray2) {
        this.setData(dArray, dArray2);
        this.setDotMode(true);
        this.setLineMode(false);
        this.setBackground(Color.white);
        this.setFont(new Font("SansSerif", 0, 9));
    }

    public void setData(double[][] dArray, double[][] dArray2, boolean bl) {
        this.x = dArray;
        this.y = dArray2;
        this.needsRescaling = bl;
        this.repaint();
    }

    public void setData(double[][] dArray, double[][] dArray2) {
        this.setData(dArray, dArray2, true);
    }

    public void setData(double[] dArray, double[][] dArray2, boolean bl) {
        this.setData(new double[][]{dArray}, dArray2, bl);
    }

    public void setData(double[] dArray, double[][] dArray2) {
        this.setData(new double[][]{dArray}, dArray2, true);
    }

    public void setData(double[] dArray, double[] dArray2, boolean bl) {
        this.setData(new double[][]{dArray}, (double[][])new double[][]{dArray2}, bl);
    }

    public void setData(double[] dArray, double[] dArray2) {
        this.setData(new double[][]{dArray}, (double[][])new double[][]{dArray2}, true);
    }

    public double[][] getXData() {
        return this.x;
    }

    public void setXData(double[][] dArray, boolean bl) {
        this.x = dArray;
        this.needsRescaling = bl;
        this.repaint();
    }

    public void setXData(double[][] dArray) {
        this.setXData(dArray, true);
    }

    public double[][] getYData() {
        return this.y;
    }

    public void setYData(double[][] dArray, boolean bl) {
        this.y = dArray;
        this.needsRescaling = bl;
        this.repaint();
    }

    public void setYData(double[][] dArray) {
        this.setYData(dArray, true);
    }

    public void setDotMode(boolean bl) {
        if (bl) {
            this.setDotSize(new int[]{this.defaultDotSize});
            this.setDotColor(this.defaultColor);
        } else {
            this.setDotSize((int[][])null);
        }
    }

    public void setLineMode(boolean bl) {
        if (bl) {
            this.setLineColor(this.defaultColor);
        } else {
            this.setLineColor((Color[][])null);
        }
    }

    public void setDotColor(Color color) {
        this.dotColor = new Color[][]{{color}};
    }

    public void setDotColor(Color[] colorArray) {
        this.dotColor = new Color[colorArray.length][1];
        for (int i = 0; i < colorArray.length; ++i) {
            this.dotColor[i][0] = colorArray[i];
        }
    }

    public void setDotColor(Color[][] colorArray) {
        this.dotColor = colorArray;
    }

    public void setDotSize(int n) {
        this.dotSize = new int[][]{{n}};
    }

    public void setDotSize(int[] nArray) {
        this.dotSize = new int[nArray.length][1];
        for (int i = 0; i < nArray.length; ++i) {
            this.dotSize[i][0] = nArray[i];
        }
    }

    public void setDotSize(int[][] nArray) {
        this.dotSize = nArray;
    }

    public void setLineColor(Color color) {
        this.lineColor = new Color[][]{{color}};
    }

    public void setLineColor(Color[] colorArray) {
        this.lineColor = new Color[colorArray.length][1];
        for (int i = 0; i < colorArray.length; ++i) {
            this.lineColor[i][0] = colorArray[i];
        }
    }

    public void setLineColor(Color[][] colorArray) {
        this.lineColor = colorArray;
    }

    public void setDefaultColor(Color[] colorArray) {
        this.defaultColor = colorArray;
    }

    public void setDefaultDotSize(int n) {
        this.defaultDotSize = n;
    }

    public void setScaleColor(Color color) {
        this.scaleColor = color;
    }

    public void setTranspose(boolean bl) {
        this.swap = bl;
        this.needsRescaling = true;
    }

    public void setSameScale(boolean bl) {
        this.sameScale = bl;
    }

    public void setAxisLabels(String[] stringArray, String[] stringArray2) {
        this.xAxisLab = stringArray;
        this.yAxisLab = stringArray2;
    }

    public void setAxisLabels(String string, String string2) {
        this.setAxisLabels(new String[]{string}, new String[]{string2});
    }

    public void setTitle(String[] stringArray) {
        this.title = stringArray;
    }

    public void setTitle(String string) {
        this.setTitle(new String[]{string});
    }

    public void setTickMode(boolean bl, boolean bl2) {
        this.xCustomLab = !bl;
        boolean bl3 = this.yCustomLab = !bl2;
        if (this.xCustomLab) {
            this.xTick = null;
            this.xTickLab = null;
        }
        if (this.yCustomLab) {
            this.yTick = null;
            this.yTickLab = null;
        }
    }

    public void setXTicks(double[] dArray, String[] stringArray) {
        this.xTick = dArray;
        this.xTickLab = stringArray;
        this.xCustomLab = true;
    }

    public void setYTicks(double[] dArray, String[] stringArray) {
        this.yTick = dArray;
        this.yTickLab = stringArray;
        this.yCustomLab = true;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        if (this.needsRescaling) {
            this.rescale();
        }
        this.setScales();
        this.drawBox(graphics);
        if (this.swap) {
            this.drawVAxis(graphics, this.xTick, this.xTickLab, this.xAxisLab);
            this.drawHAxis(graphics, this.yTick, this.yTickLab, this.yAxisLab);
            this.drawLines(graphics, this.y, this.x);
            this.drawDots(graphics, this.y, this.x);
        } else {
            this.drawVAxis(graphics, this.yTick, this.yTickLab, this.yAxisLab);
            this.drawHAxis(graphics, this.xTick, this.xTickLab, this.xAxisLab);
            this.drawLines(graphics, this.x, this.y);
            this.drawDots(graphics, this.x, this.y);
        }
    }

    protected boolean isBad(double d) {
        return Double.isNaN(d) || Double.isInfinite(d);
    }

    protected void rescale() {
        this.yMin = Double.POSITIVE_INFINITY;
        this.xMin = Double.POSITIVE_INFINITY;
        this.yMax = Double.NEGATIVE_INFINITY;
        this.xMax = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.x.length; ++i) {
            for (int j = 0; j < this.x[i].length; ++j) {
                double d = this.x[i][j];
                if (this.isBad(d)) continue;
                this.xMax = Math.max(this.xMax, d);
                this.xMin = Math.min(this.xMin, d);
            }
        }
        if (Double.isInfinite(this.xMin) || Double.isInfinite(this.xMax)) {
            this.xMax = 0.0;
            this.xMin = 0.0;
        }
        if (this.xMin >= this.xMax) {
            this.xMin -= 0.5;
            this.xMax += 0.5;
        }
        double d = 0.05 * (this.xMax - this.xMin);
        this.xMax += d;
        this.xMin -= d;
        for (int i = 0; i < this.y.length; ++i) {
            for (int j = 0; j < this.y[i].length; ++j) {
                double d2 = this.y[i][j];
                if (this.isBad(d2)) continue;
                this.yMax = Math.max(this.yMax, d2);
                this.yMin = Math.min(this.yMin, d2);
            }
        }
        if (Double.isInfinite(this.yMin) || Double.isInfinite(this.yMax)) {
            this.yMax = 0.0;
            this.yMin = 0.0;
        }
        if (this.yMin >= this.yMax) {
            this.yMin -= 0.5;
            this.yMax += 0.5;
        }
        d = 0.05 * (this.yMax - this.yMin);
        this.yMax += d;
        this.yMin -= d;
        if (!this.xCustomLab) {
            this.xTick = Utility.nice(this.xMin, this.xMax, 5, false);
            this.xTickLab = Utility.fmtNice(this.xTick);
        }
        if (!this.yCustomLab) {
            this.yTick = Utility.nice(this.yMin, this.yMax, 5, false);
            this.yTickLab = Utility.fmtNice(this.yTick);
        }
        this.needsRescaling = false;
    }

    private void setScales() {
        int n;
        int n2;
        Dimension dimension = this.getSize();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n3 = fontMetrics.getHeight();
        if (this.sameScale) {
            boolean bl;
            double d;
            double d2;
            double d3;
            double d4;
            double d5 = this.swap ? this.xMax - this.xMin : this.yMax - this.yMin;
            if (d5 / (d4 = (double)dimension.height) < (d3 = this.swap ? this.yMax - this.yMin : this.xMax - this.xMin) / (d2 = (double)dimension.width)) {
                double d6 = d4 * d3 / d2;
                d = 0.5 * (d6 - d5);
                bl = this.swap;
            } else {
                double d7 = d2 * d5 / d4;
                d = 0.5 * (d7 - d3);
                boolean bl2 = bl = !this.swap;
            }
            if (bl) {
                this.xMin -= d;
                this.xMax += d;
                if (!this.xCustomLab) {
                    this.xTick = Utility.nice(this.xMin, this.xMax, 5, false);
                    this.xTickLab = Utility.fmtNice(this.xTick);
                }
            } else {
                this.yMin -= d;
                this.yMax += d;
                if (!this.yCustomLab) {
                    this.yTick = Utility.nice(this.yMin, this.yMax, 5, false);
                    this.yTickLab = Utility.fmtNice(this.yTick);
                }
            }
        }
        if (this.swap) {
            this.hMin = this.yMin;
            this.hMax = this.yMax;
            this.vMin = this.xMin;
            this.vMax = this.xMax;
            int n4 = n2 = this.yTickLab == null ? 0 : n3;
            if (this.yAxisLab != null) {
                n2 += n3 * this.yAxisLab.length;
            }
            int n5 = n = this.xTickLab == null ? 0 : n3;
            if (this.xAxisLab != null) {
                n += n3 * this.xAxisLab.length;
            }
        } else {
            this.hMin = this.xMin;
            this.hMax = this.xMax;
            this.vMin = this.yMin;
            this.vMax = this.yMax;
            int n6 = n2 = this.xTickLab == null ? 0 : n3;
            if (this.xAxisLab != null) {
                n2 += n3 * this.xAxisLab.length;
            }
            int n7 = n = this.yTickLab == null ? 0 : n3;
            if (this.yAxisLab != null) {
                n += n3 * this.yAxisLab.length;
            }
        }
        int n8 = this.title == null ? -n3 / 2 : n3 * this.title.length;
        this.v0 = n3 + n8;
        this.v1 = dimension.height - n3 - n2;
        this.h0 = n3 + n;
        this.h1 = dimension.width - n3 / 2;
        this.mh = (this.h1 - this.h0) / (this.hMax - this.hMin);
        this.mv = (this.v1 - this.v0) / (this.vMax - this.vMin);
    }

    private void drawBox(Graphics graphics) {
        graphics.setColor(this.scaleColor);
        graphics.drawRect((int)this.h0, (int)this.v0, (int)(this.h1 - this.h0), (int)(this.v1 - this.v0));
    }

    private void drawHAxis(Graphics graphics, double[] dArray, String[] stringArray, String[] stringArray2) {
        int n;
        int n2;
        if (dArray == null && stringArray2 == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n3 = fontMetrics.getHeight();
        int n4 = (int)this.v1;
        int n5 = n4 + n3 / 3;
        int n6 = (int)(this.v1 + 1.25 * (double)n3);
        graphics.setColor(this.scaleColor);
        graphics.setFont(this.getFont());
        if (dArray != null) {
            for (n2 = 0; n2 < dArray.length; ++n2) {
                n = (int)(this.h0 + this.mh * (dArray[n2] - this.hMin));
                graphics.drawLine(n, n4, n, n5);
                if (stringArray == null) continue;
                graphics.drawString(stringArray[n2], n -= fontMetrics.stringWidth(stringArray[n2]) / 2, n6);
            }
        } else {
            n6 -= n3;
        }
        if (stringArray2 != null) {
            n6 += n3 / 2 - fontMetrics.getDescent();
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                n6 += n3;
                String string = stringArray2[n2];
                char c = string.toCharArray()[0];
                switch (c) {
                    case '>': {
                        string = string.substring(1);
                        n = (int)(this.h1 - (double)fontMetrics.stringWidth(string));
                        break;
                    }
                    case '<': {
                        string = string.substring(1);
                        n = (int)this.h0;
                        break;
                    }
                    default: {
                        n = (int)(0.5 * (this.h0 + this.h1 - (double)fontMetrics.stringWidth(string)));
                    }
                }
                graphics.drawString(string, n, n6);
            }
        }
        if (this.title == null) {
            return;
        }
        n6 = n3;
        n2 = this.getSize().width;
        for (int i = 0; i < this.title.length; ++i) {
            String string = this.title[i];
            char c = string.toCharArray()[0];
            switch (c) {
                case '>': {
                    string = string.substring(1);
                    n = n2 - fontMetrics.stringWidth(string) - n3 / 2;
                    break;
                }
                case '<': {
                    string = string.substring(1);
                    n = n3 / 2;
                    break;
                }
                default: {
                    n = (n2 - fontMetrics.stringWidth(string)) / 2;
                }
            }
            graphics.drawString(string, n, n6);
            n6 += n3;
        }
    }

    private void drawVAxis(Graphics graphics, double[] dArray, String[] stringArray, String[] stringArray2) {
        Object object;
        int n;
        int n2;
        if (dArray == null && stringArray2 == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n3 = fontMetrics.getHeight();
        int n4 = (int)this.h0;
        int n5 = n4 - n3 / 3;
        int n6 = (int)(this.h0 - 0.5 * (double)n3);
        int n7 = (int)this.h0;
        int n8 = this.getSize().height;
        double d = (double)n8 - this.v1;
        double d2 = (double)n8 - this.v0;
        Image image = this.createImage(n8, n7);
        Graphics graphics2 = image.getGraphics();
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, n8, n7);
        graphics2.setColor(this.scaleColor);
        graphics2.setFont(this.getFont());
        if (dArray != null) {
            for (n2 = 0; n2 < dArray.length; ++n2) {
                n = (int)(d + this.mv * (dArray[n2] - this.vMin));
                graphics2.drawLine(n, n4, n, n5);
                if (stringArray == null) continue;
                graphics2.drawString(stringArray[n2], n -= fontMetrics.stringWidth(stringArray[n2]) / 2, n6);
            }
        } else {
            n6 += n3;
        }
        if (stringArray2 == null) {
            return;
        }
        n6 -= n3;
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            object = stringArray2[n2];
            char c = ((String)object).toCharArray()[0];
            switch (c) {
                case '>': {
                    object = ((String)object).substring(1);
                    n = (int)(d2 - (double)fontMetrics.stringWidth((String)object));
                    break;
                }
                case '<': {
                    object = ((String)object).substring(1);
                    n = (int)d;
                    break;
                }
                default: {
                    n = (int)(0.5 * (d + d2 - (double)fontMetrics.stringWidth((String)object)));
                }
            }
            graphics2.drawString((String)object, n, n6);
            if (n2 == 0) {
                n6 = n3;
                continue;
            }
            n6 += n3;
        }
        graphics2.dispose();
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, true);
        try {
            if (pixelGrabber.grabPixels()) {
                object = (int[])pixelGrabber.getPixels();
                int[] nArray = new int[((Object)object).length];
                int n9 = n8 - 1;
                int n10 = n7 - 1;
                for (int i = 0; i < n8; ++i) {
                    for (int j = 0; j < n7; ++j) {
                        nArray[j + n7 * (n9 - i)] = (int)object[i + n8 * j];
                    }
                }
                image = this.createImage(new MemoryImageSource(n7, n8, nArray, 0, n7));
                graphics.drawImage(image, 0, 0, null);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void drawLines(Graphics graphics, double[][] dArray, double[][] dArray2) {
        if (this.lineColor == null) {
            return;
        }
        int n = dArray.length;
        int n2 = dArray2.length;
        int n3 = this.lineColor.length;
        int n4 = Math.max(n, n2);
        for (int i = 0; i < n4; ++i) {
            this.drawLines(graphics, dArray[i % n], dArray2[i % n2], this.lineColor[i % n3]);
        }
    }

    private void drawLines(Graphics graphics, double[] dArray, double[] dArray2, Color[] colorArray) {
        if (colorArray == null) {
            return;
        }
        int n = dArray.length;
        int n2 = dArray2.length;
        int n3 = colorArray.length;
        int n4 = Math.max(n, n2);
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        for (int i = 0; i < n4; ++i) {
            double d = dArray[i % n];
            double d2 = dArray2[i % n2];
            if (this.isBad(d) || this.isBad(d2)) {
                bl = false;
                continue;
            }
            int n7 = (int)(this.h0 + this.mh * (d - this.hMin));
            int n8 = (int)(this.v0 + this.mv * (this.vMax - d2));
            if (bl) {
                graphics.drawLine(n5, n6, n7, n8);
            }
            n5 = n7;
            n6 = n8;
            Color color = colorArray[i % n3];
            if (color == null) {
                bl = false;
                continue;
            }
            graphics.setColor(color);
            bl = true;
        }
    }

    private void drawDots(Graphics graphics, double[][] dArray, double[][] dArray2) {
        if (this.dotColor == null || this.dotSize == null) {
            return;
        }
        int n = dArray.length;
        int n2 = dArray2.length;
        int n3 = this.dotSize.length;
        int n4 = this.dotColor.length;
        int n5 = Math.max(n, n2);
        for (int i = 0; i < n5; ++i) {
            this.drawDots(graphics, dArray[i % n], dArray2[i % n2], this.dotColor[i % n4], this.dotSize[i % n3]);
        }
    }

    private void drawDots(Graphics graphics, double[] dArray, double[] dArray2, Color[] colorArray, int[] nArray) {
        if (colorArray == null || nArray == null) {
            return;
        }
        int n = dArray.length;
        int n2 = dArray2.length;
        int n3 = colorArray.length;
        int n4 = nArray.length;
        int n5 = Math.max(n, n2);
        for (int i = 0; i < n5; ++i) {
            int n6 = nArray[i % n4];
            Color color = colorArray[i % n3];
            if (n6 <= 0 || color == null) continue;
            double d = dArray[i % n];
            double d2 = dArray2[i % n2];
            if (this.isBad(d) || this.isBad(d2)) continue;
            int n7 = n6 / 2;
            int n8 = (int)(this.h0 - (double)n7 + this.mh * (d - this.hMin));
            int n9 = (int)(this.v0 - (double)n7 + this.mv * (this.vMax - d2));
            graphics.setColor(color);
            graphics.drawOval(n8, n9, n6, n6);
            graphics.fillOval(n8, n9, n6, n6);
        }
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth("m");
        int n2 = fontMetrics.getAscent();
        return new Dimension(24 * n, 16 * n2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }
}

