/*
 * Decompiled with CFR 0.152.
 */
package rvl.stat.dist;

import rvl.stat.dist.NormalAux;
import rvl.stat.dist.NormalAux2;
import rvl.util.NumAnal;
import rvl.util.Solve;
import rvl.util.Utility;

public class Normal {
    private static double saveMu1 = 0.0;
    private static int saveTail = 0;
    static /* synthetic */ Class class$rvl$stat$dist$Normal;

    public static double cdf(double d) {
        double d2;
        double d3 = 0.2316419;
        double d4 = 0.31938153;
        double d5 = -0.356563782;
        double d6 = 1.781477937;
        double d7 = -1.821255978;
        double d8 = 1.330274429;
        if (d > 0.0) {
            return 1.0 - Normal.cdf(-d);
        }
        if (d > -5.0) {
            d2 = 1.0 / (1.0 - d3 * d);
            d2 = Normal.pdf(d) * d2 * (d4 + d2 * (d5 + d2 * (d6 + d2 * (d7 + d2 * d8))));
        } else {
            d2 = d * d;
            d2 = Normal.pdf(d) * (1.0 - (1.0 - 3.0 * (1.0 - 5.0 * (1.0 - 7.0 / d2) / d2) / d2) / d2) / -d;
        }
        return d2;
    }

    public static double pdf(double d) {
        return 0.39894228 * Math.exp(-0.5 * d * d);
    }

    public static double quantile(double d) {
        if (d <= 0.0 || d >= 1.0) {
            return Utility.NaN("Normal.quantile: p must be in (0,1)");
        }
        NormalAux normalAux = new NormalAux();
        double d2 = 4.91 * (Math.pow(d, 0.14) - Math.pow(1.0 - d, 0.14));
        return Solve.search(normalAux, d, d2 - 0.0025, 0.005);
    }

    public static double cdf(double d, double d2, double d3) {
        return Normal.cdf((d - d2) / d3);
    }

    public static double quantile(double d, double d2, double d3) {
        return d2 + d3 * Normal.quantile(d);
    }

    public static double power(double d, int n, double d2, double d3) {
        if (d3 <= 0.0) {
            return Utility.NaN("Normal.power: sigma1 <= 0");
        }
        if (d2 <= 0.0 || d2 >= 1.0) {
            return Utility.NaN("Normal.power: alpha not in (0,1)");
        }
        if (n < 0) {
            return Normal.power(-d, 1, d2, d3);
        }
        if (n == 0) {
            double d4 = Normal.quantile(d2 / 2.0);
            return Normal.cdf(d4, d, d3) + 1.0 - Normal.cdf(-d4, d, d3);
        }
        double d5 = -Normal.quantile(d2);
        return 1.0 - Normal.cdf(d5, d, d3);
    }

    public static double power(double d, int n, double d2) {
        return Normal.power(d, n, d2, 1.0);
    }

    public static double effectSize(double d, int n, double d2) {
        if (d <= 0.0 || d >= 1.0) {
            return Utility.NaN("Normal.effectSize: goal not in (0,1)");
        }
        if (d2 <= 0.0 || d2 >= 1.0) {
            return Utility.NaN("Normal.effectSize: alpha not in (0,1)");
        }
        if (n > 0) {
            return Normal.quantile(d) - Normal.quantile(d2);
        }
        if (n < 0) {
            return -Normal.effectSize(d, 1, d2);
        }
        double d3 = Normal.effectSize(d, 1, d2 / 2.0);
        NormalAux2 normalAux2 = new NormalAux2(d2);
        return Solve.search(normalAux2, d, d3, -0.05);
    }

    public static double rocArea(double d, int n, double d2) {
        saveMu1 = d;
        saveTail = n;
        return NumAnal.integral(class$rvl$stat$dist$Normal == null ? (class$rvl$stat$dist$Normal = Normal.class$("rvl.stat.dist.Normal")) : class$rvl$stat$dist$Normal, "power", 0.0, 1.0, d2, false, 0.0, 1.0);
    }

    public static double rocArea(double d, int n) {
        return Normal.rocArea(d, n, 1.0E-4);
    }

    public static double power(double d) {
        return Normal.power(saveMu1, saveTail, d);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

