/*
 * Decompiled with CFR 0.152.
 */
package rvl.stat.anova;

import java.util.Vector;
import rvl.stat.anova.Factor;

public class Term {
    protected Factor[] fac;
    protected StringBuffer fullName;
    protected Factor[] nestedIn;

    public Term() {
    }

    public Term(Factor[] factorArray) {
        this.fac = new Factor[factorArray.length];
        this.fullName = new StringBuffer();
        int n = 0;
        Vector<Factor> vector = new Vector<Factor>(5, 5);
        for (int i = 0; i < factorArray.length; ++i) {
            this.fac[i] = factorArray[i];
            if (i > 0) {
                this.fullName.append("*");
            }
            this.fullName.append(factorArray[i].name);
            Factor[] factorArray2 = factorArray[i].getNest();
            if (factorArray2 == null) continue;
            for (int j = 0; j < factorArray2.length; ++j) {
                boolean bl = true;
                Factor factor = factorArray2[j];
                for (int k = 0; k < n; ++k) {
                    if (!factor.equals((Factor)vector.elementAt(k))) continue;
                    bl = false;
                }
                if (!bl) continue;
                vector.addElement(factor);
                ++n;
            }
        }
        if (n > 0) {
            this.nestedIn = new Factor[n];
            String string = "(";
            for (int i = 0; i < n; ++i) {
                this.nestedIn[i] = (Factor)vector.elementAt(i);
                this.fullName.append(string + this.nestedIn[i].name);
                string = " ";
            }
            this.fullName.append(")");
        }
    }

    public Term(Term term, Factor factor) {
        int n;
        this.fac = new Factor[term.order() + 1];
        this.fullName = new StringBuffer();
        for (int i = 0; i < term.order(); ++i) {
            this.fac[i] = term.factor(i);
            if (i > 0) {
                this.fullName.append("*");
            }
            this.fullName.append(term.factor((int)i).name);
        }
        this.fullName.append("*" + factor.name);
        this.fac[term.order()] = factor;
        Factor[] factorArray = term.getNest();
        Factor[] factorArray2 = factor.getNest();
        if (factorArray != null) {
            if (factorArray2 == null) {
                this.setNest(factorArray);
            } else {
                int n2;
                n = factorArray.length;
                for (n2 = 0; n2 < factorArray2.length; ++n2) {
                    if (term.containsFactor(factorArray2[n2])) continue;
                    ++n;
                }
                this.nestedIn = new Factor[n];
                n = factorArray.length;
                for (n2 = 0; n2 < factorArray.length; ++n2) {
                    this.nestedIn[n2] = factorArray[n2];
                }
                for (n2 = 0; n2 < factorArray2.length; ++n2) {
                    if (term.containsFactor(factorArray2[n2])) continue;
                    this.nestedIn[n++] = factorArray2[n2];
                }
            }
        } else {
            this.setNest(factorArray2);
        }
        if (this.nestedIn != null) {
            this.fullName.append("(" + this.nestedIn[0].getName());
            for (n = 1; n < this.nestedIn.length; ++n) {
                this.fullName.append(" " + this.nestedIn[n].getName());
            }
            this.fullName.append(")");
        }
    }

    protected void setNest(Factor[] factorArray) {
        if (factorArray == null) {
            return;
        }
        this.nestedIn = new Factor[factorArray.length];
        for (int i = 0; i < factorArray.length; ++i) {
            this.nestedIn[i] = factorArray[i];
        }
    }

    public Factor[] getNest() {
        return this.nestedIn;
    }

    public int order() {
        return this.fac.length;
    }

    public Factor factor(int n) {
        return this.fac[n];
    }

    public Factor[] getFactors() {
        return this.fac;
    }

    public String getName() {
        return this.fullName.toString();
    }

    public boolean isRandom() {
        for (int i = 0; i < this.fac.length; ++i) {
            if (!this.fac[i].isRandom()) continue;
            return true;
        }
        return false;
    }

    public boolean containsTerm(Term term) {
        for (int i = 0; i < term.order(); ++i) {
            if (this.containsFactor(term.factor(i))) continue;
            return false;
        }
        return true;
    }

    public boolean containsFactor(Factor factor) {
        for (int i = 0; i < this.order(); ++i) {
            if (!this.factor(i).contains(factor)) continue;
            return true;
        }
        return false;
    }

    public boolean overlaps(Factor factor) {
        int n;
        Factor[] factorArray = factor.getNest();
        for (n = 0; n < this.order(); ++n) {
            Factor factor2 = this.factor(n);
            if (factor2.equals(factor)) {
                return true;
            }
            if (factorArray == null) continue;
            for (int i = 0; i < factorArray.length; ++i) {
                if (!factorArray[i].overlaps(factor2)) continue;
                return true;
            }
        }
        if (this.nestedIn != null) {
            for (n = 0; n < this.nestedIn.length; ++n) {
                if (this.nestedIn[n].equals(factor)) {
                    return true;
                }
                if (factorArray == null) continue;
                for (int i = 0; i < factorArray.length; ++i) {
                    if (!factorArray[i].overlaps(this.nestedIn[n])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean overlaps(Term term) {
        if (term instanceof Factor) {
            return this.containsFactor((Factor)term);
        }
        Factor[] factorArray = term.fac;
        for (int i = 0; i < factorArray.length; ++i) {
            if (!this.overlaps(factorArray[i])) continue;
            return true;
        }
        return false;
    }

    public Term minus(Factor[] factorArray) {
        if (factorArray == null) {
            return this;
        }
        if (factorArray.length == 0) {
            return this;
        }
        Factor[] factorArray2 = new Factor[this.fac.length - factorArray.length];
        Term term = new Term(factorArray);
        int n = 0;
        for (int i = 0; i < this.fac.length; ++i) {
            if (term.containsFactor(this.fac[i])) continue;
            factorArray2[n++] = this.fac[i];
        }
        return new Term(factorArray2);
    }

    public int df() {
        int n;
        int n2 = 1;
        for (n = 0; n < this.order(); ++n) {
            n2 *= this.factor(n).getLevels() - 1;
        }
        if (this.nestedIn != null) {
            for (n = 0; n < this.nestedIn.length; ++n) {
                n2 *= this.nestedIn[n].span();
            }
        }
        return n2;
    }

    public int span() {
        int n;
        int n2 = 1;
        for (n = 0; n < this.order(); ++n) {
            n2 *= this.factor(n).getLevels();
        }
        if (this.nestedIn != null) {
            for (n = 0; n < this.nestedIn.length; ++n) {
                n2 *= this.nestedIn[n].span();
            }
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getName());
        stringBuffer.append(" <" + (this.isRandom() ? "random" : "fixed") + "> ");
        if (this instanceof Factor) {
            stringBuffer.append("" + ((Factor)this).getLevels() + " levels, ");
        }
        stringBuffer.append("" + this.df() + " df");
        return stringBuffer.toString();
    }
}

