/*
 * Decompiled with CFR 0.152.
 */
package rvl.stat.anova;

import java.util.StringTokenizer;
import java.util.Vector;
import rvl.stat.anova.Factor;
import rvl.stat.anova.FactorSet;
import rvl.stat.anova.Term;
import rvl.stat.dist.F;
import rvl.util.LinAlg;
import rvl.util.Utility;

public class Model {
    Vector fac = new Vector(5, 5);
    Vector term;
    Vector fraction = new Vector(5, 5);
    int[] coef;
    double[] leadCoef;
    double[] denom;
    double[] dendf;
    double[][] EMSC;
    double[][] LU;
    int[] LUp;
    public boolean recalcLU = true;

    public Model() {
        this.term = new Vector();
    }

    public Model(String string) {
        this.term = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "|");
            int n = this.nTerm();
            while (stringTokenizer2.hasMoreTokens()) {
                this.addTerm(stringTokenizer2.nextToken(), n);
            }
        }
    }

    public Factor getFac(int n) {
        return (Factor)this.fac.elementAt(n);
    }

    public Factor getFac(String string) {
        for (int i = 0; i < this.nFac(); ++i) {
            if (!string.equalsIgnoreCase(this.getFac((int)i).name)) continue;
            return this.getFac(i);
        }
        Utility.warning("Warning: Factor named '" + string + "' not found");
        return null;
    }

    public Term getTerm(int n) {
        return (Term)this.term.elementAt(n);
    }

    public int nFac() {
        return this.fac.size();
    }

    public int nTerm() {
        return this.term.size();
    }

    public void addFactor(Factor factor) {
        this.fac.addElement(factor);
        this.term.addElement(factor);
    }

    public void addFactor(Factor factor, boolean bl) {
        int n = this.term.size();
        this.fac.addElement(factor);
        this.term.addElement(factor);
        if (!bl) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Term term = this.getTerm(i);
            if (term.overlaps(factor)) continue;
            this.term.addElement(new Term(term, factor));
        }
    }

    public void addTerm(Term term) {
        this.term.addElement(term);
    }

    private void addTerm(String string, int n) {
        int n2;
        Factor[] factorArray;
        String string2 = "\n\t\r ()*";
        String[] stringArray = new String[20];
        String[] stringArray2 = new String[20];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        while (stringTokenizer.hasMoreTokens()) {
            factorArray = stringTokenizer.nextToken();
            n2 = factorArray.charAt(0);
            if (string2.indexOf(n2) > -1) {
                if (n2 == 40) {
                    ++n5;
                    continue;
                }
                if (n2 != 41) continue;
                --n5;
                continue;
            }
            if (n5 == 0) {
                stringArray[n3++] = factorArray;
                continue;
            }
            if (n5 != 1) continue;
            stringArray2[n4++] = factorArray;
        }
        if (n3 == 0) {
            return;
        }
        if (n3 == 1) {
            factorArray = new Factor(stringArray[0], 2, false);
            if (n4 > 0) {
                factorArray.nestedIn = new Factor[n4];
                for (n2 = 0; n2 < n4; ++n2) {
                    factorArray.nestedIn[n2] = this.getFac(stringArray2[n2]);
                }
                factorArray.setName(stringArray[0]);
            }
            n2 = this.term.size();
            this.addFactor((Factor)factorArray);
            for (int i = n; i < n2; ++i) {
                Term term = this.getTerm(i);
                if (term.overlaps((Factor)factorArray)) continue;
                this.term.addElement(new Term(term, (Factor)factorArray));
            }
            return;
        }
        factorArray = new Factor[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            factorArray[n2] = this.getFac(stringArray[n2]);
        }
        Term term = new Term(factorArray);
        this.addTerm(term);
    }

    public void removeTerm(int n) {
        this.term.removeElementAt(n);
    }

    public void setLevels(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "=");
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = stringTokenizer2.countTokens();
            int n3 = 0;
            FactorSet factorSet = new FactorSet(n2);
            while (stringTokenizer2.hasMoreTokens()) {
                Factor factor;
                String string2 = stringTokenizer2.nextToken();
                if (string2.charAt(0) == '/') {
                    factor = this.getFac(string2.substring(1));
                    this.fractionBy(factor);
                } else {
                    factor = this.getFac(string2);
                }
                factor.levels = n;
                if (n2 <= 1) continue;
                factorSet.facset[n3++] = factor;
                factor.siblings = factorSet;
            }
        }
    }

    public void setRandom(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this.getFac(stringTokenizer.nextToken()).setRandom(true);
        }
        this.sanityCheck();
    }

    public void setFixed(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this.getFac(stringTokenizer.nextToken()).setRandom(false);
        }
    }

    public void sanityCheck() {
        for (int i = 0; i < this.nFac(); ++i) {
            Factor factor = this.getFac(i);
            factor.setRandom(factor.isRandom());
        }
    }

    private void fractionBy(Factor factor) {
        this.fraction.addElement(factor);
    }

    public int getNobs() {
        int n;
        int n2 = 1;
        for (n = 0; n < this.fac.size(); ++n) {
            n2 *= ((Factor)this.fac.elementAt(n)).getLevels();
        }
        for (n = 0; n < this.fraction.size(); ++n) {
            n2 /= ((Factor)this.fraction.elementAt(n)).getLevels();
        }
        return n2;
    }

    private void getCoefs() {
        int n = this.term.size();
        int n2 = this.getNobs();
        if (this.coef == null) {
            this.coef = new int[n];
            this.leadCoef = new double[n];
            this.denom = new double[n];
            this.dendf = new double[n];
        }
        for (int i = 0; i < n; ++i) {
            Term term = this.getTerm(i);
            this.coef[i] = (int)((double)(n2 / term.span()) + 0.1);
        }
    }

    private boolean include(Term term, Term term2) {
        if (term2.isRandom()) {
            return term2.containsTerm(term);
        }
        return false;
    }

    public double[][] EMSCoefs() {
        int n = this.term.size();
        double[][] dArrayArray = new double[n][];
        this.getCoefs();
        for (int i = 0; i < n; ++i) {
            Term term = this.getTerm(i);
            dArrayArray[i] = new double[n];
            for (int j = 0; j < n; ++j) {
                dArrayArray[i][j] = this.include(term, this.getTerm(j)) ? (double)this.coef[j] : 0.0;
            }
            dArrayArray[i][i] = this.coef[i];
        }
        return dArrayArray;
    }

    public double[][] getErrorTerms(double[][] dArray) {
        int n = this.term.size();
        int[] nArray = new int[n];
        double[][] dArray2 = LinAlg.transpose(dArray);
        double[][] dArrayArray = new double[n][];
        if (!LinAlg.LUInPlace(dArray2, nArray)) {
            Utility.warning("Variance components are not all estimable");
            return null;
        }
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = LinAlg.copy(dArray[i]);
            dArrayArray[i][i] = 0.0;
            dArrayArray[i] = LinAlg.LUSolveInPlace(dArray2, nArray, dArrayArray[i]);
        }
        return dArrayArray;
    }

    public double[][] getErrorTerms() {
        return this.getErrorTerms(this.EMSCoefs());
    }

    public double[] power(double[] dArray, double d) {
        Object object;
        int n;
        int n2 = this.term.size();
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        double[][] dArray5 = this.EMSCoefs();
        double[][] dArray6 = this.getErrorTerms(dArray5);
        for (n = 0; n < n2; ++n) {
            object = dArray5[n];
            dArray2[n] = object[n] * dArray[n] * dArray[n];
            dArray3[n] = 0.0;
            for (int i = 0; i < n2; ++i) {
                int n3 = n;
                dArray3[n3] = dArray3[n3] + object[i] * dArray[i] * dArray[i];
            }
            this.denom[n] = dArray3[n] - dArray2[n];
            this.leadCoef[n] = object[n];
        }
        for (n = 0; n < n2; ++n) {
            try {
                object = this.getTerm(n);
                double d2 = 0.0;
                double d3 = 0.0;
                boolean bl = true;
                for (int i = 0; i < n2; ++i) {
                    double d4;
                    double d5 = dArray6[n][i];
                    if (!(d4 > 1.0E-6)) continue;
                    double d6 = d5 * dArray3[i];
                    d2 += d6;
                    d3 += d6 * d6 / (double)this.getTerm(i).df();
                    bl = false;
                }
                if (bl) {
                    dArray4[n] = -1.0;
                    this.dendf[n] = Double.NaN;
                    continue;
                }
                this.dendf[n] = d2 * d2 / d3;
                dArray4[n] = this.dendf[n] > 0.1 ? F.power(dArray2[n] / this.denom[n], ((Term)object).df(), this.dendf[n], d, ((Term)object).isRandom()) : -2.0;
                continue;
            }
            catch (ArithmeticException arithmeticException) {
                dArray4[n] = -3.0;
            }
        }
        return dArray4;
    }

    public double[] getPowerInfo(int n) {
        return new double[]{this.leadCoef[n], this.denom[n], this.getTerm(n).df(), this.dendf[n]};
    }

    public void printEMS() {
        System.out.print(this.EMSString());
    }

    public String EMSString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.term.size();
        double[][] dArray = this.EMSCoefs();
        double[][] dArray2 = this.getErrorTerms();
        stringBuffer.append("Expected mean squares\n");
        for (int i = 0; i < n; ++i) {
            int n2;
            Term term = this.getTerm(i);
            stringBuffer.append("\n" + term + "\n");
            stringBuffer.append("  EMS =");
            boolean bl = true;
            for (n2 = 0; n2 < n; ++n2) {
                if (dArray[i][n2] == 0.0) continue;
                stringBuffer.append(bl ? " " : " + ");
                bl = false;
                if (dArray[i][n2] != 1.0) {
                    stringBuffer.append(dArray[i][n2] + "*Var{" + this.getTerm(n2).getName() + "}");
                    continue;
                }
                stringBuffer.append("Var{" + this.getTerm(n2).getName() + "}");
            }
            stringBuffer.append("\n  Denom =");
            bl = true;
            for (n2 = 0; n2 < n; ++n2) {
                if (dArray2[i][n2] == 0.0) continue;
                stringBuffer.append(bl ? " " : " + ");
                bl = false;
                if (dArray2[i][n2] != 1.0) {
                    stringBuffer.append(dArray2[i][n2] + "*MS{" + this.getTerm(n2).getName() + "}");
                    continue;
                }
                stringBuffer.append("MS{" + this.getTerm(n2).getName() + "}");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.term.size(); ++i) {
            if (i > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(this.getTerm(i).toString());
        }
        return stringBuffer.toString();
    }

    public Vector getCompRestr(Term term) {
        if (term.isRandom()) {
            return null;
        }
        Vector<Factor[]> vector = new Vector<Factor[]>();
        vector.addElement(null);
        if (term.order() > 1) {
            for (int i = 0; i < this.nTerm(); ++i) {
                Term term2 = this.getTerm(i);
                if (!term2.isRandom() || !term2.overlaps(term) || term2.containsTerm(term)) continue;
                Vector<Factor> vector2 = new Vector<Factor>();
                for (int j = 0; j < term.order(); ++j) {
                    if (!term2.containsFactor(term.factor(j))) continue;
                    vector2.addElement(term.factor(j));
                }
                Factor[] factorArray = new Factor[vector2.size()];
                for (int j = 0; j < vector2.size(); ++j) {
                    factorArray[j] = (Factor)vector2.elementAt(j);
                }
                vector.addElement(factorArray);
            }
        }
        return vector;
    }

    public Vector getAllCompRestr(Term term) {
        if (term.isRandom()) {
            return null;
        }
        Vector<Factor[]> vector = new Vector<Factor[]>(5);
        vector.addElement(null);
        if (term.order() > 1) {
            for (int i = 0; i < this.nTerm(); ++i) {
                Term term2 = this.getTerm(i);
                if (term2 == term || term2.isRandom() || !term.containsTerm(term2)) continue;
                if (term2 instanceof Factor) {
                    vector.addElement(new Factor[]{(Factor)term2});
                    continue;
                }
                vector.addElement(term2.fac);
            }
        }
        return vector;
    }

    public double[] getCompVariance(Term term, Factor[] factorArray, double[] dArray) {
        int n;
        double[] dArray2 = this.getCompCoefs(term, factorArray);
        double[] dArray3 = this.getCompErrorTerms(dArray2);
        double[] dArray4 = LinAlg.constant(0.0, this.nTerm());
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < this.nTerm(); ++n) {
            if (!(dArray2[n] > 0.0)) continue;
            d += dArray2[n] * dArray[n] * dArray[n];
            for (int i = 0; i < this.nTerm(); ++i) {
                if (!(this.EMSC[n][i] > 0.0)) continue;
                int n2 = n;
                dArray4[n2] = dArray4[n2] + this.EMSC[n][i] * dArray[i] * dArray[i];
            }
        }
        for (n = 0; n < this.nTerm(); ++n) {
            if (dArray3[n] == 0.0) continue;
            double d3 = dArray3[n] * dArray4[n];
            d2 += d3 * d3 / (double)this.getTerm(n).df();
        }
        double d4 = d * d / d2;
        return new double[]{d, d4};
    }

    public double[] getCompCoefs(Term term, Factor[] factorArray) {
        double[] dArray = new double[this.nTerm()];
        Term term2 = term;
        if (factorArray != null) {
            term2 = term.minus(factorArray);
        }
        for (int i = 0; i < this.nTerm(); ++i) {
            Term term3 = this.getTerm(i);
            if (term3.isRandom() && term3.overlaps(term2)) {
                dArray[i] = 1.0 / (double)term3.span();
                for (int j = 0; j < term.order(); ++j) {
                    if (!term3.containsFactor(term.factor(j))) continue;
                    int n = i;
                    dArray[n] = dArray[n] * (double)term.factor(j).span();
                }
                continue;
            }
            dArray[i] = 0.0;
        }
        return dArray;
    }

    public double[] getCompErrorTerms(double[] dArray) {
        if (this.recalcLU) {
            this.recalcLU = false;
            this.EMSC = this.EMSCoefs();
            this.LU = LinAlg.transpose(this.EMSC);
            this.LUp = new int[this.nTerm()];
            if (!LinAlg.LUInPlace(this.LU, this.LUp)) {
                Utility.warning("Variance components are not all estimable");
                return null;
            }
        }
        double[] dArray2 = LinAlg.copy(dArray);
        dArray2 = LinAlg.LUSolveInPlace(this.LU, this.LUp, dArray2);
        return dArray2;
    }

    public String[] getCompVarString(Term term, Factor[] factorArray) {
        double[] dArray = this.getCompCoefs(term, factorArray);
        double[] dArray2 = this.getCompErrorTerms(dArray);
        boolean bl = true;
        boolean bl2 = true;
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer("");
        for (int i = 0; i < this.nTerm(); ++i) {
            if (dArray[i] > 0.0) {
                if (!bl) {
                    stringBuffer.append(" + ");
                }
                bl = false;
                stringBuffer.append("Var{" + this.getTerm(i).getName() + "}");
                stringBuffer.append("/" + Utility.format(1.0 / dArray[i], 3));
            }
            if (!(dArray2[i] > 0.0)) continue;
            if (!bl2) {
                stringBuffer2.append(" + ");
            }
            bl2 = false;
            stringBuffer2.append(Utility.format(dArray2[i], 3) + "*");
            stringBuffer2.append("MS{" + this.getTerm(i).getName() + "}");
        }
        return new String[]{stringBuffer.toString(), stringBuffer2.toString()};
    }
}

