/*
 * Decompiled with CFR 0.152.
 */
package rvl.stat.anova;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import rvl.stat.anova.Factor;
import rvl.stat.anova.Model;
import rvl.stat.anova.Term;
import rvl.util.Utility;

public class GetFactorsGUI
extends Frame {
    TextField facName;
    TextField nLev;
    Checkbox fixedBox;
    Checkbox randomBox;
    boolean random = false;
    boolean firstTime = true;
    List facList;
    Model model;

    public GetFactorsGUI(Model model) {
        this.model = model;
        this.setTitle("Enter factors for ANOVA model");
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(5, 1));
        panel.add(new Label("Name of factor"));
        this.facName = new TextField(10);
        this.nLev = new TextField(4);
        panel.add(this.facName);
        Panel panel2 = new Panel();
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.fixedBox = new Checkbox("Fixed", checkboxGroup, true);
        this.randomBox = new Checkbox("Random", checkboxGroup, false);
        panel2.add(this.fixedBox);
        panel2.add(this.randomBox);
        panel.add(panel2);
        panel.add(new Label("# levels"));
        panel.add(this.nLev);
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        panel3.add("North", new Label("Nested in..."));
        this.facList = new List(3, true);
        panel3.add("Center", this.facList);
        Panel panel4 = new Panel();
        panel4.setLayout(new FlowLayout(0));
        panel4.add(new Button("Accept"));
        panel4.add(new Button("Finish"));
        panel4.add(new Button("Start over"));
        panel4.add(new Button("Cancel"));
        this.setLayout(new BorderLayout());
        this.add("West", panel);
        this.add("South", panel4);
        this.add("Center", panel3);
        this.resize(350, 200);
        this.show();
    }

    public boolean HandleEvent(Event event) {
        if (event.id == 201) {
            System.out.println("Window closed");
            this.dispose();
            return true;
        }
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object object) {
        if (object.equals("Cancel")) {
            this.dispose();
            System.exit(0);
        } else if (event.target.equals(this.fixedBox)) {
            this.random = false;
        } else if (event.target.equals(this.randomBox)) {
            this.random = true;
        } else if (object.equals("Accept")) {
            String string = this.facName.getText();
            int n = Utility.strtoi(this.nLev.getText());
            boolean bl = false;
            Term term = new Term();
            for (int i = 0; i < this.facList.countItems(); ++i) {
                if (!this.facList.isSelected(i)) continue;
                term = bl ? new Term(term, this.model.getFac(i)) : this.model.getFac(i);
                this.facList.deselect(i);
                bl = true;
            }
            Factor factor = bl ? new Factor(string, n, term) : new Factor(string, n, this.random);
            this.model.addFactor(factor);
            this.facList.addItem(factor.getName());
            this.facName.setText("");
            this.nLev.setText("");
            this.random = false;
            this.fixedBox.setState(true);
        } else if (object.equals("Finish")) {
            this.model.printEMS();
        }
        return true;
    }
}

