/*
 * Decompiled with CFR 0.152.
 */
package rvl.stat.anova;

import rvl.stat.anova.FactorSet;
import rvl.stat.anova.Term;
import rvl.util.Utility;

public class Factor
extends Term {
    protected String name;
    protected int levels;
    protected boolean random;
    protected FactorSet siblings;

    public Factor() {
    }

    public Factor(String string, int n, boolean bl) {
        this.setName(string);
        this.setLevels(n);
        this.setRandom(bl);
    }

    public Factor(String string, int n, Term term) {
        this.setLevels(n);
        this.nestedIn = new Factor[term.order()];
        for (int i = 0; i < term.order(); ++i) {
            this.nestedIn[i] = term.factor(i);
        }
        this.setName(string);
        this.setRandom(true);
    }

    public Factor(String string, int n, int n2) {
        this.setLevels(n);
        this.nestedIn = new Factor[n2];
        this.name = string;
        this.setRandom(true);
    }

    public void setName(String string) {
        if ((string = string.trim()).length() > 0) {
            this.name = new String(string);
            this.fullName = new StringBuffer(string);
            if (this.nestedIn != null) {
                this.fullName.append("(");
                int n = 0;
                while (n < this.nestedIn.length) {
                    this.fullName.append(this.nestedIn[n].getName());
                    if (++n >= this.nestedIn.length) continue;
                    this.fullName.append(" ");
                }
                this.fullName.append(")");
            }
        } else {
            Utility.error("Factor name cannot be null string");
        }
    }

    public String getName() {
        return this.fullName.toString();
    }

    public String getShortName() {
        return this.name;
    }

    public void setLevels(int n) {
        if (n > 1) {
            if (this.siblings == null) {
                this.levels = n;
            } else {
                this.siblings.setLevels(n);
            }
        } else {
            Utility.warning("Factor must have at least two levels");
        }
    }

    public int getLevels() {
        return this.levels;
    }

    public int order() {
        return 1;
    }

    public Factor factor(int n) {
        if (n == 0) {
            return this;
        }
        return null;
    }

    public void setRandom(boolean bl) {
        this.random = bl;
        if (this.nestedIn != null && !bl) {
            for (int i = 0; i < this.nestedIn.length; ++i) {
                if (!this.nestedIn[i].isRandom()) continue;
                this.random = true;
                Utility.warning("Warning: fixed factor nested in a random factor:");
                Utility.warning("\t" + this.fullName + " was made random.");
            }
        }
    }

    public boolean isRandom() {
        return this.random;
    }

    public boolean contains(Factor factor) {
        if (this.equals(factor)) {
            return true;
        }
        if (this.nestedIn == null) {
            return false;
        }
        for (int i = 0; i < this.nestedIn.length; ++i) {
            if (!this.nestedIn[i].contains(factor)) continue;
            return true;
        }
        return false;
    }
}

