/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface.apps;

import rvl.piface.Piface;
import rvl.stat.dist.T;

public class TEquivGUI
extends Piface {
    private static String title = "Two-sample t test for equivalence";
    public double alpha;
    public double power;
    public double tol;
    public double diff;
    public double sigma;
    public double n;

    public void gui() {
        this.bar("tol", "Maximum negligible difference", 0.5);
        this.bar("diff", "True difference, |mu1-mu2|", 0.1);
        this.bar("sigma", "True SD of each population", 1.0);
        this.bar("n", "n for each sample", 25.0);
        this.bar("alpha", 0.05);
        this.ointerval("power", 0.0, 0.0, 1.0);
    }

    public void click() {
        this.n = TEquivGUI.max(2.0, TEquivGUI.round(this.n));
        double d = this.sigma * TEquivGUI.sqrt(2.0 / this.n);
        this.power = T.powerEquiv(this.diff, this.tol, d, 2.0 * (this.n - 1.0), this.alpha);
    }

    public TEquivGUI() {
        super(title);
    }

    public static void main(String[] stringArray) {
        new TEquivGUI();
    }
}

