/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface.apps;

import rvl.piface.Piface;
import rvl.stat.dist.Beta;
import rvl.stat.dist.Binomial;
import rvl.stat.dist.Chi2;
import rvl.stat.dist.F;
import rvl.stat.dist.Normal;
import rvl.stat.dist.Poisson;
import rvl.stat.dist.T;
import rvl.stat.dist.Tukey;

public class CDFcalc
extends Piface {
    private static String title = "Online tables";
    public double x;
    public double Fx;
    public double df1;
    public double df2;
    public double ncp;
    public int dist;
    public int RT;
    private static final int NORMAL = 0;
    private static final int TDIST = 1;
    private static final int FDIST = 2;
    private static final int CHISQ = 3;
    private static final int BETA = 4;
    private static final int TUKEY = 5;
    private static final int BINOMIAL = 6;
    private static final int POISSON = 7;
    private static final double[][] dflts = new double[][]{{0.0, 0.0, 1.0}, {0.0, 10.0, 0.009}, {1.0, 2.0, 10.0}, {5.0, 10.0, 0.009}, {0.5, 1.0, 1.0}, {1.0, 30.0, 3.0}, {5.0, 10.0, 0.5}, {5.0, 10.0, 0.009}};
    static /* synthetic */ Class class$rvl$piface$apps$AnovaPicker;

    public void gui() {
        this.choice("dist", "Distribution", new String[]{"Normal", "t", "F", "Chi-square", "Beta", "Studentized range", "Binomial", "Poisson"}, 1);
        this.field("x", "x   ", 0.0);
        this.field("Fx", "F(x)", 0.5);
        this.checkbox("RT", "Right tail", 0);
        this.newColumn();
        this.beginSubpanel(1, false);
        this.label("Parameter values...");
        this.field("df1", "df", 10.0);
        this.field("df2", 10.0);
        this.field("ncp", 0.0);
        this.endSubpanel();
        this.menuItem("localHelp", "Using this calculator", this.helpMenu);
    }

    public void click() {
        double d = 0.0;
        switch (this.dist) {
            case 0: {
                this.Fx = Normal.cdf(this.x, this.df1, this.df2);
                break;
            }
            case 1: {
                this.Fx = T.cdf(this.x, this.df1, this.ncp);
                break;
            }
            case 2: {
                this.Fx = F.cdf(this.x, this.df1, this.df2, this.ncp);
                break;
            }
            case 3: {
                this.Fx = Chi2.cdf(this.x, this.df1, this.ncp);
                break;
            }
            case 4: {
                this.Fx = Beta.cdf(this.x, this.df1, this.df2, this.ncp);
                break;
            }
            case 5: {
                this.Fx = Tukey.cdf(this.x, this.df2, this.df1);
                break;
            }
            case 6: {
                this.Fx = Binomial.cdf((int)this.x, (int)this.df1, this.df2);
                break;
            }
            case 7: {
                this.Fx = Poisson.cdf((int)this.x, this.df1);
            }
        }
        if (this.RT > 0) {
            this.Fx = 1.0 - this.Fx;
        }
    }

    public void Fx_changed() {
        double d = this.RT > 0 ? 1.0 - this.Fx : this.Fx;
        switch (this.dist) {
            case 0: {
                this.x = Normal.quantile(d, this.df1, this.df2);
                break;
            }
            case 1: {
                this.x = T.quantile(d, this.df1, this.ncp);
                break;
            }
            case 2: {
                this.x = F.quantile(d, this.df1, this.df2, this.ncp);
                break;
            }
            case 3: {
                this.x = Chi2.quantile(d, this.df1, this.ncp);
                break;
            }
            case 4: {
                this.x = Beta.quantile(d, this.df1, this.df2, this.ncp);
                break;
            }
            case 5: {
                this.x = Tukey.quantile(d, this.df2, this.df1);
                break;
            }
            case 6: {
                this.x = Binomial.quantile(d, (int)this.df1, this.df2);
                this.Fx = this.Fx = Binomial.cdf((int)this.x, (int)this.df1, this.df2);
                if (this.RT <= 0) break;
                this.Fx = 1.0 - this.Fx;
                break;
            }
            case 7: {
                this.x = Poisson.quantile(d, this.df1);
                this.Fx = Poisson.cdf((int)this.x, this.df1);
                if (this.RT <= 0) break;
                this.Fx = 1.0 - this.Fx;
            }
        }
    }

    public void dist_changed() {
        this.setVisible("df2", this.dist != 1 && this.dist != 3 && this.dist != 7);
        this.setVisible("ncp", this.dist == 1 || this.dist == 2 || this.dist == 3 || this.dist == 4);
        this.relabel("df1", "df");
        this.relabel("df2", "df2");
        switch (this.dist) {
            case 0: {
                this.relabel("df1", "mu");
                this.relabel("df2", "sigma");
                break;
            }
            case 4: {
                this.relabel("df1", "alpha");
                this.relabel("df2", "beta");
                break;
            }
            case 5: {
                this.relabel("df1", "df");
                this.relabel("df2", "k");
                break;
            }
            case 6: {
                this.relabel("df1", "n");
                this.relabel("df2", "p");
                break;
            }
            case 7: {
                this.relabel("df1", "lambda");
                break;
            }
            case 2: {
                this.relabel("df1", "df1");
            }
        }
        this.x = dflts[this.dist][0];
        this.df1 = dflts[this.dist][1];
        this.df2 = dflts[this.dist][2];
        this.ncp = 0.0;
        this.click();
    }

    public void RT_changed() {
        if (this.RT == 0) {
            this.relabel("Fx", "F(x)");
        } else {
            this.relabel("Fx", "1 - F(x)");
        }
        this.Fx = 1.0 - this.Fx;
    }

    public void localHelp() {
        this.showText(class$rvl$piface$apps$AnovaPicker == null ? (class$rvl$piface$apps$AnovaPicker = CDFcalc.class$("rvl.piface.apps.AnovaPicker")) : class$rvl$piface$apps$AnovaPicker, "CDFcalcHelp.txt", "How to use online tables", 25, 60);
    }

    public CDFcalc() {
        super(title);
    }

    public static void main(String[] stringArray) {
        CDFcalc cDFcalc = new CDFcalc();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

