/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Panel;
import rvl.awt.RVLayout;

public class PiPanel
extends Panel {
    public static final int NO_BORDER = 0;
    public static final int PLAIN_BORDER = 1;
    public static final int RAISED = 2;
    public static final int LOWERED = 3;
    private int borderType = 0;
    private Color borderColor = null;
    protected boolean isStretchable = false;

    public PiPanel() {
    }

    public PiPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public void setBorderType(int n) {
        this.borderType = n;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public void setStretchable(boolean bl) {
        Container container;
        this.isStretchable = bl;
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof RVLayout) {
            ((RVLayout)layoutManager).setStretchable(bl, true);
        }
        if ((container = this.getParent()) != null && container instanceof PiPanel) {
            ((PiPanel)container).setStretchable(bl);
        }
    }

    public Component add(Component component) {
        if (component instanceof PiPanel && ((PiPanel)component).isStretchable) {
            this.setStretchable(true);
        }
        return super.add(component);
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width - 1;
        int n2 = this.getSize().height - 1;
        switch (this.borderType) {
            case 0: {
                break;
            }
            case 1: {
                if (this.borderColor == null) {
                    this.setBorderColor(this.getForeground());
                }
                graphics.setColor(this.borderColor);
                graphics.drawRect(0, 0, n, n2);
                break;
            }
            case 2: {
                if (this.borderColor == null) {
                    this.setBorderColor(this.getBackground());
                }
                graphics.setColor(this.borderColor);
                graphics.draw3DRect(0, 0, n, n2, true);
                graphics.setColor(this.borderColor.brighter());
                graphics.draw3DRect(1, 1, n - 2, n2 - 2, true);
                break;
            }
            case 3: {
                if (this.borderColor == null) {
                    this.setBorderColor(this.getBackground());
                }
                graphics.setColor(this.borderColor);
                graphics.draw3DRect(0, 0, n, n2, false);
                graphics.setColor(this.borderColor.darker());
                graphics.draw3DRect(1, 1, n - 2, n2 - 2, false);
            }
        }
        super.paint(graphics);
    }
}

