/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import rvl.awt.DoubleField;
import rvl.awt.RVLayout;
import rvl.awt.ViewWindow;
import rvl.piface.AboutPiface;
import rvl.piface.DoubleComponent;
import rvl.piface.IntComponent;
import rvl.piface.PiComponent;
import rvl.piface.PiListener;
import rvl.piface.Piface;
import rvl.util.Utility;

public class PiGraph
extends Frame
implements PiListener,
ActionListener,
WindowListener {
    Piface piface;
    Choice yChoice = new Choice();
    Choice xChoice = new Choice();
    DoubleField fromFld = new DoubleField("", 5);
    DoubleField toFld = new DoubleField("", 5);
    DoubleField byFld = new DoubleField("", 5);
    Checkbox accumChk = new Checkbox("Persistent");
    Button dataButton = new Button("Show Data");
    Button drawButton = new Button("Redraw");
    Button quitButton = new Button("Close");
    MenuBar menuBar = new MenuBar();
    Menu helpMenu = new Menu("Help");
    int cpHeight = 0;
    int xVar;
    int yVar;
    boolean init = true;
    double xMin;
    double xMax;
    double yMin;
    double yMax;
    String xName;
    String yName;
    Vector vars = new Vector();
    Vector intComps = new Vector();
    Vector labs = new Vector();
    Vector data = new Vector();
    Font scaleFont = new Font("SansSerif", 0, 10);
    static /* synthetic */ Class class$rvl$piface$PiGraph;

    public PiGraph(Piface piface) {
        Object object;
        this.piface = piface;
        Panel panel = new Panel(new RVLayout(1, true, true));
        Panel panel2 = new Panel(new RVLayout(2, false, true));
        Panel panel3 = new Panel(new RVLayout(6, false, true));
        Panel panel4 = new Panel(new RVLayout(4, false, true));
        panel2.add(new Label("Vertical (y) axis"));
        panel2.add(this.yChoice);
        panel2.add(new Label("Horizontal (x) axis"));
        panel2.add(this.xChoice);
        panel3.add(new Label("from", 2));
        panel3.add(this.fromFld);
        panel3.add(new Label("to", 2));
        panel3.add(this.toFld);
        panel3.add(new Label("by", 2));
        panel3.add(this.byFld);
        panel4.add(this.accumChk);
        panel4.add(this.dataButton);
        panel4.add(this.drawButton);
        panel4.add(this.quitButton);
        panel.add(panel2);
        panel.add(panel3);
        panel.add(panel4);
        Enumeration enumeration = this.piface.actors.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            object = (PiComponent)enumeration.nextElement();
            if (object instanceof DoubleComponent) {
                this.vars.addElement(object.getName());
                this.labs.addElement(object.getLabel());
                this.xChoice.addItem(object.getLabel());
                this.yChoice.addItem(object.getLabel());
                ++n;
                continue;
            }
            if (!(object instanceof IntComponent)) continue;
            this.intComps.addElement(object);
        }
        if (n == 0) {
            this.yChoice.addItem("Sorry,");
            this.xChoice.addItem("No variables are available!");
        } else {
            this.xChoice.select(Math.max(0, n - 2));
            this.yChoice.select(n - 1);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "South");
        this.setTitle("PiFace Graph");
        this.setBackground(piface.getBackground());
        this.piface.addPiListener(this);
        this.quitButton.addActionListener(this);
        this.drawButton.addActionListener(this);
        this.dataButton.addActionListener(this);
        this.dataButton.setVisible(false);
        this.addWindowListener(this);
        object = new MenuItem("Help");
        MenuItem menuItem = new MenuItem("About Piface");
        ((MenuItem)object).addActionListener(this);
        menuItem.addActionListener(this);
        this.setMenuBar(this.menuBar);
        this.menuBar.setHelpMenu(this.helpMenu);
        this.helpMenu.add((MenuItem)object);
        this.helpMenu.add(menuItem);
        this.pack();
        this.drawButton.setLabel("Draw");
        this.cpHeight = panel.getSize().height;
        Point point = this.piface.getLocation();
        point.x += this.piface.getSize().width;
        this.setLocation(point);
        this.show();
    }

    public void close() {
        this.piface.removePiListener(this);
        this.dispose();
    }

    private synchronized void computePlotData() {
        Object object;
        int n;
        double d = this.fromFld.getValue();
        double d2 = this.byFld.getValue();
        double d3 = this.toFld.getValue();
        if (Double.isNaN(d + d3 + d2) || d == d3 || d2 == 0.0) {
            return;
        }
        int n2 = (int)Math.abs((d3 - d) / d2 + 1.0);
        if (n2 < 2) {
            return;
        }
        if (!this.accumChk.getState() || this.xVar != this.xChoice.getSelectedIndex() || this.yVar != this.yChoice.getSelectedIndex()) {
            this.data.removeAllElements();
        }
        this.xVar = this.xChoice.getSelectedIndex();
        this.yVar = this.yChoice.getSelectedIndex();
        String string = (String)this.vars.elementAt(this.xVar);
        String string2 = (String)this.vars.elementAt(this.yVar);
        StringBuffer stringBuffer = new StringBuffer("# " + this.yChoice.getSelectedItem() + " vs. " + this.xChoice.getSelectedItem() + "\n");
        for (n = 0; n < this.intComps.size(); ++n) {
            object = (IntComponent)this.intComps.elementAt(n);
            stringBuffer.append("#   " + object.getLabel() + ": " + object.getTextValue() + "\n");
        }
        for (n = 0; n < this.vars.size(); ++n) {
            object = (String)this.vars.elementAt(n);
            if (((String)object).equals(string) || ((String)object).equals(string2)) continue;
            stringBuffer.append("#   " + this.labs.elementAt(n) + " = " + Utility.format(this.piface.getDVar((String)object), 5) + "\n");
        }
        stringBuffer.append(string + "\t" + string2 + "\n");
        this.data.addElement(new String(stringBuffer));
        double[] dArray = new double[n2];
        object = new double[n2];
        double[] dArray2 = this.piface.saveVars();
        for (int i = 0; i < n2; ++i) {
            object[i] = this.piface.eval(string2, string, d + (double)i * d2);
            dArray[i] = this.piface.getDVar(string);
        }
        this.piface.restoreVars(dArray2);
        this.data.addElement(dArray);
        this.data.addElement(object);
    }

    void computeRanges() {
        boolean bl = false;
        this.yMax = 0.0;
        this.yMin = 0.0;
        this.xMax = 0.0;
        this.xMin = 0.0;
        if (this.data.size() == 0) {
            return;
        }
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            double[] dArray = (double[])enumeration.nextElement();
            double[] dArray2 = (double[])enumeration.nextElement();
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                if (Double.isNaN(dArray[i] + dArray2[i])) continue;
                if (!bl) {
                    this.xMin = this.xMax = dArray[i];
                    this.yMin = this.yMax = dArray2[i];
                    bl = true;
                }
                if (dArray[i] < this.xMin) {
                    this.xMin = dArray[i];
                }
                if (dArray[i] > this.xMax) {
                    this.xMax = dArray[i];
                }
                if (dArray2[i] < this.yMin) {
                    this.yMin = dArray2[i];
                }
                if (!(dArray2[i] > this.yMax)) continue;
                this.yMax = dArray2[i];
            }
        }
    }

    void showData() {
        Object object;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("# Curve number " + ++n + "\n");
            stringBuffer.append((String)enumeration.nextElement());
            object = (double[])enumeration.nextElement();
            double[] dArray = (double[])enumeration.nextElement();
            for (int i = 0; i < ((Object)object).length; ++i) {
                stringBuffer.append(Utility.format((double)object[i], 5) + "\t" + Utility.format(dArray[i], 5) + "\n");
            }
        }
        stringBuffer.append("\n");
        object = new ViewWindow("Plot data", 25, 40);
        ((ViewWindow)object).setText(new String(stringBuffer));
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.init) {
            return;
        }
        this.setTitle(this.yChoice.getSelectedItem() + " vs. " + this.xChoice.getSelectedItem());
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        int n5 = dimension.width - 10 - insets.left - insets.right;
        int n6 = dimension.height - 10 - insets.top - insets.bottom - this.cpHeight;
        int n7 = 5 + insets.left;
        int n8 = 5 + insets.top;
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        graphics.setColor(Color.white);
        graphics.fillRect(n7, n8, n5, n6);
        graphics.setColor(Color.lightGray);
        graphics.draw3DRect(n7, n8, n5, n6, false);
        graphics.setColor(Color.lightGray.darker());
        graphics.draw3DRect(n7 + 1, n8 + 1, n5 - 2, n6 - 2, false);
        if (this.xVar != this.xChoice.getSelectedIndex() || this.yVar != this.yChoice.getSelectedIndex()) {
            this.computePlotData();
        }
        if (this.data.size() == 0) {
            return;
        }
        this.computeRanges();
        if (n5 < 0 || n6 < 0) {
            return;
        }
        double d = 1.1 * (this.xMax - this.xMin);
        double d2 = 1.1 * (this.yMax - this.yMin);
        double d3 = this.xMin - 0.05 * (this.xMax - this.xMin);
        double d4 = this.yMax + 0.05 * (this.yMax - this.yMin);
        if (d == 0.0) {
            return;
        }
        if (d2 == 0.0) {
            d2 = 1.0;
            d4 += d2 / 2.0;
        }
        double[] dArray = Utility.nice(d4 - d2, d4, 5, false);
        String[] stringArray = Utility.fmtNice(dArray);
        FontMetrics fontMetrics = this.getFontMetrics(this.scaleFont);
        int n9 = fontMetrics.getAscent();
        int n10 = 2 * n9;
        int n11 = 0;
        for (n4 = 0; n4 < dArray.length; ++n4) {
            n3 = fontMetrics.stringWidth(stringArray[n4]);
            if (n3 <= n11) continue;
            n11 = n3;
        }
        graphics.setColor(Color.blue.darker());
        graphics.drawRect(n7 += (n11 += n9), n8 += 5, n5 -= n11 + 5, n6 -= n10 + 5);
        graphics.setFont(this.scaleFont);
        int n12 = n7 - n9 / 3;
        for (n4 = 0; n4 < dArray.length; ++n4) {
            n3 = (int)((double)n8 + (double)n6 * (d4 - dArray[n4]) / d2);
            graphics.drawLine(n7, n3, n12, n3);
            n2 = fontMetrics.stringWidth(stringArray[n4]);
            graphics.drawString(stringArray[n4], n7 - n2 - n9 / 2, n3 + n9 / 3);
        }
        dArray = Utility.nice(d3, d3 + d, 5, false);
        stringArray = Utility.fmtNice(dArray);
        int n13 = n8 + n6;
        n12 = n13 + n9 / 3;
        n3 = n12 + n9;
        for (n4 = 0; n4 < dArray.length; ++n4) {
            n2 = (int)((double)n7 + (double)n5 * (dArray[n4] - d3) / d);
            graphics.drawLine(n2, n13, n2, n12);
            n = fontMetrics.stringWidth(stringArray[n4]);
            graphics.drawString(stringArray[n4], n2 - n / 2, n3);
        }
        Color[] colorArray = new Color[]{Color.black, Color.blue, Color.red, Color.orange, Color.green.darker(), Color.magenta};
        n = 0;
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            graphics.setColor(colorArray[n++ % colorArray.length]);
            double[] dArray2 = (double[])enumeration.nextElement();
            double[] dArray3 = (double[])enumeration.nextElement();
            boolean bl = false;
            int n14 = 0;
            int n15 = 0;
            for (n4 = 0; n4 < dArray2.length; ++n4) {
                if (Double.isNaN(dArray2[n4] + dArray3[n4])) {
                    bl = false;
                    continue;
                }
                int n16 = (int)((double)n7 + (double)n5 * (dArray2[n4] - d3) / d);
                int n17 = (int)((double)n8 + (double)n6 * (d4 - dArray3[n4]) / d2);
                if (!bl) {
                    n14 = n16;
                    n15 = n17;
                    bl = true;
                }
                graphics.drawLine(n14, n15, n16, n17);
                n14 = n16;
                n15 = n17;
            }
        }
    }

    public void piAction(String string) {
        this.computePlotData();
        this.repaint();
    }

    public static ViewWindow showText(Class clazz, String string, String string2, int n, int n2) {
        ViewWindow viewWindow = new ViewWindow(string2, n, n2);
        try {
            String string3;
            viewWindow.ta.setVisible(false);
            InputStream inputStream = clazz.getResourceAsStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string3 = bufferedReader.readLine()) != null) {
                viewWindow.append(string3 + "\n");
            }
            inputStream.close();
            viewWindow.setTop();
            viewWindow.ta.setVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return viewWindow;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand().toString();
        if (string.equals("Close")) {
            this.close();
        } else if (string.equals("Help")) {
            PiGraph.showText(class$rvl$piface$PiGraph == null ? (class$rvl$piface$PiGraph = PiGraph.class$("rvl.piface.PiGraph")) : class$rvl$piface$PiGraph, "PiGraphHelp.txt", "Graphics help", 25, 50);
        } else if (string.equals("About Piface")) {
            new AboutPiface();
        } else if (string.equals("Show Data")) {
            this.showData();
        } else if (string.equals("Draw")) {
            this.setVisible(false);
            this.init = false;
            Dimension dimension = this.getSize();
            int n = 3 * (dimension.width - 10) / 4 + dimension.height + 10;
            this.setSize(dimension.width, n);
            this.dataButton.setVisible(true);
            this.drawButton.setLabel("Redraw");
            this.setVisible(true);
            this.xVar = this.xChoice.getSelectedIndex();
            this.yVar = this.yChoice.getSelectedIndex();
            this.computePlotData();
            this.repaint();
        } else if (string.equals("Redraw")) {
            this.computePlotData();
            this.repaint();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.close();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

