/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import rvl.awt.DoubleField;
import rvl.awt.RVLayout;
import rvl.piface.DoubleComponent;

public class PiDoubleField
extends Panel
implements DoubleComponent,
ActionListener {
    private String name;
    private String label;
    private Font font = new Font("Serif", 1, 12);
    private DoubleField field;
    private Label lbl;
    private transient ActionListener actionListener = null;

    public PiDoubleField(String string, String string2, double d) {
        this(string, string2, d, 8, 5);
    }

    public PiDoubleField(String string, String string2, double d, int n, int n2) {
        this.setLayout(new RVLayout(2, false, true));
        this.lbl = new Label(string2);
        this.lbl.setFont(this.font);
        this.add(this.lbl);
        this.field = new DoubleField(d, n, n2);
        this.field.addActionListener(this);
        this.add(this.field);
        this.setName(string, string2);
        this.setVisible(true);
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public double getValue() {
        return this.field.getValue();
    }

    public void setName(String string, String string2) {
        this.name = string;
        this.label = string2;
        this.lbl.setText(string2);
    }

    public void setValue(double d) {
        this.field.setValue(d);
    }

    public void setEditable(boolean bl) {
        this.field.setEditable(bl);
    }

    public boolean isEditable() {
        return this.field.isEditable();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.field.setBackground(this.field.isEditable() ? Color.white : color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.field.setForeground(color);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.lbl.getPreferredSize();
        Dimension dimension2 = this.field.getPreferredSize();
        int n = dimension.width + dimension2.width;
        int n2 = Math.max(dimension.height, dimension2.height);
        return new Dimension(n, n2);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.lbl.getMinimumSize();
        Dimension dimension2 = this.field.getMinimumSize();
        int n = dimension.width + dimension2.width;
        int n2 = Math.max(dimension.height, dimension2.height);
        return new Dimension(n, n2);
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.field.isEditable()) {
            return;
        }
        ActionEvent actionEvent2 = new ActionEvent(this, 1001, "" + this.getValue());
        this.actionListener.actionPerformed(actionEvent2);
    }
}

