/*
 * Decompiled with CFR 0.152.
 */
package rvl.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.Vector;

public class RVLayout
implements LayoutManager,
Serializable {
    private int rows;
    private int cols;
    private int hGap = 6;
    private int vGap = 6;
    private int[] rowHgt;
    private int[] colWid;
    private int nvg = 0;
    private int nhg = 0;
    private int[] vGlue = new int[20];
    private int[] hGlue = new int[20];
    private boolean sizesSet = false;
    private boolean stretchRows = false;
    private boolean stretchCols = false;
    private Vector extras = new Vector();

    public RVLayout() {
        this(2);
    }

    public RVLayout(int n) {
        this.cols = n;
    }

    public RVLayout(int n, int n2, int n3) {
        this.cols = n;
        this.hGap = n2;
        this.vGap = n3;
    }

    public RVLayout(int n, boolean bl, boolean bl2) {
        this.cols = n;
        this.stretchRows = bl;
        this.stretchCols = bl2;
    }

    public RVLayout(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.cols = n;
        this.hGap = n2;
        this.vGap = n3;
        this.stretchRows = bl;
        this.stretchCols = bl2;
    }

    public void setHgap(int n) {
        this.hGap = n;
    }

    public void setVgap(int n) {
        this.vGap = n;
    }

    public int getHgap() {
        return this.hGap;
    }

    public int getVgap() {
        return this.vGap;
    }

    public void setStretchable(boolean bl, boolean bl2) {
        this.stretchRows = bl;
        this.stretchCols = bl2;
    }

    public boolean[] isStretchable() {
        return new boolean[]{this.stretchRows, this.stretchCols};
    }

    public void setColWidth(int n, int n2) {
        this.extras.addElement(new Dimension(-n, n2));
        this.sizesSet = false;
    }

    public void setRowHeight(int n, int n2) {
        this.extras.addElement(new Dimension(n, n2));
        this.sizesSet = false;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.insets();
        if (!this.sizesSet) {
            this.setSizes(container);
        }
        int n = insets.left + insets.right + this.cols * this.hGap;
        int n2 = insets.top + insets.bottom + this.rows * this.vGap;
        int n3 = 0;
        while (n3 < this.rows) {
            n2 += this.rowHgt[n3++];
        }
        n3 = 0;
        while (n3 < this.cols) {
            n += this.colWid[n3++];
        }
        return new Dimension(n, n2);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public void layoutContainer(Container container) {
        int n;
        int n2;
        if (!this.sizesSet) {
            this.setSizes(container);
        }
        Dimension dimension = this.preferredLayoutSize(container);
        int[] nArray = new int[this.cols];
        int[] nArray2 = new int[this.cols];
        double d = this.stretchCols ? (0.0 + (double)container.size().width - (double)(this.cols * this.hGap)) / (double)(dimension.width - this.cols * this.hGap) : 1.0;
        for (int i = 0; i < this.cols; ++i) {
            nArray[i] = (int)(d * (double)this.colWid[i]);
            nArray2[i] = 0;
        }
        int[] nArray3 = new int[this.rows];
        int[] nArray4 = new int[this.rows];
        d = this.stretchRows ? (0.0 + (double)container.size().height - (double)(this.rows * this.vGap)) / (double)(dimension.height - this.rows * this.vGap) : 1.0;
        for (int i = 0; i < this.rows; ++i) {
            nArray3[i] = (int)(d * (double)this.rowHgt[i]);
            nArray4[i] = 0;
        }
        Dimension dimension2 = this.preferredLayoutSize(container);
        if (this.nhg > 0 && !this.stretchCols && (n2 = (container.size().width - dimension2.width) / this.nhg) > 0) {
            for (n = 0; n < this.nhg; ++n) {
                if (this.hGlue[n] >= this.cols) continue;
                nArray2[this.hGlue[n]] = n2;
            }
        }
        if (this.nvg > 0 && !this.stretchRows && (n2 = (container.size().height - dimension2.height) / this.nvg) > 0) {
            for (n = 0; n < this.nvg; ++n) {
                if (this.vGlue[n] >= this.rows) continue;
                nArray4[this.vGlue[n]] = n2;
            }
        }
        Insets insets = container.insets();
        int n3 = insets.top + this.vGap / 2;
        n = container.countComponents();
        int n4 = 0;
        block4: for (int i = 0; i < this.rows; ++i) {
            n3 += nArray4[i];
            int n5 = insets.left + this.hGap / 2;
            for (int j = 0; j < this.cols; ++j) {
                Component component = container.getComponent(n4);
                component.reshape(n5 += nArray2[j], n3, nArray[j], nArray3[i]);
                n5 += nArray[j] + this.hGap;
                if (++n4 >= n) break block4;
            }
            n3 += nArray3[i] + this.vGap;
        }
    }

    private void setSizes(Container container) {
        int n = container.countComponents();
        this.rows = (n + this.cols - 1) / this.cols;
        this.colWid = new int[this.cols];
        this.rowHgt = new int[this.rows];
        int n2 = 0;
        while (n2 < this.cols) {
            this.colWid[n2++] = 0;
        }
        n2 = 0;
        while (n2 < this.rows) {
            this.rowHgt[n2++] = 0;
        }
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            Dimension dimension = container.getComponent(n2).preferredSize();
            this.colWid[n4] = Math.max(this.colWid[n4], dimension.width);
            this.rowHgt[n3] = Math.max(this.rowHgt[n3], dimension.height);
            if (++n4 < this.cols) continue;
            ++n3;
            n4 = 0;
        }
        for (n2 = 0; n2 < this.extras.size(); ++n2) {
            Dimension dimension = (Dimension)this.extras.elementAt(n2);
            if (dimension.width > 0) {
                this.rowHgt[dimension.width] = dimension.height;
                continue;
            }
            this.colWid[-dimension.width] = dimension.height;
        }
    }

    public void horzFill(Container container) {
        this.hGlue[this.nhg++] = container.countComponents() % this.cols;
    }

    public void vertFill(Container container) {
        this.vGlue[this.nvg++] = container.countComponents() / this.cols;
    }
}

