/*
 * Decompiled with CFR 0.152.
 */
package rvl.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.util.Vector;
import rvl.awt.Bar;
import rvl.util.Utility;

public class BarGroup
extends Canvas {
    protected double maxVal = 0.0;
    protected double limit;
    protected double tickInterval;
    protected double factor = Math.pow(2.0, 0.25);
    protected Frame parentFrame;
    protected Color barColor = Color.red;
    protected Color tickColor = Color.blue;
    protected Color lineColor = Color.white;
    protected boolean rescalable = true;
    protected boolean readOnly = false;
    Vector bar = new Vector();
    private Font labFont;
    private FontMetrics labMetrics;
    private boolean fontSet = false;
    private int labHeight;
    private int xDown;
    static final double ln10 = Math.log(10.0);

    public BarGroup(double d, Frame frame) {
        this.setLimit(d, false);
        this.parentFrame = frame;
    }

    public void addBar(Bar bar, double d) {
        this.bar.addElement(bar);
        this.maxVal = Math.max(d, this.maxVal);
        if (this.maxVal > this.limit) {
            this.setLimit(this.maxVal, false);
        }
    }

    public void setRescalable(boolean bl) {
        this.rescalable = bl;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    Bar getBar(int n) {
        return (Bar)this.bar.elementAt(n);
    }

    static double log10(double d) {
        return Math.log(d) / ln10;
    }

    public double getLimit() {
        return this.limit;
    }

    public void setLimit(double d, boolean bl) {
        double d2;
        double d3;
        this.maxVal = 0.0;
        if (this.rescalable) {
            for (int i = 0; i < this.bar.size(); ++i) {
                this.maxVal = Math.max(this.maxVal, this.getBar(i).getValue());
            }
            if (d < this.maxVal) {
                d = this.maxVal * 1.01;
            }
            this.limit = d;
        }
        double d4 = (d3 = this.limit / (d2 = Math.pow(10.0, Math.floor(BarGroup.log10(this.limit))))) <= 1.5 ? d2 / 5.0 : (this.tickInterval = d3 <= 4.0 ? d2 / 2.0 : d2);
        if (bl) {
            for (int i = 0; i < this.bar.size(); ++i) {
                this.getBar(i).repaint();
            }
            this.repaint();
        }
    }

    boolean checkValue(double d) {
        if (d <= this.maxVal) {
            return false;
        }
        this.setLimit(d * 1.05, true);
        return true;
    }

    public void grow() {
        this.setLimit(this.factor * this.limit, true);
    }

    public void shrink() {
        this.setLimit(this.limit / this.factor, true);
    }

    private void setFont(Graphics graphics) {
        this.labFont = new Font("Helvetica", 0, 9);
        this.labMetrics = graphics.getFontMetrics(this.labFont);
        this.labHeight = this.labMetrics.getAscent();
        this.fontSet = true;
    }

    public void setColor(Color color) {
        this.barColor = color;
    }

    public void setTickColor(Color color) {
        this.tickColor = color;
    }

    public void setBackground(Color color) {
        this.lineColor = color;
    }

    public Dimension preferredSize() {
        return new Dimension(300, 15);
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    public void paint(Graphics graphics) {
        if (!this.fontSet) {
            this.setFont(graphics);
        }
        int n = this.size().width - 10;
        int n2 = (this.size().height + this.labHeight) / 2;
        double d = (double)n / this.limit;
        graphics.setFont(this.labFont);
        graphics.setColor(this.tickColor);
        int n3 = -100;
        for (double d2 = 0.0; d2 < 1.01 * this.limit; d2 += this.tickInterval) {
            String string = this.niceLabel(d2);
            int n4 = this.labMetrics.stringWidth(string);
            int n5 = (int)(5.5 + d2 * d - (double)(n4 / 2));
            if (n5 + n4 > 5 + n) {
                n5 = 5 + n - n4;
            }
            if (n5 <= 5 + n3) continue;
            graphics.drawString(string, n5, n2);
            n3 = n5 + n4;
        }
    }

    private String niceLabel(double d) {
        int n = 1;
        String string = Utility.format(d, n);
        double d2 = 0.01 * Math.abs(d);
        while (n < 10 && Math.abs(Utility.strtod(string) - d) > d2) {
            string = Utility.format(d, ++n);
        }
        return string;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        if (!this.rescalable) {
            return true;
        }
        this.parentFrame.setCursor(11);
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        if (!this.rescalable) {
            return true;
        }
        this.parentFrame.setCursor(0);
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.requestFocus();
        if (!this.rescalable) {
            return true;
        }
        this.xDown = n >= 10 ? n : 10;
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (!this.rescalable) {
            return true;
        }
        n = n >= 10 ? n : 10;
        double d = ((double)this.xDown + 0.0) / (double)n;
        this.setLimit(d * this.limit, true);
        return true;
    }
}

