(provide "tour")

(defproto tour-mixin '(tour-count tour-trans tour-active-vars))

(defmeth tour-mixin :do-idle () (send self :tour-step) (pause 2))

(defmeth tour-mixin :tour-active-vars (&optional (new nil set))
  (let ((tv (send self :num-tour-variables)))
    (when (and set (< 0 new) (<= new tv))
      (setf (slot-value 'tour-active-vars) new))
    (let ((av (slot-value 'tour-active-vars)))
      (if av av tv))))

;; This should really allow a subset to be chosen
(defmeth tour-mixin :choose-tour-active-vars ()
  (let ((tv (send self :num-tour-variables))
	(av (send self :tour-active-vars)))
    (let* ((choices (mapcar #'(lambda (x) (format nil "~d" x)) (iseq 1 tv)))
	   (v (choose-item-dialog "Number of Tour Variables" choices
				  :initial (- av 1))))
      (when v (send self :tour-active-vars (+ v 1))))))
    
(defmeth tour-mixin :tour-step ()
  (when (< (slot-value 'tour-count) 0)
        (flet ((sphere-rand (n)
                 (loop (let* ((x (- (* 2 (uniform-rand n)) 1))
                              (nx2 (sum (^ x 2))))
                         (if (< nx2 1) (return (/ x (sqrt nx2))))))))
          (let* ((vars (send self :tour-active-vars))
                 (angle (abs (send self :angle)))
                 (max (floor (/ pi (* 2 angle)))))
            (setf (slot-value 'tour-count) (random max))
            (setf (slot-value 'tour-trans) 
                  (make-rotation (sphere-rand vars) 
                                 (sphere-rand vars)
                                 angle)))))
  (send self :apply-transformation (slot-value 'tour-trans))
  (setf (slot-value 'tour-count) (- (slot-value 'tour-count) 1)))

(send tour-mixin :slot-value 'tour-count -1)

(defmeth tour-mixin :tour-on (&rest args) (apply #'send self :idle-on args))

(defmeth tour-mixin :reset ()
  (setf (slot-value 'tour-count) -1)
  (send self :transformation nil))

(defmeth tour-mixin :menu-template ()
  (let ((tour-item (send graph-item-proto :new "Touring" self
			 :tour-on :tour-on :toggle t))
	(reset-item (send graph-item-proto :new "Reset" self :reset))
	(vars-item (send graph-item-proto :new "Tour Variables ..."  self
			 :choose-tour-active-vars))
	(dash (send dash-item-proto :new)))
    (send tour-item :key #\T)
    (append (call-next-method) (list dash vars-item reset-item tour-item))))

(defproto spin-tour-proto '(angle) ()
  (list tour-mixin spin-proto))

(defmeth spin-tour-proto :num-tour-variables () (send self :num-variables))

(defun tour-plot (data &rest args &key point-labels)
  (let ((graph (apply #'send spin-tour-proto :new (length data) args)))
    (if point-labels
        (send graph :add-points data :point-labels point-labels :draw nil)
        (send graph :add-points data :draw nil))
    (send graph :adjust-to-data :draw nil)
    graph))
