(load-data "tutorial")

(defun coplot (x-var y-var z-var)
  (let ((h (plot-points z-var (uniform-rand (length z-var)) :show nil))
	(p (plot-points x-var y-var :variable-labels
                        '("Tensile Strength" "Abrasion Loss")))
	(ir (interquartile-range x-var)))
        
    (send h :variable-label 0 "Hardness")
    (send h :range 1 0 1.2)
    (let ((w (first (send h :size))))
      (send h :size w (round (/ w 4))))
    (send h :y-axis nil)
    (send h :adjust-to-data)
    (send h :show-window)

    (send h :linked t)
    (send h :mouse-mode 'brushing)

    (send p :linked t)

    (send p :add-slot 'kernel-width ir)

    (defmeth p :kernel-width (&optional width)
      (when width
	    (setf (slot-value 'kernel-width) width)
	    (send self :adjust-screen))
      (slot-value 'kernel-width))

    (defmeth p :adjust-screen ()
      (call-next-method)
      (let ((i (union (send self :points-selected)
		      (send self :points-hilited))))
	(send self :clear-lines :draw nil)
	(if (< 1 (length i))
	    (let ((x (select x-var i))
		  (y (select y-var i))
		  (w (send self :kernel-width)))
	      (send self :add-lines (kernel-smooth x y :width w)))
	  (send self :redraw-content))))

    (let ((s (interval-slider-dialog
	      (list (/ ir 5) (* ir 5))
	      :action #'(lambda (w) (send p :kernel-width w)))))
      (send s :value ir)
      (send p :add-subordinate s))))

