(require "tour")
(require "parplot")

;;;;
;;;; Examples
;;;;


;;
;; Abrasion Loss
;;

(load-data "tutorial")
(load-example "addhandrotate")
(load "linking")

(defun abrasion-scatmat ()
  (scatterplot-matrix (list hardness tensile-strength abrasion-loss)
		      :variable-labels '("H" "T" "A")))

(defun abrasion-spin ()
  (let ((p (spin-plot (list hardness tensile-strength abrasion-loss)
		      :variable-labels '("H" "T" "A"))))
    (send p :mouse-mode 'hand-rotate)))

(defun abrasion-plot-hist ()
  (plot-points (list tensile-strength abrasion-loss)
	       :variable-labels '("Tensile Strength" "Abrasion Loss"))
  (histogram hardness :variable-labels '("Hardness")))

(defun abrasion-parplot ()
  (parallel-plot (list abrasion-loss tensile-strength hardness)))

(defun link-and-smooth ()
  (coplot tensile-strength abrasion-loss hardness))

;;
;; density demo
;;

(defun density-demo ()
  (let* ((s (rseq 20 80 31))
         (p (plot-lines (kernel-dens abrasion-loss 
                                     :points 30 :width (first s)))))
    (send p :add-subordinate
	  (sequence-slider-dialog 
	   s
	   :action
	   #'(lambda (w)
	       (send p :clear :draw nil)
	       (send p :add-lines 
              (kernel-dens abrasion-loss :points 30 :width w))
        (pause 2))))))

;;
;; Tours
;;

(load-data "diabetes")

(defun diabetes-spin-tour ()
  (tour-plot diabetes :variable-labels dlabs))

(defun diabetes-par-tour ()
  (let ((p (tour-parallel-plot diabetes))
	(n (length diabetes)))
    (defmeth p :num-tour-variables () n)
    (send p :current-axis n)
    p))

(load "flea")

(defun fleas-spin-tour ()
  (tour-plot fleabeetles :variable-labels dlabs))

(defun fleas-par-tour ()
  (let ((p (tour-parallel-plot fleabeetles))
	(n (length fleabeetles)))
    (defmeth p :num-tour-variables () n)
    (send p :current-axis n)
    p))

;;
;; Menus
;;

(defvar *example-menu* (send menu-proto :new "JSM'17"))
(send *example-menu* :append-items
      (send menu-item-proto :new "Abrasion Plot/Hist"
	    :action 'abrasion-plot-hist)
      (send menu-item-proto :new "Abrasion Pairs" :action 'abrasion-scatmat)
      (send menu-item-proto :new "Abrasion Spin" :action 'abrasion-spin)
      (send menu-item-proto :new "Abrasion Parallel" :action 'abrasion-parplot)
      (send dash-item-proto :new)
      (send menu-item-proto :new "Density" :action 'density-demo)
      (send menu-item-proto :new "Link and Smooth" :action 'link-and-smooth)
      (send dash-item-proto :new)
      (send menu-item-proto :new "Grand Tour" :action 'diabetes-spin-tour)
      (send menu-item-proto :new "Parallel Tour" :action 'diabetes-par-tour)
      )

(send *example-menu* :install)

(require "mussels")
