#include "Rinternals.h"
#include "R_ext/Rdynload.h"

static void addone(double *x, int *nx, double *val, int *nv)
{
    if (nx[0] == nv[0]) {
	int n, i;

	n = nx[0];
	for (i = 0; i < n; i++)
	    val[i] = x[i] + 1.0;
    }
    else error("argument and value lengths do not match.");
}

static void addone_p(double *x, int *nx, double *val, int *nv, int *P)
{
    if (nx[0] == nv[0]) {
	int n, i;

	/* The variable naflag is used to record whether a NaN value
	   is encountered in the vectorized computation. The
	   reduction() clause below shows how to allow this variable
	   to be modified within each thread and have the values
	   compined with the reduction at the end of the parallel
	   loop. */
	int naflag = FALSE;

	n = nx[0];

	/* Using the default(none) clause forces all variables to be
	   explicitly declared as shared, private, firstprivate, or
	   reduction (there is also a lastprivate option).  Good OMP
	   compilers can work out the appropriate declaration, but
	   lower quality ones benefit from explicit declarations. */
#pragma omp parallel for num_threads(P[0]) default(none) \
    firstprivate(n, x, val) private(i) \
    reduction(||:naflag)
	for (i = 0; i < n; i++) {
	    /* The log(exp(...)) construct adds extra work to make the
	       effect of parallalization more visible; with this
	       simple function a vector of length 10,000,000 may be
	       needed to see much of an effect even with this
	       construct. */
	    val[i] = log(exp(x[i] + 1.0));
	    if (ISNAN(val[i]))
		naflag = TRUE;
	}
	if (naflag) warning("NAs generated");
    }
    else error("argument and value lengths do not match.");
}

/* This defines a data structure for registering the routine
   `addone'. It records the number of arguments, which allows some
   error checking when the routine is called. */
static R_CMethodDef DotCEntries[] = {
    {"add_one", (DL_FUNC) addone, 4},
    {"add_one_p", (DL_FUNC) addone_p, 5},
    {NULL}
};

/* This is called by the dynamic loader to register the routine. */
void R_init_AddOne(DllInfo *info)
{
    R_registerRoutines(info, DotCEntries, NULL, NULL, NULL);
}
