require(tcltk)

if (Sys.info()["sysname"] == "Windows") {
    my.tkdev <- function() win.metafile(width=4,height=4)
} else {
    my.tkdev <- function()
	.Internal(X11("XImage", 480, 480, 12, 1,
                  getOption("X11colortype"), 256))
}

#make.tkindex <- local({
#    index <- 0
#    function() { index <<- index + 1; index }
#})

.My.Tk.index <- 0
make.tkindex <- function() {
    .My.Tk.index <<- .My.Tk.index + 1
    .My.Tk.index
}

tkrplot <- function(parent, fun) {
    image <- paste("Rplot", make.tkindex(), sep="")
    my.tkdev()
    try(fun())
    .Tcl(paste("image create Rplot", image))
    lab<-tklabel(parent,image=image) #**** use try, delete image on failure
    tkbind(lab,"<Destroy>", function() .Tcl(paste("image delete", image)))
    lab$image <- image
    lab$fun <- fun
    lab
}

tkrreplot <- function(lab, fun = lab$fun) {
    my.tkdev()
    try(fun())
    .Tcl(paste("image create Rplot", lab$image))
}

#**** this is unspeakably crude    
tkpersp <- function(x,y,z, theta = 30,phi = 30,expand = 0.5, r = sqrt(3), ...) {
    base<-tktoplevel()

    draw <- function() {
        par(bg = "white")
        try(persp(x, y, z, theta = theta, phi = phi, expand = expand, r = r,
                  ...))
    }

    img<-tkrplot(base, draw)

    getTclVar <- function(name)
        .Tcl(paste("set", name))
    setTclVar <- function(name, value)
        .Tcl(paste("set ", name, " {", value, "}", sep = ""))

    make.scale <- function(parent, from, to, resolution, title, command,
                           initial=from, showvalue =FALSE, orient="horiz") {
        var <- paste("rgv_", make.tkindex(), sep="")
        setTclVar(var, initial)
        fun <- function(...) command(as.numeric(getTclVar(var)))

        frame <-tkframe(parent, relief="groove", borderwidth=2)
        tkpack(tklabel (frame, text=title))
        tkpack(tkscale(frame, command=fun, from=from, to=to,
                       showvalue=showvalue, variable=var,
                       resolution=resolution, orient=orient))
        tkbind(frame,"<Destroy>", function() .Tcl(paste("unset", var)))
        frame
    }

    frame <- tkframe(base)

    s.theta <- make.scale(frame, from=0, to=360, resolution=5,
                title="Theta", initial=theta, showvalue=TRUE,
                command=function(x) {
                    if (x != theta) {
                        theta <<- x 
                        tkrreplot(img)
                    }
                })

    s.phi <- make.scale(frame, from=0, to=360, resolution=5,
                title="Phi", initial=phi, showvalue=TRUE,
                command=function(x) {
                    if (x != phi) {
                        phi <<- x 
                        tkrreplot(img)
                    }
                })

    s.expand <- make.scale(frame, from=0.05, to=1, resolution=0.05,
                title="Expand", initial=expand, showvalue=TRUE,
                command=function(x) {
                    if (x != expand) {
                        expand <<- x 
                        tkrreplot(img)
                    }
                })

    s.r <- make.scale(frame, from=0.05, to=3, resolution=0.05,
                title="R", initial=r, showvalue=TRUE,
                command=function(x) {
                    if (x != r) {
                        r <<- x 
                        tkrreplot(img)
                    }
                })

    tkpack(s.theta, s.phi, s.expand, s.r, side="left", anchor="n")
    tkpack(img,frame)
}

.Tkrplot.loaded<-FALSE

.First.lib <- function(lib, pkg) {
    if (! .Tkrplot.loaded) {
        chname<-"tkrplot"
        file.ext <- .Platform$dynlib.ext
        path <- file.path("libs", paste(chname, file.ext, sep = ""))
        file <- system.file(path, package = pkg, lib.loc = lib)[1]
        .Tcl(paste("load", file, "Rplot"))
        .Tkrplot.loaded <<- TRUE
    }
}
