\name{namespace}
\title{Name Space Support}
\alias{namespace}

\alias{attachNamespace}
\alias{loadNamespace}
\alias{registeredNamespaces}
\alias{topenv}

\alias{registerMethod}

\alias{makeNamespace}
\alias{getNamespace}
\alias{namespaceEnv}
\alias{namespaceExport}
\alias{namespaceExports}
\alias{namespaceGet}
\alias{namespaceImport}
\alias{namespaceImportFrom}
\alias{namespaceImports}
\alias{namespaceIsSealed}
\alias{namespaceName}
\alias{sealNamespace}

\usage{
   attachNamespace(ns, prefix = "namespace") 
   loadNamespace(package, lib.loc = .lib.loc,
                 keep.source = getOption("keep.source.pkgs")) 
   getNamespace(name)
   registeredNamespaces()
   topenv(envir = parent.frame()) 
   registerMethod(genname, class, method) 
}
\arguments{
  \item{ns}{string or namespace object.}
  \item{name}{string or name.}
  \item{prefix}{string to use as prefix for name in search path.}
  \item{package}{string naming the package/namespace to load.}
  \item{lib.loc}{character vector specifying library search path.}
  \item{keep.source}{logical specifying whether to retain source.}
  \item{envir}{environment.}
  \item{genname}{string naming the generic.}
  \item{class}{string naming the class.}
  \item{method}{function to register as method.}
}
\description{
  Name space support functions.
}
\details{
  See \url{http://www.stat.umn.edu/~luke/R/namespaces/morenames.html}.
}
\examples{
}
\keyword{internal}
\author{Luke Tierney}
