#include "Rinternals.h"
void R_ReturnOrRestart(SEXP val, SEXP env, Rboolean restart);
void R_PrintDeferredWarnings(void);
SEXP R_GetTraceback(int);
void R_SetErrmessage(char *s);
void R_SetErrorHook(void (*hook)(SEXP, char *));
void R_SetWarningHook(void (*hook)(SEXP, char *));
void R_JumpToToplevel(Rboolean restart);
SEXP DoReturnOrRestart(SEXP val, SEXP env)
{
    R_ReturnOrRestart(val, env, TRUE);
    return R_NilValue;
}
SEXP DoReturn(SEXP val, SEXP env)
{
    R_ReturnOrRestart(val, env, FALSE);
    return R_NilValue;
}
SEXP JumpToToplevel(SEXP restart)
{
  if (TYPEOF(restart) != LGLSXP || LENGTH(restart) != 1)
        error("bad restarts.honored argument");
  R_JumpToToplevel(LOGICAL(restart)[0]);
}
static void hook(SEXP fun, SEXP call, char *s)
{
    SEXP expr, msg, qsym = install("quote");
    PROTECT(msg = allocVector(STRSXP, 1));
    SET_STRING_ELT(msg, 0, mkChar(s));
    PROTECT(call = LCONS(qsym, LCONS(call, R_NilValue)));
    expr = LCONS(msg, R_NilValue);
    expr = LCONS(call, expr);
    PROTECT(expr = LCONS(fun, expr));
    eval(expr, R_GlobalEnv);
    UNPROTECT(3);
}

static void errhook(SEXP call, char *s)
{
    hook(install("error.hook"), call, s);
}

static void warnhook(SEXP call, char *s)
{
    hook(install("warning.hook"), call, s);
}

SEXP EnableExceptionHooks(void)
{
    R_SetErrorHook(errhook);
    R_SetWarningHook(warnhook);
    return R_NilValue;
}
SEXP PrintDeferredWarnings(void)
{
    R_PrintDeferredWarnings();
    return R_NilValue;
}
SEXP GetTraceback(SEXP skip)
{
    if (TYPEOF(skip) != INTSXP || LENGTH(skip) != 1)
        error("bad skip argument");
    return R_GetTraceback(INTEGER(skip)[0]);
}
void SetErrmessage(char **s)
{
    R_SetErrmessage(*s);
}
SEXP InternalWarningCall(SEXP call, SEXP msg)
{
    if (TYPEOF(msg) != STRSXP || LENGTH(msg) != 1)
        error("invalid warning message");
    R_SetWarningHook(NULL);
    Rf_warningcall(call, "%s", CHAR(STRING_ELT(msg, 0)));
    R_SetWarningHook(warnhook);
    return R_NilValue;
}
