handler.stack <- NULL  ## place holder for .First.lib
reset.stack <- NULL  ## place holder for .First.lib
callcc <- function(fun) {
    env <- environment()
    k <- function(v, restarts.honored = FALSE) {
        if (restarts.honored)
            .Call("DoReturnOrRestart", v, env)
        else
            .Call("DoReturn", v, env)
    }
    fun(k)
}
add.to.handler.stack <- function(handler, class, exit, stack) {
    list(handler = handler, class = class, exit = exit,
         next.handler = stack)
}
add.default.handler <- function(handler, class)
    handler.stack(add.to.handler.stack(handler, class, NULL, handler.stack()))
handle.condition <- function(c) {
    h <- handler.stack()
    if (is.null(h))
         FailsafeErrorHandler(c)
    while (! is.null(h))
        if (inherits(c, h$class))
            break
        else h <- h$next.handler
    if (is.null(h)) {
        EnableErrorHooks()
        my.stop(no.condition.handler.exception(c)) #****
    }
    if (is.null(h$exit))
        dynamic.bind({
            EnableErrorHooks()
            h$handler(c)
        }, handler.stack = h$next.handler)
    else {
        restarts.honored <- inherits(c, "exception")
        result <- list(throw = TRUE, handler = h$handler, condition = c)
        EnableErrorHooks()
        h$exit(result, restarts.honored)
    }
}
FailsafeErrorHandler <- function(c) {
    errcat("Error: error in default exception handler\n")
    EnableErrorHooks()
    abort()
}
signal.condition <- function(c) {
    if (! inherits(c, "condition"))
        c <- simple.condition(c)
    handle.condition(c)
}
my.stop <- function(e, call. = TRUE) {
    if (! is.condition(e))
        e <- simple.exception(e, if (call.) sys.call(1) else NULL)
    signal.condition(e)
    errcat("aborting ...\n")
    abort()
}
stop <- my.stop
my.warning <- function(w) {
    if (! inherits(w, "warning"))
       w <- simple.warning(w, sys.call(1))
    signal.condition(w)
}
warning <- my.warning
ignore.errors <- function(expr)
    try.catch(expr, exception = function(e) e)
muffle.warnings <- function(expr)
    with.handlers(expr, warning = function(w) {})
with.handlers <- function(expr, ...) {
    stack <- handler.stack()
    handlers <- rev(list(...))
    classes <- names(handlers)
    for (i in seq(along = handlers))
        stack <- add.to.handler.stack(handlers[[i]], classes[i], NULL, stack)
    dynamic.bind(expr, handler.stack = stack)
}
try.catch <- function(expr, ..., finally = NULL) {
    on.exit(finally)
    result <- callcc(function(k) {
        stack <- handler.stack()
        handlers <- rev(list(...))
        classes <- names(handlers)
        for (i in seq(along = handlers))
            stack <- add.to.handler.stack(handlers[[i]], classes[i], k, stack)
        dynamic.bind(list(throw = FALSE, value = expr), handler.stack = stack)
    })
    if (result$throw)
        result$handler(result$condition)
    else
        result$value
}
is.condition <- function(c) inherits(c, "condition")
print.condition <- function(c, ...) {
    msg <- condition.message(c)
    call <- condition.call(c)
    class <- class(c)[1]
    if (! is.null(call))
        cat("<", class, " in ", deparse(call), ": ", msg, ">\n", sep="")
    else
        cat("<", class, ": ", msg, ">\n", sep="")
}

condition.message <- function(c) UseMethod("condition.message", c)
condition.call <- function(c) UseMethod("condition.call", c)

condition.message.condition <- function(c) c$message
condition.call.condition <- function(c) c$call
simple.condition <- function(message, call = NULL) {
    class <- c("simple.condition", "condition")
    structure(list(message=as.character(message), call = call), class=class)
}

simple.exception <- function(message, call = NULL) {
    class <- c("simple.exception", "exception", "condition")
    structure(list(message=as.character(message), call = call), class=class)
}

simple.warning <- function(message, call = NULL) {
    class <- c("simple.warning", "warning", "condition")
    structure(list(message=as.character(message), call = call), class=class)
}
no.condition.handler.exception <- function(c)
    structure(list(message = paste("no condition handler for", class(c)[1]),
                   condition = c),
              class = c("no.condition.handler.exception",
                        "exception", "condition"))
default.handler <- function(e) {
    UseMethod("default.handler", e)
}
default.handler.exception <- function(e) {
    call <- condition.call(e)
    message <- condition.message(e)
    op <- getOption("add.error.underscore")
    if (is.null(op) || op)
        us <- "_"
    else
        us <- ""
    if (is.null(call))
        emsg <- paste(us, "Error: ", message, "\n", sep = "")
    else {
        dcall <- deparse(call)
        if (nchar(dcall) > 30)
            emsg <- paste(us, "Error in ", dcall[1], " :\n\t", message, "\n",
                          sep = "")
        else
            emsg <- paste(us, "Error in ", dcall[1], " : ", message, "\n",
                          sep = "")
    }

    seterrmessage(emsg)
    if (getOption("error.messages")) {
        errcat(emsg)
        PrintDeferredWarnings()
    }

    handler <- getOption("error")
    if (! is.null(handler))
        eval(handler, R_GlobalEnv)
    else if (! interactive()) {
        errcat("Execution halted\n")
        q("no", 1, FALSE)  # quit, no save, no .Last, status=1
    }

    tb <- getTraceback()
    tb <- trim.traceback(tb)
    assign(".Traceback", tb, env = .GlobalEnv)
    abort()
}
trim.traceback <- function(t) {
    n <- length(t)
    pos <- NULL
    for (i in seq(along=t))
        if (pmatch("signal.condition(", t[[i]], 0)) {
            pos <- i
            break
        }
    if (is.null(pos))
        t
    else {
        if (pos < n - 1 &&
            pmatch("my.stop(", t[[pos + 1]], 0) &&
            pmatch("error.hook(", t[[pos + 2]], 0))
            pos <- pos + 2
        if (pos == n)
            NULL
        else
            t[(pos+1):n]
    }
}
PrintDeferredWarnings <- function() .Call("PrintDeferredWarnings")
getTraceback <- function(skip = 1)
    .Call("GetTraceback", as.integer(skip))
seterrmessage <- function(s)
    .C("SetErrmessage", as.character(s))
default.handler.warning <- function(w) {
    .Call("InternalWarningCall", condition.call(w), condition.message(w))
}
errcat<- function(s) cat(s, file=stderr())
EnableErrorHooks <- function() {
    .Call("EnableExceptionHooks")
}
error.hook <- function(call, msg)
     my.stop(simple.exception(msg, call))

warning.hook <- function(call, msg)
     my.warning(simple.warning(msg, call))
make.reset <- function(name = "",
                       handler = function(...) NULL,
                       message = NULL,
                       test = function(c) TRUE,
                       interactive = function() NULL,
                       restarts.honored = FALSE) {
    structure(list(name = name, handler = handler, message = message,
                   test = test, interactive = interactive,
                   restarts.honored = restarts.honored),
              class = "reset")
}

print.reset <- function(r)
     cat(paste("<reset:", r$name, ">\n"))

is.reset <- function(x) inherits(x, "reset")
add.to.reset.stack <- function(spec, name, exit, stack) {
    if (is.function(spec))
        reset <- make.reset(handler = spec)
    else if (is.character(spec))
        reset <- make.reset(message = spec)
    else if (is.list(spec))
        reset <- do.call("make.reset", spec)
    else
        stop("not a valid reset specification")
    reset$name <- name
    list(reset = reset, exit = exit, next.reset = stack)
}
with.resets <- function(expr, ...) {
    result <- callcc(function(k) {
        stack <- reset.stack()
        specs <- rev(list(...))
        names <- names(specs)
        for (i in seq(along = specs))
            stack <- add.to.reset.stack(specs[[i]], names[i], k, stack)
        dynamic.bind(list(throw = FALSE, value = expr), reset.stack = stack)
    })
    if (result$throw) {
        h <- result$handler
        do.call("h", result$args)
    }
    else
        result$value
}
find.reset <- function(name, cond = NULL) {
    r <- reset.stack()
    while (! is.null(r))
        if (name == r$reset$name && (is.null(cond) || r$reset$test(cond))) {
            res <- r$reset
            res$exit <- r$exit
            return(res)
        }
        else
            r <- r$next.reset
    NULL
}
compute.resets <- function(cond = NULL) {
    r <- reset.stack()
    val <- NULL
    while (! is.null(r)) {
        if (is.null(cond) || r$reset$test(cond)) {
            res <- r$reset
            res$exit <- r$exit
            val <- c(val, list(res))
        }
        r <- r$next.reset
    }
    val
}
invoke.reset <- function(r, ...) {
    if (! is.reset(r))
        r <- find.reset(r)
    if (is.null(r$exit))
        stop("calling resets not supported (yet)")
    result <- list(throw = TRUE, handler = r$handler, args = list(...))
    r$exit(result, r$restarts.honored)
}
abort <- function()
     invoke.reset("abort")
invoke.reset.interactively <- function(r) {
    if (! is.reset(r))
        r <- find.reset(r)
    if (is.null(r$exit))
        stop("calling resets not supported (yet)")
    args <- r$interactive()
    result <- list(throw = TRUE, handler = r$handler, args = args)
    r$exit(result, r$restarts.honored)
}
.First.lib <- function(lib, pkg) {
    library.dynam(pkg, pkg, lib)

    require(dynvars)
    handler.stack <<- dynamic.variable()
    add.default.handler(default.handler, "exception")
    add.default.handler(default.handler, "warning")
    reset.stack <<- dynamic.variable(
        add.to.reset.stack(list(handler = function() {},
                                restarts.honored = TRUE),
                           "abort",
                           function(result, restarts.honored)
                               .Call("JumpToToplevel", restarts.honored),
                           NULL))
    EnableErrorHooks()    
}
