
function [nX,D,y,ye,betatrue,supp]=gendata(n,p,K,sigma,cor,ratio,seednum,isnorm)
%========================================================================
% Input:
% n:           number of features 
% p:           number of observation 
% K:           number of non zero elemet in  real solution 
% ratio:       range of value in betatrue = 10^ratio;
% sigma:       varince of white gausian noise 
% cor:         corelation number of columns in X 
% seednum:     the seed number 
% isnorm:      1 normlized and stantalized; 0 not
% Output:
% nX:          covariate matrix normlized and standlized if isnormstan = 1
% D:           [], if isnormstan = 0; diagnal matrix if isnormstan = 1
% y:           outcome vector 
% betature:    the real solution 
% supp:        the support of betatrue 
% Copyright (c), Dep, 2013
% Yuling Jiao  Dept. Math.,Whuhan Univiversity
% Email: yulingjiaomath@whu.edu.cn
%======================================================================== 

disp(' Data generation ...')
t = cputime;
rand('seed',seednum);   % fix seed 
randn('seed', seednum); % fix seed 
ratio = ratio*20;
% creat betatrue
betatrue = zeros(p,1);  
q = randperm(p);
supp = q(1:K);
valbeta = ratio/20*rand(K,1);
valbeta = valbeta- min(valbeta);
valbeta = valbeta/max(valbeta)*ratio/20;
if ratio ~= 0
betatrue(supp) = 10.^valbeta.*sign(randn(K,1));
else
betatrue(supp) = sign(randn(K,1));
end

% creat X 
X = randn(n,p);
if cor ~= 0
    Sigma = zeros(p,p);
for k = 1:p
    for l = 1:p 
        Sigma(k,l)=cor^(abs(k-l));
    end
end
X= X*chol(Sigma);
end

	
% creat noisy observations  
eta = sigma*randn(n,1);
ye = X*betatrue; 
y =  ye + eta;

% normalize 
if isnorm == 1
   [nX,D] = normalize(X);
else
    nX = X;
    D = [];
end
supp = find(betatrue);
t = cputime - t;
display(sprintf('generate done using time (second) = %g',t))