function [ebeta, ed, Ac, nIter] = sdar(X,y,opts)
% ========================================================================
% Support Detection Approach for Sparse Regression 
%        y = X\beta^{\dag} + \eta
% Copyright (c), Dep, 2013
% Yuling Jiao  Dept. Math.,Whuhan Univiversity
% Email: yulingjiaomath@whu.edu.cn
% ========================================================================
% ========================================================================
% Input:  
% X:           the covariate matrix in R^{n*p}, unite normalized 
% y:           response vector in R^{n}
% opts is a structure shoud contain:
% opts.T:      number of features to be selected  (defaut: n^0.5)
% opts.J:      maxiteration number for safe guard   (defaut: 2*opts.T)
% opts.alpha : a parameter to handle the strong  colinerity  (defaut: 0)
% opts.inital: initial value
% Output: 
% ebeta:       an estimate of regression coefficient 
% ed:          an  estimate  of dual variable 
% Ac:          acive set of ebeta 
% nIter:       the iteration number when sdca stop
% ========================================================================
[n,p] = size(X);
if nargin < 2
    disp('error, not enough inputment')
elseif nargin == 2 
    T = n^0.5;
    J = 2*T;
    alpha = 0;
    initial = zeros(p,1);
elseif nargin == 3
    T = opts.T;
    J = opts.J;
    alpha = opts.alpha;
    initial = opts.initial;
else
    disp('error, too much inputment')  
end
S = 1:p;
Xty  = X'*y;
pd = initial + Xty - X'*(X*initial);
[a,b]=sort(abs(pd),'descend');
Ac = b(1:T);
nIter = 0;
ebeta = zeros(p,1);
ed = [];
stop  = 1;
while stop ~= 0 && nIter <J
   nIter = nIter  + 1;
   ebeta = zeros(p,1);
   ed = zeros(p,1);
   XtyAc = Xty(Ac);
   Ic = setdiff(S,Ac);
   Xac = X(:,Ac);
   G = Xac'*Xac + alpha*eye(length(Ac));
   tbetaac = G\XtyAc;
   ebeta(Ac) = tbetaac;
   td = Xty - X'*(Xac*tbetaac);
   tdic = td(Ic);
   ed(Ic) = tdic;
   pd = ed + ebeta;
   [a,b]=sort(abs(pd),'descend');
   oAc = Ac;
   Ac = b(1:T);
   if length(oAc) == length(Ac)
     if oAc == Ac
        stop = 0;
     end
   end
end

