function [betahat, lambdahat, Hisbeta, HisAclen, HisIter, Bic] = cdjmcppath(X,y,opts)

% ========================================================================
% Approximate the  solution path of MCP panalize linear regerssion  in
% High dimentional with n << p by minmizing 
%     1/2||X*beta-y||^2  + Mcp_{lambda,tau}(beta) 
% with Coodinate decesent  algorithm  in the version of Jacobion on 
% Lambda ={lambda_{1},...,lambda_{N}}
% Copyright (c), Des, 2012
% Yuling Jiao  Dept. Math.,Whuhan Univiversity
% Email: yulingjiaomath@whu.edu.cn
% ========================================================================
% ========================================================================
% Input:  
% X:      the covariate matrix (nomalized) in R^{n*p}
% y:      response vector in R^{n}
% opts.N:      the size of Omiga  (defaut: 30)
% opts.K:      maxiteration number in SSN for safe guard   (defaut: 5*n)
% opts.mu:     stop parameter when |df|>mu*n  (defaut: 0.5)
% opts.tau:    Lambda = norminf*[tau,1] (defaut: 1e-10-1e-15) 
% opts.normnX: step length that make convergence (default norm(nX))
% opts.initial: initial value, (default(zeros(p,1)))
% opts.stop:    stop when norm(beta^k+1)/norm(beta^k+1-beta^k)<opts.stop 
%               (default,1e-6)
% opts.D:       the diagal matrix that makes X unite normalized
   
% Output: 
% betahat:      an estimate of regression coefficient selected by BIC
% lambdahat:    regularization parameter selected by BIC
% Hisbeta:      a matix  storing the history of 
%               beta_{lambda_{k}},k =1,...N 
% HisAClen:     a vector storing the history of acive set size of
%               beta_{lambda_{k}},k =1,...N 
% HisIter:      a vector storing  the iteration number when SSN stop at
%               each  lambda_{k},k =1,...N
% Bic:          BIC value 
% ========================================================================
[n,p] = size(X);
if nargin < 2
    disp('error, not enough inputment ')
elseif  nargin > 3
    disp('error, too much inputment ')
elseif nargin == 2 || isempty(opts)
    opts.N = 100;
    opts.tau = 1e-15;
    opts.K = 5*n;
    opts.mu = 0.5;
    opts.normnX = norm(nX);
    opts.initial = zeros(p,1);
    opts.stop = 1e-6;
    opts.gamma = 2.7;
end


% define the set Lambda 
opts.Xty = X'*y;
lambdaMin = opts.tau;
lambdaMax = 1;
loghi = log(lambdaMax);
loglo = log(lambdaMin);
logrange = loghi - loglo;
interval = -logrange/(opts.N-1);
Lambda = exp(loghi:interval:loglo)';
Lambda = Lambda(2:end);
if Lambda(1) < 0.7 
    Lambda = [0.9;0.8;0.7;Lambda];
end
Lambda = norm(opts.Xty,inf)*Lambda;
lenLam = length(Lambda);

Hisbeta = zeros(p,lenLam);
HisAclen = [];
HisIter =[];
Bic = [];

%% main loop for choosing lamda 
disp(' run CD-J on Lambda ...')
df = 0;
k = 0;
mun = opts.mu*n;
while df <mun && k < lenLam
         k = k + 1;
         lambda = Lambda(k);
         [ebeta, AClen, AC, nIter] = cdjmcp(X,y,lambda,opts);
             Hisbeta(:,k) = ebeta;
          %   Hisbeta(:,k) = opts.D*ebeta;
         HisIter = [HisIter;nIter];
         df = AClen;
         HisAclen = [HisAclen;df];
         opts.initial = ebeta; % warm starting 
         bick = 0.5*norm((X*ebeta-y))^2+log(n)*df;% Bic
         Bic = [Bic;bick];        
end

% select the optimal betahat and lambdahat  
id  = find(Bic == min(Bic));
lambdahat = Lambda(id(1));
betahat = Hisbeta(:,id(1));

disp('The approximation is getton and optimal solution is selected')
end

function [ebeta, AClen, AC, nIter] = cdjmcp(X,y,lambda,opts)

% ========================================================================
% Coordinate decesent  Algorithm for solving 
% min_{beta}{1/2||Xbeta-y||^2 + Mcp_{lambda,tau}(beta)
% Copyright (c), Des, 2012
% Yuling Jiao  Dept. Math.,Whuhan Univiversity
% Email: yulingjiaomath@whu.edu.cn
% ========================================================================
% ========================================================================
% Input:  
% X:            the covariate matrix (nomalized) in R^{n*p}
% y:            response vector in R^{n}
% opts.N:       the size of Omiga  (defaut: 30)
% opts.K:       maxiteration number in SSN for safe guard   (defaut: 5*n)
% opts.mu:      stop parameter when |df|>mu*n  (defaut: 0.5)
% opts.tau:     Lambda = norminf*[tau,1] (defaut: 1e-10-1e-15) 
% opts.gamma:   the parameter contron convexity of penaty (defaut:2.7)
% opts.normnX:  step length that make convergence (default norm(nX))
% opts.initial: initial value, (default(zeros(p,1)))
% opts.Xty :    X'*y
% opts.stop:    stop when norm(beta^k+1)/norm(beta^k+1-beta^k)<opts.stop 
%               (default,1e-6)
% Output: 
% ebeta:    an estimate of regression coefficient 
% AClen:    acive set size  of ebeta 
% AC:       acive set of ebeta 
% nIter:    the iteration number when CD-J stop
% ========================================================================
[n,p] = size(X);
if nargin < 3
    disp('error, not enough inputment')
elseif nargin > 4
    disp('error, too much inputment')
elseif nargin == 3 || isempty(opts)
    Xty = X'*y;
    K = 5*n;
    mu = 0.5;
    betainitial = zeros(p,1);
    stoprule = 1e-5;
    gamma = 2.7;
else
    Xty = opts.Xty;
    K = opts.K;
    mu = opts.mu;
    betainitial = opts.initial;
    normnX = opts.normnX;
    stoprule = opts.stop;
    gamma = opts.gamma;
end

nIter = 0;
ebeta = zeros(p,1);
AC = [];
AClen = 0;
stop  = stoprule+1;
mun = mu*n;
Eps = 1e-8;
while stop > stoprule && nIter < K && AClen < mun
    nIter = nIter + 1;
    tempbeta = betainitial + (Xty - X'*(X*betainitial))/(normnX);
    AC = find(abs(tempbeta)>(lambda/normnX));
    AClen = length(AC);
    ebeta = softthmcp (tempbeta,lambda,gamma,normnX);
    stop = norm(betainitial-ebeta)/(norm(betainitial)+ Eps);
    betainitial = ebeta;
end
end
%% subfunction 
function thz = softthmcp(z,lambda,gamma,c)
    thz = z;
    id = find(abs(z)<= lambda*gamma);
    thz(id) = max(abs(z(id))-lambda/c,0).*sign(z(id))*gamma*c/(gamma*c-1);  
end

