clc
clear all 
close all
addpath(genpath(fileparts(mfilename('fullpath'))));
warning off 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%        Generate data 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% set parameters 
p = 100;            % number of features 
n = 50;             % number of observation 
K = 5;              % number of non zero elemet in  real solution 
cor = 0.5;          % corelation number of columns in X 
ratio = 1.1;          % range of value in betatrue = 10^ratio;
isnorm = 1;         % 1 normlized and stantalized; 0 not
seednum = 1;        % the seed number 
isplotpath = 1;     % 1 plot the whole path; 0 not;
sigma = 0.3e0;      % varince of white noise  
%% generate data 
[nX,D,y,ye,betatrue,supp] = gendata(n,p,K,sigma,cor,ratio,seednum,isnorm);
noiselev = norm(y - ye);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                           Lasso (LARS)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%% Approximate the Whole Path 
disp(' LARS (Homotopy) is runing....')
 mu = 0.8;
 [sols, numIters, activationHist, duals] = SolveLasso(nX, y, mu*n,D);
%% select betahat from sols by BIC
[n1,n2] = size(sols);
 Bic = [];
 for kk = 1:n2
     tempbeta = sols(:,kk);
     df = length(find(tempbeta));
     Bickk = 0.5*norm(nX*(D\tempbeta)-y)^2+log(n)*log(p)*df;
     Bic = [Bic;Bickk];
 end
 id = find(Bic == min(Bic));
 betahat = sols(:,id(1));
 betahat = D*betahat;
 esupplars = find (betahat);
 pathlars = sols';
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                           MCP (CD-J)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Precompute  and Set parameters in Algorithm CD-J
opts.N = 50;              % the size of Lambda (defaut: 100) 
opts.tau = 1e-8;           % Lambda = norminf*[tau,1] (defaut: 1e-10-1e-15)  
opts.stop = 1e-5;          % opts.stop, stoping rule for relative change
opts.K = 5*n;              % maxiteration number in CD-J    (defaut: 5*n)
opts.mu = 0.9;             % stop  when ||beta^k||_0 >mu*n  (defaut: 0.5) 
opts.initial  = zeros(p,1);% initial value 
opts.gamma = 2.7;          % the parameter contron convexity of penaty (defaut:2.7)
opts.normnX = max(norm(nX),1);   % step length 
opts.D = D;
%% Approximate the Whole Path by Coordinate Descent-J 
disp('CD-J is runing....')
[betahat, lambdahat, Hisbeta, HisAclen, HisIter, Bic] = cdjmcppath(nX,y,opts);
betahat = D*betahat;
esuppmcp = find (betahat);
pathmcp = (D*Hisbeta)';
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                               ASDAR
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Set parameters in ASDAR 
tau = 1;          % adaptive scale, tau small accurate but may slower 
mu = 0.5;         % stop when tau*k > mu*n 
%% Run ASDAR 
k = 0; 
kmax = floor(mu*n/tau);
Solutionpath = zeros(p,kmax); 
outputmode = 1;  
plotmode = 0;
Bic = [];
betaold = zeros(p,1);
disp('ASDAR is runing....')
while k <= kmax 
    k = k + 1;
    %% Set parameters in SDCA 
    opts.T = tau*k;                  % number of features to be extract each step 
    opts.alpha = 0;                  % a parameter for numerical stable 
    opts.J = 20;                     % maxiteration number in SDCA  
    opts.initial = zeros(p,1);
    % run SDAR
    [ebeta, ed, Ac, nIter] = sdar(nX,y,opts);
    opts.initial = ebeta;
    residual  = norm(nX*ebeta-y);
    Solutionpath(:,k) = D*ebeta;
    Bick = 0.5*(residual^2) + log(n)*tau*k;   % Modified Bic
    Bic = [Bic,Bick];  
end  
pathsdca = Solutionpath';
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% plot result 
figure(1),
opts.Xty = nX'*y;
lambdaMin = opts.tau;
lambdaMax = 1;
loghi = log(lambdaMax);
loglo = log(lambdaMin);
logrange = loghi - loglo;
interval = -logrange/(opts.N-1);
Lambda = exp(loghi:interval:loglo)';
Lambda = Lambda(2:end);
Lambda = norm(opts.Xty,inf)*Lambda;
 xid = Lambda(1:25);
semilogx(xid,pathlars(1:25,:),'LineWidth',2)
h = xlabel('$\lambda$ ');
set(h,'Interpreter','latex','fontsize',20)
set(gca,'ytick', -12:4:8)
h = ylabel('Coefficient');
set(h,'Interpreter','latex','fontsize',20)
h = title('Lasso');
set(h,'Interpreter','latex','fontsize',20)
set(gca,'XDir','reverse');
figure(2),
xid = Lambda(1:25);
semilogx(xid,pathmcp(1:25,:),'LineWidth',2)
h = xlabel('$\lambda$ ');
set(h,'Interpreter','latex','fontsize',20)
h = ylabel('Coefficient');
set(h,'Interpreter','latex','fontsize',20)
h = title('MCP');
set(h,'Interpreter','latex','fontsize',20)
set(gca,'ytick', -12:4:8)
set(gca,'xtick',[10^-2,10^-1, 10^0, 10^1, 10^2])
set(gca,'XDir','reverse');
figure(3),
plot(pathsdca(1:25,:),'LineWidth',2)
h = xlabel('T');
set(h,'Interpreter','latex','fontsize',20)
h = ylabel('Coefficient');
set(h,'Interpreter','latex','fontsize',20)
axis([0,6*K,1.2*min(min((pathsdca))),1.2*max(max((pathsdca)))])
set(gca,'ytick', -12:4:8)
h=title('SDAR ');
set(h,'Interpreter','latex','fontsize',20)
