
function [x,Sx,Sres,activeSet,it] = foba(X,y,Maxiter,nu,alpha,T,noiselev)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (c), Dep, 2013
% Yuling Jiao  Dept. Math.,Whuhan Univiversity
% Email: yulingjiaomath@whu.edu.cn
% Based on TongZhang's R code but optimized the least squares steps
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global opts opts_tr 
 opts.UT = true; 
 opts_tr.UT = true; opts_tr.TRANSA = true;
[n,p] = size(X);
x = zeros(p,1);
if Maxiter == 0
    s = 2*p+1;
else
    s = Maxiter;
end
 path = zeros(s,1);
 Sx = [];
 stat = zeros(1,s);
 Sres = [];
 r = y;
 v = norm(y)^2;
 k = 0;
 it = 0;
 minfw = v;
 res = noiselev + 1;
  R_I = [];
  activeSet = [];
while it < s && res > noiselev && length(activeSet) < T
   d = X'*r;
   ik = find(abs(d)==max(abs(d)));
   if noiselev == 0
   id  = find(stat(1,1:k)==ik, 1);
   if ~isempty(id) 
       Sx = Sx(:,1:it);
       break;
   end
   end
 
   newIndices = ik(1);
   for j = 1:length(newIndices)
        [R_I, flag] = updateChol(R_I, n, p, X, 1, activeSet, newIndices(j));
        activeSet = [activeSet newIndices(j)];
   end
    k=k+1;
    stat(1,k) = ik(1);
    myfs = X(:,activeSet);
     z = linsolve(R_I,myfs'*y,opts_tr);
     w = linsolve(R_I,z,opts);
    rp = myfs*w - y;
    res = norm(rp);
    Sres = [Sres,res];
    vp = res^2 + alpha*norm(w)^2;
    deltak = v - vp;
    r = rp;
    v = vp;
    stat(1,k) = deltak;
    it = it + 1;
    path(it) = ik;
    x(activeSet,1) = w;
    Sx  = [Sx,x];
    if  minfw > deltak 
      minfw = deltak;
    end
    % backward step
    while (k>1) && (it<s) 
        ik = find(abs(w) == min(abs(w)));
        col = ik(1);
        tactiveSet = [activeSet(1:col-1), activeSet(col+1:length(activeSet))];
         myfs = X(:,tactiveSet);
        R_II = downdateChol(R_I,col);
        z = linsolve(R_II,myfs'*y,opts_tr);
        w = linsolve(R_II,z,opts);
        rp = myfs*w - y;
        vp = norm(rp)^2 + alpha*norm(w)^2;
        deltak = vp - v;
        if abs(deltak) > stat(1,k)*nu
          break;
        else
            disp('Do backward step')
        end
        R_I = R_II;
        activeSet = tactiveSet;
        it = it+1;
        k = k-1;
        r=rp;
        v=vp;
    end
end
clear opts opts_tr zeroTol



function [R, flag] = updateChol(R, n, N, A, explicitA, activeSet, newIndex)
% updateChol: Updates the Cholesky factor R of the matrix 
% A(:,activeSet)'*A(:,activeSet) by adding A(:,newIndex)
% If the candidate column is in the span of the existing 
% active set, R is not updated, and flag is set to 1.

global opts_tr zeroTol
flag = 0;

if (explicitA)
    newVec = A(:,newIndex);
else
    e = zeros(N,1);
    e(newIndex) = 1;
    newVec = fval(A,1,e,1:n); 
end

if length(activeSet) == 0,
    R = sqrt(sum(newVec.^2));
else
    if (explicitA)
        p = linsolve(R,A(:,activeSet)'*A(:,newIndex),opts_tr);
    else
        %AnewVec = fval(A,2,n,length(activeSet),newVec,activeSet,N);
        AnewVec = fval(A,2,newVec,activeSet); 
        p = linsolve(R,AnewVec,opts_tr);
    end
    q = abs(sum(newVec.^2) - sum(p.^2));
    if (q <= zeroTol) % Collinear vector
        flag = 1;
    else
        R = [R p; zeros(1, size(R,2)) sqrt(q)];
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function R = downdateChol(R, j)
% downdateChol: `Downdates' the cholesky factor R by removing the 
% column indexed by j.

% Remove the j-th column
R(:,j) = [];
[m,n] = size(R);

% R now has nonzeros below the diagonal in columns j through n.
% We use plane rotations to zero the 'violating nonzeros'.
for k = j:n
    p = k:k+1;
    [G,R(p,k)] = planerot(R(p,k));
    if k < n
        R(p,k+1:n) = G*R(p,k+1:n);
    end
end

% Remove last row of zeros from R
R = R(1:n,:);

