
clc
clear all 
close all
addpath(genpath(fileparts(mfilename('fullpath'))));
warning off 
p = 1000;          % number of features 
n = 500;           % number of observation 
cor = 0;           % corelation number of columns in X 
ratio = 0;         % range of value in betatrue = 10^ratio;
isnorm = 1;        % 1 normlized the column of X; 0 not
seednum = 0;       % the seed number 
sigma = 0.01;      % varince of white noise 
N = 3:2:50;
len = length(N);
maxnumtest = 10;                        
Scputime = zeros(maxnumtest,len);     
Srel2error = zeros(maxnumtest,len);      
Sabslinferror = zeros(maxnumtest,len); % each column stores  norm(betahat-betatrue,inf)   of maxnmtest replecations  of a dataset  
Sstopiternum = zeros(maxnumtest,len);  % each column stores  number of iterations when SDCA stop of maxnmtest replecations  of a dataset
Soracle  = zeros(maxnumtest,len);      % each column stores  weather betahat = beta^o of maxnmtest replecations  of a dataset
for k = 1:len
    T = N(k);
    for l = 1:maxnumtest
       %% Generate data 
        seednum = seednum  + k*l;
        [nX,D,y,ye,betatrue,supp] = gendata(n,p,T,sigma,cor,ratio,seednum,isnorm);
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %                          SDAR
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       %% Set parameters in SDAR
        opts.T = 1*T;      % number  of features to be recovered  
        opts.alpha = 0;    % a parameter for numerical stable 
        opts.J = opts.T;   % maxiteration number in SDCA 
        opts.initial = zeros(p,1);
       %% Run SDAR 
        disp('SDAR is runing....')
        tic,
          [ebeta, ed, Ac, nIter] = sdar(nX,y,opts);
          betahat = D*ebeta;
        sdcatime = toc
       %% Store  the error, cputime, number of iterations, number of exact recover of Oracle eatimator  
        esupp = find(betahat);
        rel2error = norm(betatrue - betahat)/norm(betatrue);
        abslinferror = norm(betatrue - betahat,inf);
        Scputime(l,k) = sdcatime;
        Srel2error(l,k) = rel2error;
        Sabslinferror(l,k) = abslinferror;
        Sstopiternum(l,k) = nIter;
        if esupp == supp
           Soracle(l,k) = 1;
        end
    end
end
%% compute the average peformance 
save iternumnew
averagetime = mean(Scputime);
stdtime = std(Scputime);
averagestopiternum = mean(Sstopiternum);
stdstopiternum = std(Sstopiternum);
averagerel2error = mean(Srel2error);
stdl2error = std(Srel2error);
averageabslinferror = mean(Sabslinferror);
stdabslinferror = std(Sabslinferror);
freqexactrecov = mean(Soracle);
%% plot results 
 figure(1), 
plot (N,averagestopiternum,'--ro','LineWidth',2)
set(gca,'ytick',1:4)
axis([1 1.1*max(N) 1 4])
h = ylabel('Average number of iterations of SDAR');
set(h,'Interpreter','latex','fontsize',15)
h = xlabel('K');
set(h,'Interpreter','latex','fontsize',15)