
clc
clear all 
close all
addpath(genpath(fileparts(mfilename('fullpath'))));
warning off 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%        Data Generation Setting 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
n = 500;           % number of observation 
isnorm = 1;        % 1 normlized the column of X; 0 not
seednum = 0;       % the seed number 
sigma = 0.5e0;
cor = 0.1;
ratio = 3;
p = 1000;
%%
N = 10:50:360;
len = length(N);
maxnumtest = 100;                     % number of replecations 
nmethod = 5;                          % type of method concerned here. Lasso, MCP, SDCA,IHT(mu),AIHT,OMP,Afbgs.             
Scputime = zeros(maxnumtest,len,nmethod);     
Srel2error = zeros(maxnumtest,len,nmethod);     
Sabslinferror = zeros(maxnumtest,len,nmethod);
Sstopiternum = zeros(maxnumtest,len,nmethod); 
Soracle  = zeros(maxnumtest,len,nmethod);  
Ssignificant = zeros(maxnumtest,len,nmethod);    
for k = 1:len
         T = N(k); 
         for l = 1:maxnumtest
           %% Generate data 
            seednum = seednum  + 10000*k*l;
            [nX,D,y,ye,betatrue,supp] = gendata(n,p,T,sigma,cor,ratio,seednum,isnorm);
            significant = find(abs(betatrue)>sigma);
            noiselev = norm(y-ye);
            for method = 1:nmethod
                   if method == 1 % Lasso solved by LARS
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                            %                     LARS(HOMOTOPY)
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                          %% Approximate the Whole Path 
                            disp(' LARS (Homotopy) is runing....')
                            tic
                            ebeta   = Homotopy(nX, y, T, 'lars', T+1, 0, 1, 0, 0, 0);
                            betahat = D*ebeta;
                            larstime = toc   
                         %% store error, cputime, number of iterations, number of exact
                         %% recover of Oracle eatimator 
                            Scputime(l,k,method) = larstime;  
                            Srel2error(l,k,method) =  norm(betatrue - betahat)/norm(betatrue);     
                            Sabslinferror(l,k,method) = norm(betatrue - betahat,inf);
                            esupp = find (betahat);
                            if isempty(setdiff(significant,esupp))
                                 Ssignificant(l,k,method) = 1;
                            end
                            if length(esupp) == length(supp)
                                  if esupp == supp
                                     Soracle(l,k,method) = 1; 
                                  end
                            end
                    elseif method == 2 % MCP solved by CD-J
                           %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                           %                          MCP
                           %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
                          %% Precompute  and Set parameters in Algorithm CD-J 
                            opts.N = 100;                  % the size of Lambda (defaut: 100) 
                            opts.tau = 1e-10;
                            opts.stop = 5e-5; 
                            opts.K = 5*n;                  % maxiteration number in CD-J    (defaut: 5*n)
                            opts.mu = 2*T/n;             % stop  when ||beta^k||_0 >mu*n  (defaut: 0.5) 
                            opts.initial  = zeros(p,1);    % initial value 
                            opts.gamma = 2.7;              % the parameter contron convexity of penaty (defaut:2.7)             
                            opts.normnX = max(norm(nX),1); % step length 
                            opts.D = D;
                           %% Approximate the Whole Path by Coordinate Descent-J 
                            disp('CD-J is runing....')
                            tic,
                            [betahat, lambdahat, Hisbeta, HisAclen, HisIter, Bic] = cdjmcppath(nX,y,opts);
                            mcptime = toc
                          %% Store  the error, cputime, number of iterations, number of
                          %% exact recover of Oracle eatimator   
                            Scputime(l,k,method) = mcptime;  
                            Srel2error(l,k,method) =  norm(betatrue - betahat)/norm(betatrue);     
                            Sabslinferror(l,k,method) = norm(betatrue - betahat,inf);
                            esupp = find (betahat);
                            if isempty(setdiff(significant,esupp))
                               Ssignificant(l,k,method) = 1;
                            end
                            if length(esupp) == length(supp)
                               if esupp == supp
                                   Soracle(l,k,method) = 1; 
                               end
                            end         
                    elseif method == 3              %  ASDAR
                           %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                           %                          ASDAR
                           %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                        %% Set parameters in ASDAR 
                           tau = 10;          % adaptive scale, tau small accurate but may slower 
                           mu = 0.8;         % stop when tau*k > mu*n              
                           kkk = 0; 
                           kmax = floor(mu*n/tau);
                           Solutionpath = zeros(p,kmax); 
                           Siter = [];  
                           Bic = [];                  
                        %% Run ASDAR 
                           disp('ASDAR is runing....')
                           tic,
                           betaold = zeros(p,1);
                           residual = noiselev + 1;
                           opts.initial = zeros(p,1);
                           while kkk <= kmax && residual>noiselev
                                     %  && residual>noiselev just save time, do not influence
                                     %  the result in the figure 
                                     kkk = kkk + 1;
                                %% Set parameters in SDCA 
                                     opts.T = tau*kkk;                % number of features to be extract each step 
                                     opts.alpha = 0;                  % a parameter for handle strang colinearity  
                                     opts.J = 10;                     % maxiteration number in SDCA 
                                     % run SDAR
                                     [ebeta, ed, Ac, nIter] = sdar(nX,y,opts);
                                     opts.initial = ebeta;
                                     Siter = [Siter,nIter];
                                     residual  = norm(nX*ebeta-y);
                                     Solutionpath(:,kkk) = D*ebeta;
                                     Bickkk = 0.5*(residual^2) + log(n)*tau*kkk;   % Modified Bic
                                     Bic = [Bic,Bickkk];  
                           end   
                        %% Output  a solution 
                           id = find(Bic == min(Bic));
                           betahat = Solutionpath(:,id(1));
                           disp('BIC mode is adopted')
                           asdcatime = toc
                        %% Store  the error, cputime, number of iterations, number of
                        %% exact recover of Oracle eatimator  
                           Scputime(l,k,method) = asdcatime;  
                           Srel2error(l,k,method) =  norm(betatrue - betahat)/norm(betatrue);     
                           Sabslinferror(l,k,method) = norm(betatrue - betahat,inf);
                           esupp = find (betahat);
                           if isempty(setdiff(significant,esupp))
                                   Ssignificant(l,k,method) = 1;
                           end
                           if length(esupp) == length(supp)
                                   if esupp == supp
                                       Soracle(l,k,method) = 1; 
                                   end
                           end
                   elseif method == 4  % Grades
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                            %                     Grades
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                            disp(' Grades is runing....')
                            mu = 1/norm(nX);  
                            tic
                            [ebeta,Sac,Sx,Sres,nIter] = grades(nX,y,T,zeros(p,1),mu,2*n,noiselev);
                            betahat = D*ebeta;
                            gradestime = toc   
                         %% store error, cputime, number of iterations, number of exact
                         %% recover of Oracle eatimator 
                             Scputime(l,k,method) = gradestime;  
                             Srel2error(l,k,method) =  norm(betatrue - betahat)/norm(betatrue);     
                             Sabslinferror(l,k,method) = norm(betatrue - betahat,inf); 
                             esupp = find (betahat);
                             if isempty(setdiff(significant,esupp))
                                 Ssignificant(l,k,method) = 1;
                             end
                             if length(esupp) == length(supp)
                                 if esupp == supp
                                     Soracle(l,k,method) = 1; 
                                 end
                             end      
                  else  % FoBa
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                            %                     FoBa
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                            disp(' FoBa is runing....') 
                            tic
                            [ebeta,Sx,Sres,path,nIter] = foba(nX,y,2*T,0.8,0,T,0);
                            betahat = D*ebeta;
                            fobatime = toc   
                          %% store error, cputime, number of iterations, number of exact
                          %% recover of Oracle eatimator 
                           Scputime(l,k,method) =  fobatime;  
                           Srel2error(l,k,method) =  norm(betatrue - betahat)/norm(betatrue);     
                           Sabslinferror(l,k,method) = norm(betatrue - betahat,inf);
                           esupp = find (betahat);
                           if isempty(setdiff(significant,esupp))
                               Ssignificant(l,k,method) = 1;
                           end
                           if length(esupp) == length(supp)
                               if esupp == supp
                                   Soracle(l,k,method) = 1; 
                               end
                           end         
                   end
            end
        end
end
%% Compute average performance 
averagetime = mean(Scputime);
stdtime = std(Scputime);
averagestopiternum = mean(Sstopiternum);
stdstopiternum = std(Sstopiternum);
averagerel2error = mean(Srel2error);
stdl2error = std(Srel2error);
averageabslinferror = mean(Sabslinferror);
stdabslinferror = std(Sabslinferror);
proboracle = mean(Soracle);
probsignif = mean(Ssignificant);
%% plot results 
figure(1),
prob = [proboracle(:,:,1);proboracle(:,:,2);proboracle(:,:,3);proboracle(:,:,4);proboracle(:,:,5)]';
plot(N,prob(:,1),'k+--',N,prob(:,2),'b*:',N,prob(:,3),'ro-',N,prob(:,4),'g>-',N,prob(:,5),'md-','LineWidth',1.5)
h = xlabel('K');
set(h,'Interpreter','latex','fontsize',20)
set(gca,'xtick',N)
 h = ylabel(' Probability ');
 set(gca,'ytick',0:0.2:1)
 set(h,'Interpreter','latex','fontsize',20)
h=legend('LARS','MCP','ASDAR','GraDes','FoBa');
set(h,'Interpreter','latex','fontsize',20)
axis([10 360 0 1.2])
