clc
clear all 
close all
addpath(genpath(fileparts(mfilename('fullpath'))));
warning off 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%        Generate data 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
p = 1000;           % length of underlyling solution  
n = 300;            % number of samples 
K = 50;             % number of non zero elemet in  uderlying solution  
ratio = 1;          % range of value in betatrue (10^ratio)
sigma = 0.5;        % varince of the  noise 
seednum = 0;        % the seed number 
cor = 0.5;
isnorm = 1;         % 1 normlized and stantalized; 0 not
%% generate data 
[nX,D,y,ye,betatrue,supp] = gendata(n,p,K,sigma,cor,ratio,seednum,isnorm);
noiselev = norm(y - ye);
%% Set parameters in SDAR 
opts.T = 1*K;      % number of features to be selected 
opts.alpha = 0;    % a parameter for numerical stable 
opts.J = 20;       % maxiteration number in SDAR   
opts.initial = zeros(p,1);
%% 
tic,
[ebeta, ed, Ac, nIter] = sdar(nX,y,opts);
toc
betahat = D*ebeta;
rel2error = norm(betatrue - betahat)/norm(betatrue);
abslinferror = norm(betatrue - betahat,inf);
estsupp  = (find(betahat~=0));
diff = setdiff(estsupp,supp)
figure(1), plot(1:p,betatrue','ko',1:p,betahat','r*'), title('real (o) and estimated (*)'),
display(sprintf('iteration number = %g, nonzero number is = %g, ralative l_2 error = %g,absolute l_inf error = %g',nIter,length(find(betahat)),rel2error, abslinferror))