clc
clear all 
close all
addpath(genpath(fileparts(mfilename('fullpath'))));
warning off 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%        Generate data 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% set parameters 
p = 1000;           % length of underlyling solution  
n = 300;            % number of samples 
K = 50;             % number of non zero elemet in  uderlying solution  
ratio = 1;          % range of value in betatrue (10^ratio)
sigma = 0.5;        % varince of the  noise 
seednum = 0;        % the seed number 
cor = 0.5;
isnorm = 1;         % 1 normlized and stantalized; 0 not 
%% generate data 
[nX,D,y,ye,betatrue,supp] = gendata(n,p,K,sigma,cor,ratio,seednum,isnorm);
noiselev = norm(y - ye);  % if can not know exactly just set small enough
                          % then the baseline ASDCA + BIC will work well 
%% Set parameters in ASDCA 
delta = 1;         % stop when norm(\beta(tau*k)-beta(tau*(k+1)))<delta
                   % if not known how to set just set small enough 
                   % then the baseline ASDCA + BIC will work well 
tau = 5;           % adaptive scale, tau small accurate but may slower 
mu1 = 0.5;         % stop when tau*k > mu*n 
mu2 = 1;           % stop when norm(X*beta(tauk)-y)<= mu2*noiselev
                   % and if noiselev hard to estimate set mu2 = 0;
%% Run ASDAR 
k = 0; 
residual = noiselev*mu2 + 1;
change = delta  + 1;
% store the solutions at each tau*k in Solutionpth and plot solution path  
% and use BIC select one for safeguard
kmax = floor(mu1*n/tau);
Solutionpath = zeros(p,kmax); 
Sresidual = [];
Siter = [];
% output by outputmode,  1 for adaptive combined bic; 2 for BIC only
outputmode = 1;  
Bic = [];
tic,
betaold = zeros(p,1);
while k <= kmax && residual > noiselev*mu2 && change > delta
    k = k + 1
    %% Set parameters in SDAR 
    opts.T = tau*k;                  % number of features to be extract each step 
    opts.alpha = 0;                  % a parameter for numerical stable 
    opts.J = opts.T;                 % maxiteration number in SDCA  
    opts.initial = zeros(p,1);
    % run SDAR
    [ebeta, ed, Ac, nIter] = sdar(nX,y,opts);
    opts.initial = ebeta;
    change = norm(D*(ebeta - betaold));
    betaold = ebeta;
    residual  = norm(nX*ebeta-y);
    Sresidual = [Sresidual, residual];
    Siter = [Siter, nIter];
    Solutionpath(:,k) = D*ebeta;
    Bick = 0.5*(residual^2) + log(n)*tau*k;   % Modified Bic
    Bic = [Bic,Bick];  
end   
toc
%% Output  a solution 
if outputmode == 1
    if k<= kmax   
        if residual <= noiselev*mu2
            disp('Combine mode is adopted and ASDAR stop in usual way by the noise level')
            betahat = D*ebeta;
        else
            disp('Combine mode is adopted and ASDAR stop in usual way by the adjacent change')
            id = find(Bic == min(Bic));
            betahat = Solutionpath(:,id(1));
        end
    else
       id = find(Bic == min(Bic));
       betahat = Solutionpath(:,id(1));
       disp('Combine mode is adopted and BIC serve as a safeguard')
    end
else
    id = find(Bic == min(Bic));
    betahat = Solutionpath(:,id(1));
    disp('BIC mode is adopted')
end
%% Compute error 
rel2error = norm(betatrue - betahat)/norm(betatrue);
abslinferror = norm(betatrue - betahat,inf);
estsupp  = (find(betahat~=0));
diff = setdiff(estsupp,supp)
%% plot result 
figure(1), plot(1:p,betatrue','ko',1:p,betahat','r*'), title('real (o) and estimated (*)'),

figure(2), 
plot(tau*(1:length(Siter)),Siter,'r*:'), 
xlabel('sparsity level \tauk')
ylabel('number of iterations')

figure(3),
semilogy(tau*(1:length(Sresidual)),Sresidual,'r*:'), 
xlabel('sparsity level \tauk')
ylabel('||X\beta({\tau}k)-y||_{2}')


figure(4),
semilogy(tau*(1:length(Bic)),Bic,'r*:'), 
xlabel('sparsity level \tauk')
ylabel('Bic')
%%
display(sprintf('overall iteration number = %g, nonzero number is = %g, ralative l_2 error = %g,absolute l_inf error = %g',sum(Siter),length(find(betahat)),rel2error, abslinferror))