function soln = test_vie_trap(problem_index,lambda,N_h,T,output_step)

% This is a test program for vie_trap.  The test problems are given below
% and are indexed using the input parameter problem_index.  The input
% parameter lambda is used in defining the various problems.  The interval
% of solution is [0,T].  The number of subdivisions is N_h (and thus the
% stepsize is h = T/N_h). The solution is to be output at those problem
% indices that are evenly divisible by the parameter output_step.

soln = vie_trap(N_h,T,@g_driver,@kernel);
t = soln.t; y = soln.y;
true = true_soln(t);
error = true - y;
format short e
v = 1:output_step:N_h+1;
disp([t(v)' y(v)' error(v)'])

%================================================
function ans_g = g_driver(s)

switch problem_index
    case 1
        ans_g = 1 - lambda*s;
    case 2
        ans_g = (1-lambda)*sin(t) + (1+lambda)*cos(t) - lambda;
    case 3
        ans_g = cos(s);        
end
end % g_driver

%================================================
function ans_true = true_soln(s)
    
switch problem_index
    case 1
        ans_true = ones(size(s));
    case 2
        ans_true = cos(s) + sin(s);
    case 3
        ans_true = cos(s) + (lambda/(1+lambda^2))*(lambda*exp(lambda*s)...
            + sin(s) -lambda*cos(s));
end
end % true_soln

%================================================
function ans_k = kernel(tau,s,u)

% tau is a scalar, s and u vectors of the same dimension.

switch problem_index
    case {1,2,3}
        ans_k = lambda*u;
end

end % kernel
%================================================

end % test_vie_trap

