function varargout = SecantInit(varargin)
% SECANTINIT Application M-file for SecantInit.fig
%    FIG = SECANTINIT launch SecantInit GUI.
%    SECANTINIT('callback_name', ...) invoke the named callback.

% Last Modified by GUIDE v2.0 20-Jun-2002 22:20:06

if isstruct(varargin{1})   % LAUNCH GUI - Check to make sure that first variable is a structure

	fig = openfig(mfilename,'reuse');

	% Use system color scheme for figure:
	set(fig,'Color',get(0,'defaultUicontrolBackgroundColor'));

	% Generate a structure of handles to pass to callbacks, and store it. 
	handles = guihandles(fig);
	guidata(fig, handles);
   
    set(handles.CloseSecantInit,'UserData','open')
    % Use WAITFOR to have the GUI 'pause' until the userdata property is changed to 'close'
    waitfor(handles.CloseSecantInit,'UserData','close')
	if nargout > 0
        % Use the UserData property of particular UICONTROLs to store information 
        % and save the info to the handles structure.
        % Save the new structure to the application data of the figure
          dataIn_x0 = get(handles.x0_EditText, 'UserData');
          dataIn_x1 = get(handles.x1_EditText, 'UserData');
          handles.dataIn_x0 = dataIn_x0;
          handles.dataIn_x1 = dataIn_x1;
          guidata(fig, handles);
          varargout{1} = handles;
          delete(fig);
	end

elseif ischar(varargin{1}) % INVOKE NAMED SUBFUNCTION OR CALLBACK

	try
		[varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard
	catch
		disp(lasterr);
	end

end

% --------------------------------------------------------------------
function varargout = x0_EditText_Callback(h, eventdata, handles, varargin)

data_x0 = get(handles.x0_EditText, 'string');
set(h, 'UserData', data_x0);

% --------------------------------------------------------------------
function varargout = x1_EditText_Callback(h, eventdata, handles, varargin)

data_x1 = get(handles.x1_EditText, 'string');
set(h, 'UserData', data_x1);

% --------------------------------------------------------------------
function varargout = CloseSecantInit_Callback(h, eventdata, handles, varargin)

set(h,'UserData','close')

