function varargout = NewtonInit(varargin)
% NEWTONINIT Application M-file for NewtonInit.fig
%    FIG = NEWTONINIT launch NewtonInit GUI.
%    NEWTONINIT('callback_name', ...) invoke the named callback.

% Last Modified by GUIDE v2.0 18-Jun-2002 14:52:45

if isstruct(varargin{1})   % LAUNCH GUI - Check to make sure that first variable is a structure

	fig = openfig(mfilename,'reuse');

	% Use system color scheme for figure:
	set(fig,'Color',get(0,'defaultUicontrolBackgroundColor'));

	% Generate a structure of handles to pass to callbacks, and store it. 
	handles = guihandles(fig);
	guidata(fig, handles);
   
    set(handles.CloseNewtonInit,'UserData','open')
    % Use WAITFOR to have the GUI 'pause' until the userdata property is changed to 'close'
    waitfor(handles.CloseNewtonInit,'UserData','close')
	if nargout > 0
        % Use the UserData property of particular UICONTROLs to store information 
        % and save the info to the handles structure.
        % Save the new structure to the application data of the figure
          dataIn = get(handles.NewtonInitEditText, 'UserData');
          handles.dataIn = dataIn;
          guidata(fig, handles);
          varargout{1} = handles;
          delete(fig);
	end

elseif ischar(varargin{1}) % INVOKE NAMED SUBFUNCTION OR CALLBACK

	try
		[varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard
	catch
		disp(lasterr);
	end

end


% --------------------------------------------------------------------
function varargout = NewtonInitEditText_Callback(h, eventdata, handles, varargin)

data = get(handles.NewtonInitEditText, 'string');
set(h, 'UserData', data);

% --------------------------------------------------------------------
function varargout = CloseNewtonInit_Callback(h, eventdata, handles, varargin)

set(h,'UserData','close')

