function varargout = ListErrorData(varargin)
% LISTERRORDATA Application M-file for ListErrorData.fig
%    FIG = LISTERRORDATA launch ListErrorData GUI.
%    LISTERRORDATA('callback_name', ...) invoke the named callback.

% Last Modified by GUIDE v2.5 19-Sep-2004 14:08:19

if isstruct(varargin{1})
    
    fig = openfig(mfilename,'reuse');

	% Generate a structure of handles to pass to callbacks, and store it. 
	handles = guihandles(fig);
    
    % store handle information from Integrate_GUI figure.
    handles.figure1 = varargin{1}.figure1;
    handles.StringData_Error = varargin{1}.StringData_Error;
    handles.method = varargin{1}.method;
        
    StringData_Error = varargin{1}.StringData_Error;
    handles.StringData_Error = StringData_Error;
    % Update handles structure
    guidata(fig, handles);
    handles;
    
    % Output to the listbox.
    set(handles.ErrorEstimates,'string',StringData_Error);
    
    if nargout > 0
        varargout{1} = fig;
    end
    
elseif ischar(varargin{1}) % INVOKE NAMED SUBFUNCTION OR CALLBACK

	try
		if (nargout)
			[varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard
		else
			feval(varargin{:}); % FEVAL switchyard
		end
	catch
		disp(lasterr);
	end

end

% --------------------------------------------------------------------
function varargout = Close_Callback(h, eventdata, handles, varargin)

delete(handles.listerrordata);


% --- Executes on selection change in ErrorEstimates.
function ErrorEstimates_Callback(hObject, eventdata, handles)
% hObject    handle to ErrorEstimates (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns ErrorEstimates contents as cell array
%        contents{get(hObject,'Value')} returns selected item from ErrorEstimates


% --- Executes during object creation, after setting all properties.
function ErrorEstimates_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ErrorEstimates (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --------------------------------------------------------------------
function output_error_Callback(hObject, eventdata, handles)
% hObject    handle to output_error (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

StringData_Error = handles.StringData_Error;

switch handles.method
case 'Trapezoidal'
    fid = fopen('output_error_Trapezoidal','w');
    disp('The table is saved under the name "output_error_Trapezoidal"')
case 'Midpoint'
    fid = fopen('output_error_Midpoint','w');
    disp('The table is saved under the name "output_error_Midpoint"')
case 'Simpson'
    fid = fopen('output_error_Simpson','w');
    disp('The table is saved under the name "output_error_Simpson"')
case 'Boole'
    fid = fopen('output_error_Boole','w');
    disp('The table is saved under the name "output_error_Boole"')
end

[num_rows,num_cols] = size(StringData_Error);

for i=1:num_rows
    fprintf(fid,'%c',StringData_Error(i,1:num_cols));
    fprintf(fid,'\n');
end

fclose(fid);

% --------------------------------------------------------------------
function close_Callback(hObject, eventdata, handles)
% hObject    handle to close (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

delete(handles.listerrordata)


% --------------------------------------------------------------------
function file_Callback(hObject, eventdata, handles)
% hObject    handle to file (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
