Include trusted "parser.g".

%==============================================================================
% print functions
%==============================================================================
Define p_word_to_string :=
	fun (w : word) : string.
	match (leword 0x80000000 w) with
		ff => (ucons char '-' (word_num_to_string w))
	|	tt => (word_num_to_string (word_minus w 0x80000000)) 
	end.

Define pb_print_lit :=
	fun(#unique pb_stdio : <pb_stdio_t tt>)(l : lit) : #unique <pb_stdio_t tt>.
	match l with
		mk_uholder word w =>
		(pb_print_string pb_stdio (p_word_to_string w))
	end.

Define pb_println_clause :=
	fun pb_println_clause(#unique pb_stdio : <pb_stdio_t tt>)(c : clause) : #unique <pb_stdio_t tt>.
	match c with
		nil _ => (pb_println_string pb_stdio "0")
	|	cons _ l c' =>
		let pb_stdio = (pb_print_lit pb_stdio l) in
		let pb_stdio = (pb_print_char pb_stdio ' ') in
		(pb_println_clause pb_stdio c')
	end.

Define pb_print_formula :=
	fun pb_print_formula(#unique pb_stdio : <pb_stdio_t tt>)(f : formula) : #unique <pb_stdio_t tt>.
	match f with
		nil _ => pb_stdio
	|	cons _ c f' =>
		let pb_stdio = (pb_print_formula pb_stdio f') in
		(pb_println_clause pb_stdio c)
	end.


%==============================================================================
% print functions
%==============================================================================
Define main :=
	match (parse pb_stdio) with
		mk_pb_parser pb_stdio vnum f =>
		let pb_stdio = (pb_print_formula pb_stdio f) in
		(consume_unique <pb_stdio_t tt> pb_stdio)
	end.

Compile main to "test-parse.c".
