Include trusted "parser.g".
Include trusted "cnf-util.g".

Define build_aclause_list_h :=
  fun build_aclause_list_h(nv:word)
                          (spec F:formula)
                          (^#owned todo:formula)
                          (done:<list <aclause nv F>>)
                          (u:{ (list_subset eq_clause todo F) = tt })
    : <list <aclause nv F>>.
  match todo with
    nil _ => done
  | cons _ c todo' =>
      abbrev p1 =
        hypjoin (member c todo eq_clause) tt
          by todo_eq [eq_clause_refl c] end
      in
      abbrev p2 =
        [member_trans_lemma clause c
          eq_clause eq_clause_total todo F
          p1 u eq_clause_eq]
      in
      match (cl_valid nv (clone_owned clause c)) by q1 ign with
        ff => abort <list <aclause nv F>>
      | tt =>
					abbrev q1 = trans cong (cl_valid nv *) join c (clone_owned c) 
														q1
					in
					abbrev cp = (pf_asm F c p2) in
					let ac = (build_aclause nv F c cp q1) in
					abbrev p3_1 = % (list_subset eq_clause (cons c todo') todo) = tt
						trans cong (list_subset eq_clause * todo) symm todo_eq
									[list_subset_refl clause eq_clause eq_clause_total eq_clause_refl
										todo]
					in
					% need: (list_subset todo' todo) = tt
					abbrev p3 = [list_subset_cons_tt_tail clause eq_clause
												c todo' todo p3_1] in
					abbrev p4 =
						% want: (list_subset eq_clause todo' F) = tt
						% have p3: (list_subset eq_clause todo' todo) = tt
						% have u: (list_subset eq_clause todo F) = tt
						[list_transitivity clause eq_clause eq_clause_total
							todo' todo F p3 u eq_clause_refl eq_clause_eq]
					in
					let done' = (cons <aclause nv F> ac done) in
					(build_aclause_list_h nv F todo' done' p4)
      end
  end.

Define build_aclause_list :=
  fun(nv:word)(^#owned F:formula): <list <aclause nv F>>.
  abbrev u = [list_subset_refl clause eq_clause eq_clause_total eq_clause_refl
               F] in
  (build_aclause_list_h nv F F (nil <aclause nv F>) u).

Define main :=
	match (parse pb_stdio) with mk_pb_parser pb_stdio nv f =>
	match (ltword nv var_upper_bound) by q1 ign with
	  ff => abort void
	| tt =>
			let cnf = (build_aclause_list nv (inspect formula f)) in
			do
				(dec formula f)
				(consume_unowned <list <aclause nv (inspect formula f)>> cnf)
			  (consume_unique <pb_stdio_t tt> pb_stdio)
		  end
	end
	end.

% uncomment to see a bunch of debugging
% information about the compilation:
%
%Set "debug_to_carraway".
%Set "debug_stages".

Compile main to "test-conv.c".
