Include trusted "pf_util.g"

%=============================================================================
% "lit" lemmas for resolution
%=============================================================================

Define eq_lit_ff_lit_vnum_eq_implies_lit_sign_neq : Forall
	(x y:lit)(u1:{ (eq_lit x y) = ff })(u2:{ (lit_vnum x) = (lit_vnum y) })
	.{ (lit_sign x) != (lit_sign y) }
	:= foralli
	(x y:lit)(u1:{ (eq_lit x y) = ff })(u2:{ (lit_vnum x) = (lit_vnum y) })
	.
	case (lit_sign x) by q1 _ with
	| ff =>
		case (lit_sign y) by q2 _ with
		| ff =>
				cabbrev eq_sign = trans q1 symm q2
				cabbrev p1 = [lit_sign_ff_implies_lit_vnum_neg_eq x q1]
				cabbrev p2 = [lit_sign_ff_implies_lit_vnum_neg_eq y q2]
				cabbrev p3 = hypjoin x y by u2 p1 p2 end
				contra
				trans symm u1
				trans hypjoin (eq_lit x y) tt by p3 [eq_lit_refl x] end
				      clash tt ff
				{ (lit_sign x) != (lit_sign y) }
		| tt =>
				trans q1
				trans clash ff tt
							symm q2
		end
	| tt =>
		case (lit_sign y) by q2 _ with
		| ff =>
				trans q1
				trans clash tt ff
							symm q2
		| tt =>
				cabbrev eq_sign = trans q1 symm q2
				cabbrev p1 = [lit_sign_tt_implies_lit_vnum_pos_eq x q1]
				cabbrev p2 = [lit_sign_tt_implies_lit_vnum_pos_eq y q2]
				cabbrev p3 = hypjoin x y by u2 p1 p2 end
				contra
				trans symm u1
				trans hypjoin (eq_lit x y) tt by p3 [eq_lit_refl x] end
				      clash tt ff
				{ (lit_sign x) != (lit_sign y) }
		end
	end

Define distinct_lit_vnum_implies_eq_lit_ff : Forall
	(x y:lit)
	(u2:{ (lit_vnum x) != (lit_vnum y) })
	.{ (eq_lit x y) = ff }
	:=
        foralli(x y:lit)
	       (u2:{ (lit_vnum x) != (lit_vnum y) }).
	case (eq_lit x y) by q1 _ with
	  ff =>
            q1
	| tt =>
	     abbrev p1 = hypjoin (lit_vnum x) (lit_vnum y) by [eq_lit_eq x y q1] end in
	     contra
	     trans p1 symm u2
  	     { (eq_lit x y) = ff }
	end

%=============================================================================
% list-based clause lemmas for resolution
%=============================================================================  

Define cl_has_append_cons2 : Forall
  (c1 c2:clause)(l:lit)
  .{ (cl_has (append c1 (cons l c2)) l) = tt }
  := 
foralli(c1 c2:clause)(l:lit).
  trans join (cl_has (append c1 (cons l c2)) l) (member l (append c1 (cons l c2)) eq_lit)
        [member_append_cons lit l c1 c2 eq_lit eq_lit_total eq_lit_refl].

Define cl_has_append_cons3 : Forall
  (c1 c2:clause)(l:lit)
  .{ (cl_has (append (cons l c1) c2) l) = tt }
  := 
foralli(c1 c2:clause)(l:lit).
  trans join (cl_has (append (cons l c1) c2) l) (member l (append (cons l c1) c2) eq_lit)
        [member_append_cons2 lit l c1 c2 eq_lit eq_lit_total eq_lit_refl].

Define cl_subsume_append_cons3 : Forall
  (c c1 c2:clause)(l:lit)
  (u1:{ (cl_subsume c (append c1 (cons l c2))) = tt })
  (c1':clause)
  (u2:{ (cl_subsume c1 c1') = tt })
  (u3:{ (cl_has c1' l) = tt })
  .{ (cl_subsume c (append c1' c2)) = tt }
  :=
  foralli(c c1 c2:clause)(l:lit)
         (u1:{ (cl_subsume c (append c1 (cons l c2))) = tt })
         (c1':clause)
  	 (u2:{ (cl_subsume c1 c1') = tt })
  	 (u3:{ (cl_has c1' l) = tt }).
  abbrev p1_1 = [cl_subsume_tt_subsume_cons c1 c1 l [cl_subsume_refl c1]] in
  abbrev p1_2 = hypjoin (cl_subsume (cons l c1) c1') tt by u2 u3 end in
  abbrev p1_3 = [cl_subsume_tt_subsume_append c1' c1' c2 [cl_subsume_refl c1']]
  abbrev p1_4 = [cl_subsume_trans c1 (cons lit l c1) c1' p1_1 p1_2] in
  abbrev p1 = [cl_subsume_trans c1 c1' (append lit c1' c2) p1_4 p1_3] in

  abbrev p2_1 = [cl_has_tt_append l c1' c2 u3] in
  abbrev p2_2 = [cl_subsume_tt_subsume_append_front c2 c2 c1' [cl_subsume_refl c2]] in
  abbrev p2 = hypjoin (cl_subsume (cons l c2) (append c1' c2)) tt by p2_1 p2_2 end in

  abbrev p3 = [cl_subsume_tt_merge c1 (cons lit l c2) (append lit c1' c2) p1 p2] in
  [cl_subsume_trans c (append lit c1 (cons lit l c2)) (append lit c1' c2) u1 p3].

Define cl_subsume_append_cons4 : Forall
  (c1 c2:clause)(l:lit)
  .{ (cl_subsume (append c1 c2) (append c1 (cons l c2))) = tt }
  :=
  induction(c1:clause) return
    Forall(c2:clause)(l:lit)
    .{ (cl_subsume (append c1 c2) (append c1 (cons l c2))) = tt }
  with
    nil _ =>
      foralli(c2:clause)(l:lit).
      abbrev p1 = [cl_subsume_tt_subsume_cons c2 c2 l [cl_subsume_refl c2]] in
      hypjoin (cl_subsume (append c1 c2) (append c1 (cons l c2))) tt by c1_eq p1 end
  | cons _ x c1' =>
      foralli(c2:clause)(l:lit).
      abbrev ih = [c1_IH c1' c2 l] in
      abbrev p1 = [cl_subsume_tt_subsume_cons (append lit c1' c2) (append lit c1' (cons lit l c2)) x ih] in
      abbrev p2_1 = [cl_subsume_tt_head x (nil lit) (cons lit x (nil lit)) [cl_subsume_refl (cons lit x (nil lit))]] in
      abbrev p2 = [cl_has_tt_append x (cons lit x (nil lit)) (append lit c1' (cons lit l c2)) p2_1] in
      hypjoin (cl_subsume (append c1 c2) (append c1 (cons l c2))) tt by c1_eq ih p1 p2 end 
  end.

Define cl_subsume_append_cons5 : Forall
  (c1 c2:clause)(l:lit)
  .{ (cl_subsume (append c1 c2) (append (cons l c1) c2)) = tt }
  :=
  foralli(c1:clause)(c2:clause)(l:lit).
    [cl_subsume_append_cons1 (append lit c1 c2) c1 c2 l [cl_subsume_append_cons4 c1 c2 l]].
  
Define cl_subsume_append_implies_cons1 : Forall
  (c c1 c2:clause)(l:lit)
  (u:{ (cl_subsume c (append c1 c2)) = tt })
  .{ (cl_subsume c (append c1 (cons l c2))) = tt }
  :=
  foralli(c c1 c2:clause)(l:lit)
         (u:{ (cl_subsume c (append c1 c2)) = tt }).
  abbrev p1 = [cl_subsume_append_cons4 c1 c2 l] in
  [cl_subsume_trans c (append lit c1 c2) (append lit c1 (cons lit l c2)) u p1].

Define cl_subsume_append_implies_cons2 : Forall
  (c c1 c2:clause)(l:lit)
  (u:{ (cl_subsume c (append c1 c2)) = tt })
  .{ (cl_subsume c (append (cons l c1) c2)) = tt }
  :=
  foralli(c c1 c2:clause)(l:lit)
         (u:{ (cl_subsume c (append c1 c2)) = tt }).
  abbrev p1 = [cl_subsume_append_cons5 c1 c2 l] in
  [cl_subsume_trans c (append lit c1 c2) (append lit (cons lit l c1) c2) u p1].

Define cl_has_implies_erase_cons_has_lit :
  Forall(c:clause)(l1 l2 l3:lit)
        (u:{ (cl_has (cl_erase c l1) l2) = tt }).
    { (cl_has (cl_erase (cons l3 c) l1) l2) = tt }
    :=
    foralli(c:clause)(l1 l2 l3:lit)
           (u:{ (cl_has (cl_erase c l1) l2) = tt }).
      case (eq_lit l1 l3) by q1 _ with
        ff =>
	  abbrev p1 = hypjoin (cl_erase (cons l3 c) l1) (cons l3 (cl_erase c l1)) by q1 end in
	  abbrev p2 = [cl_subsume_tt_subsume_cons (cl_erase c l1) (cl_erase c l1) l3 [cl_subsume_refl (cl_erase c l1)]] in
	  hypjoin (cl_has (cl_erase (cons l3 c) l1) l2) tt by p1 [cl_subsume_implies_cl_has (cl_erase c l1) (cons lit l3 (cl_erase c l1)) p2 l2 u] end
      | tt =>
          abbrev p1 = hypjoin (cl_erase c l1) (cl_erase (cons l3 c) l1) by q1 end in
	  abbrev p2 =
	    symm trans symm [cl_subsume_refl (cl_erase c l1)]
	         cong (cl_subsume (cl_erase c l1) *) p1 in
	  hypjoin (cl_has (cl_erase (cons l3 c) l1) l2) tt by p1 [cl_subsume_implies_cl_has (cl_erase c l1) (cl_erase (cons lit l3 c) l1) p2 l2 u] end
      end.

Define eq_lit_trans :
  Forall(a b c:lit)
        (u1:{ (eq_lit a b) = tt})
	(u2:{ (eq_lit b c) = tt}).
    { (eq_lit a c) = tt}
  :=
  foralli(a b c:lit)
         (u1:{ (eq_lit a b) = tt})
  	 (u2:{ (eq_lit b c) = tt}).
  abbrev w1 = (unboxWord a) in 
  abbrev w2 = (unboxWord b) in 
  abbrev w3 = (unboxWord c) in
  abbrev p1_1 = hypjoin (eqvec iff w1 w2) tt by u1 end in
  abbrev p1_2 = hypjoin (eqvec iff w2 w3) tt by u2 end in
  abbrev p1 = [eqword_trans w1 w2 w3 p1_1 p1_2] in
  hypjoin (eq_lit a c) tt by p1 end.

Define eq_lit_symm : Forall(a b:lit).{ (eq_lit a b) = (eq_lit b a) }
  :=
  foralli(a b:lit).
  abbrev w1 = (unboxWord a) in 
  abbrev w2 = (unboxWord b) in
  abbrev p1 = [eqword_symm w1 w2] in
  hypjoin (eq_lit a b) (eq_lit b a) by p1 end.
  
Define cl_has_implies_erase_lit_has_lit :
  Forall(c:clause)(l l':lit)
        (u1:{ (cl_has c l) = tt })
        (u2:{ (eq_lit l l') = ff }).
    { (cl_has (cl_erase c l') l) = tt }
  :=
  induction(c:clause) return
    Forall(l l':lit)(u1:{ (cl_has c l) = tt })(u2:{ (eq_lit l l') = ff }).
      { (cl_has (cl_erase c l') l) = tt }
  with
    nil _ =>
      foralli(l l':lit)(u1:{ (cl_has c l) = tt })(u2:{ (eq_lit l l') = ff }).
      abbrev p1 = hypjoin (cl_has c l) ff by c_eq end in
      contra trans symm p1
             trans u1
  	           clash tt ff
  	     { (cl_has (cl_erase c l') l) = tt }
  | cons _ x c' =>
      foralli(l l':lit)(u1:{ (cl_has c l) = tt })(u2:{ (eq_lit l l') = ff }).
        case (eq_lit l x) by q1 _ with
	  ff =>
              existse [member_total lit l c' eq_lit eq_lit_total]
                foralli(z:bool)(z_pf:{(member l c' eq_lit) = z}).
              abbrev p1 = hypjoin (or (eq_lit l x) z) tt by c_eq u1 q1 z_pf end in
              abbrev p2 = symm trans symm p1
      	                   trans [or_comm (eq_lit l x) z]
      		           trans cong (or z *) q1
      		           trans [or_def2ff z]
      			         symm z_pf in
              abbrev u1' = trans join (cl_has c' l) (member l c' eq_lit) p2 in
      	      abbrev ih = [c_IH c' l l' u1' u2] in
      	      hypjoin (cl_has (cl_erase c l') l) tt by c_eq [cl_has_implies_erase_cons_has_lit c' l' l x ih] end
	| tt =>
	      case (eq_lit l' x) by q2 _ with
	        ff =>
        	  hypjoin (cl_has (cl_erase c l') l) tt by c_eq u1 u2 q1 q2 end
	      | tt =>
  	          contra trans symm u2
  	                 trans [eq_lit_trans l x l' q1 trans [eq_lit_symm x l'] q2]
  		         clash tt ff
  		    { (cl_has (cl_erase c l') l) = tt }
	      end
	 end
    end.
 
Define cl_subsume_tt_erase_lit_both :
  Forall(c1 c2:clause)(l:lit)(u:{ (cl_subsume c1 c2) = tt }).
    { (cl_subsume (cl_erase c1 l) (cl_erase c2 l)) = tt }
  :=
  induction(c1:clause) return
    Forall(c2:clause)(l:lit)(u:{ (cl_subsume c1 c2) = tt }).
      { (cl_subsume (cl_erase c1 l) (cl_erase c2 l)) = tt }
  with
    nil _ =>
      foralli(c2:clause)(l:lit)(u:{ (cl_subsume c1 c2) = tt }).
      hypjoin (cl_subsume (cl_erase c1 l) (cl_erase c2 l)) tt by c1_eq end
  | cons _ x c1' =>
      foralli(c2:clause)(l:lit)(u:{ (cl_subsume c1 c2) = tt }).
			case (eq_lit l x) by q1 _ with
				ff =>
          abbrev q1' = trans [eq_lit_symm x l] q1 in
					abbrev p1 = hypjoin (cl_subsume (cons x c1') c2) tt by u c1_eq end in
					abbrev u' = [cl_subsume_tt_tail x c1' c2 p1] in
					abbrev ih = [c1_IH c1' c2 l u'] in
					abbrev p2 = [cl_subsume_tt_head x c1' c2 p1] in
          abbrev p3 = [cl_has_implies_erase_lit_has_lit c2 x l p2 q1'] in
          abbrev p4 = hypjoin (cl_subsume (cons x (cl_erase c1' l)) (cl_erase c2 l)) tt by ih p3 end in
          abbrev p5 = hypjoin (cl_erase c1 l) (cons x (cl_erase c1' l)) by c1_eq q1 end in
					hypjoin (cl_subsume (cl_erase c1 l) (cl_erase c2 l)) tt by p4 p5 end
			| tt =>
					abbrev p1 = hypjoin (cl_subsume (cons x c1') c2) tt by u c1_eq end in
					abbrev u' = [cl_subsume_tt_tail x c1' c2 p1] in
					abbrev ih = [c1_IH c1' c2 l u'] in
          abbrev p2 = hypjoin (cl_erase c1 l) (cl_erase c1' l) by c1_eq q1 end in
					hypjoin (cl_subsume (cl_erase c1 l) (cl_erase c2 l)) tt by c1_eq ih p2 end
			end
  end
  .

Define cl_erase_lem1 :
  Forall(nv:word)(c:clause)
        (u1:{ (cl_valid nv c) = tt })
        (l:lit).
    { (cl_valid nv (cl_erase c l)) = tt }
  :=
  foralli(nv:word)(c:clause)
         (u1:{ (cl_valid nv c) = tt })
         (l:lit).
  [induction(c:clause) return
    Forall(nv:word)(u1:{ (cl_valid nv c) = tt })(l:lit).
      { (cl_valid nv (cl_erase c l)) = tt }
  with
    nil _ =>
      foralli(nv:word)(u1:{ (cl_valid nv c) = tt })(l:lit).
      hypjoin (cl_valid nv (cl_erase c l)) tt by c_eq end
  | cons _ x c' =>
      foralli(nv:word)(u1:{ (cl_valid nv c) = tt })(l:lit).
      case (lit_valid nv x) by q1 _ with
        ff =>
	  abbrev p1 = hypjoin (cl_valid nv c) ff by c_eq q1 end in
          contra trans symm p1
                 trans u1
  	               clash tt ff
  	     { (cl_valid nv (cl_erase c l)) = tt }
      | tt =>
	  abbrev u1' = hypjoin (cl_valid nv c') tt by c_eq u1 q1 end in
	  abbrev ih = [c_IH c' nv u1' l] in
          case (eq_lit l x) by q2 _ with
	    ff =>
	      hypjoin (cl_valid nv (cl_erase c l)) tt by c_eq q1 q2 ih end
	  | tt =>
	      hypjoin (cl_valid nv (cl_erase c l)) tt by c_eq q2 ih end
	  end
      end
  end c nv u1 l].

Define cl_has_ff_implies_tail_has_ff := foralli
	(l:lit)
  (c:clause)
	(x:lit)
	(u:{ (cl_has (cons l c) x) = ff })
	.
	case (eq_lit x l) by q1 _ with
	| ff =>
		hypjoin (cl_has c x) ff by u q1 end
	| tt =>
		contra
		trans symm u
		trans hypjoin (cl_has (cons l c) x) tt by q1 end
					clash tt ff
		{ (cl_has c x) = ff }
	end
	
Define cl_has_ff_implies_cl_erase_eq :=
  induction(c:clause) return Forall
		(l:lit)
		(u:{ (cl_has c l) = ff })
		.{ (cl_erase c l) = c }
	with
	| nil _ => foralli
		(l:lit)
		(u:{ (cl_has c l) = ff })
		.
		hypjoin (cl_erase c l) c by c_eq end
	| cons _ x c' => foralli
		(l:lit)
		(u:{ (cl_has c l) = ff })
		.
		case (eq_lit l x) by q1 _ with
		| ff =>
			cabbrev p1 = hypjoin (cl_has (cons x c') l) ff by u c_eq end
			cabbrev u' = [cl_has_ff_implies_tail_has_ff x c' l p1]
			cabbrev ih = [c_IH c' l u']
			hypjoin (cl_erase c l) c by q1 c_eq ih end
		| tt =>
			contra
			trans symm u
			trans hypjoin (cl_has c l) tt by q1 c_eq end
						clash tt ff
			{ (cl_erase c l) = c }
		end
	end

Define cl_erase_append : Forall
	(c1 c2:clause)
	(l:lit)
	.{ (cl_erase (append c1 c2) l) = (append (cl_erase c1 l) (cl_erase c2 l)) }
	:= foralli
	(c1 c2:clause)
	(l:lit)
	.
	[
	induction(c:clause) return { (cl_erase (append c c2) l) = (append (cl_erase c l) (cl_erase c2 l)) }
	with
	| nil _ =>
		cabbrev p6 = hypjoin (cl_erase (append c c2) l) (cl_erase c2 l) by c_eq end
		cabbrev p7 = hypjoin (append (cl_erase c l) (cl_erase c2 l)) (cl_erase c2 l) by c_eq end
		trans p6 symm p7
	| cons _ x c' =>
		% ih: (cl_erase (append c' c2) l) = (append (cl_erase c' l) (cl_erase c2 l))
		cabbrev ih = [c_IH c']
		case (eq_lit l x) by q1 _ with
		| default bool =>
			hypjoin (cl_erase (append c c2) l) (append (cl_erase c l) (cl_erase c2 l)) by q1 c_eq ih end
		end
	end
	c1]

Define cl_erase_has_implies_cl_has : Forall
	(c:clause)(x y:lit)
	(u:{ (cl_has (cl_erase c x) y) = tt })
  .{ (cl_has c y) = tt }
  :=
	induction(c:clause) return Forall
		(x y:lit)
		(u:{ (cl_has (cl_erase c x) y) = tt })
		.{ (cl_has c y) = tt }
	with
	| nil _ => foralli
		(x y:lit)
		(u:{ (cl_has (cl_erase c x) y) = tt })
		.
		contra
		trans symm u
		trans hypjoin (cl_has (cl_erase c x) y) ff by c_eq end
					clash ff tt
		{ (cl_has c y) = tt }
	| cons _ l c' => foralli
		(x y:lit)
		(u:{ (cl_has (cl_erase c x) y) = tt })
		.
		case (eq_lit y l) by q2 _ with
		| ff =>
			% need: (cl_has (cl_erase c' x) y) = tt
			cabbrev u' = 
				case (eq_lit x l) by q1 _ with
				| ff => hypjoin (cl_has (cl_erase c' x) y) tt by u c_eq q1 q2 end
				| tt => hypjoin (cl_has (cl_erase c' x) y) tt by u c_eq q1 end
				end
			cabbrev ih = [c_IH c' x y u']
			hypjoin (cl_has c y) tt by ih q2 c_eq end
		| tt =>
			hypjoin (cl_has c y) tt by q2 c_eq end
		end
	end

Define cl_erase_has_ff : Forall
	(c:clause)(x:lit)
  .{ (cl_has (cl_erase c x) x) = ff }
  :=
	induction(c:clause) return Forall(x:lit).{ (cl_has (cl_erase c x) x) = ff }
	with
	| nil _ => foralli(x:lit).
		hypjoin (cl_has (cl_erase c x) x) ff by c_eq end
	| cons _ y c' => foralli(x:lit).
		case (eq_lit x y) by q1 _ with
		| ff =>
			cabbrev p1 = hypjoin (cl_has (cl_erase c x) x) (cl_has (cl_erase c' x) x) by c_eq q1 end
			cabbrev ih = [c_IH c' x]
			hypjoin (cl_has (cl_erase c x) x) ff by p1 ih end
		| tt =>
			cabbrev p1 = hypjoin (cl_erase c x) (cl_erase c' x) by c_eq q1 end
			cabbrev ih = [c_IH c' x]
			hypjoin (cl_has (cl_erase c x) x) ff by p1 ih end
		end
	end

	

%=============================================================================
% cl_unique (for resolution)
% - could be generalized for any type
%=============================================================================

Define spec cl_unique := fun cl_unique(c:clause) : bool.
  match c with
  | nil _ => tt
  | cons _ l c' =>
		match (cl_has c' l) with
		| ff => (cl_unique c')
		| tt => ff
		end
  end

Define cl_unique_erase_lit_length :
  Forall(c:clause)(l:lit)
        (u1:{ (cl_unique c) = tt })
        (u2:{ (cl_has c l) = tt }).
    { (S (length (cl_erase c l))) = (length c) }
  :=
  induction(c:clause) return Forall
           (l:lit)
           (u1:{ (cl_unique c) = tt })
           (u2:{ (cl_has c l) = tt }).
	   { (S (length (cl_erase c l))) = (length c) }
  with
    nil _ =>
      foralli(l:lit)(u1:{ (cl_unique c) = tt })(u2:{ (cl_has c l) = tt }).
      contra
        trans symm u2
        trans hypjoin (cl_has c l) ff by c_eq end
          clash ff tt
      { (S (length (cl_erase c l))) = (length c) }
  | cons _ x c' =>
    foralli(l:lit)(u1:{ (cl_unique c) = tt })(u2:{ (cl_has c l) = tt }).
    case (cl_has c' x) by q1 _ with
      ff =>
        case (eq_lit l x) by q2 _ with
          ff =>
            abbrev u1' = hypjoin (cl_unique c') tt by c_eq u1 q1 end in
	    abbrev u2' = hypjoin (cl_has c' l) tt by c_eq u2 q2 end in
            abbrev ih = [c_IH c' l u1' u2'] in
	    hypjoin (S (length (cl_erase c l))) (length c) by c_eq q2 ih end
        | tt =>
	    abbrev p1 = hypjoin (cl_has c' l) ff by q1 q2 [eq_lit_eq l x q2] end
	    hypjoin (S (length (cl_erase c l))) (length c) by c_eq q2 [cl_has_ff_implies_cl_erase_eq c' l p1] end
	end
    | tt =>
        contra
	  trans symm u1
	  trans hypjoin (cl_unique c) ff by c_eq q1 end
	    clash ff tt
       { (S (length (cl_erase c l))) = (length c) }
    end
  end.

Define cl_has_ff_implies_erase_cl_has_ff :
  Forall(c:clause)(l1 l2:lit)(u:{ (cl_has c l1) = ff }).
    { (cl_has (cl_erase c l2) l1) = ff }
  :=
  induction(c:clause) return Forall
           (l1 l2:lit)(u:{ (cl_has c l1) = ff }).
    { (cl_has (cl_erase c l2) l1) = ff }
  with
    nil _ =>
    foralli(l1 l2:lit)(u:{ (cl_has c l1) = ff }).
    hypjoin (cl_has (cl_erase c l2) l1) ff by c_eq end
  | cons _ x c' => 
    foralli(l1 l2:lit)(u:{ (cl_has c l1) = ff }).
    case (cl_has c l2) by q1 _ with
      ff =>
        hypjoin (cl_has (cl_erase c l2) l1) ff by u [cl_has_ff_implies_cl_erase_eq c l2 q1] end
    | tt =>
        case (eq_lit l2 x) by q2 _ with
	  ff =>
	    % (cl_erase c l2) = (cons x (cl_erase c' l2))
	    % show (eq_lit l1 x) = ff
	    % show (cl_has (cl_erase c' l2) l1) = ff
	    abbrev p1 = hypjoin (cl_has (cons x c') l1) ff by u c_eq end in
	    abbrev u' = [cl_has_ff_implies_tail_has_ff x c' l1 p1] in
	    abbrev ih = [c_IH c' l1 l2 u'] in
            abbrev p2_1 = hypjoin (or (eq_lit l1 x) (cl_has c' l1)) ff by c_eq u end in
	    abbrev p2 = [or_eq_ff (eq_lit l1 x) (cl_has c' l1) p2_1] in % (eq_lit l1 x) = ff
	    hypjoin (cl_has (cl_erase c l2) l1) ff by c_eq q2 p2 ih end
	| tt =>
	    % (cl_erase c l2) = (cl_erase c' l2)
	    % show (cl_has (cl_erase c' l2) l1) = ff (ih)
	    abbrev p1 = hypjoin (cl_has (cons x c') l1) ff by u c_eq end in
	    abbrev u' = [cl_has_ff_implies_tail_has_ff x c' l1 p1] in
	    abbrev ih = [c_IH c' l1 l2 u'] in
	    hypjoin (cl_has (cl_erase c l2) l1) ff by c_eq q2 ih end	    
	end
    end
  end.

Define cl_unique_implies_unique_erase :
  Forall(c:clause)(l:lit)
        (u1:{ (cl_unique c) = tt })
    .{ (cl_unique (cl_erase c l)) = tt }
  := 
  induction(c:clause) return Forall
           (l:lit)(u1:{ (cl_unique c) = tt })
    .{ (cl_unique (cl_erase c l)) = tt }
  with
    nil _ =>
      foralli(l:lit)(u1:{ (cl_unique c) = tt }).
      hypjoin (cl_unique (cl_erase c l)) tt by c_eq u1 end
  | cons _ x c' =>
      foralli(l:lit)(u1:{ (cl_unique c) = tt }).
      case (cl_has c' x) by q1 _ with
        ff =>
        case (eq_lit l x) by q2 _ with
          ff =>
            abbrev u1' = hypjoin (cl_unique c') tt by c_eq u1 q1 end in
            abbrev ih = [c_IH c' l u1'] in
	    abbrev p1 = [cl_has_ff_implies_erase_cl_has_ff c' x l q1] in
	    hypjoin (cl_unique (cl_erase c l)) tt by c_eq q2 ih p1 end
	| tt =>
            abbrev u1' = hypjoin (cl_unique c') tt by c_eq u1 q1 end in
            abbrev ih = [c_IH c' l u1'] in
	    hypjoin (cl_unique (cl_erase c l)) tt by c_eq q2 ih end
        end
      | tt =>
        contra
	  trans symm u1
	  trans hypjoin (cl_unique c) ff by c_eq q1 end
	    clash ff tt
       { (cl_unique (cl_erase c l)) = tt }
      end
  end

%=============================================================================
% clause lemma for conflict
%=============================================================================

Define cl_length_one_has_lit : Forall
  (c:clause)(l:lit)
  (u1:{ (length c) = (S Z) })
  (u2:{ (cl_has c l) = tt })
  .{ c = (cons l nil) }
  :=
  foralli(c:clause)(l:lit)(u1:{ (length c) = (S Z) })
         (u2:{ (cl_has c l) = tt }).
  case c with
    nil _ =>
      contra
  	trans symm u1
  	trans hypjoin (length c) Z by c_eq end
  	  clash Z (S Z)
      { c = (cons l nil) }
  | cons _ x c' =>
      abbrev p1_1 =
        inj (S *)
	  trans hypjoin (S (length c')) (length c) by c_eq end
	        u1 in
      abbrev p1 = [length_eq_Z lit c' p1_1] in % c' = nil
      case (cl_has c' l) by q1 _ with
        ff => 
          abbrev p2_1 = hypjoin (eq_lit l x) tt by c_eq u2 q1 [or_def2ff (eq_lit l x)] end in % (eq_lit l x)
	  abbrev p2 = [eq_lit_eq l x p2_1] in % l = x
          hypjoin c (cons l nil) by c_eq p1 p2 end
      | tt =>
        contra
  	  trans symm q1
  	  trans hypjoin (cl_has c' l) ff by p1 end
  	    clash ff tt
        { c = (cons l nil) }
      end
  end.
