Include trusted "lib-lemma.g".
Include trusted "pf.g".

%=============================================================================
% lit lemmas
%=============================================================================

Define eq_lit_total : Forall(a b:lit).Exists(x:bool).{ (eq_lit a b) = x } :=
  foralli(a b:lit).
  existse [eqword_tot (unboxWord a) (unboxWord b)]
  foralli(x:bool)(x_pf:{ (eqword (unboxWord a) (unboxWord b)) = x }).
  existsi x { (eq_lit a b) = * }
    hypjoin (eq_lit a b) x by x_pf end

Total eq_lit eq_lit_total.
  
Define eq_lit_refl : Forall(l:lit).{ (eq_lit l l) = tt } :=
	foralli(l:lit).
	abbrev w = (unboxWord l) in
	abbrev p1 = [eqword_refl w] in
	hypjoin (eq_lit l l) tt by p1 end

Define eq_lit_eq : Forall(a b:lit)(u:{ (eq_lit a b) = tt }).{ a = b } :=
  foralli(a b:lit)(u:{ (eq_lit a b) = tt }).
  abbrev p1 = hypjoin (eqword (unboxWord a) (unboxWord b)) tt by u end in
  abbrev p2 = [eqword_eq (unboxWord a) (unboxWord b) p1] in
  % p2: (unboxWord a) = (unboxWord b)
  % want: a = b
  case a with mk_uholder _ a' =>
  case b with mk_uholder _ b' =>
  hypjoin a b by u p2 a_eq b_eq end
  end end.

Define lit_sign_total : Forall(l:lit).Exists(b:bool).{ (lit_sign l) = b } :=
  foralli(l:lit).
  existsi (word_msb (unboxWord l)) { (lit_sign l) = * }
  join (lit_sign l) (word_msb (unboxWord l))

Define lit_vnum_total : Forall(l:lit).Exists(w:word).{ (lit_vnum l) = w } :=
  foralli(l:lit).
  existsi (word_clear_msb (unboxWord l)) { (lit_vnum l) = * }
  join (lit_vnum l) (word_clear_msb (unboxWord l))

Total lit_sign lit_sign_total.
Total lit_vnum lit_vnum_total.

Define pos_total :
	Forall(w:word)(u:{ (word_msb w) = ff }).Exists(l:lit).{ (pos w) = l }
	:=
	foralli(w:word)(u:{ (word_msb w) = ff }).
	existsi (boxWord (word_set_msb w)) { (pos w) = * }
	join (pos w) (boxWord (word_set_msb w))

Define neg_total :
	Forall(w:word)(u:{ (word_msb w) = ff }).Exists(l:lit).{ (neg w) = l }
	:=
	foralli(w:word)(u:{ (word_msb w) = ff }).
	existsi (boxWord w) { (neg w) = * }
	join (neg w) (boxWord w)

Total pos pos_total.
Total neg neg_total.
  
Define negated_total : Forall(l:lit).Exists(l':lit).{ (negated l) = l' } :=
	foralli(l:lit).
  abbrev sign = (lit_sign l) in
  abbrev q = [lit_vnum_word_msb_ff l] in
  case sign with
    ff => existsi (pos (lit_vnum l) q) { (negated l) = * }
    			hypjoin (negated l) (pos (lit_vnum l)) by sign_eq end
  | tt => existsi (neg (lit_vnum l) q) { (negated l) = * }
    			hypjoin (negated l) (neg (lit_vnum l)) by sign_eq end
  end.

Total negated negated_total.

Define pos_lit_vnum :
	Forall(w:word)(u:{ (word_msb w) = ff }).{ (lit_vnum (pos w)) = w } :=
	foralli(w:word)(u:{ (word_msb w) = ff }).
	abbrev p1 = join (lt (to_nat 0x1f) wordlen) tt in
	hypjoin (lit_vnum (pos w)) w by
		[word_set_clear w 0x1f p1]
		[word_msb_ff_clear_msb w u]
	end

Define neg_lit_vnum :
	Forall(w:word)(u:{ (word_msb w) = ff }).{ (lit_vnum (neg w)) = w } :=
	foralli(w:word)(u:{ (word_msb w) = ff }).
	hypjoin (lit_vnum (neg w)) w by
		[word_msb_ff_clear_msb w u]
	end

Define pos_sign_tt :
	Forall(v:word)(u:{ (word_msb v) = ff }). { (lit_sign (pos v)) = tt }
	:=
  foralli(v:word)(u:{ (word_msb v) = ff }).
	abbrev p1 = join (lt (to_nat 0x1f) wordlen) tt in
  hypjoin (lit_sign (pos v)) tt by [word_set_read v 0x1f p1] end.

Define neg_sign_ff :
	Forall(v:word)(u:{ (word_msb v) = ff }). { (lit_sign (neg v)) = ff }
	:=
  foralli(v:word)(u:{ (word_msb v) = ff }).
  hypjoin (lit_sign (neg v)) ff by u end.

Define negated_pos_is_neg :
	Forall(v:word)(u:{ (word_msb v) = ff }). { (negated (pos v)) = (neg v) }
	:=
  foralli(v:word)(u:{ (word_msb v) = ff }).
	abbrev p1 = join (lt (to_nat 0x1f) wordlen) tt in
  hypjoin (negated (pos v)) (neg v) by [pos_sign_tt v u] [pos_lit_vnum v u] end
  
Define negated_neg_is_pos :
	Forall(v:word)(u:{ (word_msb v) = ff }). { (negated (neg v)) = (pos v) }
	:=
  foralli(v:word)(u:{ (word_msb v) = ff }).
	abbrev p1 = join (lt (to_nat 0x1f) wordlen) tt in
  hypjoin (negated (neg v)) (pos v) by [neg_sign_ff v u] [neg_lit_vnum v u] end

Define lit_sign_tt_implies_lit_vnum_pos_eq :
	Forall(l:lit)(u:{ (lit_sign l) = tt }).{ (pos (lit_vnum l)) = l } :=
	foralli(l:lit)(u:{ (lit_sign l) = tt }).
	abbrev p1_1 = join (lt (to_nat 0x1f) wordlen) tt in
	abbrev p1 = [word_clear_set (unboxWord l) 0x1f p1_1] in
	abbrev p2 = hypjoin (word_msb (unboxWord l)) tt by u end in
	abbrev p3 = [word_msb_tt_set_msb (unboxWord l) p2] in
	hypjoin (pos (lit_vnum l)) l by p1 p3 [unboxWord_boxWord l] end

Define lit_sign_ff_implies_lit_vnum_neg_eq :
	Forall(l:lit)(u:{ (lit_sign l) = ff }).{ (neg (lit_vnum l)) = l } :=
	foralli(l:lit)(u:{ (lit_sign l) = ff }).
	abbrev p2 = hypjoin (word_msb (unboxWord l)) ff by u end in
	abbrev p3 = [word_msb_ff_clear_msb (unboxWord l) p2] in
	hypjoin (neg (lit_vnum l)) l by p3 [unboxWord_boxWord l] end

Define elim_double_neg : Forall(l:lit).{ (negated (negated l)) = l } :=
	foralli(l:lit).
	abbrev v = (lit_vnum l) in
	abbrev sl = (lit_sign l) in
	abbrev u = [lit_vnum_word_msb_ff l] in
	case sl with
		ff => trans hypjoin (negated (negated l)) (neg v) by sl_eq [negated_pos_is_neg v u] end
								[lit_sign_ff_implies_lit_vnum_neg_eq l sl_eq]
	| tt => trans hypjoin (negated (negated l)) (pos v) by sl_eq [negated_neg_is_pos v u] end
								[lit_sign_tt_implies_lit_vnum_pos_eq l sl_eq]
	end.

Define negated_lit_sign :
	Forall(l:lit)
	.{ (lit_sign (negated l)) = (not (lit_sign l)) }
	:= foralli(l:lit).
	cabbrev v = (lit_vnum l)
	cabbrev p1 = [lit_vnum_word_msb_ff l]
	case (lit_sign l) by q1 _ with
	| ff =>
		cabbrev p2 = [pos_sign_tt v p1]
		hypjoin (lit_sign (negated l)) (not (lit_sign l)) by q1 p2 end
	| tt =>
		cabbrev p2 = [neg_sign_ff v p1]
		hypjoin (lit_sign (negated l)) (not (lit_sign l)) by q1 p2 end
	end


%=============================================================================
% clause lemmas
%=============================================================================

Define eq_clause_total :
	Forall(c1 c2:clause).Exists(b:bool).{ (eq_clause c1 c2) = b }
	:=
  foralli(c1 c2:clause).
  [eqlist_total lit eq_lit eq_lit_total c1 c2].

Total eq_clause eq_clause_total.

Define eq_clause_refl : Forall(c:clause). { (eq_clause c c) = tt } :=
  foralli(c:clause).
  [eqlist_refl lit eq_lit eq_lit_refl c].

Define eq_clause_eq :
	Forall(c1 c2:clause)(u:{ (eq_clause c1 c2) = tt }).{ c1 = c2 }
	:=
  foralli(c1 c2:clause)
         (u:{ (eq_clause c1 c2) = tt }).
  [eqlistEq lit c1 c2 eq_lit eq_lit_total eq_lit_eq u].

Define cl_has_total :=
  foralli(c:clause)(l:lit).
	existse [member_total lit l c eq_lit eq_lit_total]
	foralli(z:bool)(z_pf:{ (member lit l c eq_lit) = z }).
	existsi z { (cl_has c l) = * }
	hypjoin (cl_has c l) z by z_pf end
    
Total cl_has cl_has_total.

Define cl_erase_total :=
  foralli(c:clause)(l:lit).
	existse [erase_total lit eq_lit eq_lit_total l c]
	foralli(z:clause)(z_pf:{ (erase lit eq_lit l c) = z }).
	existsi z { (cl_erase c l) = * }
	hypjoin (cl_erase c l) z by z_pf end
    
Total cl_erase cl_erase_total.

Define cl_has_tt_cons :
  Forall(c:clause)(l l':lit)(u:{ (cl_has c l) = tt }).
  	{ (cl_has (cons l' c) l) = tt }
  :=
  foralli(c:clause)(l l':lit)(u:{ (cl_has c l) = tt }).
  abbrev p1 = hypjoin (member l c eq_lit) tt by u end in
  abbrev p2 = [member_tt_cons lit eq_lit eq_lit_total l c l' p1] in
	hypjoin (cl_has (cons l' c) l) tt by p2 end

Define cl_has_tt_append :
	Forall(l:lit)(c c':clause)(u:{ (cl_has c l) = tt }).
		{ (cl_has (append c c') l) = tt }
	:=
  foralli(l:lit)(c c':clause)(u:{ (cl_has c l) = tt }).
  abbrev p1 = hypjoin (member lit l c eq_lit) tt by u end in
  hypjoin (cl_has (append c c') l) tt
    by u [member_tt_append lit eq_lit eq_lit_total l c c' p1] end

Define cl_has_tt_append_front :
	Forall(l:lit)(c c':clause)(u:{ (cl_has c l) = tt }).
		{ (cl_has (append c' c) l) = tt }
	:=
  foralli(l:lit)(c c':clause)(u:{ (cl_has c l) = tt }).
  abbrev p1 = hypjoin (member lit l c eq_lit) tt by u end in
  hypjoin (cl_has (append c' c) l) tt
    by u [member_tt_append_front lit eq_lit eq_lit_total l c c' p1] end

Define cl_has_append_or :
  Forall(c1 c2:clause)(x:lit).
    { (cl_has (append c1 c2) x) = (or (cl_has c1 x) (cl_has c2 x)) }
  :=
  foralli(c1 c2:clause)(x:lit).
  trans join (cl_has (append c1 c2) x) (member x (append c1 c2) eq_lit)
  trans symm [member_or_append lit eq_lit eq_lit_total x c1 c2]
  		  join (or (member x c1 eq_lit) (member x c2 eq_lit))
  					 (or (cl_has c1 x) (cl_has c2 x))

Define cl_has_append_cons1 :
  Forall(c1 c2:clause)(l x:lit)(u:{ (cl_has (append c1 (cons l c2)) x) = tt })
    .{ (cl_has (append (cons l c1) c2) x) = tt }
  :=
 	foralli(c1 c2:clause)(l x:lit)(u:{ (cl_has (append c1 (cons l c2)) x) = tt }).
	case (eq_lit x l) by q1 _ with
		ff =>
			case (cl_has c1 x) by q2 _ with
				ff =>
					abbrev p1 = hypjoin (cl_has (cons l c1) x) ff by q2 q1 end in
					abbrev p2 = [cl_has_append_or (cons lit l c1) c2 x] in
					abbrev p3_1 = [cl_has_append_or c1 (cons lit l c2) x] in
					abbrev p3 = hypjoin (cl_has c2 x) tt by u p3_1 q2 q1 end in
					hypjoin (cl_has (append (cons l c1) c2) x) tt by p2 p3 q1 q2 end
			| tt =>
					abbrev p1 = hypjoin (cl_has (cons l c1) x) tt by q1 q2 end in
					abbrev p2 = [cl_has_append_or (cons lit l c1) c2 x] in
					hypjoin (cl_has (append (cons l c1) c2) x) tt by p1 p2 end
			end
	| tt =>
			hypjoin (cl_has (append (cons l c1) c2) x) tt by q1 end
	end.

%=============================================================================
% subsumption lemmas
%=============================================================================

Define cl_subsume_total :=
  foralli(c1:clause)(c2:clause).
    existse [list_subset_total lit eq_lit eq_lit_total c1 c2]
    foralli(z:bool)(z_pf: { (list_subset lit eq_lit c1 c2) = z }).
    existsi z { (cl_subsume c1 c2) = * }
      hypjoin (cl_subsume c1 c2) z by z_pf end.
           
Total cl_subsume cl_subsume_total.

Define cl_subsume_tt_head :
  Forall(l:lit)(c1 c2:clause)(u:{ (cl_subsume (cons l c1) c2) = tt }).
    { (cl_has c2 l) = tt }
  :=
  foralli(l:lit)(c1 c2:clause)(u:{ (cl_subsume (cons l c1) c2) = tt }).
  abbrev z1 = (cl_has c2 l) in
  abbrev z2 = (cl_subsume c1 c2) in
  case z1 with
    ff =>
    	contra trans symm u
			     	 trans hypjoin (cl_subsume (cons l c1) c2) ff by z1_eq end
			     	 			 clash ff tt
			     	 { (cl_has c2 l) = tt }
  | tt =>
  		z1_eq
  end.

Define cl_subsume_tt_tail :
  Forall(l:lit)(c1 c2:clause)(u:{ (cl_subsume (cons l c1) c2) = tt }).
    { (cl_subsume c1 c2) = tt }
  :=
  foralli(l:lit)(c1 c2:clause)(u:{ (cl_subsume (cons l c1) c2) = tt }).
  abbrev z1 = (cl_has c2 l) in
  abbrev z2 = (cl_subsume c1 c2) in
  case z1 with
    ff =>
    	contra trans symm u
			     	 trans hypjoin (cl_subsume (cons l c1) c2) ff by z1_eq end
			     	 			 clash ff tt
			     	 { (cl_subsume c1 c2) = tt }
  | tt =>
  		hypjoin (cl_subsume c1 c2) tt by z1_eq u end
  end.

Define cl_subsume_implies_cl_has :
  Forall(c1 c2:clause)(u:{ (cl_subsume c1 c2) = tt })
  			(l:lit)(r:{ (cl_has c1 l) = tt }).
    { (cl_has c2 l) = tt }
  :=
  induction(c1:clause) return
		Forall(c2:clause)(u:{ (cl_subsume c1 c2) = tt })
					(l:lit)(r:{ (cl_has c1 l) = tt }).
			{ (cl_has c2 l) = tt }
	with
		nil _ =>
		  foralli(c2:clause)(u:{ (cl_subsume c1 c2) = tt })
						 (l:lit)(r:{ (cl_has c1 l) = tt }).
			contra
				trans symm r
				trans hypjoin (cl_has c1 l) ff by c1_eq end
							clash ff tt
				{ (cl_has c2 l) = tt }
	| cons _ l' c1' =>
		  foralli(c2:clause)(u:{ (cl_subsume c1 c2) = tt })
						 (l:lit)(r:{ (cl_has c1 l) = tt }).
			case (eq_lit l l') by q1 _ with
				ff =>
					abbrev p1 = hypjoin (cl_subsume (cons l' c1') c2) tt by u c1_eq end in
					abbrev u' = [cl_subsume_tt_tail l' c1' c2 p1] in
					abbrev r' = hypjoin (cl_has c1' l) tt by r c1_eq q1 end in
					[c1_IH c1' c2 u' l r']
			| tt =>
					abbrev l_eq = [eq_lit_eq l l' q1] in
					abbrev p1_1 = hypjoin (cl_subsume (cons l' c1') c2) tt by u c1_eq end in
					abbrev p1 = [cl_subsume_tt_head l' c1' c2 p1_1] in
					hypjoin (cl_has c2 l) tt by p1 l_eq end
			end
	end.

Define cl_subsume_tt_erase_lit :
  Forall(c1 c2:clause)(l:lit)(u:{ (cl_subsume c1 c2) = tt }).
    { (cl_subsume (cl_erase c1 l) c2) = tt }
  :=
  induction(c1:clause) return
    Forall(c2:clause)(l:lit)(u:{ (cl_subsume c1 c2) = tt }).
      { (cl_subsume (cl_erase c1 l) c2) = tt }
  with
    nil _ =>
      foralli(c2:clause)(l:lit)(u:{ (cl_subsume c1 c2) = tt }).
      hypjoin (cl_subsume (cl_erase c1 l) c2) tt by c1_eq end
  | cons _ x c1' =>
      foralli(c2:clause)(l:lit)(u:{ (cl_subsume c1 c2) = tt }).
			case (eq_lit l x) by q1 _ with
				ff =>
					abbrev p1 = hypjoin (cl_subsume (cons x c1') c2) tt by u c1_eq end in
					abbrev u' = [cl_subsume_tt_tail x c1' c2 p1] in
					abbrev ih = [c1_IH c1' c2 l u'] in
					abbrev p2 = [cl_subsume_tt_head x c1' c2 p1] in
					hypjoin (cl_subsume (cl_erase c1 l) c2) tt by c1_eq q1 ih p2 end
			| tt =>
					abbrev p1 = hypjoin (cl_subsume (cons x c1') c2) tt by u c1_eq end in
					abbrev u' = [cl_subsume_tt_tail x c1' c2 p1] in
					abbrev ih = [c1_IH c1' c2 l u'] in
					hypjoin (cl_subsume (cl_erase c1 l) c2) tt by c1_eq q1 ih end
			end
  end

Define cl_subsume_tt_subsume_cons :
  Forall(c1 c2:clause)(l:lit)(u:{ (cl_subsume c1 c2) = tt }).
    { (cl_subsume c1 (cons l c2)) = tt }
  :=
  induction(c1:clause) return
    Forall(c2:clause)(l:lit)(u:{ (cl_subsume c1 c2) = tt }).
      { (cl_subsume c1 (cons l c2)) = tt }
  with
    nil _ =>
      foralli(c2:clause)(l:lit)(u:{ (cl_subsume c1 c2) = tt }).
      hypjoin (cl_subsume c1 (cons l c2)) tt by c1_eq end
  | cons _ l' c1' =>
      foralli(c2:clause)(l:lit)(u:{ (cl_subsume c1 c2) = tt }).
			abbrev p1 = hypjoin (cl_subsume (cons l' c1') c2) tt by u c1_eq end in
      abbrev p2_1 = [cl_subsume_tt_head l' c1' c2 p1] in
      abbrev p2 = [cl_has_tt_cons c2 l' l p2_1] in
      abbrev u' = [cl_subsume_tt_tail l' c1' c2 p1] in
      abbrev ih = [c1_IH c1' c2 l u'] in
      hypjoin (cl_subsume c1 (cons l c2)) tt by c1_eq p2 ih end
  end.

 Define cl_subsume_tt_merge :
  Forall(c1 c2 c3:clause)
        (u1:{ (cl_subsume c1 c3) = tt })
        (u2:{ (cl_subsume c2 c3) = tt }).
    { (cl_subsume (append lit c1 c2) c3) = tt }
  :=
  induction(c1:clause) return 
    Forall(c2 c3:clause)
          (u1:{ (cl_subsume c1 c3) = tt })
          (u2:{ (cl_subsume c2 c3) = tt }).
      { (cl_subsume (append c1 c2) c3) = tt }
  with
    nil _ =>
      foralli(c2 c3:clause)
             (u1:{ (cl_subsume c1 c3) = tt })
             (u2:{ (cl_subsume c2 c3) = tt }).
      hypjoin (cl_subsume (append c1 c2) c3)
              tt
        by c1_eq u2 end
  | cons _ l c1' =>
      foralli(c2 c3:clause)
             (u1:{ (cl_subsume c1 c3) = tt })
             (u2:{ (cl_subsume c2 c3) = tt }).
      abbrev p1 = trans cong (cl_subsume * c3) symm c1_eq
                        u1
      in
      abbrev p2 = [cl_subsume_tt_head l c1' c3 p1] in
      abbrev p3 = [cl_subsume_tt_tail l c1' c3 p1] in
      hypjoin (cl_subsume (append c1 c2) c3) tt
        by c1_eq p2 [c1_IH c1' c2 c3 p3 u2] end
  end

Define cl_subsume_refl : Forall(c:clause). { (cl_subsume c c) = tt }
  :=
  induction(c:clause) return { (cl_subsume c c) = tt }
  with
    nil _ => hypjoin (cl_subsume c c) tt by c_eq end
  | cons _ l c' =>
  		abbrev p1 = hypjoin (cl_has c l) tt by c_eq [eq_lit_refl l] end in
  		abbrev ih = [c_IH c'] in
  		abbrev p2 = [cl_subsume_tt_subsume_cons c' c' l ih] in
  		hypjoin (cl_subsume c c) tt by c_eq p1 p2 end
  end.

Define cl_subsume_trans :
  Forall(c1 c2 c3:clause)
        (u1:{ (cl_subsume c1 c2) = tt})
	(u2:{ (cl_subsume c2 c3) = tt}).
    { (cl_subsume c1 c3) = tt}
  :=
  foralli(c1 c2 c3:clause)
        (u1:{ (cl_subsume c1 c2) = tt})
	(u2:{ (cl_subsume c2 c3) = tt}).
  abbrev u1' = trans join (list_subset eq_lit c1 c2) (cl_subsume c1 c2)
                     u1 in
  abbrev u2' = trans join (list_subset eq_lit c2 c3) (cl_subsume c2 c3)
                     u2 in
  trans join (cl_subsume c1 c3) (list_subset eq_lit c1 c3)
        [list_transitivity lit eq_lit eq_lit_total c1 c2 c3 u1' u2' eq_lit_refl eq_lit_eq].
                          

%==============================================================================
% cl_subsume and append lemmas
%==============================================================================

Define cl_subsume_tt_subsume_append :
  Forall(c1 c2 c3:clause)(u:{ (cl_subsume c1 c2) = tt }).
    { (cl_subsume c1 (append c2 c3)) = tt }
  :=
  induction(c1:clause) return
    Forall(c2 c3:clause)(u:{ (cl_subsume c1 c2) = tt }).
      { (cl_subsume c1 (append c2 c3)) = tt }
  with
    nil _ =>
      foralli(c2 c3:clause)(u:{ (cl_subsume c1 c2) = tt }).
      hypjoin (cl_subsume c1 (append c2 c3)) tt by c1_eq end
  | cons _ l c1' =>
      foralli(c2 c3:clause)(u:{ (cl_subsume c1 c2) = tt }).
			abbrev p1 = hypjoin (cl_subsume (cons l c1') c2) tt by u c1_eq end in
      abbrev p2_1 = [cl_subsume_tt_head l c1' c2 p1] in
      abbrev p2 = [cl_has_tt_append l c2 c3 p2_1] in
      abbrev u' = [cl_subsume_tt_tail l c1' c2 p1] in
      abbrev ih = [c1_IH c1' c2 c3 u'] in
      hypjoin (cl_subsume c1 (append c2 c3)) tt by c1_eq p2 ih end
  end.

Define cl_subsume_tt_subsume_append_front :
  Forall(c1 c2 c3:clause)(u:{ (cl_subsume c1 c2) = tt }).
    { (cl_subsume c1 (append c3 c2)) = tt }
  :=
  induction(c1:clause) return
    Forall(c2 c3:clause)(u:{ (cl_subsume c1 c2) = tt }).
      { (cl_subsume c1 (append c3 c2)) = tt }
  with
    nil _ =>
      foralli(c2 c3:clause)(u:{ (cl_subsume c1 c2) = tt }).
      hypjoin (cl_subsume c1 (append c3 c2)) tt by c1_eq end
  | cons _ l c1' =>
      foralli(c2 c3:clause)(u:{ (cl_subsume c1 c2) = tt }).
			abbrev p1 = hypjoin (cl_subsume (cons l c1') c2) tt by u c1_eq end in
      abbrev p2_1 = [cl_subsume_tt_head l c1' c2 p1] in
      abbrev p2 = [cl_has_tt_append_front l c2 c3 p2_1] in
      abbrev u' = [cl_subsume_tt_tail l c1' c2 p1] in
      abbrev ih = [c1_IH c1' c2 c3 u'] in
      hypjoin (cl_subsume c1 (append c3 c2)) tt by c1_eq p2 ih end
  end.

Define cl_subsume_append :
  Forall(c1 c2 c3 c2':clause)
        (u1:{ (cl_subsume c1 (append c2 c3)) = tt})
        (u2:{(cl_subsume c2 c2') = tt})
    .{ (cl_subsume c1 (append c2' c3)) = tt }
  :=
  induction(c1:clause) return
    Forall(c2 c3 c2':clause)
          (u1:{ (cl_subsume c1 (append c2 c3)) = tt})
	  (u2:{(cl_subsume c2 c2') = tt})
    .{ (cl_subsume c1 (append c2' c3)) = tt }
  with
    nil _ =>
      foralli(c2 c3 c2':clause)(u1:{ (cl_subsume c1 (append c2 c3)) = tt})
	     (u2:{(cl_subsume c2 c2') = tt}).
      hypjoin (cl_subsume c1 (append c2' c3)) tt by c1_eq end
  | cons _ x c1' =>
      foralli(c2 c3 c2':clause)(u1:{ (cl_subsume c1 (append c2 c3)) = tt})
	     (u2:{(cl_subsume c2 c2') = tt}).
      abbrev p1 = hypjoin (cl_subsume (cons x c1') (append c2 c3)) tt by u1 c1_eq end in
      abbrev u1' = [cl_subsume_tt_tail x c1' (append lit c2 c3) p1] in
      abbrev ih = [c1_IH c1' c2 c3 c2' u1' u2] in
      abbrev p2_1 = hypjoin (cl_has c1 x) tt by c1_eq [eq_lit_refl x] end in

      abbrev p2 = [cl_subsume_implies_cl_has c1 (append lit c2 c3) u1 x p2_1] in
      case (cl_has c2 x) by q1 _ with
         ff =>
	   abbrev p3_1 = hypjoin (cl_has (append c2 c3) x) (or (cl_has c3 x) ff) by q1 [cl_has_append_or c2 c3 x] [or_comm ff (cl_has c3 x)] end in
	   abbrev p3 = symm trans symm p2
	               trans p3_1 [or_def2ff (cl_has c3 x)] in
	   abbrev p4 = [cl_has_tt_append_front x c3 c2' p3] in
	   hypjoin (cl_subsume c1 (append c2' c3)) tt by c1_eq ih p4 end
       | tt =>
	   abbrev p3 = [cl_subsume_implies_cl_has c2 c2' u2 x q1] in
	   abbrev p4 = [cl_has_tt_append x c2' c3 p3] in
	   hypjoin (cl_subsume c1 (append c2' c3)) tt by c1_eq ih p4 end
       end
  end.
  
Define cl_subsume_append_cons1 :
  Forall(c c1 c2:clause)(l:lit)(u:{ (cl_subsume c (append c1 (cons l c2))) = tt })
    .{ (cl_subsume c (append (cons l c1) c2)) = tt }
  :=
  induction(c:clause) return
    Forall(c1 c2:clause)(l:lit)(u:{ (cl_subsume c (append c1 (cons l c2))) = tt })
    .{ (cl_subsume c (append (cons l c1) c2)) = tt }
  with
    nil _ =>
      foralli(c1 c2:clause)(l:lit)(u:{ (cl_subsume c (append c1 (cons l c2))) = tt }).
      hypjoin (cl_subsume c (append (cons l c1) c2)) tt by c_eq end
  | cons _ x c' =>
      foralli(c1 c2:clause)(l:lit)(u:{ (cl_subsume c (append c1 (cons l c2))) = tt }).
      abbrev d1 = (append lit c1 (cons lit l c2)) in
			abbrev p1 = hypjoin (cl_subsume (cons x c') d1) tt by u c_eq end in
      abbrev u' = [cl_subsume_tt_tail x c' d1 p1] in
      abbrev ih = [c_IH c' c1 c2 l u'] in
      abbrev p2_1 = [cl_subsume_tt_head x c' d1 p1] in
      abbrev p2 = [cl_has_append_cons1 c1 c2 l x p2_1] in
      hypjoin (cl_subsume c (append (cons l c1) c2)) tt by c_eq ih p2 end
  end.

Define cl_subsume_append_cons2 :
  Forall(c c1 c2:clause)(l:lit)
        (u1:{ (cl_subsume c (append c1 (cons l c2))) = tt })
        (u2:{ (cl_has c1 l) = tt })
    .{ (cl_subsume c (append c1 c2)) = tt }
  :=
  induction(c:clause) return
    Forall(c1 c2:clause)(l:lit)
        	(u1:{ (cl_subsume c (append c1 (cons l c2))) = tt })
        	(u2:{ (cl_has c1 l) = tt })
    .{ (cl_subsume c (append c1 c2)) = tt }
  with
    nil _ =>
      foralli(c1 c2:clause)(l:lit)
						 (u1:{ (cl_subsume c (append c1 (cons l c2))) = tt })
						 (u2:{ (cl_has c1 l) = tt }).
      hypjoin (cl_subsume c (append c1 c2)) tt by c_eq end
  | cons _ x c' =>
      foralli(c1 c2:clause)(l:lit)
						 (u1:{ (cl_subsume c (append c1 (cons l c2))) = tt })
						 (u2:{ (cl_has c1 l) = tt }).
      abbrev d = (append lit c1 (cons lit l c2)) in
			abbrev p1 = hypjoin (cl_subsume (cons x c') d) tt by u1 c_eq end in
      abbrev u1' = [cl_subsume_tt_tail x c' d p1] in
      abbrev ih = [c_IH c' c1 c2 l u1' u2] in
			abbrev p3 = [cl_has_append_or c1 c2 x] in
			abbrev p6 =
				case (eq_lit x l) by q1 _ with
					ff =>
						abbrev p2 = hypjoin (cl_has (cons l c2) x) (cl_has c2 x) by q1 end in
						trans p3
						trans cong (or (cl_has c1 x) *) symm p2
						trans symm [cl_has_append_or c1 (cons lit l c2) x]
									[cl_subsume_tt_head x c' d p1]
				| tt =>
						hypjoin (cl_has (append c1 c2) x) tt by p3 [eq_lit_eq x l q1] u2 end
				end in
			hypjoin (cl_subsume c (append c1 c2)) tt by c_eq ih p6 end
  end.


%=============================================================================
% lemmas related to the number of variables
%=============================================================================

Define var_upper_bound := 0x80000000.

Define ltword_upper_bound_implies_msb_ff :
  Forall(w:word)(u:{ (ltword w var_upper_bound) = tt }).
    { (word_msb w) = ff }
  :=
  foralli(w:word)(u:{ (ltword w var_upper_bound) = tt }).
  % want: (leword w var_max) = tt
  % have: var_ub = (var_max+1)
  abbrev var_max = 0x7fffffff in
  abbrev var_ub_eq = join var_upper_bound (word_inc2 var_max) in
  abbrev u' = trans cong (ltword w *) symm var_ub_eq u in
  abbrev p1 = [ltword_word_inc2_implies_leword w var_max u'] in
  abbrev p2 = join (word_msb var_max) ff in
  [leword_msb_ff_implies_msb_ff w var_max p1 p2]

Define ltword_var_upper_bound_word_max :
	{ (ltword var_upper_bound word_max) = tt }
  := 
  abbrev p1_1 = [leword_word_max var_upper_bound] in
  abbrev p1 = trans symm [leword_to_le var_upper_bound word_max] p1_1 in
  abbrev p2_1 = join (eqword var_upper_bound word_max) ff in
  abbrev p2_2 = [eqword_ff_neq var_upper_bound word_max p2_1] in
  abbrev p2_3 = [word_neq_to_nat_neq var_upper_bound word_max p2_2] in
  abbrev p2 = [neqEqnat (word_to_nat var_upper_bound) (word_to_nat word_max) p2_3] in
  abbrev p3 = [or_def2ff (lt (word_to_nat var_upper_bound) (word_to_nat word_max))] in
  trans [ltword_to_lt var_upper_bound word_max]
				[eqnat_ff_implies_lt (word_to_nat var_upper_bound) (word_to_nat word_max)
					p2 p1]

Define lt_var_upper_bound_word_max :
	{ (lt (to_nat var_upper_bound) (to_nat word_max)) = tt }
  :=
  trans symm [ltword_to_lt var_upper_bound word_max]
  			ltword_var_upper_bound_word_max

Define inc_nv :=
  fun(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt }).
  (word_inc_safe nv [ltword_implies_ltword_word_max nv var_upper_bound nv_ub]).

Define inc_nv_total :=
  foralli(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt }).
  abbrev p = [ltword_implies_ltword_word_max nv var_upper_bound nv_ub] in
  existse [word_inc_safe_total nv p]
  foralli(nv':word)(nv'_pf:{ (word_inc_safe nv) = nv' }).
  existsi nv' { (inc_nv nv nv_ub) = * }
  trans join (inc_nv nv nv_ub) (word_inc_safe nv)
        nv'_pf

Total inc_nv inc_nv_total.

Define ltword_inc_nv :
  Forall(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt }).
    { (ltword nv (inc_nv nv)) = tt }
  :=
  foralli(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt }).
  abbrev nv' = (inc_nv nv nv_ub) in
  abbrev p1 = join (inc_nv nv) (word_inc_safe nv) in
  [word_inc_safe_implies_ltword nv nv' p1]

Define leword_inc_nv_var_upper_bound :
  Forall(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt }).
    { (leword (inc_nv nv) var_upper_bound) = tt }
  :=
  foralli(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt }).
  abbrev nv' = (inc_nv nv nv_ub) in
  abbrev nv_ub' = trans symm [ltword_to_lt nv var_upper_bound] nv_ub in
  abbrev p1 = join (inc_nv nv) (word_inc2 nv) in
  trans [leword_to_le nv' var_upper_bound]
  trans cong (le * (to_nat var_upper_bound)) symm [word_inc2_word_to_nat nv nv' p1]
        [lt_S_le (word_to_nat nv) (word_to_nat var_upper_bound) nv_ub']

Define le_to_nat_inc_nv_var_upper_bound :
  Forall(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt }).
    { (le (to_nat (inc_nv nv)) (to_nat var_upper_bound)) = tt }
  :=
  foralli(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt }).
  trans symm [leword_to_le (inc_nv nv nv_ub) var_upper_bound]
  			[leword_inc_nv_var_upper_bound nv nv_ub]

Define to_nat_inc_nv :
  Forall(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt }).
    { (to_nat (inc_nv nv)) = (S (to_nat nv)) }
  :=
  foralli(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt }).
  abbrev p1 = join (inc_nv nv) (word_inc2 nv) in
  symm [word_inc2_word_to_nat nv (inc_nv nv nv_ub) p1]

Define leword_nv_eq_ltword_inc_nv :
  Forall(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
        (i:word).
    { (leword i nv) = (ltword i (inc_nv nv)) }
  :=
  foralli(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
         (i:word).
  abbrev p1 = [to_nat_inc_nv nv nv_ub] in
  abbrev p2 = hypjoin (ltword i (inc_nv nv)) (lt (to_nat i) (S (to_nat nv))) by p1 end in
  trans [leword_to_le i nv]
  trans [le_eq_lt_S (word_to_nat i) (word_to_nat nv)]
        symm p2

Define leword_nv_implies_ltword_inc_nv :
  Forall(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
        (i:word)
        (u:{ (leword i nv) = tt }).
    { (ltword i (inc_nv nv)) = tt }
  :=
  foralli(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
         (i:word)
         (u:{ (leword i nv) = tt }).
  abbrev p1 = [ltword_inc_nv nv nv_ub] in
  [leltword_trans i nv (inc_nv nv nv_ub) u p1].

Define leword_nv_implies_lt_inc_nv :
  Forall(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
        (i:word)
        (u:{ (leword i nv) = tt }).
    { (lt (to_nat i) (to_nat (inc_nv nv))) = tt }
  :=
  foralli(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
         (i:word)
         (u:{ (leword i nv) = tt }).
  trans join (lt (to_nat i) (to_nat (inc_nv nv)))
             (ltword i (inc_nv nv))
        [leword_nv_implies_ltword_inc_nv nv nv_ub i u]

Define leword_nv_implies_ltword_word_max :
  Forall(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
        (i:word)
        (u:{ (leword i nv) = tt }).
    { (ltword i word_max) = tt }
  :=
  foralli(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
         (i:word)
         (u:{ (leword i nv) = tt }).
  % nv < word_max
  abbrev p1 = [ltword_implies_ltword_word_max nv var_upper_bound nv_ub] in
  [leltword_trans i nv word_max u p1]

Define ltword_inc_nv_implies_ltword_var_upper_bound :
  Forall(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
        (i:word)
        (u:{ (ltword i (inc_nv nv)) = tt }).
    { (ltword i var_upper_bound) = tt }
  :=
  foralli(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
         (i:word)
         (u:{ (ltword i (inc_nv nv)) = tt }).
  abbrev p1 = [leword_inc_nv_var_upper_bound nv nv_ub] in
  [ltleword_trans i (inc_nv nv nv_ub) var_upper_bound u p1]

Define ltword_inc_nv_implies_word_msb_ff :
  Forall(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
        (i:word)
        (u:{ (ltword i (inc_nv nv)) = tt }).
    { (word_msb i) = ff }
  :=
  foralli(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
         (i:word)
         (u:{ (ltword i (inc_nv nv)) = tt }).
  abbrev p1 = [ltword_inc_nv_implies_ltword_var_upper_bound nv nv_ub i u] in
  [ltword_upper_bound_implies_msb_ff i p1]


%=============================================================================
% lit & clause validity predicates and lemmas
%=============================================================================

Define lit_valid :=
  fun(nv:word)(^#owned l:lit).
  let v = (lit_vnum l) in
  (and (ltword word0 v) (leword v nv)).

Define cl_valid :=
  fun cl_valid(nv:word)(^#owned c:clause) : bool.
  match c with
    nil _ => tt
  | cons _ l c' =>
      match (lit_valid nv l) with
        ff => do (consume_owned clause c') ff end
      | tt => (cl_valid nv c')
      end
  end.

Define lit_valid_total :
  Forall(nv:word)(l:lit).Exists(b:bool).{ (lit_valid nv l) = b }
  :=
  foralli(nv:word)(l:lit).
  abbrev v = (lit_vnum l) in
  abbrev b = (and (ltword word0 v) (leword v nv)) in
  existsi b { (lit_valid nv l) = * }
  join (lit_valid nv l) b

Total lit_valid lit_valid_total.

Define cl_valid_total :
  Forall(nv:word)(c:clause).Exists(b:bool).{ (cl_valid nv c) = b }
  :=
  foralli(nv:word).
  induction(c:clause) return Exists(b:bool).{ (cl_valid nv c) = b }
  with
  	nil _ =>
  		existsi tt { (cl_valid nv c) = * }
  		hypjoin (cl_valid nv c) tt by c_eq end
  | cons _ l c' =>
      case (lit_valid nv l) by q1 _ with
        ff =>
					existsi ff { (cl_valid nv c) = * }
					hypjoin (cl_valid nv c) ff by c_eq q1 end
      | tt =>
      		existse [c_IH c']
      		foralli(b:bool)(b_pf:{ (cl_valid nv c') = b }).
					existsi b { (cl_valid nv c) = * }
					hypjoin (cl_valid nv c) b by c_eq q1 b_pf end
      end
  end.

Total cl_valid cl_valid_total.

Define cl_valid_implies_lit_valid_head :
  Forall(nv:word)(l:lit)(c:clause)
				(u1:{ (cl_valid nv (cons l c)) = tt }).
		{ (lit_valid nv l) = tt }
	:=
	foralli(nv:word)(l:lit)(c:clause)
				(u1:{ (cl_valid nv (cons l c)) = tt }).
	case (lit_valid nv l) by q1 _ with
	  ff =>
			abbrev p1 = hypjoin (cl_valid nv (cons l c)) ff by q1 end in
			contra trans symm p1
			       trans u1
			             clash tt ff 
			       { (lit_valid nv l) = tt }
  | tt =>
      q1
	end.

Define cl_valid_implies_lit_valid_head2 :
  Forall(nv:word)(c:clause)(l:lit)(c':clause)
				(u1:{ (cl_valid nv c) = tt })
				(u2:{ c = (cons l c') })
		.{ (lit_valid nv l) = tt }
	:=
	foralli(nv:word)(c:clause)(l:lit)(c':clause)
				(u1:{ (cl_valid nv c) = tt })
				(u2:{ c = (cons l c') })
	.
	abbrev p1 = hypjoin (cl_valid nv (cons l c')) tt by u1 u2 end in
	[cl_valid_implies_lit_valid_head nv l c' p1]

Define cl_valid_implies_cl_valid_tail :
  Forall(nv:word)(l:lit)(c:clause)
				(u1:{ (cl_valid nv (cons l c)) = tt }).
		{ (cl_valid nv c) = tt }
	:=
  foralli(nv:word)(l:lit)(c:clause)
				 (u1:{ (cl_valid nv (cons l c)) = tt }).
	case (lit_valid nv l) by q1 _ with
		ff =>
			contra
			trans symm u1
			trans hypjoin (cl_valid nv (cons l c)) ff by q1 end
						clash ff tt
			{ (cl_valid nv c) = tt }
	| tt =>
			hypjoin (cl_valid nv c) tt by u1 q1 end
	end.

Define cl_valid_implies_cl_valid_tail2 :
  Forall(nv:word)(c:clause)(l:lit)(c':clause)
				(u1:{ (cl_valid nv c) = tt })
				(u2:{ c = (cons l c') })
		.{ (cl_valid nv c') = tt }
	:=
	foralli(nv:word)(c:clause)(l:lit)(c':clause)
				(u1:{ (cl_valid nv c) = tt })
				(u2:{ c = (cons l c') })
	.
	abbrev p1 = hypjoin (cl_valid nv (cons l c')) tt by u1 u2 end in
	[cl_valid_implies_cl_valid_tail nv l c' p1]

Define cl_valid_implies_all_lit_valid :
  Forall(nv:word)(l:lit)(c:clause)
				(u1:{ (cl_valid nv c) = tt })
				(u2:{ (cl_has c l) = tt }).
		{ (lit_valid nv l) = tt }
	:=
  foralli(nv:word)(l:lit).
  induction(c:clause) return 
		Forall(u1:{ (cl_valid nv c) = tt })
				  (u2:{ (cl_has c l) = tt }).
			{ (lit_valid nv l) = tt }
	with
		nil _ =>
			foralli(u1:{ (cl_valid nv c) = tt })
						 (u2:{ (cl_has c l) = tt }).
			contra
			trans symm u2
			trans hypjoin (cl_has c l) ff by c_eq end
						clash ff tt
			{ (lit_valid nv l) = tt }
	| cons _ l' c' =>
			foralli(u1:{ (cl_valid nv c) = tt })
						 (u2:{ (cl_has c l) = tt }).
			abbrev p1 = hypjoin (cl_valid nv (cons l' c')) tt by c_eq u1 end in
			case (eq_lit l l') by q1 _ with
				ff =>
					abbrev u1' = [cl_valid_implies_cl_valid_tail nv l' c' p1] in
					abbrev u2' = hypjoin (cl_has c' l) tt by u2 q1 c_eq end in
					[c_IH c' u1' u2']
			| tt =>
					trans cong (lit_valid nv *) [eq_lit_eq l l' q1]
								[cl_valid_implies_lit_valid_head nv l' c' p1]
			end
	end.

%- not used
Define lit_valid_implies_ltword_word0 :
  Forall(nv:word)(l:lit)
				(u:{ (lit_valid nv l) = tt }).
		{ (ltword word0 (lit_vnum l)) = tt }
  :=
  foralli(nv:word)(l:lit)
         (u:{ (lit_valid nv l) = tt }).
  abbrev p1 = hypjoin (and (ltword word0 (lit_vnum l)) (leword (lit_vnum l) nv)) tt by u end in
  [andtt_e1 (ltword word0 (lit_vnum l)) (leword (lit_vnum l) nv) p1]

Define lit_valid_implies_not_word0 :
  Forall(nv:word)(l:lit)(u:{ (lit_valid nv l) = tt }).{ (lit_vnum l) != word0 }
  :=
  foralli(nv:word)(l:lit)
				 (u:{ (lit_valid nv l) = tt }).
	case (eqword (lit_vnum l) word0) by q1 _ with
		ff => [eqword_ff_neq (lit_vnum l) word0 q1]
	| tt =>
			contra
			abbrev p1 = [eqword_eq (lit_vnum l) word0 q1] in
			abbrev p2_1 = hypjoin (and (ltword word0 (lit_vnum l)) (leword (lit_vnum l) nv)) tt by u end in
			abbrev p2 = [andtt_e1 (ltword word0 (lit_vnum l)) (leword (lit_vnum l) nv) p2_1] in
			trans p1
						[ltword_implies_neq word0 (lit_vnum l) p2]
			{ (lit_vnum l) != word0 }
	end.
-%

Define lit_valid_implies_leword_nv :
  Forall(nv:word)(l:lit)
				(u:{ (lit_valid nv l) = tt }).
		{ (leword (lit_vnum l) nv) = tt }
  :=
  foralli(nv:word)(l:lit)
         (u:{ (lit_valid nv l) = tt }).
  abbrev p1 = hypjoin (and (ltword word0 (lit_vnum l)) (leword (lit_vnum l) nv)) tt by u end in
  [andtt_e2 (ltword word0 (lit_vnum l)) (leword (lit_vnum l) nv) p1]

Define lit_valid_implies_ltword_inc_nv :
  Forall(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
        (l:lit)
				(u:{ (lit_valid nv l) = tt }).
		{ (ltword (lit_vnum l) (inc_nv nv)) = tt }
  :=
  foralli(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
				 (l:lit)
         (u:{ (lit_valid nv l) = tt }).
  abbrev p1 = [lit_valid_implies_leword_nv nv l u] in
  [leword_nv_implies_ltword_inc_nv nv nv_ub (lit_vnum l) p1]

Define cl_valid_append :
  Forall(nv : word)
        (c1 c2 : clause)
        (u1 : { (cl_valid nv c1) = tt })
        (u2 : { (cl_valid nv c2) = tt }).
     { (cl_valid nv (append c1 c2)) = tt } :=
  foralli(nv : word).
  induction (c1 : clause)
  return
    Forall(c2 : clause)
          (u1 : { (cl_valid nv c1) = tt })
          (u2 : { (cl_valid nv c2) = tt }).
     { (cl_valid nv (append c1 c2)) = tt }
  with
    nil _ => 
    foralli(c2 : clause)
           (u1 : { (cl_valid nv c1) = tt })
           (u2 : { (cl_valid nv c2) = tt }).
      trans hypjoin (cl_valid nv (append c1 c2)) (cl_valid nv c2) by c1_eq end
            u2
  | cons _ l c1' => 
    foralli(c2 : clause)
           (u1 : { (cl_valid nv c1) = tt })
           (u2 : { (cl_valid nv c2) = tt }).
      case (lit_valid nv l) by lv_eq _ with
        ff => 
          contra
            transs hypjoin ff (cl_valid nv c1) by c1_eq lv_eq end
                   u1
                   clash tt ff
            end
          { (cl_valid nv (append c1 c2)) = tt }  
      | tt => 
        trans
          hypjoin (cl_valid nv (append c1 c2)) (cl_valid nv (append c1' c2)) by c1_eq lv_eq end
          [c1_IH c1' c2 hypjoin (cl_valid nv c1') tt by c1_eq u1 lv_eq end u2]
      end
  end.
  
Define cl_valid_append1 :
  Forall(nv : word)
        (c1 c2 : clause)
        (u : { (cl_valid nv (append c1 c2)) = tt }).
  { (cl_valid nv c1) = tt }
	:=
	foralli(nv:word).
	induction(c1:clause) return
		Forall(c2:clause)(u:{ (cl_valid nv (append c1 c2)) = tt }).{ (cl_valid nv c1) = tt }
	with
		nil _ =>
			foralli(c2:clause)(u:{ (cl_valid nv (append c1 c2)) = tt }).
			hypjoin (cl_valid nv c1) tt by c1_eq end
	| cons _ l c1' =>
			foralli(c2:clause)(u:{ (cl_valid nv (append c1 c2)) = tt }).
			abbrev p1 = hypjoin (append c1 c2) (cons l (append c1' c2)) by c1_eq end in
			abbrev p2 = hypjoin (cl_valid nv (cons l (append c1' c2))) tt by u p1 end in
			abbrev p3 = [cl_valid_implies_lit_valid_head nv l (append lit c1' c2) p2] in
			abbrev p4 = [cl_valid_implies_cl_valid_tail nv l (append lit c1' c2) p2] in
			abbrev ih = [c1_IH c1' c2 p4] in
			hypjoin (cl_valid nv c1) tt by p3 ih c1_eq end
	end.
