%=============================================================================
% pf.g: the main specification of formula and correctness (trusted)
% - defines boolean literals, list-based (specificational) clauses
% - defines the "pf" (proof) type, which encodes the propositional logic
% - defines the "answer" type
%=============================================================================
%=============================================================================
% literal
%=============================================================================

% lit: a word that represent a lit (MSB is used for the sign)
% if MSB is 1, just variable, otherwise negated variable
Define lit := boxedWord.

% constructors for lit
Define lit_null := (boxWord word0).
Define pos := fun(w:word)(u:{ (word_msb w) = ff }). (boxWord (word_set_msb w)).
Define neg := fun(w:word)(u:{ (word_msb w) = ff }). (boxWord w).

% operations on lit
Define eq_lit := fun(^#owned a b:lit). (eqword (unboxWord a) (unboxWord b)).
Define lit_sign := fun(^#owned l:lit). (word_msb (unboxWord l)).
Define lit_vnum := fun(^#owned l:lit). (word_clear_msb (unboxWord l)).

Define lit_vnum_word_msb_ff : Forall(l:lit). { (word_msb (lit_vnum l)) = ff } :=
  foralli(l:lit).
  abbrev p1 = join (lt (to_nat 0x1f) wordlen) tt in
  abbrev p2 = [word_clear_read (unboxWord l) word0x1f p1] in
  hypjoin (word_msb (lit_vnum l)) ff by p2 end

Define negated := fun(^#owned l:lit).
  let sign = (lit_sign (clone_owned lit l)) in
  abbrev q = [lit_vnum_word_msb_ff l] in
  match sign with
    ff => (pos (lit_vnum l) q)
  | tt => (neg (lit_vnum l) q)
  end


%=============================================================================
% list-based clause and formula
%=============================================================================

Define clause := <list lit>.
Define formula := <list clause>.

Define cl_has := fun(^#owned c:clause)(^#owned l:lit) .(member lit l c eq_lit).
Define cl_erase := fun(^#owned c:clause)(^#owned l:lit). (erase lit eq_lit l c).

Define eq_clause := (eqlist lit eq_lit).


%=============================================================================
% pf type for proofs
%=============================================================================

% subsumption: "C" subsumes "C or D"
Define cl_subsume := fun(c1:clause)(c2:clause). (list_subset lit eq_lit c1 c2).

Define is_resolvent : Fun(r:clause)(c1:clause)(c2:clause)(l:lit).bool :=
  fun(r:clause)(c1:clause)(c2:clause)(l:lit).
    (and
      (and (cl_has c1 (negated l))
           (cl_has c2 l))
      (and (cl_subsume (cl_erase c1 (negated l)) r)
           (cl_subsume (cl_erase c2 l) r))
    ).

% <pf F C> means F implies C.
Inductive pf : Fun(F:formula)(C:clause).type :=
  pf_asm : Fun(F:formula)(C:clause)
              (u:{ (member C F eq_clause) = tt })
             .<pf F C>
| pf_sub : Fun(F:formula)(C C':clause)
              (d:<pf F C'>)
              (u:{ (cl_subsume C' C) = tt })
             .<pf F C>
| pf_res : Fun(F:formula)(C C1 C2: clause)(l:lit)
              (d1:<pf F C1>)
              (d2:<pf F C2>)
              (u:{ (is_resolvent C C1 C2 l) = tt })
             .<pf F C>
| pf_hyp : Fun(F:formula)(l:lit)(C:clause)
							(d:<pf (cons clause (cons lit l (nil lit)) F) C>)
						 .<pf F (cons lit (negated l) C)>


%=============================================================================
% answer type
%=============================================================================

Inductive answer : Fun(F:formula).type :=
  sat : Fun(spec F:formula).<answer F>
| unsat : Fun(spec F:formula)(spec p:<pf F (nil lit)>).<answer F>
