%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% flags for compilation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Include trusted "lib_includes.g".

% I am including all the library files up front, so that we can count non-library proofs accurately.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%Set "count_proofs".

% Guru will count the number of proofs seen (whether checked or not) while this flag is set.
% (Duckki) Now, this flag is part of "lib_includes.g".

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%Set "ignore_trusted_flag_for_includes".

% Set the above flag to ignore the trusted flag for all includes.  This will
% have the effect of checking all lemmas except those explicitly marked as
% trusted.
% (Duckki) Turned off for compilation. Compiling needs fast feedback for
% resource typing. Instead, use "check.g" for whole-project type checking.
% To check library files, use "force-check-lib.g".

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Set "trust_hypjoins".	% for faster compilation

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%=============================================================================
% Compilation directive
%=============================================================================

% uncomment to see a bunch of debugging
% information about the compilation:
%
%Set "debug_to_carraway".
%Set "debug_stages".
%Set "debug_simulate".
%Set "debug_refs".
%Set "debug_eta_expand".
%Set "debug_def_eq".
%Set "debug_classify_apps".
