Include trusted "cnf-lemma2.g".
Include trusted "assignment.g".

%=============================================================================
% internal helpers for scores
%=============================================================================

%Set "trust_hypjoins".

Define _ds_inc_lit := fun
  (spec nv:word)
  (nv_ub:{ (ltword nv var_upper_bound) = tt })
  (#unique scores:<uwarray word (inc_nv nv nv_ub)>)
  (l:ulit)
  (r:{ (leword (ulit_vnum l) nv) = tt })
  :#unique <uwarray word (inc_nv nv nv_ub)>.
  abbrev nv' = (inc_nv nv nv_ub) in
  let v = (ulit_vnum l) in
  abbrev p1 = hypjoin (leword v nv) tt by r v_eq end in
  abbrev p2 = [leword_nv_implies_ltword_inc_nv nv nv_ub v p1] in
  let scores' = (inspect_unique <uwarray word nv'> scores) in
  let s = (uwarray_get word nv' scores' v p2) in
  let s' = (word_inc_wrap s) in
  do
  (consume_unique_owned <uwarray word nv'> scores')
  (uwarray_set word nv' scores v s' p2)
  end.


%=============================================================================
% Helpers for Heap
%=============================================================================

Define _heap_less := fun
  (spec nv:word)
  (nv_ub:{ (ltword nv var_upper_bound) = tt })
  (!#unique_owned scores:<uwarray word (inc_nv nv nv_ub)>)
  (x y:word)
  (xb:{ (leword x nv) = tt })
  (yb:{ (leword y nv) = tt })
  .
  abbrev nv' = (inc_nv nv nv_ub) in
  abbrev px = [leword_nv_implies_ltword_inc_nv nv nv_ub x xb] in
  abbrev py = [leword_nv_implies_ltword_inc_nv nv nv_ub y yb] in
  let xs = (uwarray_get word nv' scores x px) in
  let ys = (uwarray_get word nv' scores y py) in
  % the higher score, the less in heap
  (ltword ys xs)
  .

Define _heap_less_tot
 : Forall(nv:word)
         (nv_ub:{ (ltword nv var_upper_bound) = tt })
         (scores:<uwarray word (inc_nv nv nv_ub)>)
         (x y:word)
         (xb:{ (leword x nv) = tt })
         (yb:{ (leword y nv) = tt }).
    Exists(z:bool). 
      { (_heap_less nv_ub scores x y) = z } :=
  foralli(nv:word)
         (nv_ub:{ (ltword nv var_upper_bound) = tt })
         (scores:<uwarray word (inc_nv nv nv_ub)>)
         (x y:word)
         (xb:{ (leword x nv) = tt })
         (yb:{ (leword y nv) = tt }).
    existsi (ltword (uwarray_get word (inc_nv nv nv_ub) scores y [leword_nv_implies_ltword_inc_nv nv nv_ub y yb])
                    (uwarray_get word (inc_nv nv nv_ub) scores x [leword_nv_implies_ltword_inc_nv nv nv_ub x xb]))
      { (_heap_less nv_ub scores x y) = * }
      join (_heap_less nv_ub scores x y) (ltword (uwarray_get scores y) (uwarray_get scores x)).

Total _heap_less _heap_less_tot.

Define _heap_less' := fun
  (spec nv:word)
  (nv_ub:{ (ltword nv var_upper_bound) = tt })
  (!#unique_owned scores:<uwarray word (inc_nv nv nv_ub)>)
  (x y:word)
  (xb:{ (ltword x (inc_nv nv nv_ub)) = tt })
  (yb:{ (ltword y (inc_nv nv nv_ub)) = tt })
  .
  abbrev nv' = (inc_nv nv nv_ub) in
  let xs = (uwarray_get word nv' scores x xb) in
  let ys = (uwarray_get word nv' scores y yb) in
  % the higher score, the less in heap
  (ltword ys xs)
  .

Define _heap_parent := fun
  (i:word)
  (u:{ (ltword word0 i) = tt })
  .(word_shift word1 (word_dec_safe i u)).
  
Define _heap_parent_lem1 : Forall
  (i:word)
  (u:{ (ltword word0 i) = tt })
  .{ (ltword (_heap_parent i) i) = tt }
  :=
  foralli(i: word)(u:{ (ltword word0 i) = tt }).
  % { (le (to_nat (bv_shift one (word_dec_safe i u))) (to_nat (word_dec_safe i u)) = tt }
  cabbrev p1 = 
    [bv_shift_le 
      one
      wordlen_pred
      (word_dec_safe i u)
    ]
  in
  % { (ltword (word_dec_safe i u)) i) = tt }
  cabbrev p2 =
    trans
      join
        (lt (to_nat (word_dec_safe i u)) (to_nat i))
        (ltword (word_dec_safe i u) i)
      
      [leword_and_word_dec_safe_implies_ltword
        i
        (word_dec_safe i u)
        i
        [leword_refl i]
        refl (word_dec_safe i) 
      ]
  in
  % { (ltword (bv_shift one (word_dec_safe i)) i) = tt }
  cabbrev p3 =
    trans
      join
        (ltword (bv_shift one (word_dec_safe i)) i)
        (lt (to_nat (bv_shift one (word_dec_safe i))) (to_nat i))
      

      [lelt_trans
        (to_nat wordlen (bv_shift one wordlen_pred (word_dec_safe i u)))
        (to_nat wordlen (word_dec_safe i u))
        (to_nat wordlen i)
        p1
        p2
      ]
  in
  trans
    cong (ltword * i)
          join (_heap_parent i) (bv_shift one (word_dec_safe i))
    p3
  .

Define _heap_left := fun
  (i:word)
  .(word_inc_wrap (word_mult i word2)).

Define _heap_right := fun
  (i:word)
  .(word_mult (word_inc_wrap i) word2).

Define _heap_in := fun
  (spec n:word)
  (!#unique indices:<uwarray word n>)
  (v:word)
  (r:{ (ltword v n) = tt })
  : bool.
  let indices_i = (inspect_unique <uwarray word n> indices) in
  let pos = (uwarray_get word n indices_i v r) in
  do
  (consume_unique_owned <uwarray word n> indices_i)
  (not (eqword word_max pos))
  end.


%=============================================================================
% Heap
%=============================================================================

Inductive Heap : Fun(n:word).type :=
  heap_state : Fun(spec n:word) % max size
                  (sz:word)   % current size
                  (#unique heap:<uwarray word n>) % heap of vars (word0 is invalid)
                  (#unique indices:<uwarray word n>) % var -> position in heap (word_max is invalid)
                  (u:{ (leword sz n) = tt })
		% u2: all vars are less than n, which is supposed to be (inc_nv nv)
		%(u2:Forall(i:nat)(r:{ (lt i (to_nat sz)) = tt }).{ (ltword (vec_get heap i) n) = tt }
                .#unique <Heap n>
.

Define heap_new := fun
  (n:word)
  :#unique <Heap n>.
  let heap = (uwarray_new word n word0) in
  let indices = (uwarray_new word n word_max) in
  abbrev p = [leword_word0 n] in
  (heap_state n word0 heap indices p).
  
Define _heap_percolate_up := fun _heap_percolate_up
  (nv:word)
  (nv_ub:{ (ltword nv var_upper_bound) = tt })
  (!#unique_owned scores:<uwarray word (inc_nv nv nv_ub)>)
  (#unique hs:<Heap (inc_nv nv nv_ub)>)
  (pos:word)
  (v:word)
  (u:{ (ltword pos (inc_nv nv nv_ub)) = tt })
  (r:{ (leword v nv) = tt })
  :#unique <Heap (inc_nv nv nv_ub)>.
  abbrev nv' = (inc_nv nv nv_ub) in
  abbrev r' = [leword_nv_implies_ltword_inc_nv nv nv_ub v r] in
  match hs with heap_state _ sz heap indices sz_ub =>
  match (ltword word0 pos) by q1 _ with
    ff => % pos == word0
      let heap' = (uwarray_set word nv' heap pos v u) in
      let indices' = (uwarray_set word nv' indices v pos r') in
      (heap_state nv' sz heap' indices' sz_ub)
  | tt =>
      let parent_pos = (_heap_parent pos q1) in
      abbrev p1_1 = [_heap_parent_lem1 pos q1] in
      abbrev p1_2 = trans cong (ltword * pos) parent_pos_eq
                          p1_1 in
      abbrev p1 = [ltword_trans parent_pos pos nv' p1_2 u] in
      let heap_i = (inspect_unique <uwarray word nv'> heap) in
      let parent_v = (uwarray_get word nv' heap_i parent_pos p1) in
      match (leword parent_v nv) by q2 _ with ff => abort <Heap nv'> | tt =>
      match (_heap_less nv nv_ub scores v parent_v r q2) with
        ff =>
          do
          (consume_unique_owned <uwarray word nv'> heap_i)
          let heap' = (uwarray_set word nv' heap pos v u) in
          let indices' = (uwarray_set word nv' indices v pos r') in
          (heap_state nv' sz heap' indices' sz_ub)
          end
      | tt => 
          do
          (consume_unique_owned <uwarray word nv'> heap_i)
          abbrev q2' = [leword_nv_implies_ltword_inc_nv nv nv_ub parent_v q2] in
          let heap' = (uwarray_set ulit nv' heap pos parent_v u) in
          let indices' = (uwarray_set word nv' indices parent_v pos q2') in
          let hs' = (heap_state nv' sz heap' indices' sz_ub) in
          (_heap_percolate_up nv nv_ub scores hs' parent_pos v p1 r)
          end
      end
      end
  end
  end.

Define _heap_pick_child := fun
  (nv:word)
  (nv_ub:{ (ltword nv var_upper_bound) = tt })
  (!#unique_owned scores:<uwarray word (inc_nv nv nv_ub)>)
  (sz:word)
  (!#unique_owned heap:<uwarray word (inc_nv nv nv_ub)>)
  (sz_ub:{ (leword sz (inc_nv nv nv_ub)) = tt })
  (l_pos:word)
  (l_ub:{ (ltword l_pos (inc_nv nv nv_ub)) = tt })
  .
  abbrev nv' = (inc_nv nv nv_ub) in
  abbrev p1 = [ltword_implies_ltword_word_max l_pos nv' l_ub] in
  let r_pos = (word_inc_safe l_pos p1) in
  match (ltword r_pos sz) by q1 _ with
    ff => % no right child
      l_pos
  | tt => % there is a right child
      abbrev r_ub = [ltleword_trans r_pos sz nv' q1 sz_ub] in
      let l_val = (uwarray_get word nv' heap l_pos l_ub) in
      let r_val = (uwarray_get word nv' heap r_pos r_ub) in
      match (leword l_val nv) by ql _ with ff => abort word | tt =>
      match (leword r_val nv) by qr _ with ff => abort word | tt =>
      match (_heap_less nv nv_ub scores l_val r_val ql qr) with
        ff => r_pos
      | tt => l_pos
      end
      end end
  end.
  
Define _heap_pick_child_lem1 : Forall
  (nv:word)
  (nv_ub:{ (ltword nv var_upper_bound) = tt })
  (scores:<uwarray word (inc_nv nv nv_ub)>)
  (sz:word)
  (heap:<uwarray word (inc_nv nv nv_ub)>)
  (sz_ub:{ (leword sz (inc_nv nv nv_ub)) = tt })
  (l_pos:word)
  (l_ub:{ (ltword l_pos (inc_nv nv nv_ub)) = tt })
  (p:word) % the child position picked
  (p_eq:{ p = (_heap_pick_child nv scores sz heap l_pos) })
  .{ (ltword p (inc_nv nv)) = tt } :=
 foralli(nv:word)
        (nv_ub:{ (ltword nv var_upper_bound) = tt })
        (scores:<uwarray word (inc_nv nv nv_ub)>)
        (sz:word)
        (heap:<uwarray word (inc_nv nv nv_ub)>)
        (sz_ub:{ (leword sz (inc_nv nv nv_ub)) = tt })
        (l_pos:word)
        (l_ub:{ (ltword l_pos (inc_nv nv nv_ub)) = tt })
        (p:word) 
        (p_eq:{ p = (_heap_pick_child nv scores sz heap l_pos) }).
  abbrev nv' = (inc_nv nv nv_ub) in
  abbrev p1 = [ltword_implies_ltword_word_max l_pos nv' l_ub] in
  cabbrev r_pos = (word_inc_safe l_pos p1) in
    case (ltword r_pos sz) by q1 _ with
      ff => 
        trans cong (ltword * (inc_nv nv))
                trans p_eq
                  hypjoin (_heap_pick_child nv scores sz heap l_pos) l_pos by q1 end 
          l_ub
    | tt => 
      cabbrev r_ub = [ltleword_trans r_pos sz nv' q1 sz_ub] in
      cabbrev l_val = (uwarray_get word nv' heap l_pos l_ub) in
      cabbrev r_val = (uwarray_get word nv' heap r_pos r_ub) in
      

      % need to know (leword l_val nv) = tt and (leword r_val nv) = tt,
      % or else _heap_pick_child aborts.
        
        case (leword l_val nv) by ql _ with
          ff =>
          contra
            transs 
              p_eq
              hypjoin (_heap_pick_child nv scores sz heap l_pos) abort ! 
                by q1 ql end
              aclash p
            end
          { (ltword p (inc_nv nv)) = tt } 
        | tt => 
          case (leword r_val nv) by qr _ with
            ff =>
            contra
              transs 
                p_eq
                hypjoin (_heap_pick_child nv scores sz heap l_pos) abort ! 
                  by q1 ql qr end
                aclash p
              end
            { (ltword p (inc_nv nv)) = tt } 
          | tt => 
            case (_heap_less nv nv_ub scores l_val r_val ql qr) by qh _ with
              ff => 
                 trans
                    cong (ltword * (inc_nv nv))
                       trans p_eq
                         hypjoin (_heap_pick_child nv scores sz heap l_pos) r_pos
                           by q1 ql qr qh end
                    [ltleword_trans r_pos sz (inc_nv nv nv_ub) q1 sz_ub]
            | tt => 
              trans cong (ltword * (inc_nv nv))
                      trans p_eq 
                      hypjoin (_heap_pick_child nv scores sz heap l_pos) l_pos by q1 ql qr qh end 
                l_ub
            end
          end
        end
    end.

Define _heap_percolate_down := fun _heap_percolate_down
  (nv:word)
  (nv_ub:{ (ltword nv var_upper_bound) = tt })
  (!#unique_owned scores:<uwarray word (inc_nv nv nv_ub)>)
  (#unique hs:<Heap (inc_nv nv nv_ub)>)
  (pos:word) % position just removed
  (v:word)   % the original value at pos
  (u:{ (ltword pos (inc_nv nv nv_ub)) = tt })
  (r:{ (ltword v (inc_nv nv nv_ub)) = tt })
  :#unique <Heap (inc_nv nv nv_ub)>.
  abbrev nv' = (inc_nv nv nv_ub) in
  match hs with heap_state _ sz heap indices sz_ub =>
  let l_pos = (_heap_left pos) in
  match (ltword l_pos sz) by q1 _ with
    ff => % pos is at the bottom
      let heap' = (uwarray_set word nv' heap pos v u) in
      let indices' = (uwarray_set word nv' indices v pos r) in
      (heap_state nv' sz heap' indices' sz_ub)
  | tt =>
      abbrev q1' = [ltleword_trans l_pos sz nv' q1 sz_ub] in
      let heap_i = (inspect_unique <uwarray word nv'> heap) in
      let new_pos = (_heap_pick_child nv nv_ub scores sz heap_i sz_ub l_pos q1') in
      abbrev new_pos_ub_1 = [_heap_pick_child_lem1 nv nv_ub scores sz heap_i sz_ub l_pos q1' new_pos new_pos_eq] in
      abbrev new_pos_ub = hypjoin (ltword new_pos nv') tt by new_pos_ub_1 heap_i_eq end in
      let new_v = (uwarray_get word nv' heap_i new_pos new_pos_ub) in
      match (leword new_v nv) by q2 _ with ff => abort <Heap nv'> | tt =>
      abbrev q2 = [leword_nv_implies_ltword_inc_nv nv nv_ub new_v q2] in
      do
      (consume_unique_owned <uwarray word nv'> heap_i)
      match (_heap_less' nv nv_ub scores new_v v q2 r) with
        ff =>
          let heap' = (uwarray_set word nv' heap pos v u) in
          let indices' = (uwarray_set word nv' indices v pos r) in
          (heap_state nv' sz heap' indices' sz_ub)
      | tt => 
          let heap' = (uwarray_set ulit nv' heap pos new_v u) in
          let indices' = (uwarray_set word nv' indices new_v pos q2) in
          let hs' = (heap_state nv' sz heap' indices' sz_ub) in
          (_heap_percolate_down nv nv_ub scores hs' new_pos v new_pos_ub r)
      end
      end % do
      end
  end
  end.

Define heap_empty := fun
  (spec nv:word)
  (nv_ub:{ (ltword nv var_upper_bound) = tt })
  (#unique hs:<Heap (inc_nv nv nv_ub)>).
  match hs with heap_state _ sz heap indices sz_ub =>
  (not (ltword word0 sz))
  end.

Define heap_insert := fun
  (nv:word)
  (nv_ub:{ (ltword nv var_upper_bound) = tt })
  (!#unique_owned scores:<uwarray word (inc_nv nv nv_ub)>)
  (#unique hs:<Heap (inc_nv nv nv_ub)>)
  (v:word)
  (r:{ (leword v nv) = tt })
  :#unique <Heap (inc_nv nv nv_ub)>.
  abbrev nv' = (inc_nv nv nv_ub) in
  match hs with heap_state _ sz heap indices sz_ub =>
  abbrev r' = [leword_nv_implies_ltword_inc_nv nv nv_ub v r] in
  match (_heap_in nv' indices v r') with
    ff =>
      match (leword sz nv) by q1 _ with
        ff => % full
          abort <Heap nv'>
      | tt =>
        abbrev p1 = [leword_nv_implies_ltword_inc_nv nv nv_ub sz q1] in
        abbrev p2 = [ltword_implies_ltword_word_max sz nv' p1] in
        let sz' = (word_inc_safe sz p2) in
        abbrev sz'_ub = [ltword_and_word_inc_safe_implies_leword sz sz' nv' p1 sz'_eq] in
        let hs' = (heap_state nv' sz' heap indices sz'_ub) in
        (_heap_percolate_up nv nv_ub scores hs' sz v p1 r)
      end
  | tt =>
      (heap_state nv' sz heap indices sz_ub)
  end
  end.

Inductive heap_remove_min_t : Fun(n:word).type :=
  heap_remove_min_empty : Fun(spec n:word)
                     (#unique hs:<Heap n>)
                     .#unique <heap_remove_min_t n>
| heap_remove_min_return : Fun(spec n:word)
                     (#unique hs:<Heap n>)
                     (v:word)
                     (v_ub:{ (ltword v n) = tt })
                     .#unique <heap_remove_min_t n>
.

Define heap_remove_min := fun
  (nv:word)
  (nv_ub:{ (ltword nv var_upper_bound) = tt })
  (!#unique_owned scores:<uwarray word (inc_nv nv nv_ub)>)
  (#unique hs:<Heap (inc_nv nv nv_ub)>)
  :#unique <heap_remove_min_t (inc_nv nv nv_ub)>.
  match hs with heap_state _ sz heap indices sz_ub =>
  abbrev nv' = (inc_nv nv nv_ub) in
  abbrev p3_1 = [ltword_inc_nv nv nv_ub] in
  abbrev p3 = [ltword_implies_ltword_word0 nv' nv p3_1] in
  match (ltword word0 sz) by q1 _ with
    ff => % empty
      let hs' = (heap_state nv' sz heap indices sz_ub) in
      (heap_remove_min_empty nv' hs')
  | tt =>
    let heap_i = (inspect_unique <uwarray word nv'> heap) in
    let v = (uwarray_get word nv' heap_i word0 p3) in
    let sz' = (word_dec_safe sz q1) in
    abbrev p2 = [leword_and_word_dec_safe_implies_ltword sz sz' nv' sz_ub sz'_eq] in
    abbrev sz'_ub = [leword_and_word_dec_safe_implies_leword sz sz' nv' sz_ub sz'_eq] in
    let last_v = (uwarray_get word nv' heap_i sz' p2) in
    match (ltword v nv') by q3 _ with ff => abort <heap_remove_min_t nv'> | tt =>
    match (ltword last_v nv') by q2 _ with ff => abort <heap_remove_min_t nv'> | tt =>
    do
    (consume_unique_owned <uwarray word nv'> heap_i)
    let indices' = (uwarray_set word nv' indices v word_max q3) in
    let hs' = (heap_state nv' sz' heap indices' sz'_ub) in
    abbrev p1 = [ltleword_trans word0 sz nv' q1 sz_ub] in
    let hs'' = (_heap_percolate_down nv nv_ub scores hs' word0 last_v p1 q2) in
    match (leword v nv) by q3 _ with ff => abort <heap_remove_min_t nv'> | tt =>
    abbrev q3' = [leword_nv_implies_ltword_inc_nv nv nv_ub v q3] in
    (heap_remove_min_return nv' hs'' v q3')
    end % match (leword v nv)
    end % do
    end end
    end
  end.

Define heap_update := fun
  (nv:word)
  (nv_ub:{ (ltword nv var_upper_bound) = tt })
  (!#unique_owned scores:<uwarray word (inc_nv nv nv_ub)>)
  (#unique hs:<Heap (inc_nv nv nv_ub)>)
  (v:word) % v may not be in heap
  (r:{ (leword v nv) = tt })
  :#unique <Heap (inc_nv nv nv_ub)>.
  abbrev nv' = (inc_nv nv nv_ub) in
  let hs_i = (inspect_unique <Heap nv'> hs) in
  match hs_i with heap_state _ sz _ indices sz_ub =>
  abbrev r' = [leword_nv_implies_ltword_inc_nv nv nv_ub v r] in
  let pos = (uwarray_get word nv' indices v r') in
  do
  (consume_unique_owned <uwarray word nv'> indices)
  (consume_unique_owned <Heap nv'> hs_i)
  match (eqword pos word_max) with
    ff =>
      match (ltword pos nv') by q1 _ with ff => abort <Heap nv'> | tt =>
      (_heap_percolate_up nv nv_ub scores hs pos v q1 r)
      end
  | tt =>
      hs
  end
  end % do
  end.


%=============================================================================
% DecisionState
%=============================================================================

Inductive DecisionState : Fun(nv:word).type :=
  decision_state : Fun(spec nv:word)
                   (nv_ub:{ (ltword nv var_upper_bound) = tt })
                   (#unique scores:<uwarray word (inc_nv nv nv_ub)>)
                   (#unique hs:<Heap (inc_nv nv nv_ub)>)
                   (n_confl:word)
                  .#unique <DecisionState nv>
.

Define newDecisionState :=
  fun(nv:word)
     (nv_ub:{ (ltword nv var_upper_bound) = tt })
  : #unique <DecisionState nv>.
  abbrev nv' = (inc_nv nv nv_ub) in
	cabbrev scores = (uwarray_new word nv' word0)
	cabbrev hs = (heap_new nv')
  (decision_state nv nv_ub scores hs word0)
  

%=============================================================================
% insertVarOrder
%=============================================================================

Define insertVarOrder := fun
  (nv:word)
  (#unique ds:<DecisionState nv>)
  (v:word)
  (r:{ (leword v nv) = tt })
  :#unique <DecisionState nv>.
  match ds with decision_state _ nv_ub scores hs nc =>
  abbrev nv' = (inc_nv nv nv_ub) in
  let scores_i = (inspect_unique <uwarray word nv'> scores) in
  let hs' = (heap_insert nv nv_ub scores_i hs v r) in
  do
  (consume_unique_owned <uwarray word nv'> scores_i)
  (decision_state nv nv_ub scores hs' nc)
  end
  end.


%=============================================================================
% decideLit
%=============================================================================

Inductive pickVar_return_t : Fun(nv:word)(pa:<uwarray assignment nv>).type :=
   pickVar_empty : Fun(spec nv:word)
                      (spec pa:<uwarray assignment nv>)
                      (#unique hs:<Heap nv>)
                     .#unique <pickVar_return_t nv pa>
| pickVar_return : Fun(spec nv:word)
                      (#unique hs:<Heap nv>)
                      (v:word)
                      (v_ub:{ (ltword v nv) = tt })
                      (spec pa:<uwarray assignment nv>)
                      (u:{ (is_assigned (uwarray_get pa v)) = ff })
                      .#unique <pickVar_return_t nv pa>
.

%Unset "trust_hypjoins".

Define _pickVar_h := fun _pickVar_h
  (nv:word)
  (nv_ub:{ (ltword nv var_upper_bound) = tt })
  (^#unique_owned pa:<uwarray assignment (inc_nv nv nv_ub)>)
  (^#unique_owned scores:<uwarray word (inc_nv nv nv_ub)>)
  (#unique hs:<Heap (inc_nv nv nv_ub)>)
    :#unique <pickVar_return_t (inc_nv nv nv_ub) pa>
  .
  abbrev nv' = (inc_nv nv nv_ub) in
  match (heap_remove_min nv nv_ub scores hs) with
    heap_remove_min_empty _ hs' =>
      (pickVar_empty nv' pa hs')
  | heap_remove_min_return _ hs' v v_ub =>
      let val = (uwarray_get assignment nv' pa v v_ub) in
      match (is_assigned val) by uu _ with
        ff =>
          (pickVar_return nv' hs' v v_ub pa 
             trans cong (is_assigned *) symm val_eq 
                   uu)
      | tt =>
          (_pickVar_h nv nv_ub pa scores hs')
      end
  end.

Inductive decideLit_t : Fun(nv:word)(F:formula)(as:<AssignState nv F>).type :=
  decide_nothing : Fun(spec nv:word)
                      (spec F:formula)
                      (spec as:<AssignState nv F>)
                      (#unique ds:<DecisionState nv>)
                     .#unique <decideLit_t nv F as>
| decide_something : Fun(spec nv:word)
                        (spec F:formula)
                        (spec as:<AssignState nv F>)
                        (#unique ds:<DecisionState nv>)
                        (l:ulit)
                        (u : { (unassigned as (ulit_vnum l)) = tt })
                       .#unique <decideLit_t nv F as>
.

Define decideLit :=
  fun(nv:word)(spec F:formula)
     (!#unique as:<AssignState nv F>)
     (#unique ds:<DecisionState nv>)
  :#unique <decideLit_t nv F as>.
  let asi = (inspect_unique <AssignState nv F> as) in
  let rval =
		match asi by asi_eq2 _ with assign_state _ _ nv_ub pa _ _ _ _ _ %-_ _-% =>
    match ds with decision_state _ nv_ub scores hs nc =>
    abbrev nv' = (inc_nv nv nv_ub) in
    let scores_i = (inspect_unique <uwarray word nv'> scores) in
    match (_pickVar_h nv nv_ub pa scores_i hs) with
      pickVar_empty _ _ hs' =>
        let ds' = (decision_state nv nv_ub scores hs' nc) in
        (decide_nothing nv F as ds')
    | pickVar_return _ hs' v v_ub _ get_v_assigned_ff =>
        let ds' = (decision_state nv nv_ub scores hs' nc) in
        let l = (word_set_msb v) in
        (decide_something nv F as ds' l
           transs cong (unassigned as (ulit_vnum *)) l_eq 
                cong (unassigned as *) 
                  transs 
                    join (ulit_vnum (word_set_msb v)) (word_clear_msb (word_set_msb v))
                    [word_set_clear_msb v] 
                    [word_msb_ff_clear_msb v [ltword_inc_nv_implies_word_msb_ff nv nv_ub v v_ub]]
                  end
                abbrev a = (uwarray_get assignment (inc_nv nv nv_ub) pa v v_ub) in
                case a with
                  default =>
                    contra
                      transs symm get_v_assigned_ff
                             hypjoin (is_assigned a) tt by a_eq end
                             clash tt ff
                      end
                    { (unassigned as v) = tt }
                | UN => 
                    hypjoin (unassigned as v) tt by asi_eq asi_eq2 get_v_assigned_ff a_eq end
                end
           end
        )
    end
		end end in
	do
	  (consume_unique_owned <AssignState nv F> asi)
		rval
	end.

%=============================================================================
% bumpActivity
% increase scores of the lits in the clause
% adjust ranks
%=============================================================================

Define _ds_inc_la_h := fun _ds_inc_la_h
  (nv:word)
  (#unique ds:<DecisionState nv>)
  (spec n:word)
  (!#unique_owned la:<uwarray ulit n>)
  (i:word)
  (u:{ (array_in_bounds nv (vec_nth_tail la (to_nat i))) = tt })
  :#unique <DecisionState nv>.
  % need: (ltword i n) = tt
  cabbrev p1 = [nth_tail_in_bounds_implies_ltword nv n la i u]
  let x = (uwarray_get ulit n la i p1) in
  match (eq_ulit x ulit_null) by q1 Q1 with
    ff => % do more
      match ds with decision_state _ nv_ub scores hs nc =>
      abbrev nv' = (inc_nv nv nv_ub) in
      abbrev p4_1 = [nth_tail_in_bounds_leword_nth nv (word_to_nat n) la (word_to_nat i) u] in
      abbrev p4 = hypjoin (leword (ulit_vnum x) nv) tt by p4_1 x_eq end in
      let scores' = (_ds_inc_lit nv nv_ub scores x p4) in
      let scores'_i = (inspect_unique <uwarray word nv'> scores') in
      let hs' = (heap_update nv nv_ub scores'_i hs (ulit_vnum x) p4) in
      do
      (consume_unique_owned <uwarray word nv'> scores'_i)
      let ds' = (decision_state nv nv_ub scores' hs' nc) in
      
      abbrev p2 = [ltword_implies_ltword_word_max i n p1] in
      let i' = (word_inc_safe i p2) in
      abbrev p3 = [nth_tail_in_bounds_the_rest nv n la i i' x u i'_eq x_eq q1] in
      (_ds_inc_la_h nv ds' n la i' p3)
      end % do
      end % match ds
  | tt => % done
      ds
  end.

Define _ds_inc_la := fun
	(nv:word)
  (#unique ds:<DecisionState nv>)
  (spec n:word)
  (!#unique_owned la:<uwarray ulit n>)
  (u:{ (array_in_bounds nv la) = tt })
  .
  abbrev u' = hypjoin (array_in_bounds nv (vec_nth_tail la (to_nat word0))) tt by u end in
  (_ds_inc_la_h nv ds n la word0 u')
  .

Define bumpActivity := fun
	(nv:word)(spec F:formula)
  (#unique ds:<DecisionState nv>)
  (!#owned ac:<aclause nv F>)
  :#unique <DecisionState nv>.
  match !ac with mk_aclause n la _ _ u _ _ _ =>
  abbrev u' = hypjoin (array_in_bounds nv (vec_nth_tail la (to_nat word0))) tt by u end in
  (_ds_inc_la_h nv ds n la word0 u')
  end % match ac
  .


%=============================================================================
% decayActivity
%=============================================================================

Define _decay_h := fun _decay_h
  (nv:word)
  (nv_ub:{ (ltword nv var_upper_bound) = tt })
  (#unique scores:<uwarray word (inc_nv nv nv_ub)>)
  (i:word)
  :#unique <uwarray word (inc_nv nv nv_ub)>.
  abbrev nv' = (inc_nv nv nv_ub) in
  match (leword i nv) by q1 _ with
    ff => scores
  | tt =>
      abbrev p1 = [leword_nv_implies_ltword_inc_nv nv nv_ub i q1] in
      let scores_i = (inspect_unique <uwarray word nv'> scores) in
      let old_s = (uwarray_get word nv' scores_i i p1) in
      let new_s = (word_shift word1 old_s) in
      do
      (consume_unique_owned <uwarray word nv'> scores_i)
      let scores' = (uwarray_set word nv' scores i new_s p1) in
      
      abbrev p2 = [ltword_implies_ltword_word_max i nv' p1] in
      let i' = (word_inc_safe i p2) in
      (_decay_h nv nv_ub scores' i')
      end
  end.

Define decayActivity := fun
	(nv:word)
  (#unique ds:<DecisionState nv>)
  :#unique <DecisionState nv>.
  match ds with decision_state _ nv_ub scores hs nc =>
  match (ltword nc 0x7f) with
    ff => % reached half-life
      let scores' = (_decay_h nv nv_ub scores word1) in
      (decision_state nv nv_ub scores' hs word0)
  | tt =>
      let nc' = (word_inc_wrap nc) in
      (decision_state nv nv_ub scores hs nc')
  end
  end.
