%=============================================================================
% cnf-util.g : constructing array-based clause and lemmas about it
%=============================================================================
Include trusted "pf_util.g".
Include trusted "pf_util2.g".
Include trusted "cnf.g".
Include trusted "cnf-lemma.g".

%Set "trust_hypjoins".                                

%=============================================================================
% clause_to_uwarray
%
% spec function for turning a clause into a vector of ulits.
%=============================================================================

Define spec clause_to_uwarray : Fun( L : clause ). <vec ulit (length lit L)> :=
fun clause_to_uwarray( L : clause ) : <vec ulit (length lit L)>.
  match L with
    nil _ => cast (vecn ulit) by
                cong <vec ulit *>
                  symm trans cong (length lit *) L_eq
                  join (length nil) Z

  | cons _ a L' => 
    match a with
      mk_uholder _ w => 
         cast (vecc ulit (length lit L') w (clause_to_uwarray L')) by
           cong <vec ulit *>
                symm trans cong (length *) L_eq
                           join (length (cons a L')) (S (length L'))
      end
  end.

Define clause_to_uwarray_tot : 
  Forall(L:clause).Exists(u:<vec ulit (length lit L)>). { (clause_to_uwarray L) = u } :=
  induction(L:clause)
  return Exists(u:<vec ulit (length lit L)>). { (clause_to_uwarray L) = u } with
    nil _ => 
      existsi terminates (clause_to_uwarray L) by hypjoin (clause_to_uwarray L) vecn by L_eq end
        { (clause_to_uwarray L) = * } join (clause_to_uwarray L) (clause_to_uwarray L) 
  | cons _ a L' => 
      case a with
         mk_uholder _ w =>
           existsi cast (vecc ulit (length lit L') w 
                           terminates (clause_to_uwarray L') by [L_IH L']) by
                   cong <vec ulit *>
                   symm trans cong (length *) L_eq
                              join (length (cons a L')) (S (length L'))
             { (clause_to_uwarray L) = * } hypjoin (clause_to_uwarray L) (vecc w (clause_to_uwarray L')) by L_eq a_eq end
      end
  end.

Total clause_to_uwarray clause_to_uwarray_tot.

Define clause_to_uwarray_append
 : Forall(c1 c2:clause).
     { (clause_to_uwarray (append lit c1 c2)) = (vec_append (clause_to_uwarray c1) (clause_to_uwarray c2)) } :=
   induction(c1:clause)
   return Forall(c2:clause).
           { (clause_to_uwarray (append lit c1 c2)) = (vec_append (clause_to_uwarray c1) (clause_to_uwarray c2)) } 
   with
     nil => 
     foralli(c2:clause).
       hypjoin (clause_to_uwarray (append lit c1 c2)) (vec_append (clause_to_uwarray c1) (clause_to_uwarray c2))
       by c1_eq end
   | cons _ a c1' =>
     case a with
       mk_uholder _ w =>
       foralli(c2:clause).
         hypjoin (clause_to_uwarray (append lit c1 c2)) (vec_append (clause_to_uwarray c1) (clause_to_uwarray c2))
         by a_eq c1_eq [c1_IH c1' c2] end
     end
   end.


%=============================================================================
% to_cl lemmas
%=============================================================================

Define to_cl_append_null 
  : Forall(n:nat)
          (l:<vec ulit n>)
          (nv:word)
          (c:clause)
          (u: { (cl_valid nv c) = tt }).
       { (to_cl (vec_append (clause_to_uwarray c) (vecc ulit_null l))) = c }
  :=
  foralli(n:nat)
         (l:<vec ulit n>)
         (nv:word)
         (c:clause)
         (u: { (cl_valid nv c) = tt }).
 [induction(c:clause) return
   Forall(n:nat)(l:<vec ulit n>)(nv:word)(u: { (cl_valid nv c) = tt }).
          { (to_cl (vec_append (clause_to_uwarray c) (vecc ulit_null l))) = c } with
   nil _ =>
     foralli(n:nat)(l:<vec ulit n>)(nv:word)(u: { (cl_valid nv c) = tt }).
     hypjoin (to_cl (vec_append (clause_to_uwarray c) (vecc ulit_null l))) c by c_eq end
 | cons _ x c' => 
     foralli(n:nat)(l:<vec ulit n>)(nv:word)(u: { (cl_valid nv c) = tt }).
       abbrev u' = [cl_valid_implies_cl_valid_tail2 nv c x c' u c_eq] in
       abbrev ih = [c_IH c' n l nv u'] in

       case x with
       mk_uholder _ wx =>
         case (eq_ulit wx ulit_null) by q1 _ with
	   ff =>
             % want 
             % (cons x (to_cl (vec_append (clause_to_uwarray c') (vecc ulit_null l)))) =
             % (to_cl (vec_append (clause_to_uwarray c) (vecc ulit_null l)))

	     abbrev p1 =
	       hypjoin (cons x (to_cl (vec_append (clause_to_uwarray c') (vecc ulit_null l))))
	               (to_cl (vec_append (clause_to_uwarray c) (vecc ulit_null l))) by c_eq x_eq q1 end in
	     hypjoin (to_cl (vec_append (clause_to_uwarray c) (vecc ulit_null l))) c by c_eq p1 ih end
	 | tt =>
	     abbrev u' = hypjoin (cl_valid nv (cons x c')) tt by c_eq u end in
	     abbrev p1_1 = [cl_valid_implies_lit_valid_head nv x c' u'] in
	     abbrev p1 = [lit_valid_implies_ulit_vnum_not_null nv x p1_1] in
	     abbrev p2 = hypjoin (eq_ulit (to_ulit x) ulit_null) tt by x_eq q1 end
	     contra
	       trans symm p1
	       trans p2
	       clash tt ff
	     { (to_cl (vec_append (clause_to_uwarray c) (vecc ulit_null l))) = c }
	 end
       end
     end c n l nv u].


%=============================================================================
% conversion from logical clause to array clause
%=============================================================================

%- a helper lemma used in clause_to_array_h, and also the main
   lemma about clause_to_array_h. -% 
Define ltword_i_n :
  Forall(n:word)(i:word)(c:clause)
        (u:{ (S (plus (word_to_nat i) (length c))) = (word_to_nat n) }).
    { (ltword i n) = tt } :=
  foralli(n:word)(i:word)(c:clause)
         (u:{ (S (plus (word_to_nat i) (length c))) = (word_to_nat n) }).
  % want: i < n
  % have: i + c + 1  = n
  % need: i <= i + c < n
  % p1: (le i (i+c)) = tt
  abbrev p1 = [plus_implies_le (word_to_nat i) (length lit c)] in
  % p2: (lt (i+c) (S (i+c))) = tt
  abbrev p2 = [lt_S (plus (word_to_nat i) (length lit c))] in
  % p3: (lt i (S (i+c))) = tt
  abbrev p3 = [lelt_trans (word_to_nat i)
						  (plus (word_to_nat i) (length lit c))
						  (S (plus (word_to_nat i) (length lit c)))
						  p1 p2]
  in
    trans join (ltword i n) (lt (word_to_nat i) (word_to_nat n))
    trans cong (lt (word_to_nat i) *) symm u
          p3.



Define clause_to_array_h :=
  fun clause_to_array_h(spec n:word)(#unique wc:<uwarray ulit n>)
                  (i:word)(^#owned c:clause)
                  (u:{ (S (plus (word_to_nat i) (length c))) = (word_to_nat n) })
                  : #unique <uwarray ulit n>.
  abbrev ltword_i_n = [ltword_i_n n i c u] in
  abbrev ltword_i_word_max = [ltword_implies_ltword_word_max i n ltword_i_n] in
  match c with
    nil _ =>
      % make sure null-terminated
      (uwarray_set ulit n wc i ulit_null ltword_i_n)

  | cons _ l c' =>
      let l' = (unboxWord l) in
      let wc' = (uwarray_set ulit n wc i l' ltword_i_n) in
      let i' = (word_inc_safe i ltword_i_word_max) in
      
      % goal: (S (plus (to_nat i') (length c'))) = (to_nat n)

      % want: (S (word_to_nat i)) = (word_to_nat i')
      % p3: (to_nat (word_inc_safe i)) = (S (to_nat i))
      abbrev p3 = [word_inc_safe_word_to_nat i ltword_i_word_max] in
              
      % want: (length c) = (S (length c'))
      abbrev p4 =
        existse [length_tot lit c']
        foralli(z:nat)(z_pf:{ (length c') = z }).
        hypjoin (length c) (S (length c')) by c_eq z_pf end
      in
      abbrev p5 =
        trans hypjoin (plus (word_to_nat i') (length c'))
                      (plus (S (word_to_nat i)) (length c')) by p3 i'_eq end
        trans [plusS_hop (word_to_nat i) (length lit c')]
              hypjoin (plus (word_to_nat i) (S (length c')))
                      (plus (word_to_nat i) (length c))
                by p4 end
      in
      abbrev p = trans cong (S *) p5
                       u
      in
      (clause_to_array_h n wc' i' c' p)
  end.


Define clause_to_array_h_to_clause :
  Forall(c2 c1:clause)
        (nv w wb:word)
        (wb_eq : { (length_word (append c1 c2)) = wb })
        (w_eq:{ w = (word_inc2 (length_word lit c2)) })
        (u:{ (cl_valid nv (append c1 c2)) = tt })
        (l:<uwarray ulit w>).
    { (to_cl (clause_to_array_h (vec_append (clause_to_uwarray c1) l) (length_word c1) c2)) = (append c1 c2) }
  := 
 induction(c2:clause)
 return Forall(c1:clause)
              (nv w wb:word)
              (wb_eq : { (length_word (append c1 c2)) = wb })
              (w_eq:{ w = (word_inc2 (length_word lit c2)) })
              (u:{ (cl_valid nv (append c1 c2)) = tt })
              (l:<uwarray ulit w>).
          { (to_cl (clause_to_array_h (vec_append (clause_to_uwarray c1) l) (length_word c1) c2)) = (append c1 c2) } with
   nil _ => 
   foralli(c1:clause)
          (nv w wb:word)
          (wb_eq : { (length_word (append c1 c2)) = wb })
          (w_eq:{ w = (word_inc2 (length_word lit c2)) })
          (u:{ (cl_valid nv (append c1 c2)) = tt })
          (l:<uwarray ulit w>).
   terminates-case (length_word lit c2) by g with
     lw =>
     case l with
       vecn _ => 
          contra
            transs symm inj <vec ulit *> l_Eq
                   symm [word_inc2_word_to_nat terminates (length_word lit c2) by g 
                          w w_eq]
                   clash (S (word_to_nat (length_word list c2))) Z
            end
          { (to_cl (clause_to_array_h (vec_append (clause_to_uwarray c1) l) (length_word c1) c2)) = (append c1 c2) }
     | vecc _ n' a' l' =>

       %- in theory we should be able to use one big hypjoin, but
          this is too inefficient and maybe would not even succeed (due to
	  possible incompleteness in hypjoin?). -%

       transs
       hypjoin (to_cl (clause_to_array_h (vec_append (clause_to_uwarray c1) l) (length_word c1) c2))
               (to_cl (vec_update (vec_append (clause_to_uwarray c1) l) (length c1) ulit_null))
       by c2_eq [length_word_implies_eq_length lit c1
                  terminates (length_word lit c1) by [length_word_append_defined lit c1 c2 wb wb_eq]
                  join (length_word c1) (length_word c1)]
       end

       hypjoin (to_cl (vec_update (vec_append (clause_to_uwarray c1) l) (length c1) ulit_null))
               (to_cl (vec_append (clause_to_uwarray c1) (vec_update l Z ulit_null)))
       by [vec_update_append ulit ulit_null (length lit c1) (word_to_nat w) (clause_to_uwarray c1) l]
       end

       hypjoin (to_cl (vec_append (clause_to_uwarray c1) (vec_update l Z ulit_null)))
               (to_cl (vec_append (clause_to_uwarray c1) (vecc ulit_null l')))
       by l_eq end

       [to_cl_append_null n' l' nv c1 [cl_valid_append1 nv c1 c2 u]]

       symm [append_nil lit c1]

       cong (append c1 *) symm c2_eq
       end

     end
   | abort =>
       contra
         transs w_eq
                cong (word_inc2 *) g
                join (word_inc2 abort !) abort !
                aclash w
         end
      { (to_cl (clause_to_array_h (vec_append (clause_to_uwarray c1) l) (length_word c1) c2)) = (append c1 c2) }
   end
| cons _ x c2' => 
   case x with
   mk_uholder _ wx =>
    foralli(c1:clause)
            (nv w wb:word)
            (wb_eq : { (length_word (append c1 c2)) = wb })
            (w_eq:{ w = (word_inc2 (length_word lit c2)) })
            (u:{ (cl_valid nv (append c1 c2)) = tt })
            (l:<uwarray ulit w>).
   terminates-case (length_word lit c2) by g with
     lw =>
     case l with
       vecn _ => 
       contra
        transs symm inj <vec ulit *> l_Eq
               symm [word_inc2_word_to_nat terminates (length_word lit c2) by g w w_eq]
               clash (S (word_to_nat (length_word list c2))) Z
        end
       { (to_cl (clause_to_array_h (vec_append (clause_to_uwarray c1) l) (length_word c1) c2)) = (append c1 c2) }
     | vecc _ n' a' l' =>
       abbrev append_pf = hypjoin (append (append c1 (cons lit (mk_uholder word wx) (nil lit))) c2') (append c1 c2) 
                          by c2_eq x_eq [append_assoc lit c1 (cons lit (mk_uholder word wx) (nil lit)) c2'] end in
       transs
           hypjoin (to_cl (clause_to_array_h (vec_append (clause_to_uwarray c1) l) (length_word c1) c2))
                   (to_cl (clause_to_array_h (vec_update (vec_append (clause_to_uwarray c1) l) (length c1) wx)
                              (word_inc_safe (length_word c1)) c2'))
           by x_eq c2_eq [length_word_implies_eq_length lit c1 terminates (length_word lit c1) by 
                            [length_word_append_defined lit c1 c2 wb wb_eq]
                            join (length_word c1) (length_word c1)]
           end

           cong (to_cl (clause_to_array_h * (word_inc_safe (length_word c1)) c2'))
             [vec_update_append ulit wx (length lit c1) (word_to_nat w) (clause_to_uwarray c1) l]

           cong (to_cl (clause_to_array_h (vec_append (clause_to_uwarray c1) *) (word_inc_safe (length_word c1)) c2'))
             hypjoin (vec_update l Z wx) (vec_append (vecc wx vecn) l') by l_eq end

           cong (to_cl (clause_to_array_h * (word_inc_safe (length_word c1)) c2'))
             symm [vec_append_assoc ulit (length lit c1) (clause_to_uwarray c1) (S Z) n' (vecc ulit Z wx (vecn ulit)) l' ]

           cong (to_cl (clause_to_array_h (vec_append * l') (word_inc_safe (length_word c1)) c2'))
             hypjoin (vec_append (clause_to_uwarray c1) (vecc wx vecn)) (clause_to_uwarray (append c1 (cons (mk_uholder wx) nil)))
             by [clause_to_uwarray_append c1 (cons lit (mk_uholder word wx) (nil lit))] end
           
           cong (to_cl (clause_to_array_h (vec_append (clause_to_uwarray (append c1 (cons (mk_uholder wx) nil))) l') * c2'))
             trans join (word_inc_safe (length_word c1)) (word_inc2 (length_word c1)) 
                   symm [length_word_cons_end lit (mk_uholder word wx) c1]
              
         [c2_IH c2' (append lit c1 (cons lit (mk_uholder word wx) (nil lit))) nv
           terminates (length_word lit c2) by g
           wb trans cong (length_word *) append_pf
                    wb_eq
           [length_word_cons lit c2 x c2' c2_eq]
           trans cong (cl_valid nv *) append_pf
                    u
           cast l' by cong <vec word *> 
                        inj (S *) 
                          trans symm inj <vec word *> l_Eq
                                symm [word_inc2_word_to_nat terminates (length_word lit c2) by g w w_eq]

            ]
          hypjoin (append (append c1 (cons (mk_uholder wx) nil)) c2') (append c1 c2) 
          by c2_eq x_eq [append_assoc lit c1 (cons lit x (nil lit)) c2'] end
       end
     end
   | abort =>
       contra
         transs w_eq
                cong (word_inc2 *) g
                join (word_inc2 abort !) abort !
                aclash w
         end
      { (to_cl (clause_to_array_h (vec_append (clause_to_uwarray c1) l) (length_word c1) c2)) = (append c1 c2) }
   end % terminates-case

   end % case mk_uholder
end.  

Define clause_to_array_to_clause :
  Forall(nv:word)
        (c:clause)
        (u:{ (cl_valid nv c) = tt })
        (w:word)
        (w_eq:{ w = (word_inc2 (length_word lit c)) })
        (l:<uwarray ulit w>).
    { (to_cl (clause_to_array_h l word0 c)) = c }
  := 
  foralli(nv:word)
         (c:clause)
         (u:{ (cl_valid nv c) = tt })
         (w:word)
         (w_eq:{ w = (word_inc2 (length_word lit c)) })
         (l:<uwarray ulit w>).
   terminates-case (length_word lit c) by g with
      lw => 
      transs join (to_cl (clause_to_array_h l word0 c))
                  (to_cl (clause_to_array_h (vec_append (clause_to_uwarray nil) l) (length_word nil) c))
             
             [clause_to_array_h_to_clause c (nil lit) nv w lw 
                trans join (length_word (append nil c)) (length_word c)
                      g
                w_eq
                trans join (cl_valid nv (append nil c)) (cl_valid nv c)
                      u
                l]
             join (append nil c) c
      end
    | abort =>
      contra 
        transs w_eq
               cong (word_inc2 *) g
               join (word_inc2 abort !) abort !
               aclash w
        end
      { (to_cl (clause_to_array_h l word0 c)) = c }
    end.

Inductive clause_to_array_t : Fun(c:clause).type :=
  mk_clause_to_array_t : Fun(spec c:clause)
                            (spec n:word)(#unique l:<uwarray ulit n>)
														(n_eq:{ n = (word_inc2 (length_word lit c)) })
                            (u1:{ (word_to_nat n) = (S (length c)) })
                            (u2:{ (to_cl l) = c })
                           .#unique <clause_to_array_t c>.

Define clause_to_array :=
  fun(spec nv:word)
     (^#owned c:clause)
     (u:{ (cl_valid nv c) = tt }) : #unique <clause_to_array_t c>.
  let wn = (length_word lit (clone_owned clause c)) in
  let wn' = (word_inc2 wn) in
  
  % allocate new array of the type: <uwarray ulit wn'>
  let wc = (uwarray_new ulit wn' ulit_null) in

  % need: (to_nat wn) = (length c) in
  abbrev wn_eq' = trans wn_eq
                        cong (length_word *) join (clone_owned c) c
  in
  abbrev p1 = hypjoin (to_nat wn) (length c)
                by wn_eq' [length_word_implies_eq_length lit c wn symm wn_eq'] end in
  % need: (to_nat wn') = (S (length c))
  abbrev p2 = hypjoin (to_nat wn') (S (length c))
                by p1 [word_inc2_word_to_nat wn wn' wn'_eq] end in

  % want: (S (plus (to_nat word0) (length c))) = (S (length c))
  abbrev p3 = trans hypjoin (S (plus (to_nat word0) (length c))) (S (length c))
                     by [plusZ (word_to_nat wn)] end
                   symm p2
  in
  let wc' = (clause_to_array_h wn' wc word0 c p3) in
  
  % want: (to_cl wc') = c
  abbrev wn'_eq' = hypjoin wn' (word_inc2 (length_word c)) by wn'_eq wn_eq end in
  abbrev p4_1 = [clause_to_array_to_clause nv c u wn' wn'_eq' wc] in
  abbrev p4 = hypjoin (to_cl wc') c by wc'_eq p4_1 end in
  (mk_clause_to_array_t c wn' wc' wn'_eq' p2 p4).

Define partial_array_in_bounds := fun partial_array_in_bounds
  (nv:word)(spec n:nat)(c:<vec ulit n>)
	: bool.
	match c with
		vecn _ => tt
	| vecc _ n' l c' =>
			match (eq_ulit l ulit_null) with
				ff =>
					cabbrev v = (ulit_vnum l)
					match (ltword word0 v) with
					  ff => ff
					| tt =>
						match (leword v nv) with
							ff => ff
						| tt => (partial_array_in_bounds nv n' c')
						end
					end
			| tt => ff
			end
	end.

Define partial_array_in_bounds_lem1 : Forall
	(nv:word)
	(n1:nat)(l1:<vec ulit n1>)
	(n2:nat)(l2:<vec ulit n2>)
	(r1:{ (partial_array_in_bounds nv l1) = tt })
  .{ (array_in_bounds nv (vec_append l1 (vecc ulit_null l2))) = tt }
  :=
  foralli
	(nv:word)
	.
	induction(n1:nat)(l1:<vec ulit n1>) return Forall
		(n2:nat)(l2:<vec ulit n2>)
		(r1:{ (partial_array_in_bounds nv l1) = tt })
		.{ (array_in_bounds nv (vec_append l1 (vecc ulit_null l2))) = tt }
	with
		vecn _ => foralli
			(n2:nat)(l2:<vec ulit n2>)
			(r1:{ (partial_array_in_bounds nv l1) = tt })
			.
			abbrev p1 = hypjoin (vec_append l1 (vecc ulit_null l2)) (vecc ulit_null l2) by l1_eq end in
			abbrev p2 = hypjoin (array_in_bounds nv (vecc ulit_null l2)) tt by end in
			hypjoin (array_in_bounds nv (vec_append l1 (vecc ulit_null l2))) tt by p1 p2 end
	| vecc _ n1' x l1' => foralli
			(n2:nat)(l2:<vec ulit n2>)
			(r1:{ (partial_array_in_bounds nv l1) = tt })
			.
			case (eq_ulit x ulit_null) by q1 _ with
				ff =>
				  case (ltword word0 (ulit_vnum x)) by q3 _ with
				    ff =>
				      contra
				        trans symm r1
				        trans hypjoin (partial_array_in_bounds nv l1) ff by q1 q3 l1_eq end
					      clash ff tt
 				      { (array_in_bounds nv (vec_append l1 (vecc ulit_null l2))) = tt }
				  | tt =>

					case (leword (ulit_vnum x) nv) by q2 _ with
						ff =>
							contra
							trans symm r1
							trans hypjoin (partial_array_in_bounds nv l1) ff by q1 q3 q2 l1_eq end
										clash ff tt
							{ (array_in_bounds nv (vec_append l1 (vecc ulit_null l2))) = tt }
					| tt =>
						abbrev r1' = hypjoin (partial_array_in_bounds nv l1') tt by r1 q1 q3 q2 l1_eq end in
						abbrev ih = [l1_IH n1' l1' n2 l2 r1'] in
						hypjoin (array_in_bounds nv (vec_append l1 (vecc ulit_null l2))) tt by ih q1 q3 q2 l1_eq end
					end
                                  end
			| tt =>
					contra
					trans symm r1
					trans hypjoin (partial_array_in_bounds nv l1) ff by q1 l1_eq end
								clash ff tt
					{ (array_in_bounds nv (vec_append l1 (vecc ulit_null l2))) = tt }
			end
	end.

Define partial_array_in_bounds_lem2 : Forall
	(nv:word)
	(n1:nat)(l1:<vec ulit n1>)
	(x:ulit)
	(u1:{ (eq_ulit x ulit_null) = ff })
	(u1a:{ (ltword word0 (ulit_vnum x)) = tt })
	(u2:{ (leword (ulit_vnum x) nv) = tt })
	(r1:{ (partial_array_in_bounds nv l1) = tt })
  .{ (partial_array_in_bounds nv (vec_append l1 (vecc x vecn))) = tt }
  :=
	foralli(nv:word).
	induction(n1:nat)(l1:<vec ulit n1>) return Forall
		(x:ulit)
		(u1:{ (eq_ulit x ulit_null) = ff })
                (u1a:{ (ltword word0 (ulit_vnum x)) = tt })
		(u2:{ (leword (ulit_vnum x) nv) = tt })
		(r1:{ (partial_array_in_bounds nv l1) = tt })
		.{ (partial_array_in_bounds nv (vec_append l1 (vecc x vecn))) = tt }
	with
		vecn _ => foralli
			(x:ulit)
			(u1:{ (eq_ulit x ulit_null) = ff })
                        (u1a:{ (ltword word0 (ulit_vnum x)) = tt })
			(u2:{ (leword (ulit_vnum x) nv) = tt })
			(r1:{ (partial_array_in_bounds nv l1) = tt })
			.
			hypjoin (partial_array_in_bounds nv (vec_append l1 (vecc x vecn))) tt by l1_eq u1 u1a u2 end
	| vecc _ n1' y l1' => foralli
			(x:ulit)
			(u1:{ (eq_ulit x ulit_null) = ff })
                        (u1a:{ (ltword word0 (ulit_vnum x)) = tt })
			(u2:{ (leword (ulit_vnum x) nv) = tt })
			(r1:{ (partial_array_in_bounds nv l1) = tt })
			.
			case (eq_ulit y ulit_null) by q1 _ with
				ff =>
				case (ltword word0 (ulit_vnum y)) by q1a _ with
					ff =>
 					  contra
					    trans symm r1
					    trans hypjoin (partial_array_in_bounds nv l1) ff by q1 q1a l1_eq end
					    clash ff tt
					  { (partial_array_in_bounds nv (vec_append l1 (vecc x vecn))) = tt }
					| tt =>
 					  case (leword (ulit_vnum y) nv) by q2 _ with
					    ff =>
						contra
						  trans symm r1
						  trans hypjoin (partial_array_in_bounds nv l1) ff by q1 q1a q2 l1_eq end
						  clash ff tt
						{ (partial_array_in_bounds nv (vec_append l1 (vecc x vecn))) = tt }
					  | tt =>
						abbrev r1' = hypjoin (partial_array_in_bounds nv l1') tt by r1 l1_eq q1 q1a q2 end in
						abbrev ih = [l1_IH n1' l1' x u1 u1a u2 r1'] in
						hypjoin (partial_array_in_bounds nv (vec_append l1 (vecc x vecn))) tt 
                                                  by ih q1 q1a q2 l1_eq end
					  end
                                        end
			| tt =>
					contra
					trans symm r1
					trans hypjoin (partial_array_in_bounds nv l1) ff by q1 l1_eq end
								clash ff tt
					{ (partial_array_in_bounds nv (vec_append l1 (vecc x vecn))) = tt }
			end
	end.

%Unset "trust_hypjoins". 

Define partial_array_in_bounds_lem3 : Forall
	(nv:word)
	(n:word)
	(i:word)
	(c:clause)
	(l1:<vec ulit (word_to_nat i)>)
	(l2:<vec ulit (S (length lit c))>)
	(u1:{ (cl_valid nv c) = tt })
	(u2:{ (S (plus (word_to_nat i) (length c))) = (word_to_nat n) })
	(r1:{ (partial_array_in_bounds nv l1) = tt })
	.{ (array_in_bounds nv (clause_to_array_h (vec_append l1 l2) i c)) = tt }
	:=
	foralli
	(nv:word)
	(n:word)
	.
	induction(i:word)(c:clause) return Forall
		(l1:<vec ulit (word_to_nat i)>)
		(l2:<vec ulit (S (length lit c))>)
		(u1:{ (cl_valid nv c) = tt })
		(u2:{ (S (plus (word_to_nat i) (length c))) = (word_to_nat n) })
		(r1:{ (partial_array_in_bounds nv l1) = tt })
		.{ (array_in_bounds nv (clause_to_array_h (vec_append l1 l2) i c)) = tt }
	with
		nil _ =>
			foralli
			(l1:<vec ulit (word_to_nat i)>)
			(l2:<vec ulit (S (length lit c))>)
			(u1:{ (cl_valid nv c) = tt })
			(u2:{ (S (plus (word_to_nat i) (length c))) = (word_to_nat n) })
			(r1:{ (partial_array_in_bounds nv l1) = tt })
			.
			abbrev l = (vec_append l1 l2) in
			case l2 with
				vecn _ =>
					contra
					abbrev p3_1 = inj <vec ulit *> l2_Eq in
					abbrev p3_2 = hypjoin (S (length c)) Z by p3_1 end in
					abbrev p3_3 = hypjoin (S (length c)) (S Z) by c_eq end in
					trans symm p3_2
					trans p3_3
								clash (S Z) Z
					{ (array_in_bounds nv (clause_to_array_h (vec_append l1 l2) i c)) = tt }
					
			| vecc _ n2' x l2' =>
					% goal: (clause_to_array_h l i c) = (vec_append l1 (vec_update l2 Z ulit_null))
					abbrev p1 = hypjoin (clause_to_array_h l i c)
															(vec_update l (to_nat i) ulit_null) by c_eq end in
					abbrev p2 = [vec_update_append ulit ulit_null (word_to_nat i) (S (length lit c)) l1 l2] in

					% subgoal: (vec_update l2 Z ulit_null) = (vecc ulit_null l2')
					abbrev n1 = (word_to_nat i) in
					abbrev n2' = (length lit c) in
					abbrev p3_1 = [partial_array_in_bounds_lem1 nv n1 l1 n2' l2' r1] in
					abbrev p3_2 = hypjoin (vec_update l2 Z ulit_null) (vecc ulit_null l2') by l2_eq end in
					
					hypjoin (array_in_bounds nv (clause_to_array_h l i c)) tt by p3_1 p3_2 p1 p2 end
			end

	| cons _ x c' =>
			foralli
			(l1:<vec ulit (word_to_nat i)>)
			(l2:<vec ulit (S (length lit c))>)
			(u1:{ (cl_valid nv c) = tt })
			(u2:{ (S (plus (word_to_nat i) (length c))) = (word_to_nat n) })
			(r1:{ (partial_array_in_bounds nv l1) = tt })
			.
			case l2 with
				vecn _ =>
					contra
					abbrev p3_1 = inj <vec ulit *> l2_Eq in
					abbrev p3 = hypjoin (S (length c)) Z by p3_1 end in
					existse [length_tot c]
					foralli(n2':nat)(n2'_pf:{ (length c) = n2' }).
					abbrev p4 = hypjoin (S (length c)) (S n2') by n2'_pf end in
					trans symm p3
					trans p4
								clash (S n2') Z
					{ (array_in_bounds nv (clause_to_array_h (vec_append l1 l2) i c)) = tt }
					
			| vecc _ n2' y l2' =>
					abbrev ltword_i_n = [ltword_i_n n i c u2] in
					abbrev ltword_i_word_max = [ltword_implies_ltword_word_max i n ltword_i_n] in

					abbrev l = (vec_append l1 l2) in
					abbrev n1 = (word_to_nat i) in
					abbrev n2 = (S (length lit c)) in
					abbrev x' = (to_ulit x) in
					abbrev l' = (uwarray_set l i x') in
					abbrev i' = (word_inc_safe i ltword_i_word_max) in
					
					abbrev u1'_1 = hypjoin (cl_valid nv (cons x c')) tt by u1 c_eq end in
					abbrev u1' = [cl_valid_implies_cl_valid_tail nv x c' u1'_1] in

					% goal u2': (S (plus (to_nat i') (length c'))) = (to_nat n)

					% want: (S (word_to_nat i)) = (word_to_nat i')
					% p3: (to_nat (word_inc_safe i)) = (S (to_nat i))
					abbrev p3 = [word_inc_safe_word_to_nat i ltword_i_word_max] in
									
					% want: (length c) = (S (length c'))
					abbrev p4 =
						existse [length_tot lit c']
						foralli(z:nat)(z_pf:{ (length c') = z }).
						hypjoin (length c) (S (length c')) by c_eq z_pf end
					in
					abbrev p5 =
						trans hypjoin (plus (word_to_nat i') (length c'))
													(plus (S (word_to_nat i)) (length c')) by p3 end
						trans [plusS_hop (word_to_nat i) (length lit c')]
									hypjoin (plus (word_to_nat i) (S (length c')))
													(plus (word_to_nat i) (length c))
										by p4 end
					in
					abbrev u2' = trans cong (S *) p5
														 u2
					in

					% want p1: l' = (vec_append l1 (vecc x' l2')) in
					% p1_1: l' = (vec_append l1 (vec_update l2 Z ulit_null))
					abbrev p1_1 = [vec_update_append ulit x' n1 n2 l1 l2] in
					abbrev p1_2 = hypjoin (vec_update l2 Z x') (vecc x' l2') by l2_eq end in
					abbrev p1 = hypjoin l' (vec_append l1 (vecc x' l2')) by p1_1 p1_2 end in

					abbrev l1' = (vec_append ulit n1 (S Z) l1 (vecc ulit Z x' (vecn ulit))) in
					
					% want p2: l' = (vec_append l1' l2')
					abbrev p2_1 = [vec_append_vecc_assoc ulit n1 l1 x' n2' l2'] in
					abbrev p2 = hypjoin l' (vec_append l1' l2') by p1 p2_1 l2_eq end in
					
					abbrev p6_1 = [plusS (word_to_nat i) Z] in
					abbrev p6_2 = [plusZ (word_to_nat i)] in
					abbrev p6 = hypjoin (plus (to_nat i) (S Z)) (word_to_nat i') by p6_1 p6_2 p3 end in
					abbrev l1'' = cast l1' by cong <vec ulit *> p6 in
					abbrev l2'' = cast l2' by cong <vec ulit *> p4 in
					
					abbrev r1'_1 = [cl_valid_implies_lit_valid_head nv x c' u1'_1] in
					abbrev r1'_2 = [lit_valid_implies_ulit_vnum_not_null nv x r1'_1] in
					abbrev r1'_2a = [lit_valid_implies_ltword_word0 nv x r1'_1] in
					abbrev r1'_3 = [lit_valid_implies_ulit_vnum_leword_nv nv x r1'_1] in
					abbrev r1' = [partial_array_in_bounds_lem2 nv n1 l1 x' r1'_2 r1'_2a r1'_3 r1] in
					
					% ih: (array_in_bounds nv (clause_to_array_h (vec_append l1' l2') i' c')) = tt
					abbrev ih = [c_IH i' c' l1'' l2'' u1' u2' r1'] in
					abbrev p7 = hypjoin (clause_to_array_h l i c)
															(clause_to_array_h l' i' c') by c_eq end in
					hypjoin (array_in_bounds nv (clause_to_array_h l i c)) tt by ih p2 p7 end
			end
	end.

Define clause_to_array_in_bounds : Forall
	(nv:word)
	(c:clause)
	(n:word)(l:<uwarray ulit n>)
  (n_eq:{ n = (word_inc2 (length_word lit c)) })
	(u1:{ (cl_valid nv c) = tt })
	(r:{ (clause_to_array c) = (mk_clause_to_array_t l) })
  .{ (array_in_bounds nv l) = tt }
  :=
	foralli
	(nv:word)
	(c:clause)
	(n:word)(l:<uwarray ulit n>)
  (n_eq:{ n = (word_inc2 (length_word lit c)) })
	(u1:{ (cl_valid nv c) = tt })
	(r:{ (clause_to_array c) = (mk_clause_to_array_t l) })
	.
	existse
	cinv (length_word lit c) symm trans n_eq eval (word_inc2 (length_word lit c))
	foralli(wn:word)(wn_pf:{ (length_word c) = wn }).
	abbrev p1 = hypjoin n (word_inc2 wn) by wn_pf n_eq end in
	
	abbrev wc = (mkvec ulit ulit_null (word_to_nat n)) in
	abbrev wc' = (clause_to_array_h wc word0 c) in

	abbrev wn_eq = symm wn_pf in
	abbrev wn' = n in
	abbrev wn'_eq = hypjoin n (word_inc2 wn) by wn_pf n_eq end in
	
  % need: (to_nat wn) = (length c) in
  abbrev wn_eq' = wn_eq in
  abbrev p1 = hypjoin (word_to_nat wn) (length c)
                by wn_eq' [length_word_implies_eq_length lit c wn symm wn_eq'] end in
  % need: (to_nat wn') = (S (length c))
  abbrev p2 = hypjoin (word_to_nat wn') (S (length c))
                by p1 [word_inc2_word_to_nat wn wn' wn'_eq] end in

  % want: (S (plus (to_nat word0) (length c))) = (S (length c))
  abbrev p3 = trans hypjoin (S (plus (word_to_nat word0) (length c))) (S (length c))
                     by [plusZ (word_to_nat wn)] end
                   symm p2
  in
	abbrev l1 = cast (vecn ulit) by cong <vec ulit *> join Z (word_to_nat word0) in
	
	% want: (word_to_nat (word_inc2 (length_word lit c)) = (S (length c))
	abbrev l2 = cast wc by cong <vec ulit *> p2 in
	abbrev r1 = join (partial_array_in_bounds nv l1) tt in
	
	abbrev p4 = [partial_array_in_bounds_lem3 nv n word0 c l1 l2 u1 p3 r1] in
	abbrev p5 = join (clause_to_array c) (mk_clause_to_array_t wc') in
	abbrev l_eq = inj (mk_clause_to_array_t *) hypjoin (mk_clause_to_array_t l) (mk_clause_to_array_t wc') by p1 r n_eq end in
	
	hypjoin (array_in_bounds nv l) tt by p4 l_eq end
	.

Define build_aclause :=
  fun(spec nv:word)
     (spec F:formula)
     (^#owned c:clause)
     (spec cp:<pf F c>)
     (cv:{ (cl_valid nv c) = tt }): <aclause nv F>.
  match (clause_to_array nv c cv) by q1 _ with
    mk_clause_to_array_t _ n l n_eq u1 u3 =>
      % want p1: (array_in_bounds nv l) = tt
      abbrev p1 = [clause_to_array_in_bounds nv c n l n_eq cv q1] in
      (mk_aclause n l nv F p1 c cp symm u3)
  end.
