Include trusted "cnf-lemma.g".
Include trusted "pf_util2.g".

%=============================================================================
% aclause lemmas (most specialized)
%=============================================================================

Define aclause_lem1 :
  Forall(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
        (n:word)(c:<uwarray ulit n>)
        (u:{ (array_in_bounds nv c) = tt })
        (x:ulit)
        (u1:{ x = (uwarray_get c word0) })
        (u2:{ (eq_ulit x ulit_null) = ff }).
    { (leword (ulit_vnum x) nv) = tt }
  :=
  foralli(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (n:word)(c:<uwarray ulit n>)
  (u:{ (array_in_bounds nv c) = tt })
  (x:ulit)
  (u1:{ x = (uwarray_get c word0) })
  (u2:{ (eq_ulit x ulit_null) = ff })
  .
  symm trans symm [array_in_bounds_leword_0 nv (to_nat wordlen n) c u]
       cong (leword (ulit_vnum *) nv)
       trans join (vec_get c Z) (uwarray_get c word0) symm u1.

Define aclause_lem2 :
  Forall(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
        (n:word)(c:<uwarray ulit n>)
        (u:{ (array_in_bounds nv c) = tt })
        (x1 x2:ulit)
        (u1:{ x1 = (uwarray_get c word0) })
        (u2:{ (eq_ulit x1 ulit_null) = ff })
        (u3:{ x2 = (uwarray_get c 0x1) })
        (u4:{ (eq_ulit x2 ulit_null) = ff })
    .{ (leword (ulit_vnum x2) nv) = tt }
  := 
 foralli(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
        (n:word)(c:<uwarray ulit n>)
        (u:{ (array_in_bounds nv c) = tt })
        (x1 x2:ulit)
        (u1:{ x1 = (uwarray_get c word0) })
        (u2:{ (eq_ulit x1 ulit_null) = ff })
        (u3:{ x2 = (uwarray_get c 0x1) })
        (u4:{ (eq_ulit x2 ulit_null) = ff }).
   case c with
     vecn _ => 
       contra
         transs
           u1
           hypjoin (uwarray_get c word0) abort ! by c_eq end
           aclash x1
         end
         { (leword (ulit_vnum x2) nv) = tt }
   | vecc _ n' l c' =>
     cabbrev lnnull = hypjoin (eq_ulit l ulit_null) ff by c_eq u1 u2 end in
     case c' with
       vecn _ => 
          contra
            transs 
              u3
              hypjoin (uwarray_get c 0x1) abort ! by c_eq c'_eq end
              aclash x2
            end
            { (leword (ulit_vnum x2) nv) = tt }
     | vecc _ n'' l2 c'' => 
       cabbrev l2nnull = hypjoin (eq_ulit l2 ulit_null) ff by c_eq c'_eq u3 u4 end in
       case (ltword word0 (ulit_vnum l)) by lt1 _ with
         ff => 
           contra
              transs
                 symm u
                 hypjoin (array_in_bounds nv c) ff
                 by c_eq lnnull lt1 end
                 clash ff tt
              end
              { (leword (ulit_vnum x2) nv) = tt }
       | tt => 
         case (leword (ulit_vnum l) nv) by le1 _ with
           ff => 
             contra
               transs
                 symm u
                 hypjoin (array_in_bounds nv c) ff
                 by c_eq lnnull lt1 le1 end
                 clash ff tt
               end
             { (leword (ulit_vnum x2) nv) = tt }
         | tt =>
           cabbrev uc = hypjoin (array_in_bounds nv c) (array_in_bounds nv c')
                        by c_eq lnnull lt1 le1 end in
           case (ltword word0 (ulit_vnum l2)) by lt2 _ with
             ff => 
               contra
                 transs
                   symm u
                   uc
                   hypjoin (array_in_bounds nv c') ff
                     by c'_eq l2nnull lt2 end
                   clash ff tt
                 end
               { (leword (ulit_vnum x2) nv) = tt }
           | tt => 
             case (leword (ulit_vnum l2) nv) by le2 _ with
               ff => 
                 contra
                   transs
                     symm u
                     uc
                     hypjoin (array_in_bounds nv c') ff
                       by c'_eq l2nnull lt2 le2 end 
                     clash ff tt
                   end
                 { (leword (ulit_vnum x2) nv) = tt }
             | tt =>
               hypjoin (leword (ulit_vnum x2) nv) tt
               by c_eq c'_eq u3 le2 end
             end
           end
         end
       end
     end
   end.

Define aclause_lem3 : Forall
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(n:word)(la:<uwarray ulit n>)
	(u:{ (array_in_bounds nv la) = tt })
	(x:ulit)
	(u1:{ x = (uwarray_get la word0) })
	(u2:{ (eq_ulit x ulit_null) = ff })
	.{ (ltword 0x1 n) = tt }
  := foralli
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(n:word)(la:<uwarray ulit n>)
	(u:{ (array_in_bounds nv la) = tt })
	(x:ulit)
	(u1:{ x = (uwarray_get la word0) })
	(u2:{ (eq_ulit x ulit_null) = ff })
	.
	cabbrev p1 = [array_in_bounds_implies_null_terminated nv (word_to_nat n) la u] in
	abbrev p3_1 = hypjoin (null_terminated (vec_nth_tail la (to_nat word0))) tt by p1 end in
	abbrev p3_2 = hypjoin (eq_ulit (vec_get la (to_nat word0)) ulit_null) ff by u1 u2 end in
	abbrev p3_3 = [nth_tail_null_terminated_later (to_nat wordlen n) la
									(to_nat wordlen word0) p3_1 p3_2] in
	abbrev p3_4 = hypjoin (null_terminated (vec_nth_tail la (to_nat 0x1))) tt by p3_3 end in
	trans join (ltword 0x1 n) (lt (to_nat 0x1) (to_nat n))
				[null_terminated_nth_tail_implies_lt (to_nat wordlen n) la (to_nat wordlen 0x1) p3_4]

Define aclause_empty :
  Forall(nv:word)(n:word)(l:<uwarray ulit n>)
        (u1:{ (array_in_bounds nv l) = tt })
        (c:clause)
        (u2:{ c = (to_cl l) })
        (v:{ (eq_ulit (uwarray_get l word0) ulit_null) = tt }).
             { c = nil }
  :=
  foralli(nv:word)(n:word)(l:<uwarray ulit n>)
         (u1:{ (array_in_bounds nv l) = tt })
         (c:clause)
         (u2:{ c = (to_cl l) })
         (v:{ (eq_ulit (uwarray_get l word0) ulit_null) = tt }).
  % (ltword word0 n) = tt
  cabbrev p1 = [array_in_bounds_implies_ltword_word0 nv n l u1]
  abbrev p2 = hypjoin (lt Z (to_nat n)) tt by p1 end in
  abbrev p3 = hypjoin (eq_ulit (vec_get l Z) ulit_null) tt by v end in
  % (to_cl l) = nil
  abbrev p4 = [empty_array_empty_clause (to_nat wordlen n) l p2 p3] in
  hypjoin c nil by p4 u2 end


%=============================================================================
% cl_subsume + vec_nth_tail lemmas (formulated for resolution)
%=============================================================================

Define cl_subsume_init_res_lem1 : Forall
  (c c1 c1':clause)
  (n:nat)(la:<vec ulit n>)
  (i:nat)
  (l:lit)
  (u1:{ (cl_subsume c (append c1 (cons l (to_cl (vec_nth_tail la (S i)))))) = tt })
  (r1:{ (cl_subsume c1 c1') = tt })
  (r2:{ (cl_has c1' l) = tt })
  .{ (cl_subsume c (append c1' (to_cl (vec_nth_tail la (S i))))) = tt }
  :=
  foralli(c c1 c1':clause)
         (n:nat)(la:<vec ulit n>)
         (i:nat)(l:lit)
         (u1:{ (cl_subsume c (append c1 (cons l (to_cl (vec_nth_tail la (S i)))))) = tt })
         (r1:{ (cl_subsume c1 c1') = tt })
         (r2:{ (cl_has c1' l) = tt }).
  case (le (S i) n) by q1 _ with
    ff =>
      abbrev p1 = [vec_nth_tail_abort ulit n la (S i) q1] in
      contra
        trans symm u1
        trans hypjoin (cl_subsume c (append c1 (cons l (to_cl (vec_nth_tail la (S i)))))) abort ! by p1 end
	aclash tt
      { (cl_subsume c (append c1' (to_cl (vec_nth_tail la (S i))))) = tt }
  | tt =>
      abbrev to_cl_tot =
        cinv (to_cl (minus n (S i)) (vec_nth_tail ulit n la (S i) q1))
      	trans cong (cl_subsume c (append c1 (cons l (*)))) symm eval (to_cl (vec_nth_tail la (S i))) u1 in
      [cl_subsume_append_cons3 c c1
         terminates (to_cl (minus n (S i)) (vec_nth_tail ulit n la (S i) q1)) by to_cl_tot
         l u1 c1' r1 r2]
  end.
   
Define cl_subsume_append_filter_lem1 : Forall
  (c' d1 d1':clause)
  (n:nat)(la:<vec ulit n>)
  (i:nat)
  (l x:lit)
  (u1:{ (cl_subsume c' (append d1 (cl_erase (cons x (to_cl (vec_nth_tail la (S i)))) l))) = tt })
  (r1:{ (cl_subsume d1 d1') = tt })
  (r2:{ (cl_has d1' x) = tt })
  .{ (cl_subsume c' (append d1' (cl_erase (to_cl (vec_nth_tail la (S i))) l))) = tt }
  :=
  foralli(c' d1 d1':clause)
         (n:nat)(la:<vec ulit n>)
         (i:nat)(l x:lit)
         (u1:{ (cl_subsume c' (append d1 (cl_erase (cons x (to_cl (vec_nth_tail la (S i)))) l))) = tt })
         (r1:{ (cl_subsume d1 d1') = tt })
         (r2:{ (cl_has d1' x) = tt }).
  case (le (S i) n) by q1 _ with
    ff =>
      abbrev p1 = [vec_nth_tail_abort ulit n la (S i) q1] in
      contra
        trans symm u1
        trans hypjoin (cl_subsume c' (append d1 (cl_erase (cons x (to_cl (vec_nth_tail la (S i)))) l))) abort ! by p1 end
	aclash tt
      { (cl_subsume c' (append d1' (cl_erase (to_cl (vec_nth_tail la (S i))) l))) = tt }
  | tt =>
      abbrev to_cl_tot =
        cinv (to_cl (minus n (S i)) (vec_nth_tail ulit n la (S i) q1))
      	trans cong (cl_subsume c' (append d1 (cl_erase (cons x (*)) l))) symm eval (to_cl (vec_nth_tail la (S i))) u1 in
      case (eq_lit l x) by q2 _ with
        ff =>
	  abbrev u1' = hypjoin (cl_subsume c' (append d1 (cons x (cl_erase (to_cl (vec_nth_tail la (S i))) l)))) tt by u1 q2 end in

	  [cl_subsume_append_cons3 c' d1
	     terminates (cl_erase
	       terminates (to_cl (minus n (S i)) (vec_nth_tail ulit n la (S i) q1)) by to_cl_tot
	       l) by [cl_erase_total
	         terminates (to_cl (minus n (S i)) (vec_nth_tail ulit n la (S i) q1)) by to_cl_tot
		 l] 
	     x u1' d1' r1 r2]
      | tt =>
          abbrev u1' = hypjoin (cl_subsume c' (append d1 (cl_erase (to_cl (vec_nth_tail la (S i))) l))) tt by u1 q2 end in
	  [cl_subsume_append c' d1
	    (cl_erase
	      terminates (to_cl (minus n (S i)) (vec_nth_tail ulit n la (S i) q1)) by to_cl_tot
	      l) d1' u1' r1]
      end
  end.

Define cl_subsume_append_filter_lem2 : Forall
  (c' d1:clause)
  (n:nat)(la:<vec ulit n>)
  (i:nat)
  (l:lit)
  (u1:{ (cl_subsume c' (append d1 (cl_erase (cons l (to_cl (vec_nth_tail la (S i)))) l))) = tt })
  .{ (cl_subsume c' (append d1 (cl_erase (to_cl (vec_nth_tail la (S i))) l))) = tt }
  := 
  foralli(c' d1:clause)
         (n:nat)(la:<vec ulit n>)
         (i:nat)(l:lit)
         (u1:{ (cl_subsume c' (append d1 (cl_erase (cons l (to_cl (vec_nth_tail la (S i)))) l))) = tt }).
    abbrev l_eqlit_l = [eq_lit_refl l] in
    hypjoin (cl_subsume c' (append d1 (cl_erase (to_cl (vec_nth_tail la (S i))) l))) tt by u1 l_eqlit_l end.

%=============================================================================
% to_cl lemmas for resolution
%=============================================================================

Define to_cl_vecc_eq_cons_to_cl : Forall
  (n:nat)(la:<vec ulit n>)
  (x:ulit)
  (u:{ (eq_ulit x ulit_null) = ff })
  .{ (to_cl (vecc x la)) = (cons (to_lit x) (to_cl la)) }
  :=
  foralli(n:nat)(la:<vec ulit n>)
         (x:ulit)(u:{ (eq_ulit x ulit_null) = ff })
  .
  hypjoin (to_cl (vecc x la)) (cons (to_lit x) (to_cl la)) by u end
  .

Define to_cl_nth_tail_eq_cons_to_cl : Forall
  (n:nat)(la:<vec ulit n>)
  (i:nat)
  (x:ulit)
  (x_eq:{ x = (vec_get la i) })
  (u:{ (eq_ulit x ulit_null) = ff })
  .{ (to_cl (vec_nth_tail la i)) = (cons (to_lit x) (to_cl (vec_nth_tail la (S i)))) }
  := foralli
  (n:nat)(la:<vec ulit n>)
  (i:nat)
  (x:ulit)
  (x_eq:{ x = (vec_get la i) })
  (u:{ (eq_ulit x ulit_null) = ff })
  .
  abbrev p1_1 = [vec_get_implies_lt ulit n i la x x_eq] in  % (lt i n) = tt
  abbrev p1 = [vec_nth_tail_eq ulit n i la p1_1] in
  abbrev p2_1 = [lt_S_le i n p1_1] in
  abbrev p2 = [to_cl_vecc_eq_cons_to_cl (minus n (S i)) (vec_nth_tail ulit n la (S i) p2_1) x u] in
  hypjoin (to_cl (vec_nth_tail la i))
          (cons (to_lit x) (to_cl (vec_nth_tail la (S i))))
    by x_eq p1 p2 end
  .

Define to_cl_nth_tail_eq_nil : Forall
  (n:nat)(la:<vec ulit n>)
  (i:nat)
  (x:ulit)
  (x_eq:{ x = (vec_get la i) })
  (u:{ (eq_ulit x ulit_null) = tt })
  .{ (to_cl (vec_nth_tail la i)) = nil }
  := foralli
  (n:nat)(la:<vec ulit n>)
  (i:nat)
  (x:ulit)
  (x_eq:{ x = (vec_get la i) })
  (u:{ (eq_ulit x ulit_null) = tt })
  .
  abbrev p1_1 = [vec_get_implies_lt ulit n i la x x_eq] in  % (lt i n) = tt
  abbrev p1 = [vec_nth_tail_eq ulit n i la p1_1] in
  hypjoin (to_cl (vec_nth_tail la i)) nil by p1 x_eq u end
	
	
%=============================================================================
% to_cl lemmas for conflict analysis
%=============================================================================

Define to_cl_total : Forall
	(n:nat)(la:<vec ulit n>)(u:{ (null_terminated la) = tt }).
	Exists(c:clause).{ (to_cl la) = c }
	:=
	induction(n:nat)(la:<vec ulit n>) return Forall
		(u:{ (null_terminated la) = tt }).
		Exists(c:clause).{ (to_cl la) = c }
	with
	| vecn _ => foralli(u:{ (null_terminated la) = tt }).
		contra
		trans symm u
		trans hypjoin (null_terminated la) ff by la_eq end
					clash ff tt
		Exists(c:clause).{ (to_cl la) = c }
	| vecc _ n' l la' => foralli(u:{ (null_terminated la) = tt }).
		case (eq_ulit l ulit_null) by q1 _ with
		| ff =>
			cabbrev u' = hypjoin (null_terminated la') tt by u q1 la_eq end
			existse [la_IH n' la' u']
			foralli(c':clause)(c'_pf:{ (to_cl la') = c' }).
			existsi (cons lit (to_lit l) c') { (to_cl la) = * }
			hypjoin (to_cl la) (cons (to_lit l) c') by la_eq q1 c'_pf end
		| tt =>
			existsi (nil lit) { (to_cl la) = * }
			hypjoin (to_cl la) nil by q1 la_eq end
		end
	end

Define to_cl_total' : Forall
	(nv:word)(n:nat)(la:<vec ulit n>)(u:{ (array_in_bounds nv la) = tt }).
	Exists(c:clause).{ (to_cl la) = c }
	:= foralli
	(nv:word)(n:nat)(la:<vec ulit n>)(u:{ (array_in_bounds nv la) = tt }).
	cabbrev u' = [array_in_bounds_implies_null_terminated nv n la u]
	[to_cl_total n la u']

