%=============================================================================
% cnf-lemma.g : properties of array-based clause
% Note: constructing array-based clause from list-base clause is in cnf-util.g
%=============================================================================
Include trusted "cnf.g".
Include trusted "pf_util.g".

%=============================================================================
% lemmas for basic functions
%=============================================================================

Define to_ulit_total : Forall(l:lit).Exists(l':ulit).{ (to_ulit l) = l' } := 
  foralli(l:lit).
  case l with
    mk_uholder _ w => existsi cast w by symm inj <uholder *> l_Eq
                        { (to_ulit l) = *} hypjoin (to_ulit l) w by l_eq end
  end.
 
Total to_ulit to_ulit_total.

Define eq_ulit_eq :
  Forall(a b:ulit)(u:{ (eq_ulit a b) = tt }).
    { a = b }
  :=
  foralli(a b:ulit)(u:{ (eq_ulit a b) = tt }).
  abbrev p1 = hypjoin (eqword a b) tt by u end in
  [eqword_eq a b p1]
  .

Define neq_ulitneq :
  Forall(a b:ulit)(u:{ a != b }).
    { (eq_ulit a b) = ff }
  :=
  foralli(a b:ulit)(u:{ a != b }).
  [neq_wordneq a b u]

Define unegated_total :
  Forall(l:ulit).Exists(l':ulit).{ (unegated l) = l' } := 
  foralli(l:ulit).
    case (word_read_msb l) by q _ with
      ff => existsi (word_set_msb l) { (unegated l) = * } hypjoin (unegated l) (word_set_msb l) by q end
    | tt => existsi (word_clear_msb l) { (unegated l) = * } hypjoin (unegated l) (word_clear_msb l) by q end
    end.

Total unegated unegated_total.


%=============================================================================
% relation between lit and ulit
%=============================================================================

Define to_lit_to_ulit_lem : Forall(l:lit).{ (to_lit (to_ulit l)) = l }
  :=
  foralli(l:lit).
  case l with mk_uholder _ l' =>
  hypjoin (to_lit (to_ulit l)) l by l_eq end
  end.
 
Define to_lit_lit_vnum_eq_ulit_vnum :
  Forall(l:ulit).{ (lit_vnum (to_lit l)) = (ulit_vnum l) }
  :=
  foralli(l:ulit).
  join (lit_vnum (to_lit l)) (ulit_vnum l)
  .


Define ulit_vnum_eq_to_lit_vnum :
  Forall(l:ulit).{ (ulit_vnum l) = (lit_vnum (to_lit l)) }
  := 
  foralli(l:ulit).
    join (ulit_vnum l) (lit_vnum (to_lit l))

Define ulit_sign_to_lit_sign :
  Forall(l:ulit).{ (ulit_sign l) = (lit_sign (to_lit l)) }
  :=
  foralli(l:ulit). join (ulit_sign l) (lit_sign (to_lit l))


% the following lemma is a bit slow to check, so disable
% checking hypjoins for the moment.

%Set "trust_hypjoins".

Define lit_vnum_eq_to_lit_vnum_negated_lit :
  Forall(l:lit).{ (lit_vnum l) = (lit_vnum (negated l)) }
  := 
  foralli(l:lit).
     case l with
       mk_uholder _ w =>
       case (lit_sign l) by sign_eq _ with
         default bool =>
           symm
           transs hypjoin (lit_vnum (negated l)) (word_clear_msb (lit_vnum l))
                by l_eq sign_eq [word_set_clear_msb (lit_vnum l)] end
                hypjoin (word_clear_msb (lit_vnum l)) (word_clear_msb (word_clear_msb w)) by l_eq end
                [word_clear_clear_msb w]
                hypjoin (word_clear_msb w) (lit_vnum l) by l_eq end
           end
       end
     end

%Unset "trust_hypjoins".

Define ulit_vnum_eq_to_lit_negated_lit_vnum :
  Forall(l:ulit).{ (ulit_vnum l) = (lit_vnum (negated (to_lit l))) }
  := 
  foralli(l:ulit).
    trans [ulit_vnum_eq_to_lit_vnum l]
          [lit_vnum_eq_to_lit_vnum_negated_lit (to_lit l)]
  
Define ulit_valid_implies_ltword_inc_nv :
  Forall(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
        (l:ulit)
				(u:{ (lit_valid nv (to_lit l)) = tt })
		.{ (ltword (ulit_vnum l) (inc_nv nv)) = tt }
  :=
  foralli(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
				 (l:ulit)(u:{ (lit_valid nv (to_lit l)) = tt })
  .
  abbrev p1 = [lit_valid_implies_leword_nv nv (to_lit l) u] in
  abbrev p2 = hypjoin (leword (ulit_vnum l) nv) tt by
								[to_lit_lit_vnum_eq_ulit_vnum l] p1 end in
  [leword_nv_implies_ltword_inc_nv nv nv_ub (ulit_vnum l) p2]
  .

Define lit_valid_implies_ulit_vnum_not_null :
  Forall(nv:word)(l:lit)(u:{ (lit_valid nv l) = tt })
	.{ (eq_ulit (to_ulit l) ulit_null) = ff }
  := 
  foralli(nv:word)(l:lit)(u:{ (lit_valid nv l) = tt }).
    case l with
      mk_uholder _ w =>
      trans 
         hypjoin (eq_ulit (to_ulit l) ulit_null) (eqbv w (mkvec ff wordlen)) by l_eq end
         [bv_clear_neq (to_nat wordlen 0x1f) wordlen w join (lt (to_nat 0x1f) wordlen) tt
           [neq_ulitneq (bv_update wordlen w (to_nat wordlen 0x1f) ff join (lt (to_nat 0x1f) wordlen) tt) ulit_null 
             trans
              join (vec_update w (to_nat 0x1f) ff) (word_clear_msb w)
              symm
              [ltword_implies_neq word0 (word_clear_msb w)
               [andtt_e1 (ltword word0 (word_clear_msb w)) (leword (word_clear_msb w) nv)
                 symm
                 trans symm u 
                       hypjoin (lit_valid nv l) (and (ltword word0 (word_clear_msb w)) (leword (word_clear_msb w) nv)) by l_eq end]]]]
    end

Define lit_valid_implies_ulit_vnum_leword_nv :
  Forall(nv:word)(l:lit)(u:{ (lit_valid nv l) = tt })
	.{ (leword (ulit_vnum (to_ulit l)) nv) = tt }
  :=
  foralli(nv:word)(l:lit)(u:{ (lit_valid nv l) = tt }).
    case l with
      mk_uholder _ w =>
	abbrev p1_1 = hypjoin (lit_valid nv l) (and (ltword word0 (word_clear_msb w)) (leword (word_clear_msb w) nv)) by l_eq end in
	abbrev p1 = symm trans symm u p1_1 in
        abbrev p2 = [andtt_e2 (ltword word0 (word_clear_msb w)) (leword (word_clear_msb w) nv) p1] in
	hypjoin (leword (ulit_vnum (to_ulit l)) nv) tt by p2 l_eq end
	end
	.

Define lit_valid_implies_ltword_word0 :
  Forall(nv:word)(l:lit)(u:{ (lit_valid nv l) = tt })
	.{ (ltword word0 (ulit_vnum (to_ulit l))) = tt }
  :=
  foralli(nv:word)(l:lit)(u:{ (lit_valid nv l) = tt }).
    case l with
      mk_uholder _ w =>
	abbrev p1_1 = hypjoin (lit_valid nv l) (and (ltword word0 (word_clear_msb w)) (leword (word_clear_msb w) nv)) by l_eq end in
	abbrev p1 = symm trans symm u p1_1 in
        abbrev p2 = [andtt_e1 (ltword word0 (word_clear_msb w)) (leword (word_clear_msb w) nv) p1] in
	hypjoin (ltword word0 (ulit_vnum (to_ulit l))) tt by p2 l_eq end
    end.
    
%=============================================================================
% vector n-th tail
% - the tail of vector after n-th item
% - Zero-th tail means the whole vector
% - n-th tail of size n vector gives the empty vector
%=============================================================================

Define vec_nth_tail :=
  fun vec_nth_tail(A:type)(spec n:nat)(l:<vec A n>)(m:nat)(u:{ (le m n) = tt })
    : <vec A (minus n m)>.
  match m with
    Z => cast l by cong <vec A *> hypjoin n (minus n m) by m_eq end
  | S m' =>
    match l with
      vecn _ => abort <vec A (minus n m)>
    | vecc _ n' a l' =>
        abbrev n_eq = inj <vec ** *> l_Eq in
        abbrev p1 = symm
                      trans symm u
                      trans cong (le * n) m_eq
                      trans cong (le (S m') *) n_eq
                            [S_le_S m' n']
        in
        let l'' = (vec_nth_tail A n' l' m' p1) in
        % l'' : <vec A (minus n' m')>
        % want: <vec A (minus n' m')> = <vec A (minus n m)>
        abbrev p2 = hypjoin (minus n' m') (minus n m) by n_eq m_eq end in
        cast l'' by cong <vec A *> p2
    end
  end.

Define vec_nth_tail_total :
	Forall(A:type)(n:nat)(l:<vec A n>)(m:nat)(u:{ (le m n) = tt }).
		Exists(l':<vec A (minus n m)>).{ (vec_nth_tail l m) = l' }
	:=
	foralli(A:type).
	induction(n:nat)(l:<vec A n>)(m:nat) return
		Forall(u:{ (le m n) = tt }).
		Exists(l':<vec A (minus n m)>).{ (vec_nth_tail l m) = l' }
	with
		Z =>
			foralli(u:{ (le m n) = tt }).
			abbrev l' = cast l by cong <vec A *> hypjoin n (minus n m) by m_eq end in
			existsi l' { (vec_nth_tail l m) = * }
				hypjoin (vec_nth_tail l m) l by m_eq end
	| S m' =>
			foralli(u:{ (le m n) = tt }).
			case l with
				vecn _ =>
					abbrev n_eq = inj <vec ** *> l_Eq in
					contra trans hypjoin ff (le m n) by m_eq n_eq end
								 trans u
											 clash tt ff
								 Exists(l':<vec A (minus n m)>).{ (vec_nth_tail l m) = l' }
			| vecc _ n' a l' =>
					abbrev n_eq = inj <vec ** *> l_Eq in
					abbrev p1 = symm
												trans symm u
												trans cong (le * n) m_eq
												trans cong (le (S m') *) n_eq
															[S_le_S m' n']
					in
					existse [m_IH n' l' m' p1]
					foralli(l'':<vec A (minus n' m')>)(l''_pf:{ (vec_nth_tail l' m') = l'' }).
					% l'' : <vec A (minus n' m')>
					% want: <vec A (minus n' m')> = <vec A (minus n m)>
					abbrev p2 = hypjoin (minus n' m') (minus n m) by n_eq m_eq end in
					abbrev l''' = cast l'' by cong <vec A *> p2 in
					existsi l''' { (vec_nth_tail l m) = * }
						hypjoin (vec_nth_tail l m) l''' by m_eq l_eq l''_pf end
			end
	end.
	
Total vec_nth_tail vec_nth_tail_total.

Define vec_nth_tail_eq :
  Forall (A:type)(n i:nat)(v:<vec A n>)(u:{ (lt i n) = tt }).
    { (vec_nth_tail v i) = (vecc (vec_get v i) (vec_nth_tail v (S i))) }
  :=
  foralli(A:type).
  induction (n i:nat)(v:<vec A n>)
  return Forall(u:{ (lt i n) = tt }).
          { (vec_nth_tail v i) = (vecc (vec_get v i) (vec_nth_tail v (S i))) }
  with
    vecn _ =>
    foralli(u:{ (lt i n) = tt }).
      contra
        transs symm [lt_Z i] 
               cong (lt i *) symm inj <vec ** *> v_Eq 
               u
               clash tt ff
        end
      { (vec_nth_tail v i) = (vecc (vec_get v i) (vec_nth_tail v (S i))) }
  | vecc _ n' a v' => 
    abbrev n_eq = symm inj <vec ** *> v_Eq in
    foralli(u:{ (lt i n) = tt }).
      case i with
        Z =>
          hypjoin (vec_nth_tail v i) (vecc (vec_get v i) (vec_nth_tail v (S i))) 
          by i_eq v_eq end
      | S i' =>
          hypjoin (vec_nth_tail v i) (vecc (vec_get v i) (vec_nth_tail v (S i))) 
          by i_eq v_eq 
             [v_IH n' i' v' trans symm [S_lt_S i' n'] hypjoin (lt (S i') (S n')) tt by i_eq n_eq u end] 
          end
      end
  end.

Define vec_nth_tail_last :
  Forall(A:type)(n:nat)(v:<vec A n>)
    .{ (vec_nth_tail v n) = vecn }
  := foralli(A:type).
	induction(n:nat)(v:<vec A n>) return { (vec_nth_tail v n) = vecn }
	with
		vecn _ =>
			abbrev n_eq = inj <vec ** *> v_Eq in
			hypjoin (vec_nth_tail v n) vecn by v_eq n_eq end
	| vecc _ n' a v' =>
			abbrev n_eq = inj <vec ** *> v_Eq in
			abbrev ih = [v_IH n' v'] in
			hypjoin (vec_nth_tail v n) vecn by v_eq n_eq ih end
	end.

Define vec_nth_tail_abort :
  Forall(A:type)(n:nat)(v:<vec A n>)
        (i:nat)(u:{ (le i n) = ff }).
    { (vec_nth_tail v i) = abort ! }
  :=
  foralli(A:type).
  induction(n:nat)(v:<vec A n>) return
    Forall(i:nat)(u:{ (le i n) = ff }).
      { (vec_nth_tail v i) = abort ! }
  with
    vecn _ =>
      foralli(i:nat)(u:{ (le i n) = ff }).
      abbrev n_eq = inj <vec ** *> v_Eq in
			case i with
			  Z =>
					contra
					trans symm u
					trans hypjoin (le i n) tt by i_eq n_eq end
								clash tt ff
					{ (vec_nth_tail v i) = abort ! }
			| S i' =>
					hypjoin (vec_nth_tail v i) abort ! by v_eq i_eq end
			end
  | vecc _ n' a v' =>
      foralli(i:nat)(u:{ (le i n) = ff }).
      abbrev n_eq = inj <vec ** *> v_Eq in
      case i with
        Z =>
          contra
          trans symm u
          trans hypjoin (le i n) tt by i_eq n_eq end
                clash tt ff
          { (vec_nth_tail v i) = abort ! }
      | S i' =>
        abbrev u' = hypjoin (le i' n') ff by u i_eq n_eq end in
        abbrev ih = [v_IH n' v' i' u'] in
        hypjoin (vec_nth_tail v i) abort ! by v_eq i_eq ih end
      end
  end.

Define vec_nth_tail_implies_le :
  Forall(A:type)(n i:nat)(v:<vec A n>)(a:A)(u:{ a = (vec_nth_tail v i) })
    .{ (le i n) = tt }
  :=
  foralli(A:type)(n i:nat)(v:<vec A n>)(a:A)(u:{ a = (vec_nth_tail v i) }).
  case (le i n) by q1 _ with
    ff => contra
            trans u
            trans [vec_nth_tail_abort A n v i q1]
                  aclash a
            { (le i n) = tt }
  | tt => q1
  end.


%=============================================================================
% [PRIVATE] null termination
% DO NOT use these lemmas outside of this file
%=============================================================================

Define null_terminated :=
  fun null_terminated(spec n:nat)(c:<vec ulit n>) : bool.
  match c with
    vecn _ => ff
  | vecc _ n' l c' =>
      match (eq_ulit l ulit_null) with
        ff => (null_terminated n' c')
      | tt => tt
      end
  end.

Define null_terminated_implies_lt_Z :
  Forall(n:nat)(c:<vec ulit n>)
        (u:{ (null_terminated c) = tt }).
    { (lt Z n) = tt }
  :=
	foralli
	(n:nat)(c:<vec ulit n>)
  (u:{ (null_terminated c) = tt })
	.
	case c with
		vecn _ =>
			contra
			trans symm u
			trans hypjoin (null_terminated c) ff by c_eq end
						clash ff tt
			{ (lt Z n) = tt }
	| vecc _ n' l c' =>
			abbrev n_eq = inj <vec ** *> c_Eq in
			hypjoin (lt Z n) tt by n_eq end
	end.

Define null_terminated_nth_tail_implies_lt :
  Forall(n:nat)(c:<vec ulit n>)
				(i:nat)
				(u:{ (null_terminated (vec_nth_tail c i)) = tt })
    .{ (lt i n) = tt }
  :=
	foralli(n:nat)(c:<vec ulit n>)
				 (i:nat)
				 (u:{ (null_terminated (vec_nth_tail c i)) = tt })
	.
	case (lt i n) by q1 _ with
		ff =>
			case (eqnat i n) by q2 _ with
				ff =>
					abbrev q2' = [eqnat_ff_implies_neq i n q2] in
					abbrev p1 = [lt_ff_neq_implies_lt i n q1 q2'] in
					abbrev p2 = [lt_leff n i p1] in
					abbrev p3 = [vec_nth_tail_abort ulit n c i p2] in
					contra
					trans symm u
					trans hypjoin (null_terminated (vec_nth_tail c i)) abort ! by p3 end
								aclash tt
					{ (lt i n) = tt }
			| tt =>
					abbrev p1 = [vec_nth_tail_last ulit n c] in
					abbrev i_eq = [eqnatEq i n q2] in
					contra
					trans symm u
					trans hypjoin (null_terminated (vec_nth_tail c i)) ff by p1 i_eq end
								clash ff tt
					{ (lt i n) = tt }
			end
	| tt => q1
	end.

Define nth_tail_null_terminated_later :
  Forall(n:nat)(c:<vec ulit n>)
        (i:nat)
        (u1:{ (null_terminated (vec_nth_tail c i)) = tt })
        (u2:{ (eq_ulit (vec_get c i) ulit_null) = ff }).
    { (null_terminated (vec_nth_tail c (S i))) = tt }
  :=
  foralli(n:nat)(c:<vec ulit n>)
         (i:nat)
         (u1:{ (null_terminated (vec_nth_tail c i)) = tt })
         (u2:{ (eq_ulit (vec_get c i) ulit_null) = ff }).
	abbrev r = [null_terminated_nth_tail_implies_lt n c i u1] in
  % need p1: (vec_nth_tail c i) = (vecc (vec_get c i) ...)
	abbrev p1 = [vec_nth_tail_eq ulit n i c r] in
	abbrev u1' = trans cong (null_terminated *) symm p1
										u1 in
	hypjoin (null_terminated (vec_nth_tail c (S i))) tt by p1 u2 u1' end
	.


%=============================================================================
% [PRIVATE] null termination lemmas (word-based)
% DO NOT use these lemmas outside of this file
%=============================================================================

Define null_terminated_later2 :
  Forall(n:word)(c:<vec ulit (word_to_nat n)>)
        (i i':word)
        (x:ulit)
        (u1:{ (null_terminated (vec_nth_tail c (to_nat i))) = tt })
        (u2:{ i' = (word_inc_safe i) })
        (u3:{ x = (uwarray_get c i) })
        (u4:{ (eq_ulit x ulit_null) = ff }).
    { (null_terminated (vec_nth_tail c (to_nat i'))) = tt }
  := 
  foralli(n:word)(c:<vec ulit (word_to_nat n)>)
         (i i':word)
         (x:ulit)
         (u1:{ (null_terminated (vec_nth_tail c (to_nat i))) = tt })
         (u2:{ i' = (word_inc_safe i) })
         (u3:{ x = (uwarray_get c i) })
         (u4:{ (eq_ulit x ulit_null) = ff }).
  % want: (to_nat i') = (S (to_nat i))
  abbrev p1_1 = [word_inc_safe_implies_ltword i i' u2] in
  abbrev p1_2 = [ltword_implies_ltword_word_max i i' p1_1] in
  abbrev p1 = trans cong (to_nat *) u2
                    [word_inc_safe_word_to_nat i p1_2]
  in

  % want: (eq_ulit (vec_get c (to_nat i)) ulit_null) = ff
  abbrev p2 =
    trans join (eq_ulit (vec_get c (to_nat i)) ulit_null)
               (eq_ulit (uwarray_get c i) ulit_null)
    trans cong (eq_ulit * ulit_null) symm u3
          u4
  in

  % want: (null_terminated (vec_nth_tail c (to_nat i'))) = tt
  % have: (null_terminated (vec_nth_tail c (S (to_nat i)))) = tt
  trans cong (null_terminated (vec_nth_tail c *)) p1
        [nth_tail_null_terminated_later (to_nat wordlen n) c (to_nat wordlen i) u1 p2]
  .

Define null_terminated_nth_tail_implies_ltword :
  Forall(n:word)(c:<vec ulit (word_to_nat n)>)
				(i:word)
				(u:{ (null_terminated (vec_nth_tail c (to_nat i))) = tt })
    .{ (ltword i n) = tt }
  :=
	foralli(n:word)(c:<vec ulit (word_to_nat n)>)
				 (i:word)
				 (u:{ (null_terminated (vec_nth_tail c (to_nat i))) = tt })
	.
	case (ltword i n) by q1 _ with
		ff =>
			case (eqword i n) by q2 _ with
				ff =>
					abbrev q1' = hypjoin (lt (word_to_nat i) (word_to_nat n)) ff by q1 end in
					abbrev q2'_1 = [eqword_ff_neq i n q2] in
					abbrev q2' = [to_nat_inj2 wordlen i n q2'_1] in
					abbrev p1 = [lt_ff_neq_implies_lt (word_to_nat i) (word_to_nat n) q1' q2'] in
					abbrev p2 = [lt_leff (word_to_nat n) (word_to_nat i) p1] in
					abbrev p3 = [vec_nth_tail_abort ulit (word_to_nat n) c (word_to_nat i) p2] in
					contra
					trans symm u
					trans hypjoin (null_terminated (vec_nth_tail c (to_nat i))) abort ! by p3 end
								aclash tt
					{ (ltword i n) = tt }
			| tt =>
					abbrev p1 = [vec_nth_tail_last ulit (word_to_nat n) c] in
					abbrev i_eq = [eqword_eq i n q2] in
					contra
					trans symm u
					trans hypjoin (null_terminated (vec_nth_tail c (to_nat i))) ff by p1 i_eq end
								clash ff tt
					{ (ltword i n) = tt }
			end
	| tt => q1
	end.

Define null_terminated_implies_ltword_word0 :
  Forall(n:word)(c:<uwarray ulit n>)
        (u:{ (null_terminated c) = tt }).
    { (ltword word0 n) = tt }
  := foralli
	(n:word)(c:<uwarray ulit n>)
  (u:{ (null_terminated c) = tt })
	.
	case (ltword word0 n) by q1 _ with
	  ff =>
			% q1': (lt Z (to_nat n)) = ff
			abbrev q1' = hypjoin (lt Z (to_nat n)) ff by q1 end in
			case c with
				vecn _ =>
					contra
					trans symm u
					trans hypjoin (null_terminated c) ff by c_eq end
								clash ff tt
					{ (ltword word0 n) = tt }
			| vecc _ n' l c' =>
					abbrev n_eq = inj <vec ** *> c_Eq in
					contra
					trans symm q1'
					trans hypjoin (lt Z (to_nat n)) tt by n_eq end
								clash tt ff
					{ (ltword word0 n) = tt }
			end
	| tt => q1
	end.
 

%=============================================================================
% array_in_bounds lemmas
%=============================================================================

Define array_in_bounds_implies_null_terminated : Forall
	(nv:word)
	(n:nat)(c:<vec ulit n>)
	(u:{ (array_in_bounds nv c) = tt })
	.{ (null_terminated c) = tt }
  := foralli
	(nv:word)
	.
	induction(n:nat)(c:<vec ulit n>) return Forall
		(u:{ (array_in_bounds nv c) = tt })
		.{ (null_terminated c) = tt }
	with
	  vecn _ =>
	    foralli(u:{ (array_in_bounds nv c) = tt }).
	    contra
	    abbrev p1 = hypjoin (array_in_bounds nv c) ff by c_eq end in
	    trans symm p1
	    trans u
	    clash tt ff
	    { (null_terminated c) = tt }
	| vecc _ n' l c' =>
	    foralli(u:{ (array_in_bounds nv c) = tt }).
	    case (eq_ulit l ulit_null) by q1 _ with
	      ff =>
	         case (ltword word0 (ulit_vnum l)) by q2 _ with
		   ff =>
		     contra
		     abbrev p1 = hypjoin (array_in_bounds nv c) ff by c_eq q1 q2 end in
		     trans symm p1
		     trans u
		     clash tt ff
                     { (null_terminated c) = tt }		     
		 | tt =>
 	 	     case (leword (ulit_vnum l) nv) by q3 _ with
		       ff =>
		         contra
		         abbrev p1 = hypjoin (array_in_bounds nv c) ff by c_eq q1 q2 q3 end in
		         trans symm p1
		         trans u
		         clash tt ff
		         { (null_terminated c) = tt }
		     | tt =>
  		         abbrev u' = hypjoin (array_in_bounds nv c') tt by u c_eq q1 q2 q3 end in
  		         abbrev ih = [c_IH n' c' u'] in
		         hypjoin (null_terminated c) tt by c_eq ih q1 end
		     end
		 end
            | tt =>
	 	hypjoin (null_terminated c) tt by c_eq q1 end
	    end
	end.
	
Define array_in_bounds_implies_ltword_word0 :
  Forall(nv:word)
				(n:word)(l:<uwarray ulit n>)
				(u:{ (array_in_bounds nv l) = tt })
				.{ (ltword word0 n) = tt }
  :=
  foralli(nv:word)
				 (n:word)(l:<uwarray ulit n>)
				 (u:{ (array_in_bounds nv l) = tt })
	.
	cabbrev p1 = [array_in_bounds_implies_null_terminated nv (word_to_nat n) l u]
  % (lt Z (to_nat n)) = tt
  abbrev p2 = [null_terminated_implies_lt_Z (to_nat wordlen n) l p1] in
  trans join (ltword word0 n) (lt Z (to_nat n))
        p2

Define array_in_bounds_leword_0 :
  Forall(nv:word)
        (n:nat)(c:<vec ulit n>)
        (u:{ (array_in_bounds nv c) = tt }).
    { (leword (ulit_vnum (vec_get c Z)) nv) = tt }
  :=
  foralli(nv:word)
	 (n:nat)(c:<vec ulit n>)
	 (u:{ (array_in_bounds nv c) = tt }).
    case c with
      vecn _ =>
    	contra
    	trans symm u
    	trans hypjoin (array_in_bounds nv c) ff by c_eq end
    	clash ff tt
        { (leword (ulit_vnum (vec_get c Z)) nv) = tt  }
    | vecc _ n' l c' =>
         case (eq_ulit l ulit_null) by q1 _ with
	   ff =>
	     case (ltword word0 (ulit_vnum l)) by q2 _ with
	       ff =>
	         contra
		 trans symm u
		 trans hypjoin (array_in_bounds nv c) ff by c_eq q1 q2 end
		 clash ff tt
                 { (leword (ulit_vnum (vec_get c Z)) nv) = tt  }
	     | tt =>
                 case (leword (ulit_vnum l) nv) by q3 _ with
	           ff =>
             	     contra
    	             trans symm u
              	     trans hypjoin (array_in_bounds nv c) ff by c_eq q1 q2 q3 end
    	             clash ff tt
                     { (leword (ulit_vnum (vec_get c Z)) nv) = tt  }
	         | tt =>
	             hypjoin (leword (ulit_vnum (vec_get c Z)) nv) tt by c_eq q1 q2 q3 end
                 end
	     end
	 | tt =>
	       hypjoin (leword (ulit_vnum (vec_get c Z)) nv) tt by c_eq q1 [eqword_eq l ulit_null q1] [leword_word0 nv] end
	 end
    end

Define array_in_bounds_tail : Forall
	(nv:word)
	(n:nat)
	(l:ulit)
	(la:<vec ulit n>)
	(u1:{ (array_in_bounds nv (vecc l la)) = tt })
	(u2:{ (eq_ulit l ulit_null) = ff })
	.{ (array_in_bounds nv la) = tt }
	:= foralli
	(nv:word)
	(n:nat)
	(l:ulit)
	(la:<vec ulit n>)
	(u1:{ (array_in_bounds nv (vecc l la)) = tt })
	(u2:{ (eq_ulit l ulit_null) = ff })
	.
	case (ltword word0 (ulit_vnum l)) by q1 _ with
	  ff =>
	    contra
	    trans symm u1
	    trans hypjoin (array_in_bounds nv (vecc l la)) ff by q1 u2 end
	    clash ff tt
	    { (array_in_bounds nv la) = tt }
	| tt =>
	    case (leword (ulit_vnum l) nv) by q2 _ with
	      ff =>
		contra
		trans symm u1
		trans hypjoin (array_in_bounds nv (vecc l la)) ff by q1 q2 u2 end
		clash ff tt
		{ (array_in_bounds nv la) = tt }
	    | tt =>
		hypjoin (array_in_bounds nv la) tt by q1 q2 u2 u1 end
	    end
	 end


%=============================================================================
% array_bounds + vec_nth_tail lemmas (nat-based)
%=============================================================================
Define array_bounds_nth_tail_implies_lt :
  Forall(nv:word)
				(n:nat)(c:<vec ulit n>)
				(i:nat)
				(u:{ (array_in_bounds nv (vec_nth_tail c i)) = tt })
    .{ (lt i n) = tt }
  :=
	foralli(nv:word)
				 (n:nat)(c:<vec ulit n>)
				 (i:nat)
				 (u:{ (array_in_bounds nv (vec_nth_tail c i)) = tt })
	.
	case (lt i n) by q1 _ with
		ff =>
			case (eqnat i n) by q2 _ with
				ff =>
					abbrev q2' = [eqnat_ff_implies_neq i n q2] in
					abbrev p1 = [lt_ff_neq_implies_lt i n q1 q2'] in
					abbrev p2 = [lt_leff n i p1] in
					abbrev p3 = [vec_nth_tail_abort ulit n c i p2] in
					contra
					trans symm u
					trans hypjoin (array_in_bounds nv (vec_nth_tail c i)) abort ! by p3 end
								aclash tt
					{ (lt i n) = tt }
			| tt =>
					abbrev p1 = [vec_nth_tail_last ulit n c] in
					abbrev i_eq = [eqnatEq i n q2] in
					contra
					trans symm u
					trans hypjoin (array_in_bounds nv (vec_nth_tail c i)) ff by p1 i_eq end
								clash ff tt
					{ (lt i n) = tt }
			end
	| tt => q1
	end.

Define nth_tail_in_bounds_implies_null_terminated :
  Forall(nv:word)
        (n:nat)(c:<vec ulit n>)
        (i:nat)
        (u:{ (array_in_bounds nv (vec_nth_tail c i)) = tt }).
    { (null_terminated (vec_nth_tail c i)) = tt }
  := foralli
	(nv:word)
	(n:nat)(c:<vec ulit n>)
	(i:nat)
  (u:{ (array_in_bounds nv (vec_nth_tail c i)) = tt })
	.
	abbrev r_1 = [array_bounds_nth_tail_implies_lt nv n c i u] in
	abbrev r = [lt_implies_le i n r_1] in
	[array_in_bounds_implies_null_terminated nv (minus n i) (vec_nth_tail ulit n c i r) u]
	.

Define nth_tail_in_bounds_implies_le :
  Forall(nv:word)
        (n:nat)(c:<vec ulit n>)
        (i:nat)
        (u:{ (array_in_bounds nv (vec_nth_tail c i)) = tt }).
    { (le i n) = tt }
  := foralli
	(nv:word)
	(n:nat)(c:<vec ulit n>)
	(i:nat)
        (u:{ (array_in_bounds nv (vec_nth_tail c i)) = tt })
	.
	abbrev p1 = [array_bounds_nth_tail_implies_lt nv n c i u] in
	[lt_implies_le i n p1]
	.

Define nth_tail_in_bounds_implies_lt :
  Forall(nv:word)
        (n:nat)(c:<vec ulit n>)
        (i:nat)
        (u:{ (array_in_bounds nv (vec_nth_tail c i)) = tt }).
    { (lt i n) = tt }
  := foralli
	(nv:word)
	(n:nat)(c:<vec ulit n>)
	(i:nat)
        (u:{ (array_in_bounds nv (vec_nth_tail c i)) = tt })
	.
        [array_bounds_nth_tail_implies_lt nv n c i u].

Define nth_tail_in_bounds_leword_nth :
  Forall(nv:word)
        (n:nat)(c:<vec ulit n>)
        (i:nat)
        (u:{ (array_in_bounds nv (vec_nth_tail c i)) = tt }).
    { (leword (ulit_vnum (vec_get c i)) nv) = tt }
  :=
    foralli(nv:word)(n:nat)(c:<vec ulit n>)
           (i:nat)(u:{ (array_in_bounds nv (vec_nth_tail c i)) = tt }).
    [induction (n i:nat)(c:<vec ulit n>) return
    Forall(nv:word)(u:{ (array_in_bounds nv (vec_nth_tail c i)) = tt }).
             { (leword (ulit_vnum (vec_get c i)) nv) = tt }
    with
      vecn _ =>
        foralli(nv:word)(u:{ (array_in_bounds nv (vec_nth_tail c i)) = tt }).
        abbrev p1_1 = [nth_tail_in_bounds_implies_null_terminated nv n c i u] in
        abbrev p1 = [null_terminated_nth_tail_implies_lt n c i p1_1] in
        abbrev p2_1 = [vec_nth_tail_eq ulit n i c p1] in
	abbrev p2 = hypjoin (array_in_bounds nv (vec_nth_tail c i)) abort ! by c_eq p2_1 end in
	contra
	transs symm u
	       p2
	       aclash tt
	end
        { (leword (ulit_vnum (vec_get c i)) nv) = tt }
    | vecc _ n' l c' =>
        foralli(nv:word)(u:{ (array_in_bounds nv (vec_nth_tail c i)) = tt }).
        case i with
	  Z =>
	    abbrev u' = hypjoin (array_in_bounds nv c) tt by u i_eq end in
	    abbrev p1 = [array_in_bounds_leword_0 nv n c u'] in
	    hypjoin (leword (ulit_vnum (vec_get c i)) nv) tt by i_eq p1 end
	| S i' =>
	    abbrev u' = hypjoin (array_in_bounds nv (vec_nth_tail c' i')) tt by u i_eq c_eq end in
	    abbrev ih = [c_IH n' i' c' nv u'] in
	    hypjoin (leword (ulit_vnum (vec_get c i)) nv) tt by c_eq i_eq ih end
	end
    end n i c nv u].

Define vec_nth_tail_array_in_bounds_implies_lit_valid_nth : Forall
	(nv:word)
	(n:nat)(c:<vec ulit n>)
	(i:nat)
	(u1:{ (array_in_bounds nv (vec_nth_tail c i)) = tt })
	(u2:{ (eq_ulit (vec_get c i) ulit_null) = ff })
	.{ (lit_valid nv (to_lit (vec_get c i))) = tt }
  :=
  foralli(nv:word)
	 (n:nat)(c:<vec ulit n>)
	 (i:nat)
 	 (u1:{ (array_in_bounds nv (vec_nth_tail c i)) = tt })
	 (u2:{ (eq_ulit (vec_get c i) ulit_null) = ff }).
  abbrev r = [array_bounds_nth_tail_implies_lt nv n c i u1] in
  abbrev p1 = [vec_nth_tail_eq ulit n i c r] in
  
  case (ltword word0 (ulit_vnum (vec_get ulit n c i r))) by q1 _ with
    ff =>
      contra
      transs
        % another instance of hypjoin's incompleteness:
	% symm hypjoin (array_in_bounds nv (vec_nth_tail c i)) ff by p1 u2 q1 end
	symm trans cong (array_in_bounds nv *) p1
	     hypjoin (array_in_bounds nv (vecc (vec_get c i) (vec_nth_tail c (S i)))) ff by u2 q1 end
	u1
	clash tt ff
      end
      { (lit_valid nv (to_lit (vec_get c i))) = tt }
  | tt =>
      case (leword (ulit_vnum (vec_get ulit n c i r)) nv) by q2 _ with
        ff =>
	  contra
	  transs
  	    symm trans cong (array_in_bounds nv *) p1
              hypjoin (array_in_bounds nv (vecc (vec_get c i) (vec_nth_tail c (S i)))) ff by u2 q1 q2 end
	    u1
	    clash tt ff
	  end
          { (lit_valid nv (to_lit (vec_get c i))) = tt }
      | tt =>
          hypjoin (lit_valid nv (to_lit (vec_get c i))) tt by q1 q2 end
      end
  end

%=============================================================================
% array_in_bounds + vec_nth_tail (word-based)
%=============================================================================

Define nth_tail_in_bounds_the_rest :
  Forall(nv:word)
        (n:word)(c:<vec ulit (word_to_nat n)>)
        (i i':word)
        (x:ulit)
        (u1:{ (array_in_bounds nv (vec_nth_tail c (to_nat i))) = tt })
        (u2:{ i' = (word_inc_safe i) })
        (u3:{ x = (uwarray_get c i) })
        (u4:{ (eq_ulit x ulit_null) = ff }).
    { (array_in_bounds nv (vec_nth_tail c (to_nat i'))) = tt }
  :=
  foralli(nv:word)
         (n:word)(c:<vec ulit (word_to_nat n)>)
         (i i':word)
         (x:ulit)
         (u1:{ (array_in_bounds nv (vec_nth_tail c (to_nat i))) = tt })
         (u2:{ i' = (word_inc_safe i) })
         (u3:{ x = (uwarray_get c i) })
         (u4:{ (eq_ulit x ulit_null) = ff }).
    abbrev r = [array_bounds_nth_tail_implies_lt nv (word_to_nat n) c (word_to_nat i) u1] in
    abbrev p1 = [vec_nth_tail_eq ulit (word_to_nat n) (word_to_nat i) c r] in

    case (ltword word0 (ulit_vnum x)) by q1 _ with
      ff =>
        contra
        transs
          symm hypjoin (array_in_bounds nv (vec_nth_tail c (to_nat i))) ff by p1 u3 u4 q1 end
          u1
	  clash tt ff
	end
        { (array_in_bounds nv (vec_nth_tail c (to_nat i'))) = tt }
    | tt =>
        case (leword (ulit_vnum x) nv) by q2 _ with
          ff =>
            contra
            transs
	      symm hypjoin (array_in_bounds nv (vec_nth_tail c (to_nat i))) ff by p1 u3 u4 q1 q2 end
	      u1
	      clash tt ff
	    end
	    { (array_in_bounds nv (vec_nth_tail c (to_nat i'))) = tt }
        | tt =>
            abbrev u1' = trans cong (array_in_bounds nv *) symm p1 u1 in

            abbrev p2_1 = [word_inc_safe_implies_ltword i i' u2] in
            abbrev p2_2 = [ltword_implies_ltword_word_max i i' p2_1] in
            abbrev p2 = trans cong (to_nat *) u2
                          [word_inc_safe_word_to_nat i p2_2] in

            hypjoin (array_in_bounds nv (vec_nth_tail c (to_nat i'))) tt by u1' p2 u3 u4 q1 q2 end
        end
     end

Define nth_tail_in_bounds_implies_ltword : Forall
	(nv:word)
	(n:word)(c:<vec ulit (word_to_nat n)>)
	(i:word)
  (u:{ (array_in_bounds nv (vec_nth_tail c (word_to_nat i))) = tt })
	.{ (ltword i n) = tt }
	:= foralli
	(nv:word)
	(n:word)(c:<vec ulit (word_to_nat n)>)
	(i:word)
  (u:{ (array_in_bounds nv (vec_nth_tail c (word_to_nat i))) = tt })
	.
  cabbrev p1 = [nth_tail_in_bounds_implies_null_terminated nv (word_to_nat n) c (word_to_nat i) u]
  [null_terminated_nth_tail_implies_ltword n c i p1]

Define nth_tail_in_bounds_leword_nth2 :
  Forall(nv:word)
        (n:word)(c:<vec ulit (word_to_nat n)>)
        (i:word)(x:ulit)(v:word)
        (u1:{ (array_in_bounds nv (vec_nth_tail c (to_nat i))) = tt })
        (u2:{ x = (uwarray_get c i) })
        (u3:{ v = (ulit_vnum x) }).
    { (leword v nv) = tt }
  :=
  foralli(nv:word)
         (n:word)(c:<vec ulit (word_to_nat n)>)
         (i:word)(x:ulit)(v:word)
         (u1:{ (array_in_bounds nv (vec_nth_tail c (to_nat i))) = tt })
         (u2:{ x = (uwarray_get c i) })
         (u3:{ v = (ulit_vnum x) }).
  abbrev p1 = [nth_tail_in_bounds_leword_nth nv (word_to_nat n) c (word_to_nat i) u1] in
  hypjoin (leword v nv) tt by u2 u3 p1 end.

%-
Define nth_tail_in_bounds_implies_ltword_inc_nv :
  Forall(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
        (n:nat)(c:<vec ulit n>)
        (i:nat)(v:word)
        (u1:{ (array_in_bounds nv (vec_nth_tail c i)) = tt })
        (u2:{ v = (ulit_vnum (vec_get c i)) }).
    { (ltword v (inc_nv nv)) = tt }
  :=
  foralli(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
         (n:nat)(c:<vec ulit n>)
         (i:nat)(v:word)
         (u1:{ (array_in_bounds nv (vec_nth_tail c i)) = tt })
         (u2:{ v = (ulit_vnum (vec_get c i)) }).
  abbrev p1 = [nth_tail_in_bounds_leword_nth nv n c i u1] in
  abbrev p1' = hypjoin (leword v nv) tt by p1 u2 end in
  [leword_nv_implies_ltword_inc_nv nv nv_ub v p1']
  .

Define nth_tail_in_bounds_implies_lt_inc_nv :
  Forall(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
        (n:nat)(c:<vec ulit n>)
        (i:nat)(v:word)
        (u1:{ (array_in_bounds nv (vec_nth_tail c i)) = tt })
        (u2:{ v = (ulit_vnum (vec_get c i)) }).
    { (lt (to_nat v) (to_nat (inc_nv nv))) = tt }
  :=
  foralli(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
         (n:nat)(c:<vec ulit n>)
         (i:nat)(v:word)
         (u1:{ (array_in_bounds nv (vec_nth_tail c i)) = tt })
         (u2:{ v = (ulit_vnum (vec_get c i)) }).
  abbrev p1 = [nth_tail_in_bounds_leword_nth nv n c i u1] in
  abbrev p1' = hypjoin (leword v nv) tt by p1 u2 end in
  abbrev p2 = [leword_nv_implies_ltword_inc_nv nv nv_ub v p1'] in
  hypjoin (lt (to_nat v) (to_nat (inc_nv nv))) tt by p2 end
  .
-%


%=============================================================================
% the empty clause lemma
%=============================================================================

Define empty_array_empty_clause :
  Forall(n:nat)(c:<vec ulit n>)
        (u1:{ (lt Z n) = tt })
        (u2:{ (eq_ulit (vec_get c Z) ulit_null) = tt }).
             { (to_cl c) = nil }
  :=
  foralli(n:nat)(c:<vec ulit n>)
         (u1:{ (lt Z n) = tt })
         (u2:{ (eq_ulit (vec_get c Z) ulit_null) = tt }).
  % want: c = (vecc ulit_null c')
  case c with
    vecn _ =>
      % c_Eq : <uwarray ulit n> = <uwarray ulit Z>
      % have: n = Z
      abbrev p1 = inj <vec ulit *> c_Eq in
      contra
        trans hypjoin ff (lt Z n) by p1 end
        trans u1
              clash tt ff
        { (to_cl c) = nil }
  | vecc _ n' l c' =>
      % need: l = (vec_get c Z)
      abbrev p1 = hypjoin l (vec_get c Z) by c_eq end in
      abbrev p2 = hypjoin (eq_ulit l ulit_null) tt by p1 u2 end in
      hypjoin (to_cl c)
              nil by c_eq p2 end
  end.
