Include trusted "assignment.g".
Include trusted "lib-lemma.g".

%=============================================================================
% basic assignment lemmas
%=============================================================================

Define unegated_ulit_assignment_eq_negated_lit_assignment :
  Forall(l:ulit)
	.{ (ulit_assignment (unegated l)) = (lit_assignment (negated (to_lit l))) }
  := foralli(l:ulit).
	cabbrev v = (ulit_vnum l)
	cabbrev p1 = join (lt (to_nat 0x1f) wordlen) tt in
	cabbrev p2 = [negated_lit_sign (to_lit l)]
	cabbrev p6 = 
		case (ulit_sign l) by q1 _ with
		| ff =>
			cabbrev p3 = [word_set_read l 0x1f p1]
			cabbrev p4 = hypjoin (ulit_sign (unegated l)) tt by p3 q1 end
			cabbrev p5 = hypjoin (lit_sign (negated (to_lit l))) tt by p2 q1 end
			trans p4 symm p5
		| tt =>
			cabbrev p3 = [word_clear_read l 0x1f p1]
			cabbrev p4 = hypjoin (ulit_sign (unegated l)) ff by p3 q1 end
			cabbrev p5 = hypjoin (lit_sign (negated (to_lit l))) ff by p2 q1 end
			trans p4 symm p5
		end
	hypjoin (ulit_assignment (unegated l)) (lit_assignment (negated (to_lit l))) by p6 end

Define lit_assignment_TT_pos_lit_vnum := foralli(l:lit)(u:{ (lit_assignment l) = TT }).
  case (lit_sign l) by q1 _ with
	| ff => contra
		trans symm u
		trans hypjoin (lit_assignment l) FF by q1 end
					clash FF TT
		{ l = (pos (lit_vnum l)) }
	| tt =>
		symm [lit_sign_tt_implies_lit_vnum_pos_eq l q1]
	end

Define lit_assignment_FF_neg_lit_vnum := foralli(l:lit)(u:{ (lit_assignment l) = FF }).
  case (lit_sign l) by q1 _ with
	| ff =>
		symm [lit_sign_ff_implies_lit_vnum_neg_eq l q1]
	| tt => contra
		trans symm u
		trans hypjoin (lit_assignment l) TT by q1 end
					clash TT FF
		{ l = (neg (lit_vnum l)) }
	end
	
Define lit_assignment_is_assigned : Forall
  (l:lit)
	.{ (is_assigned (lit_assignment l)) = tt }
	:=
	foralli(l:lit).
	case (lit_sign l) by q _ with
	  default bool => hypjoin (is_assigned (lit_assignment l)) tt by q end
	end.

Define lit_assignment_is_equal_assignment : Forall
  (l:lit)
	.{ (is_equal_assignment (lit_assignment l) (lit_sign l)) = tt }
	:=
	foralli(l:lit).
	case (lit_sign l) by q _ with
	| default bool =>
		hypjoin (is_equal_assignment (lit_assignment l) (lit_sign l)) tt by q end
	end.

Define unassigned_implies_not_equal_assignment : Forall
	(a:assignment)(s:bool)
	(u1:{ (is_assigned a) = ff })
	.{ (is_equal_assignment a s) = ff }
	:= foralli
	(a:assignment)(s:bool)
	(u1:{ (is_assigned a) = ff })
	.
	case a with
	| UN => hypjoin (is_equal_assignment a s) ff by a_eq end
	| TT => contra
		trans symm u1
		trans hypjoin (is_assigned a) tt by a_eq end
					clash tt ff
		{ (is_equal_assignment a s) = ff }
	| FF => contra
		trans symm u1
		trans hypjoin (is_assigned a) tt by a_eq end
					clash tt ff
		{ (is_equal_assignment a s) = ff }
	end

Define is_equal_assignment_lem1 : Forall
	(a:assignment)(s s':bool)
	(u1:{ (is_equal_assignment a s) = tt })
	(u2:{ s != s' })
	.{ (is_equal_assignment a s') = ff }
	:= foralli
	(a:assignment)(s s':bool)
	(u1:{ (is_equal_assignment a s) = tt })
	(u2:{ s != s' })
	.
	case a with
	| UN => contra
		trans symm u1
		trans hypjoin (is_equal_assignment a s) ff by a_eq end
		      clash ff tt
		{ (is_equal_assignment a s') = ff }
	| TT =>
		cabbrev p1 = hypjoin s tt by a_eq u1 end
		case s' with
		| ff =>
			hypjoin (is_equal_assignment a s') ff by a_eq s'_eq end
		| tt => contra
			trans hypjoin s s' by p1 s'_eq end
						symm u2
			{ (is_equal_assignment a s') = ff }
		end
	| FF =>
		cabbrev p1 = hypjoin s ff by a_eq u1 [not_not s] end
		case s' with
		| ff => contra
			trans hypjoin s s' by p1 s'_eq end
						symm u2
			{ (is_equal_assignment a s') = ff }
		| tt =>
			hypjoin (is_equal_assignment a s') ff by a_eq s'_eq end
		end
	end

Define is_equal_assignment_lem2 :
  Forall(a:assignment)(l:lit)
        (u:{ (is_equal_assignment a (lit_sign l)) = tt })
  .{ a = (lit_assignment l) }
  :=
  foralli(a:assignment)(l:lit)(u:{ (is_equal_assignment a (lit_sign l)) = tt }).
  case a with
    | UN => 
      contra
        trans hypjoin ff (is_equal_assignment a (lit_sign l)) by a_eq end
        trans u
              clash tt ff

        { a = (lit_assignment l) }
    | TT =>
      hypjoin a (lit_assignment l) by a_eq u end 
    | FF =>
      abbrev p0 = hypjoin (not ff) (not (lit_sign l)) by a_eq u end in
      abbrev p1 = [not_injective ff (lit_sign l) p0] in
      hypjoin a (lit_assignment l) by a_eq p1 end
  end.


%=============================================================================
% all_lits_are_assigned
%=============================================================================

Define all_lits_are_assigned := fun all_lits_are_assigned
  (spec nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (vt:<uwarray assignment (inc_nv nv nv_ub)>)
  (c:clause)(u:{ (cl_valid nv c) = tt })
  : bool.
  match c with
    nil _ => tt
  | cons _ l c' =>
      abbrev p1 = [cl_valid_implies_lit_valid_head2 nv c l c' u c_eq] in
      abbrev p2 = [lit_valid_implies_ltword_inc_nv nv nv_ub l p1] in
      abbrev u' = [cl_valid_implies_cl_valid_tail2 nv c l c' u c_eq] in
      let a = (uwarray_get assignment (inc_nv nv nv_ub) vt (lit_vnum l) p2) in
      match (is_equal_assignment a (lit_sign l)) with
        ff => ff
      | tt => (all_lits_are_assigned nv nv_ub vt c' u')
      end
  end.

Define all_lits_are_assigned_implies_head_is_equal_assignment : Forall
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt:<uwarray assignment (inc_nv nv nv_ub)>)
	(l:lit)
	(c:clause)
	(u:{ (lit_valid nv l) = tt })
	(r:{ (all_lits_are_assigned vt (cons l c)) = tt })
	.{ (is_equal_assignment (uwarray_get vt (lit_vnum l)) (lit_sign l)) = tt }
  := foralli
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt:<uwarray assignment (inc_nv nv nv_ub)>)
	(l:lit)
	(c:clause)
	(u:{ (lit_valid nv l) = tt })
	(r:{ (all_lits_are_assigned vt (cons l c)) = tt })
	.
	cabbrev nv' = (inc_nv nv nv_ub)
	cabbrev p1 = [lit_valid_implies_ltword_inc_nv nv nv_ub l u]
	cabbrev a = (uwarray_get assignment nv' vt (lit_vnum l) p1)
	case (is_equal_assignment a (lit_sign l)) by q1 _ with
		ff =>
			contra
			trans symm r
			trans hypjoin (all_lits_are_assigned vt (cons l c)) ff by q1 end
						clash ff tt
			{ (is_equal_assignment a (lit_sign l)) = tt }
	| tt =>
			q1
	end.

Define all_lits_are_assigned_lem1 : Forall
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt vt':<uwarray assignment (inc_nv nv nv_ub)>)
	(l:lit)
	(u:{ (is_assigned (uwarray_get vt (lit_vnum l))) = ff })
	(vt'_eq:{ vt' = (uwarray_set vt (lit_vnum l) (lit_assignment l)) })
	(c:clause)
	(u1:{ (all_lits_are_assigned vt c) = tt })
	(u3:{ (cl_valid nv c) = tt })
	.{ (all_lits_are_assigned vt' (cons l c)) = tt }
  := foralli
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt vt':<uwarray assignment (inc_nv nv nv_ub)>)
	(l:lit)
	(u:{ (is_assigned (uwarray_get vt (lit_vnum l))) = ff })
	(vt'_eq:{ vt' = (uwarray_set vt (lit_vnum l) (lit_assignment l)) })
	.
	abbrev nv' = (inc_nv nv nv_ub) in
	abbrev v = (lit_vnum l) in
	abbrev p1 = [uwarray_set_implies_ltword assignment nv' vt vt' v (lit_assignment l) vt'_eq] in
	abbrev p2 = [uwarray_set_get assignment nv' vt v (lit_assignment l) p1] in
	abbrev p3 = [lit_assignment_is_equal_assignment l] in
	abbrev p4 = hypjoin (is_equal_assignment (uwarray_get vt' v) (lit_sign l)) tt by vt'_eq p2 p3 end in
	induction(c:clause) return Forall
		(u1:{ (all_lits_are_assigned vt c) = tt })
		(u3:{ (cl_valid nv c) = tt })
		.{ (all_lits_are_assigned vt' (cons l c)) = tt }
	with
		nil _ => foralli
			(u1:{ (all_lits_are_assigned vt c) = tt })
			(u3:{ (cl_valid nv c) = tt })
			.
			hypjoin (all_lits_are_assigned vt' (cons l c)) tt by c_eq p4 end
	| cons _ x c' => foralli
			(u1:{ (all_lits_are_assigned vt c) = tt })
			(u3:{ (cl_valid nv c) = tt })
			.
			% want: (all_lits_are_assigned vt' c') = tt
			% need: IH
			abbrev u1' = hypjoin (all_lits_are_assigned vt (cons x c')) tt by c_eq u1 end in
			abbrev u3' = hypjoin (cl_valid nv (cons x c')) tt by c_eq u3 end in
			abbrev p5 = [cl_valid_implies_lit_valid_head nv x c' u3'] in
			abbrev p6 = [lit_valid_implies_ltword_inc_nv nv nv_ub x p5] in
			
			% want p7: (is_equal_assignment (uwarray_get vt (lit_vnum x)) (lit_sign x)) = tt
			abbrev p7 = [all_lits_are_assigned_implies_head_is_equal_assignment nv nv_ub vt x c' p5 u1'] in
			abbrev p8 = hypjoin (all_lits_are_assigned vt c') tt by c_eq u1 p7 end in
			abbrev p9 = [cl_valid_implies_cl_valid_tail nv x c' u3'] in
			
			abbrev ih = [c_IH c' p8 p9]in
			abbrev p10 = hypjoin (all_lits_are_assigned vt' c') tt by ih p4 end in
			
			cabbrev a' = (uwarray_get assignment nv' vt' (lit_vnum x) p6)
			% want: (is_equal_assignment a' (lit_sign x)) = tt
			abbrev p11 =
				case (eq_lit x l) by q2 _ with
				| ff =>
					case (eqword (lit_vnum x) v) by q1 _ with
					| ff =>
						% need: (lit_vnum x) != (lit_vnum l)
						abbrev p11 = [eqword_neq (lit_vnum x) v q1] in
						abbrev p12 = [uwarray_set_get_distinct assignment nv' vt (lit_vnum x) v (lit_assignment l) p6 p1 p11] in
						hypjoin (is_equal_assignment a' (lit_sign x)) tt by p12 vt'_eq p7 end
					| tt =>
						abbrev p11 = [eqword_eq (lit_vnum x) v q1] in
						cabbrev a = (uwarray_get assignment nv' vt (lit_vnum x) p6)
						abbrev u' = hypjoin (is_assigned a) ff by u p11 end
						contra
						trans symm [unassigned_implies_not_equal_assignment a (lit_sign x) u']
						trans hypjoin (is_equal_assignment a (lit_sign x)) tt by p7 end
									clash tt ff
						{ (is_equal_assignment a' (lit_sign x)) = tt }
					end
				| tt =>
					cabbrev p11 = [eq_lit_eq x l q2]
					hypjoin (is_equal_assignment a' (lit_sign x)) tt by p11 p4 end
				end
			hypjoin (all_lits_are_assigned vt' (cons l c)) tt by p10 p11 c_eq p4 end
	end.

Define all_lits_are_assigned_lem2 :
  Forall(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
        (vt:<uwarray assignment (inc_nv nv nv_ub)>)
        (c:clause)
        (l:lit)
				(u:{ (cl_valid nv c) = tt })
        (q1:{ (all_lits_are_assigned vt c) = tt })
        (q2:{ (uwarray_get vt (lit_vnum l)) = UN })
    .{ (cl_has c l) = ff }
  := foralli
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt:<uwarray assignment (inc_nv nv nv_ub)>)
	.
	induction(c:clause) return Forall
		(l:lit)
		(u:{ (cl_valid nv c) = tt })
		(q1:{ (all_lits_are_assigned vt c) = tt })
		(q2:{ (uwarray_get vt (lit_vnum l)) = UN })
    .{ (cl_has c l) = ff }
	with
	| nil _ => foralli
		(l:lit)
		(u:{ (cl_valid nv c) = tt })
		(q1:{ (all_lits_are_assigned vt c) = tt })
		(q2:{ (uwarray_get vt (lit_vnum l)) = UN })
		.
		hypjoin (cl_has c l) ff by c_eq end
	| cons _ x c' => foralli
		(l:lit)
		(u:{ (cl_valid nv c) = tt })
		(q1:{ (all_lits_are_assigned vt c) = tt })
		(q2:{ (uwarray_get vt (lit_vnum l)) = UN })
		.
		cabbrev p1_1 = hypjoin (cl_valid nv (cons x c')) tt by u c_eq end
		cabbrev p1 = [cl_valid_implies_lit_valid_head nv x c' p1_1]
		cabbrev r1 = trans cong (all_lits_are_assigned vt *) symm c_eq
											 q1
		% p2: (is_equal_assignment ...x...) = tt
		cabbrev p2 = [all_lits_are_assigned_implies_head_is_equal_assignment nv nv_ub vt x c' p1 r1]
		case (eq_lit l x) by q3 _ with
		| ff =>
			cabbrev u' = [cl_valid_implies_cl_valid_tail nv x c' p1_1]
			cabbrev p3 = hypjoin (all_lits_are_assigned vt c') tt by q1 p2 c_eq end
			cabbrev ih = [c_IH c' l u' p3 q2]
			hypjoin (cl_has c l) ff by q3 ih c_eq end
		| tt =>
			cabbrev l_eq_x = [eq_lit_eq l x q3]
			cabbrev p2' = hypjoin (is_equal_assignment (vec_get vt (word_to_nat (lit_vnum x))) (lit_sign x)) tt by p2 end
			cabbrev q2' = hypjoin (vec_get vt (word_to_nat (lit_vnum l))) UN by q2 end
			contra
			trans symm p2'
			trans cong (is_equal_assignment (vec_get vt (word_to_nat (lit_vnum *))) (lit_sign x)) symm l_eq_x
			trans cong (is_equal_assignment * (lit_sign x)) q2'
			trans join (is_equal_assignment UN (lit_sign x)) ff
			      clash ff tt
			{ (cl_has c l) = ff }
		end
	end

Define forall_lits_are_assigned : Forall
  (nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (vt:<uwarray assignment (inc_nv nv nv_ub)>)
  (c:clause)
	(u:Forall(l:lit)(r:{ (cl_has c l) = tt })
			.{ (is_equal_assignment (uwarray_get vt (lit_vnum l)) (lit_sign l)) = tt })
  .{ (all_lits_are_assigned vt c) = tt }
  := foralli
  (nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (vt:<uwarray assignment (inc_nv nv nv_ub)>)
	.
	induction(c:clause) return Forall
		(u:Forall(l:lit)(r:{ (cl_has c l) = tt })
				.{ (is_equal_assignment (uwarray_get vt (lit_vnum l)) (lit_sign l)) = tt })
		.{ (all_lits_are_assigned vt c) = tt }
	with
	| nil _ => foralli
		(u:Forall(l:lit)(r:{ (cl_has c l) = tt })
				.{ (is_equal_assignment (uwarray_get vt (lit_vnum l)) (lit_sign l)) = tt })
		.
		hypjoin (all_lits_are_assigned vt c) tt by c_eq end
	| cons _ x c' => foralli
		(u:Forall(l:lit)(r:{ (cl_has c l) = tt })
				.{ (is_equal_assignment (uwarray_get vt (lit_vnum l)) (lit_sign l)) = tt })
		.
		% IH
		cabbrev u' =
			foralli(l:lit)(r:{ (cl_has c' l) = tt })
			.
			cabbrev p1_1 = [cl_has_tt_cons c' l x r]
			cabbrev p1 = hypjoin (cl_has c l) tt by p1_1 c_eq end
			[u l p1]
		cabbrev ih = [c_IH c' u']
		
		% x is assigned
		cabbrev p2_1 = hypjoin (cl_has c x) tt by c_eq [eq_lit_refl x] end
		cabbrev p2 = [u x p2_1]
		
		hypjoin (all_lits_are_assigned vt c) tt by p2 ih c_eq end
	end


Define all_lits_are_assigned_implies_any_is_equal_assignment : Forall
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt:<uwarray assignment (inc_nv nv nv_ub)>)
	(c:clause)
	(u1:{ (cl_valid nv c) = tt })
	(u2:{ (all_lits_are_assigned vt c) = tt })
	(l:lit)
	(r:{ (cl_has c l) = tt })
	.{ (is_equal_assignment (uwarray_get vt (lit_vnum l)) (lit_sign l)) = tt }
  := foralli
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt:<uwarray assignment (inc_nv nv nv_ub)>)
	.
	induction(c:clause) return Forall
		(u1:{ (cl_valid nv c) = tt })
		(u2:{ (all_lits_are_assigned vt c) = tt })
		(l:lit)
		(r:{ (cl_has c l) = tt })
		.{ (is_equal_assignment (uwarray_get vt (lit_vnum l)) (lit_sign l)) = tt }
	with
	| nil _ => foralli
		(u1:{ (cl_valid nv c) = tt })
		(u2:{ (all_lits_are_assigned vt c) = tt })
		(l:lit)
		(r:{ (cl_has c l) = tt })
		.
		contra
		trans symm r
		trans hypjoin (cl_has c l) ff by c_eq end
					clash ff tt
		{ (is_equal_assignment (uwarray_get vt (lit_vnum l)) (lit_sign l)) = tt }
	| cons _ x c' => foralli
		(u1:{ (cl_valid nv c) = tt })
		(u2:{ (all_lits_are_assigned vt c) = tt })
		(l:lit)
		(r:{ (cl_has c l) = tt })
		.
		cabbrev p1_1 = hypjoin (cl_valid nv (cons x c')) tt by u1 c_eq end
		cabbrev p1 = [cl_valid_implies_lit_valid_head nv x c' p1_1]
		cabbrev p2_1 = hypjoin (all_lits_are_assigned vt (cons x c')) tt by u2 c_eq end
		cabbrev p2 = [all_lits_are_assigned_implies_head_is_equal_assignment nv nv_ub vt x c' p1 p2_1]

		cabbrev u1' = [cl_valid_implies_cl_valid_tail nv x c' p1_1] 
		cabbrev u2' = hypjoin (all_lits_are_assigned vt c') tt by c_eq p2 u2 end
		case (eq_lit l x) by q1 _ with
		| ff =>
			cabbrev r' = hypjoin (cl_has c' l) tt by q1 c_eq r end
			[c_IH c' u1' u2' l r']
		| tt =>
			cabbrev p3 = [eq_lit_eq l x q1]
			hypjoin (is_equal_assignment (uwarray_get vt (lit_vnum l)) (lit_sign l)) tt by p3 p2 end
		end
	end


%=============================================================================
% cl_has_all_vars
%=============================================================================

Define check_h_h1 :
  Forall (n n':nat)
  			 (i:word)
         (u1:{ (le (plus n (to_nat i)) (to_nat var_upper_bound)) = tt })
         (n_eq:{ n = (S n') })	% n is not zero
  .{ (ltword i var_upper_bound) = tt }
  :=
  foralli(n n':nat)
  			 (i:word)
         (u1:{ (le (plus n (to_nat i)) (to_nat var_upper_bound)) = tt })
         (n_eq:{ n = (S n') })
  .
  cabbrev u1' = trans cong (le (plus * (to_nat i)) (to_nat var_upper_bound)) symm n_eq
  									  u1
	cabbrev p1 = [le_plus_S_implies_lt n' (word_to_nat i) (word_to_nat var_upper_bound) u1']
	cabbrev p2 = [lt_trans_le (word_to_nat i) (word_to_nat var_upper_bound) (word_to_nat word_max) p1 lt_var_upper_bound_word_max]
	trans [ltword_to_lt i var_upper_bound]
				p1

Define check_h_h1' :
  Forall (n n':nat)
  			 (i:word)
         (u1:{ (le (plus n (to_nat i)) (to_nat var_upper_bound)) = tt })
         (n_eq:{ n = (S n') })	% n is not zero
  .{ (word_msb i) = ff }
  :=
  foralli(n n':nat)
  			 (i:word)
         (u1:{ (le (plus n (to_nat i)) (to_nat var_upper_bound)) = tt })
         (n_eq:{ n = (S n') })
  .
	cabbrev p3 = [check_h_h1 n n' i u1 n_eq]
	[ltword_upper_bound_implies_msb_ff i p3]

Define check_h_h2 :
  Forall (n n':nat)
				 (i i':word)
         (n_eq:{ n = (S n') })
         (i'_eq:{ i' = (word_inc_safe i) })
         (u:{ (le (plus n (to_nat i)) (to_nat var_upper_bound)) = tt })
    .{ (le (plus n' (to_nat i')) (to_nat var_upper_bound)) = tt }
  :=
  foralli(n n':nat)
				 (i i':word)
         (n_eq:{ n = (S n') })
         (i'_eq:{ i' = (word_inc_safe i) })
         (u:{ (le (plus n (to_nat i)) (to_nat var_upper_bound)) = tt })
  .
	% need: (S (to_nat i)) = (to_nat i')
	cabbrev p2_1 = [word_inc_safe_implies_ltword i i' i'_eq]
	cabbrev p2_2 = [ltword_implies_ltword_word_max i i' p2_1]
	cabbrev p2_3 = [word_inc_safe_word_to_nat i p2_2]
	cabbrev p2 = hypjoin (S (to_nat i)) (to_nat i') by p2_3 i'_eq end
  % need: (plus n (to_nat i)) = (plus n' (to_nat i'))
  cabbrev p1 = hypjoin (plus n (to_nat i)) (plus n' (to_nat i')) by [plusS_hop n' (word_to_nat i)] n_eq p2 end
  trans cong (le * (to_nat var_upper_bound)) symm p1
        u
  .

Define spec check_var :=
	fun(c:clause)(a:assignment)
		 (vn:word)(u:{ (word_msb vn) = ff })
	.
	match a with
		UN => tt
	| TT => (cl_has c (pos vn u))
	| FF => (cl_has c (neg vn u))
	end.

Define check_var_total : Forall
	(c:clause)(a:assignment)(vn:word)(u:{ (word_msb vn) = ff })
	.Exists(b:bool).{ (check_var c a vn) = b }
	:= foralli
	(c:clause)(a:assignment)(vn:word)(u:{ (word_msb vn) = ff })
	.
	case a with
	| UN =>
		existsi tt { (check_var c a vn) = * }
		hypjoin (check_var c a vn) tt by a_eq end
	| TT =>
		cabbrev b = (cl_has c (pos vn u))
		existsi b { (check_var c a vn) = * }
		hypjoin (check_var c a vn) b by a_eq end 
	| FF =>
		cabbrev b = (cl_has c (neg vn u))
		existsi b { (check_var c a vn) = * }
		hypjoin (check_var c a vn) b by a_eq end 
	end

Total check_var check_var_total.

Define check_var_lem1 :=
	foralli(a:assignment)
         (vn:word)(u:{ (word_msb vn) = ff })
         (r:{ (check_var nil a vn) = tt }).
  case a with
    UN => a_eq
  | TT =>
      abbrev p1 = join (cl_has nil (pos vn u)) ff in
      abbrev p2 = trans hypjoin (cl_has nil (pos vn u)) (check_var nil a vn) by a_eq end
                        r in
      contra trans symm p1
             trans p2
                   clash tt ff
        { a = UN }
  | FF =>
      abbrev p1 = join (cl_has nil (pos vn u)) ff in
      abbrev p2 = trans hypjoin (cl_has nil (pos vn u)) (check_var nil a vn) by a_eq end
                        r in
      contra trans symm p1
             trans p2
                   clash tt ff
        { a = UN }
  end
  .

Define spec cl_has_all_vars_h := fun cl_has_all_vars_h
  (c:clause)
	(spec n:nat)(vt:<vec assignment n>)
  (i:word)
  (u1:{ (le (plus n (to_nat i)) (to_nat var_upper_bound)) = tt })
  : bool.
  match vt with
    vecn _ => tt
  | vecc _ n' a vt' =>
			cabbrev n_eq = inj <vec assignment *> vt_Eq
			% p1:{ (ltword i var_upper_bound) = tt }
			cabbrev p1 = [check_h_h1 n n' i u1 n_eq]
			cabbrev p2 = [ltword_upper_bound_implies_msb_ff i p1]
			match (check_var c a i p2) with
				ff => ff
			| tt =>
					cabbrev p2 = [ltword_implies_ltword_word_max i var_upper_bound p1]
					let i' = (word_inc_safe i p2)
					cabbrev u1' = [check_h_h2 n n' i i' n_eq i'_eq u1]
					(cl_has_all_vars_h c n' vt' i' u1')
			end
  end.

Define cl_has_all_vars_h_lem1 :
	Forall (c:clause)
				 (i:word)
				 (a:assignment)
         (n':nat)(vt':<vec assignment n'>)
	       (u:{ (le (plus (S n') (to_nat i)) (to_nat var_upper_bound)) = tt })
				 (r:{ (cl_has_all_vars_h c (vecc a vt') i) = tt })
    .{ (check_var c a i) = tt }
  :=
	foralli(c:clause)
				 (i:word)
				 (a:assignment)
         (n':nat)(vt':<vec assignment n'>)
	       (u:{ (le (plus (S n') (to_nat i)) (to_nat var_upper_bound)) = tt })
				 (r:{ (cl_has_all_vars_h c (vecc a vt') i) = tt }).
	cabbrev p5 = [check_h_h1' (S n') n' i u refl (S n')] in
	case (check_var c a i p5) by q1 _ with
		ff => contra
						trans symm hypjoin (cl_has_all_vars_h c (vecc a vt') i) ff by q1 end
						trans r
									clash tt ff
						{ (check_var c a i) = tt }
	| tt => q1
	end.

Define cl_has_all_vars_h_step : Forall
  (c:clause)
	(n:nat)(a:assignment)(vt:<vec assignment n>)
  (i:word)
  (u:{ (le (plus (S n) (to_nat i)) (to_nat var_upper_bound)) = tt })
	(r:{ (cl_has_all_vars_h c (vecc a vt) i) = tt })
	.{ (cl_has_all_vars_h c vt (word_inc_safe i)) = tt }
	:= foralli
  (c:clause)
	(n:nat)(a:assignment)(vt:<vec assignment n>)
  (i:word)
  (u:{ (le (plus (S n) (to_nat i)) (to_nat var_upper_bound)) = tt })
	(r:{ (cl_has_all_vars_h c (vecc a vt) i) = tt })
	.
	cabbrev p1 = [check_h_h1' (S n) n i u refl (S n)]
	case (check_var c a i p1) by q1 _ with
	| ff =>
		contra
		trans symm r
		trans hypjoin (cl_has_all_vars_h c (vecc a vt) i) ff by q1 end
					clash ff tt
		{ (cl_has_all_vars_h c vt (word_inc_safe i)) = tt }
	| tt =>
		hypjoin (cl_has_all_vars_h c vt (word_inc_safe i)) tt by q1 r end
	end

Define spec cl_has_all_vars := fun
  (c:clause)
	(spec nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt:<uwarray assignment (inc_nv nv nv_ub)>)
  .
  cabbrev nv' = (inc_nv nv nv_ub)
  cabbrev n = (word_to_nat nv')
  cabbrev p1_1 = [plusZ n]
	cabbrev p1 = hypjoin (plus n (to_nat word0)) n by p1_1 end
  abbrev p2_1 = [leword_inc_nv_var_upper_bound nv nv_ub] in
  abbrev p2 = trans cong (le * (to_nat var_upper_bound)) p1
              trans symm [leword_to_le nv' var_upper_bound]
                    p2_1
  in
  (cl_has_all_vars_h c n vt word0 p2)
  .

% only for cl_has_all_vars_lem2
Define cl_has_all_vars_lem2_h1 :
	Forall (c:clause)
         (n:nat)
         (n_ub:{ (le n (to_nat var_upper_bound)) = tt })
         (vt:<vec assignment n>)
				 (u1:{ (cl_has_all_vars c vt) = tt })
				 (i:word)
	       (u2:{ (lt (to_nat i) n) = tt })
    .{ (cl_has_all_vars_h c (vec_nth_tail vt (to_nat i)) i) = tt }
  :=
  foralli(c:clause)
         (n:nat)
				 (n_ub:{ (le n (to_nat var_upper_bound)) = tt })
         (vt:<vec assignment n>)
				 (u1:{ (cl_has_all_vars c vt) = tt })
				 (i:word)
	       (r1:{ (lt (to_nat i) n) = tt })
  .
	[
	induction(j:nat) return Forall
	  (i:word)
		(i_eq:{ (to_nat i) = j })
		(r1:{ (lt j n) = tt })
		.{ (cl_has_all_vars_h c (vec_nth_tail vt j) i) = tt }
	with
	| Z => foralli
	  (i:word)
		(i_eq:{ (to_nat i) = j })
		(r1:{ (lt j n) = tt })
		.
		cabbrev p1_1 = hypjoin (to_nat i) Z by j_eq i_eq end
		cabbrev p1 = [word_to_nat_Z_implies_word0 i p1_1]
		hypjoin (cl_has_all_vars_h c (vec_nth_tail vt j) i) tt by j_eq p1 u1 end
			
	| S j' => foralli
	  (i:word)
		(i_eq:{ (to_nat i) = j })
		(r1:{ (lt j n) = tt })
		.
		cabbrev r1'_1 = hypjoin (lt (S j') n) tt by r1 j_eq end
		cabbrev r1' = [Sa_lt_implies_a_lt j' n r1'_1]
		cabbrev p4 = [lt_implies_le j' n r1']
		cabbrev t = (vec_nth_tail assignment n vt j' p4)
		case t with
		| vecn _ =>
			% r1': j < n
			cabbrev p1_1 = inj <vec ** *> t_Eq	% (minus n j') = Z
			cabbrev p1 = [minus_eq_Z n j' p1_1]	% n = j'
			contra
			trans [lt_implies_neq j' n r1']	% j' != n
				    p1
			{ (cl_has_all_vars_h c (vec_nth_tail vt j) i) = tt }
		| vecc _ n' a t' =>
			% p1: (ltword word0 i) = tt
			cabbrev p1 = hypjoin (ltword word0 i) tt by i_eq j_eq end
			cabbrev i' = (word_dec_safe i p1)
			
			% p2: (to_nat i') = j'
			cabbrev p2_1 = [word_dec_safe_to_nat i p1]
			cabbrev p2_2 = transs p2_1 i_eq j_eq end
			cabbrev p2 = inj (S *) p2_2

			% p6: (le (plus (S n') (to_nat i')) (to_nat var_upper_bound)) = tt
			% p5: (S n') = (minus n j')
			cabbrev p5 = inj <vec ** *> t_Eq
			cabbrev p6_1 = hypjoin (lt (S j') n) tt by j_eq r1 end
			cabbrev p6_2 = [Sa_lt_implies_a_lt j' n p6_1]
			cabbrev p6_3 = [lt_implies_le j' n p6_2]
			cabbrev p6_4 =
				transs
					cong (plus * (to_nat i')) symm p5
					cong (plus (minus n j') *) p2
					[plus_comm (minus n j') j']
					[plus_minus_le j' n p6_3]
				end
			cabbrev p6 = trans cong (le * (to_nat var_upper_bound)) p6_4
												 n_ub
													
			% p7: (cl_has_all_vars_h c t' (word_inc_safe i')) = tt
			% ih: (cl_has_all_vars_h t i') = tt
			cabbrev ih = [j_IH j' i' p2 r1']
			cabbrev ih' = trans cong (cl_has_all_vars_h c * i') symm t_eq
													ih
			cabbrev p7 = [cl_has_all_vars_h_step c n' a t' i' p6 ih']
			
			cabbrev p3_1 = trans symm t_eq [vec_nth_tail_eq assignment n j' vt r1']
			cabbrev p3_2 = inj (vecc ** *) p3_1
			cabbrev p3 = hypjoin (vec_nth_tail vt j) t' by p3_2 j_eq end
			cabbrev p8 = [word_dec_inc_safe i p1]
			
			trans cong (cl_has_all_vars_h c * i) p3
			trans cong (cl_has_all_vars_h c t' *) symm p8
			      p7
		end
	end
	(word_to_nat i) i refl (to_nat i) r1]

Define cl_has_all_vars_lem2_h2 :
  Forall(n i:nat)(u:{ (lt i n) = tt }).
    { (plus (S (minus n (S i))) i) = n }
  :=
  foralli(n:nat)(i:nat)(u:{ (lt i n) = tt }).
  abbrev u' = [lt_implies_le i n u] in
  trans cong (plus * i) symm [minusS2 n i u]
  trans symm [plus_comm i (minus n i)]
        [plus_minus_le i n u']
  .

Define cl_has_all_vars_lem2 :
	Forall (c:clause)
         (n:nat)(n_ub:{ (le n (to_nat var_upper_bound)) = tt })
         (vt:<vec assignment n>)
				 (u1:{ (cl_has_all_vars c vt) = tt })
				 (i:word)
	       (u2:{ (lt (to_nat i) n) = tt })
    .{ (check_var c (vec_get vt (to_nat i)) i) = tt }
  :=
  foralli(c:clause)
         (n:nat)(n_ub:{ (le n (to_nat var_upper_bound)) = tt })
         (vt:<vec assignment n>)
				 (u1:{ (cl_has_all_vars c vt) = tt })
				 (i:word)
	       (u2:{ (lt (to_nat i) n) = tt })
  .
	cabbrev i' = (word_to_nat i)
  cabbrev p2 = [vec_nth_tail_eq assignment n i' vt u2] in
  % p3 : (cl_has_all_vars_h c (vec_nth_tail vt i') i') = tt
  cabbrev p3 = [cl_has_all_vars_lem2_h1 c n n_ub vt u1 i u2] in  
  cabbrev p4 = hypjoin (cl_has_all_vars_h c (vecc (vec_get vt i') (vec_nth_tail vt (S i'))) i) tt by p2 p3 end in
  % need: (le (plus (S (minus n (S i'))) i') (to_nat var_upper_bound)) = tt
  cabbrev p5_1 = [cl_has_all_vars_lem2_h2 n i' u2] in
  cabbrev p5 = trans cong (le * (to_nat var_upper_bound)) p5_1
										 n_ub
  cabbrev p6 = [lt_S_le i' n u2] in
  [cl_has_all_vars_h_lem1 c i
    (vec_get assignment n vt i' u2) (minus n (S i')) (vec_nth_tail assignment n vt (S i') p6)
    p5 p4]

Define cl_has_all_vars_lem3 : Forall
	(c:clause)
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt:<uwarray assignment (inc_nv nv nv_ub)>)
	(l:lit)
	(u1:{ (cl_has_all_vars c vt) = tt })
	(u2:{ (uwarray_get vt (lit_vnum l)) = (lit_assignment l) })
	.{ (cl_has c l) = tt }
  := foralli
	(c:clause)
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt:<uwarray assignment (inc_nv nv nv_ub)>)
	(l:lit)
	(u1:{ (cl_has_all_vars c vt) = tt })
	(u2:{ (uwarray_get vt (lit_vnum l)) = (lit_assignment l) })
	.
	cabbrev nv' = (inc_nv nv nv_ub)
	cabbrev n = (word_to_nat nv')
	cabbrev n_ub = [le_to_nat_inc_nv_var_upper_bound nv nv_ub]
	cabbrev v = (lit_vnum l)
	cabbrev u2' = hypjoin (lit_assignment l) (vec_get vt (word_to_nat v)) by u2 end
	cabbrev p1 = [vec_get_implies_lt assignment n (word_to_nat v) vt (lit_assignment l) u2']
	% p2: (check_var c (vec_get vt (to_nat v)) v) = tt
	cabbrev p2 = [cl_has_all_vars_lem2 c n n_ub vt u1 v p1]
	case (lit_sign l) by q1 _ with
	| ff =>
		cabbrev p3 = hypjoin (vec_get vt (to_nat v)) FF by q1 u2' end
		cabbrev p4 = [lit_sign_ff_implies_lit_vnum_neg_eq l q1]
		hypjoin (cl_has c l) tt by p2 p3 p4 end
	| tt =>
		cabbrev p3 = hypjoin (vec_get vt (to_nat v)) TT by q1 u2' end
		cabbrev p4 = [lit_sign_tt_implies_lit_vnum_pos_eq l q1]
		hypjoin (cl_has c l) tt by p2 p3 p4 end
	end

Define _forall_check_var_implies_cl_has_all_vars_h : Forall
	(c:clause)
	(n:nat)(n_ub:{ (le n (to_nat var_upper_bound)) = tt })
	(vt:<vec assignment n>)
	(u:Forall(i:word)(r1:{ (lt (to_nat i) n) = tt })
			.{ (check_var c (vec_get vt (to_nat i)) i) = tt })
	(i:word)
  (r:{ (le (to_nat i) n) = tt })
	.{ (cl_has_all_vars_h c (vec_nth_tail vt (to_nat i)) i) = tt }
	:= foralli
	(c:clause)
	(n:nat)(n_ub:{ (le n (to_nat var_upper_bound)) = tt })
	(vt:<vec assignment n>)
	(u:Forall(i:word)(r1:{ (lt (to_nat i) n) = tt })
			.{ (check_var c (vec_get vt (to_nat i)) i) = tt })
	(i:word)
  (r:{ (le (to_nat i) n) = tt })
  .
	cabbrev p =
		induction(j:nat) return Forall
			(i:word)
			(i_eq:{ (to_nat i) = (minus n j) })
			(r1:{ (le j n) = tt })
			.{ (cl_has_all_vars_h c (vec_nth_tail vt (minus n j)) i) = tt }
		with
		| Z => foralli
			(i:word)
			(i_eq:{ (to_nat i) = (minus n j) })
			(r1:{ (le j n) = tt })
			.
			cabbrev p1 = [vec_nth_tail_last assignment n vt]
			hypjoin (cl_has_all_vars_h c (vec_nth_tail vt (minus n j)) i) tt by j_eq p1 end
				
		| S j' => foralli
			(i:word)
			(i_eq:{ (to_nat i) = (minus n j) })
			(r1:{ (le j n) = tt })
			.
			cabbrev p1 = [minus_le n j (minus n j) refl (minus n j)]	% (minus n j) <= n
			cabbrev t = (vec_nth_tail assignment n vt (minus n j) p1)
			cabbrev t_len = [minus_minus n j r1]	% (minus n (minus n j)) = j
			case t with
			| vecn _ =>
				cabbrev p2_1 = inj <vec ** *> t_Eq	% (minus n (minus n j)) = Z
				cabbrev p2 = hypjoin j Z by p2_1 t_len end
				contra
				trans symm p2
				trans j_eq
							clash (S j') Z
				{ (cl_has_all_vars_h c (vec_nth_tail vt (minus n j)) i) = tt }
			| vecc _ n' a t' =>
				% p2: (lt j' n) = tt
				cabbrev p2_1 = hypjoin (le (S j') n) tt by r1 j_eq end
				cabbrev p2 = [le_S_lt j' n p2_1]
				
				% p3: (lt Z j) = tt
				cabbrev p3 = hypjoin (lt Z j) tt by j_eq end
				
				% p4: (ltword i word_max) = tt
				cabbrev p4_1 = [minus_lt2 n j r1 p3]
				cabbrev p4_2 = [ltle_trans (minus n j) n (word_to_nat var_upper_bound) p4_1 n_ub]
				cabbrev p4_3 =
					trans [ltword_to_lt i var_upper_bound]
					trans cong (lt * (to_nat var_upper_bound)) i_eq
								p4_2
				cabbrev p4 = [ltword_trans i var_upper_bound word_max p4_3 ltword_var_upper_bound_word_max]
				cabbrev i' = (word_inc_safe i p4)

				% p5: (to_nat i') = (minus n j')
				% need: (minus n j') = (S (minus n j)) = (S (to_nat i))
				cabbrev p5_1 = [minusS2 n j' p2]
				cabbrev p5_2 = [word_inc_safe_word_to_nat i p4]
				cabbrev p5 = hypjoin (to_nat i') (minus n j') by p5_1 p5_2 i_eq j_eq end
				
				cabbrev r1' = [le_S2 j' n p2_1]
				% ih: (cl_has_all_vars_h c (vec_nth_tail vt (minus n j')) i') = tt
				cabbrev ih = [j_IH j' i' p5 r1']

				% p6: (check_var c a i) = tt
				cabbrev p6_1 = hypjoin (lt (to_nat i) n) tt by p4_1 i_eq end
				cabbrev p6_2 = [u i p6_1]
				cabbrev p6_3 = [vec_nth_tail_eq assignment n (minus n j) vt p4_1]
				cabbrev a_eq = inj (vecc * **) trans symm t_eq p6_3
				cabbrev p6 = hypjoin (check_var c a i) tt by a_eq p6_2 i_eq end
				
				% have: (cl_has_all_vars_h c (vec_nth_tail vt (minus n j)) i) = (cl_has_all_vars_h c (vecc a t') i)
				% want: (cl_has_all_vars_h c (vecc a t') i) = (cl_has_all_vars_h c t' i')
				cabbrev t'_eq = inj (vecc ** *) trans symm t_eq p6_3
				cabbrev p7_1 = hypjoin (minus n j') (S (minus n j)) by p5_1 j_eq end
				cabbrev p7 = hypjoin t' (vec_nth_tail vt (minus n j')) by t'_eq p7_1 end
				trans cong (cl_has_all_vars_h c * i) t_eq
				trans hypjoin (cl_has_all_vars_h c (vecc a t') i) (cl_has_all_vars_h c t' i') by p6 end
				trans cong (cl_has_all_vars_h c * i') p7
							ih
			end
		end
	% q1: (word_to_nat i) = (minus n (minus n (word_to_nat i)))
	% q2: (le (minus n (to_nat i)) n) = tt
	cabbrev q1 = symm [minus_minus n (word_to_nat i) r]
	cabbrev q2 = [minus_le n (word_to_nat i) (minus n (word_to_nat i)) refl (minus n (word_to_nat i))]
	cabbrev q1' = hypjoin (to_nat i) (minus n (minus n (word_to_nat i))) by q1 end
	trans cong (cl_has_all_vars_h c (vec_nth_tail vt *) i) q1'
				[p (minus n (word_to_nat i)) i q1 q2]

Define forall_check_var_implies_cl_has_all_vars : Forall
	(c:clause)
	(n:nat)(n_ub:{ (le n (to_nat var_upper_bound)) = tt })
	(vt:<vec assignment n>)
	(u:Forall(i:word)(r1:{ (lt (to_nat i) n) = tt })
			.{ (check_var c (vec_get vt (to_nat i)) i) = tt })
	.{ (cl_has_all_vars c vt) = tt }
	:= foralli
	(c:clause)
	(n:nat)(n_ub:{ (le n (to_nat var_upper_bound)) = tt })
	(vt:<vec assignment n>)
	(u:Forall(i:word)(r1:{ (lt (to_nat i) n) = tt })
			.{ (check_var c (vec_get vt (to_nat i)) i) = tt })
	.
	cabbrev p1 = hypjoin (le (to_nat word0) n) tt by [leZ n] end
	cabbrev p2 = [_forall_check_var_implies_cl_has_all_vars_h c n n_ub vt u word0 p1]
	hypjoin (cl_has_all_vars c vt) tt by p2 end

Define cl_has_all_vars_elim : Forall
	(c:clause)
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt:<uwarray assignment (inc_nv nv nv_ub)>)
	(u1:{ (cl_has_all_vars c vt) = tt })
	(i:word)
	(u2:{ (ltword i (inc_nv nv)) = tt })
	.{ (check_var c (uwarray_get vt i) i) = tt }
	:= foralli
	(c:clause)
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt:<uwarray assignment (inc_nv nv nv_ub)>)
	(u1:{ (cl_has_all_vars c vt) = tt })
	(i:word)
	(u2:{ (ltword i (inc_nv nv)) = tt })
	.
	cabbrev nv' = (inc_nv nv nv_ub)
	cabbrev n = (word_to_nat nv')
	cabbrev n_ub = [le_to_nat_inc_nv_var_upper_bound nv nv_ub]
	cabbrev u2' = hypjoin (lt (to_nat i) n) tt by u2 end
	cabbrev p1 = [cl_has_all_vars_lem2 c n n_ub vt u1 i u2']
	hypjoin (check_var c (uwarray_get vt i) i) tt by p1 end

Define cl_has_all_vars_intro : Forall
	(c:clause)
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt:<uwarray assignment (inc_nv nv nv_ub)>)
	(u:Forall(i:word)(r:{ (ltword i (inc_nv nv nv_ub)) = tt })
			.{ (check_var c (uwarray_get vt i) i) = tt })
	.{ (cl_has_all_vars c vt) = tt }
	:= foralli
	(c:clause)
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt:<uwarray assignment (inc_nv nv nv_ub)>)
	(u:Forall(i:word)(r:{ (ltword i (inc_nv nv nv_ub)) = tt })
			.{ (check_var c (uwarray_get vt i) i) = tt })
	.
	cabbrev nv' = (inc_nv nv nv_ub)
	cabbrev n = (word_to_nat nv')
	cabbrev n_ub = [le_to_nat_inc_nv_var_upper_bound nv nv_ub]
	cabbrev u' =
		foralli(i:word)(r:{ (lt (to_nat i) n) = tt }).
		cabbrev r' = hypjoin (ltword i nv') tt by r end
		cabbrev p1 = [u i r']
		hypjoin (check_var c (vec_get vt (to_nat i)) i) tt by p1 end
	[forall_check_var_implies_cl_has_all_vars c n n_ub vt u']
	
Define cl_has_all_vars_empty : Forall
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt:<uwarray assignment (inc_nv nv nv_ub)>)
  (u:{ vt = (uwarray_new (inc_nv nv) UN) })
  .{ (cl_has_all_vars nil vt) = tt }
  := foralli
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt:<uwarray assignment (inc_nv nv nv_ub)>)
  (u:{ vt = (uwarray_new (inc_nv nv) UN) })
	.
	cabbrev nv' = (inc_nv nv nv_ub)
	cabbrev p1 =
		foralli(i:word)(r:{ (ltword i nv') = tt }).
		% subgoal: (check_var c (uwarray_get vt i) i) = tt
		cabbrev r' = hypjoin (lt (to_nat i) (to_nat nv')) tt by r end
		cabbrev p1 = [mkvec_implies_vec_get assignment UN (word_to_nat nv') vt (word_to_nat i) r']
		cabbrev p2 = hypjoin (uwarray_get vt i) UN by p1 u end
		hypjoin (check_var nil (uwarray_get vt i) i) tt by p2 end
	[cl_has_all_vars_intro (nil lit) nv nv_ub vt p1]

Define cl_has_all_vars_add : Forall
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt vt':<uwarray assignment (inc_nv nv nv_ub)>)
  (c:clause)(l:lit)
  (u:{ (cl_has_all_vars c vt) = tt })
  (vt'_eq:{ vt' = (uwarray_set vt (lit_vnum l) (lit_assignment l)) })
  .{ (cl_has_all_vars (cons l c) vt') = tt }
  := foralli
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt vt':<uwarray assignment (inc_nv nv nv_ub)>)
  (c:clause)(l:lit)
  (u:{ (cl_has_all_vars c vt) = tt })
  (vt'_eq:{ vt' = (uwarray_set vt (lit_vnum l) (lit_assignment l)) })
	.
	cabbrev nv' = (inc_nv nv nv_ub)
	cabbrev c' = (cons lit l c)
	cabbrev r =
		foralli(i:word)(r:{ (ltword i nv') = tt }).
		% subgoal: (check_var c' (uwarray_get vt' i) i) = tt
		cabbrev p1 = [cl_has_all_vars_elim c nv nv_ub vt u i r]
		cabbrev p2 = [uwarray_set_implies_ltword assignment nv' vt vt' (lit_vnum l) (lit_assignment l) vt'_eq]
		cabbrev p4 = [ltword_inc_nv_implies_word_msb_ff nv nv_ub i r]
		cabbrev a = (uwarray_get assignment nv' vt i r)
		case (eqword (lit_vnum l) i) by q1 _ with
		| ff =>
			cabbrev q1' = [eqword_neq (lit_vnum l) i q1]
			cabbrev p3_1 = [uwarray_set_get_distinct assignment nv' vt i (lit_vnum l) (lit_assignment l) r p2 symm q1']
			cabbrev p3 = hypjoin (uwarray_get vt' i) (uwarray_get vt i) by p3_1 vt'_eq end
			case a by q2 _ with
			| UN =>
				hypjoin (check_var c' (uwarray_get vt' i) i) tt by p3 q2 end
			| TT =>
				cabbrev p5 = hypjoin (cl_has c (pos i)) tt by p3 q2 p1 end
				cabbrev p6 = [cl_has_tt_cons c (pos i p4) l p5]
				hypjoin (check_var c' (uwarray_get vt' i) i) tt by p3 q2 p6 end
			| FF =>
				cabbrev p5 = hypjoin (cl_has c (neg i)) tt by p3 q2 p1 end
				cabbrev p6 = [cl_has_tt_cons c (neg i p4) l p5]
				hypjoin (check_var c' (uwarray_get vt' i) i) tt by p3 q2 p6 end
			end
		| tt =>
			cabbrev q1' = [eqword_eq (lit_vnum l) i q1]
			cabbrev p3_1 = [uwarray_set_get assignment nv' vt i (lit_assignment l) r]
			cabbrev p3 = hypjoin (uwarray_get vt' i) (lit_assignment l) by p3_1 vt'_eq q1' end
			case (lit_sign l) by q2 _ with
			| ff =>
				cabbrev p5 = hypjoin (uwarray_get vt' i) FF by q2 p3 end
				cabbrev p6 = [lit_sign_ff_implies_lit_vnum_neg_eq l q2]
				% HYPJOIN FAILS: hypjoin (eq_lit l l) tt by p6 q1' [eq_lit_refl l] end
				cabbrev p7 = hypjoin (eq_lit (neg i) l) tt by [eq_lit_refl l] p6 q1' end
				cabbrev p8 = hypjoin (cl_has c' (neg i)) tt by p7 end
				hypjoin (check_var c' (uwarray_get vt' i) i) tt by p8 p5 end
				
			| tt =>
				cabbrev p5 = hypjoin (uwarray_get vt' i) TT by q2 p3 end
				cabbrev p6 = [lit_sign_tt_implies_lit_vnum_pos_eq l q2]
				cabbrev p8 = hypjoin (cl_has c' (pos i)) tt by [eq_lit_refl l] p6 q1' end
				hypjoin (check_var c' (uwarray_get vt' i) i) tt by p8 p5 end
			end
		end
	[cl_has_all_vars_intro c' nv nv_ub vt' r]


%==============================================================================
% clear_vars
% - lem1: clear_vars does not assign a new var
% - lem2: clear_vars does clear all vars in c
%==============================================================================

Define clear_vars := fun clear_vars
  (spec nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
  (^#owned c:clause)
  (u1:{ (cl_valid nv c) = tt })
  : #unique <uwarray assignment (inc_nv nv nv_ub)>.
  match c with
    nil _ => vt
  | cons _ l c' =>
      abbrev nv' = (inc_nv nv nv_ub) in
      abbrev vn = (lit_vnum l) in
      abbrev p1 = [cl_valid_implies_lit_valid_head2 nv c l c' u1 c_eq] in
      abbrev p2 = [lit_valid_implies_ltword_inc_nv nv nv_ub l p1] in
      let vt' = (uwarray_set assignment nv' vt vn UN p2) in
      abbrev p3 = [cl_valid_implies_cl_valid_tail2 nv c l c' u1 c_eq] in
      (clear_vars nv nv_ub vt' c' p3)
  end.

Define clear_vars_total :=
  foralli(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  .
  induction(vt:<uwarray assignment (inc_nv nv nv_ub)>)(c:clause) return 
    Forall(u1:{ (cl_valid nv c) = tt }).
    Exists(vt':<uwarray assignment (inc_nv nv nv_ub)>).
      { (clear_vars vt c) = vt' }
  with
    nil _ =>
      foralli(u1:{ (cl_valid nv c) = tt }).
      existsi vt { (clear_vars vt c) = * }
        hypjoin (clear_vars vt c) vt by c_eq end
  | cons _ l c' =>
      foralli(u1:{ (cl_valid nv c) = tt }).
      abbrev p1 = hypjoin (cl_valid nv (cons l c')) tt by u1 c_eq end in
      abbrev u1' = [cl_valid_implies_cl_valid_tail nv l c' p1] in

      abbrev p2_1 = [cl_valid_implies_lit_valid_head2 nv c l c' u1 c_eq] in
      abbrev p2 = [lit_valid_implies_ltword_inc_nv nv nv_ub l p2_1] in
      abbrev vt' = (uwarray_set assignment (inc_nv nv nv_ub) vt (lit_vnum l) UN p2) in

      existse [c_IH vt' c' u1']
      foralli(vt'':<uwarray assignment (inc_nv nv nv_ub)>)
             (vt''_pf:{ (clear_vars vt' c') = vt'' })
      .        
      existsi vt'' { (clear_vars vt c) = * }
        hypjoin (clear_vars vt c) vt'' by c_eq vt''_pf end
  end
  .

Total clear_vars clear_vars_total. 
  
Define clear_vars_lem1 : Forall
  (nv:word)
  (nv_ub:{ (ltword nv var_upper_bound) = tt })
  (v:word)
  (c:clause)
  (vt:<uwarray assignment (inc_nv nv nv_ub)>)
  (u1:{ (ltword v (inc_nv nv nv_ub)) = tt })
  (u2:{ (cl_valid nv c) = tt })
  (u3:{ (uwarray_get vt v) = UN })
  .{ (uwarray_get (clear_vars vt c) v) = UN }
  := foralli
  (nv:word)
  (nv_ub:{ (ltword nv var_upper_bound) = tt })
  (v:word)
  .
  induction(c:clause) return
    Forall(vt:<uwarray assignment (inc_nv nv nv_ub)>)
           (u1:{ (ltword v (inc_nv nv nv_ub)) = tt })
           (u2:{ (cl_valid nv c) = tt })
           (u3:{ (uwarray_get vt v) = UN })
         .{ (uwarray_get (clear_vars vt c) v) = UN }
  with
    nil _ =>
      foralli(vt:<uwarray assignment (inc_nv nv nv_ub)>)
             (u1:{ (ltword v (inc_nv nv nv_ub)) = tt })
             (u2:{ (cl_valid nv c) = tt })
             (u3:{ (uwarray_get vt v) = UN })
      .
      hypjoin (uwarray_get (clear_vars vt c) v) UN by u3 c_eq end
            
  | cons _ l' c' =>
      foralli(vt:<uwarray assignment (inc_nv nv nv_ub)>)
             (u1:{ (ltword v (inc_nv nv nv_ub)) = tt })
             (u2:{ (cl_valid nv c) = tt })
             (u3:{ (uwarray_get vt v) = UN })
      .
      abbrev u2'_1 = trans cong (cl_valid nv *) symm c_eq
                           u2 in
      abbrev u2' = [cl_valid_implies_cl_valid_tail nv l' c' u2'_1] in
      abbrev p3_1 = [cl_valid_implies_lit_valid_head2 nv c l' c' u2 c_eq] in
      abbrev p3 = [lit_valid_implies_ltword_inc_nv nv nv_ub l' p3_1] in
      abbrev p4 = u1 in

      abbrev vt' = (uwarray_set assignment (inc_nv nv nv_ub) vt (lit_vnum l') UN p3) in
      % p5: (warray_get vt' (lit_vnum l)) = UN
      abbrev p5 =
        case (eqword v (lit_vnum l')) by q1 _ with
          ff =>
            abbrev p5_1 = [eqword_ff_neq v (lit_vnum l') q1] in
            abbrev p5_2 = [uwarray_set_get_distinct assignment (inc_nv nv nv_ub) vt
                            v (lit_vnum l') UN p4 p3 p5_1] in
            hypjoin (warray_get vt' v) UN by p5_2 u3 end
        | tt =>
            abbrev p5_1 = [uwarray_set_get assignment (inc_nv nv nv_ub) vt
                            v UN p4] in
            abbrev p5_2 = [eqword_eq v (lit_vnum l') q1] in
            hypjoin (warray_get vt' v) UN by p5_1 p5_2 u3 end
        end in
        
      % ih: (uwarray_get (clear_vars vt' c') v) = UN
      abbrev ih = [c_IH c' vt' u1 u2' p5] in

      % p6: (clear_vars vt c) = (clear_vars vt' c')
      abbrev p6 =
        hypjoin (clear_vars vt c)
                (clear_vars vt' c') by c_eq end in
      hypjoin (uwarray_get (clear_vars vt c) v) UN by ih p6 end
  end.

Define clear_vars_lem2 : Forall
  (nv:word)
  (nv_ub:{ (ltword nv var_upper_bound) = tt })
  (l:lit)
  (c:clause)
  (vt:<uwarray assignment (inc_nv nv nv_ub)>)
  (u1:{ (cl_has c l) = tt })
  (u2:{ (cl_valid nv c) = tt })
  .{ (uwarray_get (clear_vars vt c) (lit_vnum l)) = UN }
  := foralli
  (nv:word)
  (nv_ub:{ (ltword nv var_upper_bound) = tt })
  (l:lit)
  .
  induction(c:clause) return
    Forall(vt:<uwarray assignment (inc_nv nv nv_ub)>)
          (u1:{ (cl_has c l) = tt })
          (u2:{ (cl_valid nv c) = tt })
         .{ (uwarray_get (clear_vars vt c) (lit_vnum l)) = UN }
  with
    nil _ =>
      foralli(vt:<uwarray assignment (inc_nv nv nv_ub)>)
             (u1:{ (cl_has c l) = tt })
             (u2:{ (cl_valid nv c) = tt })
      .
      contra
        trans symm hypjoin (cl_has c l) ff by c_eq end
        trans u1
              clash tt ff
        { (uwarray_get (clear_vars vt c) (lit_vnum l)) = UN }
            
  | cons _ l' c' =>
      foralli(vt:<uwarray assignment (inc_nv nv nv_ub)>)
             (u1:{ (cl_has c l) = tt })
             (u2:{ (cl_valid nv c) = tt })
      .
      abbrev u2'_1 = trans cong (cl_valid nv *) symm c_eq
                           u2 in
      abbrev u2' = [cl_valid_implies_cl_valid_tail nv l' c' u2'_1] in
      abbrev p3_1 = [cl_valid_implies_lit_valid_head2 nv c l' c' u2 c_eq] in
      abbrev p3 = [lit_valid_implies_ltword_inc_nv nv nv_ub l' p3_1] in
      abbrev p4 = [cl_valid_implies_all_lit_valid nv l c u2 u1] in
      abbrev p4' = [lit_valid_implies_ltword_inc_nv nv nv_ub l p4] in

      abbrev vt' = (uwarray_set assignment (inc_nv nv nv_ub) vt (lit_vnum l') UN p3) in
      case (eq_lit l l') by q1 _ with
        ff =>
          abbrev u1' = hypjoin (cl_has c' l) tt by u1 c_eq q1 end in
          
          % ih: (uwarray_get (clear_vars vt' c') (lit_vnum l)) = UN
          abbrev ih = [c_IH c' vt' u1' u2'] in
          hypjoin (uwarray_get (clear_vars vt c) (lit_vnum l))
                  UN by c_eq ih end
          
      | tt =>
          abbrev p5_2 = [uwarray_set_get assignment (inc_nv nv nv_ub) vt
                          (lit_vnum l) UN p4'] in
          abbrev p5_3 = [eq_lit_eq l l' q1] in
          abbrev p5 = hypjoin (warray_get vt' (lit_vnum l)) UN by p5_2 p5_3 end in

          abbrev p7 = [clear_vars_lem1 nv nv_ub (lit_vnum l) c' vt' p4' u2' p5] in
          hypjoin (uwarray_get (clear_vars vt c) (lit_vnum l)) UN by p7 c_eq q1 end
      end
  end.


%=============================================================================
% cl_has_all_vars + clear_vars lemmas
%=============================================================================

Define cl_has_all_vars_implies_clear_vars_get_UN :
  Forall (nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
         (c:clause)
         (u1:{ (cl_valid nv c) = tt })
         (vt:<uwarray assignment (inc_nv nv nv_ub)>)
         (r:{ (cl_has_all_vars c vt) = tt })
         (i:word)
         (u2:{ (ltword i (inc_nv nv nv_ub)) = tt })
    .{ (uwarray_get (clear_vars vt c) i) = UN }
  :=
  foralli(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
         (c:clause)
         (u1:{ (cl_valid nv c) = tt })
         (vt:<uwarray assignment (inc_nv nv nv_ub)>)
         (r:{ (cl_has_all_vars c vt) = tt })
         (i:word)
         (u2:{ (ltword i (inc_nv nv nv_ub)) = tt })
  .
  abbrev p1 = [ltword_inc_nv_implies_word_msb_ff nv nv_ub i u2] in
  abbrev pl = (pos i p1) in
  abbrev nl = (neg i p1) in
  case (cl_has c pl) by q1 _ with
    ff =>
  case (cl_has c nl) by q2 _ with
    ff =>
      abbrev nv' = (inc_nv nv nv_ub) in
      case (uwarray_get assignment nv' vt i u2) by q3 _ with
        UN =>
          [clear_vars_lem1 nv nv_ub i c vt u2 u1 q3]
          
      | TT =>
          abbrev n = (word_to_nat nv') in
          abbrev n_ub = [le_to_nat_inc_nv_var_upper_bound nv nv_ub] in
          abbrev i' = (word_to_nat i) in
          abbrev u2' = hypjoin (lt i' n) tt by u2 end in
          abbrev p2 = [cl_has_all_vars_lem2 c n n_ub vt r i u2'] in
          contra
					trans symm hypjoin (check_var c (vec_get vt (to_nat i)) i) ff by q1 q3 end
					trans p2
								clash tt ff
					{ (uwarray_get (clear_vars vt c) i) = UN }
      | FF =>
          abbrev n = (word_to_nat nv') in
          abbrev n_ub = [le_to_nat_inc_nv_var_upper_bound nv nv_ub] in
          abbrev i' = (word_to_nat i) in
          abbrev u2' = hypjoin (lt i' n) tt by u2 end in
          abbrev p2 = [cl_has_all_vars_lem2 c n n_ub vt r i u2'] in
          contra
					trans symm hypjoin (check_var c (vec_get vt i') i) ff by q2 q3 end
					trans p2
								clash tt ff
					{ (uwarray_get (clear_vars vt c) i) = UN }
      end

  | tt =>
      abbrev p2 = [clear_vars_lem2 nv nv_ub nl c vt q2 u1] in
      abbrev p3 = [neg_lit_vnum i p1] in
      hypjoin (uwarray_get (clear_vars vt c) i) UN by p2 p3 end
  end
  | tt =>
      abbrev p2 = [clear_vars_lem2 nv nv_ub pl c vt q1 u1] in
      abbrev p3 = [pos_lit_vnum i p1] in
      hypjoin (uwarray_get (clear_vars vt c) i) UN by p2 p3 end
  end

Define cl_has_all_vars_implies_clear_vars_like_new :
  Forall (nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
         (vt:<uwarray assignment (inc_nv nv nv_ub)>)
         (c:clause)
         (u:{ (cl_valid nv c) = tt })
         (r:{ (cl_has_all_vars c vt) = tt })
    .{ (clear_vars vt c) = (uwarray_new (inc_nv nv nv_ub) UN) }
  :=
  foralli(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
         (vt:<uwarray assignment (inc_nv nv nv_ub)>)
         (c:clause)
         (u:{ (cl_valid nv c) = tt })
         (r:{ (cl_has_all_vars c vt) = tt })
  .
  abbrev nv' = (inc_nv nv nv_ub) in
  abbrev p1 = [cl_has_all_vars_implies_clear_vars_get_UN nv nv_ub c u vt r] in
  abbrev vt' = (clear_vars nv nv_ub vt c u) in
  [all_uwarray_get_implies_new assignment UN nv' vt' p1]
