%=============================================================================
% unitprop.g : unit-proagation (using watched-literals)
%=============================================================================
Include trusted "cnf-lemma2.g".
Include trusted "assignment.g".

%=============================================================================
% assignment helper functions
%=============================================================================

Define pa_eval := fun
	(spec nv:word)
 	(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (!#unique_owned pa:<uwarray assignment (inc_nv nv nv_ub)>)
	(x:ulit)
	(u:{ (leword (ulit_vnum x) nv) = tt })
	.
	abbrev p = [leword_nv_implies_ltword_inc_nv nv nv_ub (ulit_vnum x) u] in
	match (uwarray_get assignment (inc_nv nv nv_ub) pa (ulit_vnum x) p) with
	  UN => UN
	| TT =>
			match (ulit_sign x) with
				ff => FF
			| tt => TT
			end
	| FF =>
			match (ulit_sign x) with
				ff => TT
			| tt => FF
			end
	end.

Define pa_eval_lem1 : Forall
	(nv:word)
 	(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (pa:<uwarray assignment (inc_nv nv nv_ub)>)
	(x:ulit)
	(u:{ (leword (ulit_vnum x) nv) = tt })
	(r:{ (pa_eval pa x) = UN })
	.{ (unassigned2 pa (ulit_vnum x)) = tt }
	:= foralli
	(nv:word)
 	(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (pa:<uwarray assignment (inc_nv nv nv_ub)>)
	(x:ulit)
	(u:{ (leword (ulit_vnum x) nv) = tt })
	(r:{ (pa_eval pa x) = UN })
	.
	cabbrev p = [leword_nv_implies_ltword_inc_nv nv nv_ub (ulit_vnum x) u]
	case (uwarray_get assignment (inc_nv nv nv_ub) pa (ulit_vnum x) p) by q1 _ with
	|	UN =>
		hypjoin (unassigned2 pa (ulit_vnum x)) tt by q1 end
	| TT =>
		contra
		trans symm r
		case (ulit_sign x) by q2 _ with
		| ff =>
			trans hypjoin (pa_eval pa x) FF by q1 q2 end
						clash FF UN
		| tt =>
			trans hypjoin (pa_eval pa x) TT by q1 q2 end
						clash TT UN
		end
		{ (unassigned2 pa (ulit_vnum x)) = tt }
	| FF =>
		contra
		trans symm r
		case (ulit_sign x) by q2 _ with
		| ff =>
			trans hypjoin (pa_eval pa x) TT by q1 q2 end
						clash TT UN
		| tt =>
			trans hypjoin (pa_eval pa x) FF by q1 q2 end
						clash FF UN
		end
		{ (unassigned2 pa (ulit_vnum x)) = tt }
	end

% when free lits are already found, we just need to check if the rest is sat
Define la_check_sat := fun la_check_sat
	(spec nv:word)
 	(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (!#unique_owned pa:<uwarray assignment (inc_nv nv nv_ub)>)
  (spec n:word)
  (!#unique_owned la:<uwarray ulit n>)
	(i:word)
  (u:{ (array_in_bounds nv (vec_nth_tail la (to_nat i))) = tt })
	: bool.
  % need: (ltword i n) = tt
  cabbrev p1 = [nth_tail_in_bounds_implies_ltword nv n la i u]
  let x = (uwarray_get ulit n la i p1) in
  match (eq_ulit x ulit_null) by q1 Q1 with
    ff => % do more
    	abbrev p2_1 = [nth_tail_in_bounds_leword_nth nv (word_to_nat n) la (word_to_nat i) u] in
    	abbrev p2 = hypjoin (leword (ulit_vnum x) nv) tt by p2_1 x_eq end in
    	match (pa_eval nv nv_ub pa x p2) with
				default => % free or unsat (move on)
					abbrev p2 = [ltword_implies_ltword_word_max i n p1] in
					let i' = (word_inc_safe i p2) in
					abbrev u' = [nth_tail_in_bounds_the_rest nv n la i i' x u i'_eq x_eq q1] in
					(la_check_sat nv nv_ub pa n la i' u')
    	| TT => % sat (stop)
					tt
    	end
  | tt => % done
      ff
  end.


%=============================================================================
% find_free: find free lits (at most two)
%=============================================================================

Inductive find_free_h_t : Fun(nv nv':word)(pa:<uwarray assignment nv'>).type :=
| find_free_h_sat				: Fun(spec nv nv':word)(spec pa:<uwarray assignment nv'>)
													 .<find_free_h_t nv nv' pa>
| find_free_h_not_found : Fun(spec nv nv':word)(spec pa:<uwarray assignment nv'>)
													 .<find_free_h_t nv nv' pa>
| find_free_h_found_one : Fun(spec nv nv':word)(spec pa:<uwarray assignment nv'>)
													 (x:ulit)
													 (u1:{ (leword (ulit_vnum x) nv) = tt })
													 (u2:{ (unassigned2 pa (ulit_vnum x)) = tt })
													 .<find_free_h_t nv nv' pa>
| find_free_h_found_two : Fun(spec nv nv':word)(spec pa:<uwarray assignment nv'>)
													 (x y:ulit)
													 (u1:{ (leword (ulit_vnum x) nv) = tt })
													 (u2:{ (unassigned2 pa (ulit_vnum x)) = tt })
													 (u3:{ (leword (ulit_vnum y) nv) = tt })
													 (u4:{ (unassigned2 pa (ulit_vnum y)) = tt })
													 .<find_free_h_t nv nv' pa>
		% x and y are distinct assuming lits in a clause are all distinct

% find one more free lit
Define find_free_h' := fun find_free_h'
	(spec nv:word)
 	(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (!#unique_owned pa:<uwarray assignment (inc_nv nv nv_ub)>)
  (spec n:word)
  (!#unique_owned la:<uwarray ulit n>)
	(found:ulit)
	(u1:{ (leword (ulit_vnum found) nv) = tt })
	(u2:{ (unassigned2 pa (ulit_vnum found)) = tt })
	(i:word)
  (u:{ (array_in_bounds nv (vec_nth_tail la (to_nat i))) = tt })
	: <find_free_h_t nv (inc_nv nv nv_ub) pa>.
	abbrev nv' = (inc_nv nv nv_ub) in
  % need: (ltword i n) = tt
  cabbrev p1 = [nth_tail_in_bounds_implies_ltword nv n la i u]
  let x = (uwarray_get ulit n la i p1) in
  match (eq_ulit x ulit_null) by q1 Q1 with
    ff => % do more
    	abbrev p2_1 = [nth_tail_in_bounds_leword_nth nv (word_to_nat n) la (word_to_nat i) u] in
    	abbrev p2 = hypjoin (leword (ulit_vnum x) nv) tt by p2_1 x_eq end in
			abbrev p3 = [ltword_implies_ltword_word_max i n p1] in
    	match (pa_eval nv nv_ub pa x p2) by q2 _ with
				UN => % found two, but still need to check sat
					let i' = (word_inc_safe i p3) in
					abbrev u' = [nth_tail_in_bounds_the_rest nv n la i i' x u i'_eq x_eq q1] in
					cabbrev p4 = [pa_eval_lem1 nv nv_ub pa x p2 q2]
					match (la_check_sat nv nv_ub pa n la i' u') with
						ff => (find_free_h_found_two nv nv' pa found x u1 u2 p2 p4)
					| tt => (find_free_h_sat nv nv' pa)
					end
    	| TT => % sat
					(find_free_h_sat nv nv' pa)
			| FF => % unsat
					let i' = (word_inc_safe i p3) in
					abbrev p4 = [nth_tail_in_bounds_the_rest nv n la i i' x u i'_eq x_eq q1] in
					(find_free_h' nv nv_ub pa n la found u1 u2 i' p4)
    	end
  | tt => % done
      (find_free_h_found_one nv nv' pa found u1 u2)
  end.

Define find_free_h := fun find_free_h
	(spec nv:word)
 	(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (!#unique_owned pa:<uwarray assignment (inc_nv nv nv_ub)>)
  (spec n:word)
  (!#unique_owned la:<uwarray ulit n>)
	(i:word)
  (u:{ (array_in_bounds nv (vec_nth_tail la (to_nat i))) = tt })
	: <find_free_h_t nv (inc_nv nv nv_ub) pa>.
	abbrev nv' = (inc_nv nv nv_ub) in
  % need: (ltword i n) = tt
  cabbrev p1 = [nth_tail_in_bounds_implies_ltword nv n la i u]
  let x = (uwarray_get ulit n la i p1) in
  match (eq_ulit x ulit_null) by q1 Q1 with
    ff => % do more
    	abbrev p2_1 = [nth_tail_in_bounds_leword_nth nv (word_to_nat n) la (word_to_nat i) u] in
    	abbrev p2 = hypjoin (leword (ulit_vnum x) nv) tt by p2_1 x_eq end in
			abbrev p4 = [ltword_implies_ltword_word_max i n p1] in
    	match (pa_eval nv nv_ub pa x p2) by q2 _ with
				UN => % free => find more
					let i' = (word_inc_safe i p4) in
					abbrev p3 = [nth_tail_in_bounds_the_rest nv n la i i' x u i'_eq x_eq q1] in
					cabbrev p5 = [pa_eval_lem1 nv nv_ub pa x p2 q2]
					(find_free_h' nv nv_ub pa n la x p2 p5 i' p3)
    	| TT => % sat
					(find_free_h_sat nv nv' pa)
			| FF => % unsat
					let i' = (word_inc_safe i p4) in
					abbrev p3 = [nth_tail_in_bounds_the_rest nv n la i i' x u i'_eq x_eq q1] in
					(find_free_h nv nv_ub pa n la i' p3)
    	end
  | tt => % done
      (find_free_h_not_found nv nv' pa)
  end.


Inductive find_free_t : Fun(nv:word)(F:formula)(as:<AssignState nv F>).type :=
| find_free_sat				: Fun(spec nv:word)(spec F:formula)(spec as:<AssignState nv F>)
													 .<find_free_t nv F as>
| find_free_not_found : Fun(spec nv:word)(spec F:formula)(spec as:<AssignState nv F>)
													 .<find_free_t nv F as>
| find_free_found_one : Fun(spec nv:word)(spec F:formula)(spec as:<AssignState nv F>)
													 (x:ulit)
													 (u1:{ (leword (ulit_vnum x) nv) = tt })
													 (u2:{ (unassigned as (ulit_vnum x)) = tt })
													 .<find_free_t nv F as>
| find_free_found_two : Fun(spec nv:word)(spec F:formula)(spec as:<AssignState nv F>)
													 (x y:ulit)
													 (u1:{ (leword (ulit_vnum x) nv) = tt })
													 (u2:{ (unassigned as (ulit_vnum x)) = tt })
													 (u3:{ (leword (ulit_vnum y) nv) = tt })
													 (u4:{ (unassigned as (ulit_vnum y)) = tt })
													 .<find_free_t nv F as>
		% x and y are distinct assuming lits in a clause are all distinct

Define find_free := fun
	(spec nv:word)(spec F:formula)
	(!#unique as:<AssignState nv F>)
  (spec n:word)
  (!#unique_owned la:<uwarray ulit n>)
  (u:{ (array_in_bounds nv la) = tt })
  .
	let asi = (inspect_unique <AssignState nv F> as) in
	match asi by q1 _ with assign_state _ _ nv_ub pa _ _ _ _ _ =>
  abbrev u' = hypjoin (array_in_bounds nv (vec_nth_tail la (to_nat word0))) tt by u end in
  let rval = match (find_free_h nv nv_ub pa n la word0 u') with
		| find_free_h_sat _ _ _ => (find_free_sat nv F as)
		| find_free_h_not_found _ _ _ => (find_free_not_found nv F as)
		| find_free_h_found_one _ _ _ x u1 u2 =>
			cabbrev u2' = hypjoin (unassigned as (ulit_vnum x)) tt by u2 asi_eq q1 end
			(find_free_found_one nv F as x u1 u2')
		| find_free_h_found_two _ _ _ x y u1 u2 u3 u4 =>
			cabbrev u2' = hypjoin (unassigned as (ulit_vnum x)) tt by u2 asi_eq q1 end
			cabbrev u4' = hypjoin (unassigned as (ulit_vnum y)) tt by u4 asi_eq q1 end
			(find_free_found_two nv F as x y u1 u2' u3 u4')
		end
	do
	(consume_unique_owned <uwarray assignment (inc_nv nv nv_ub)> pa)
	(consume_unique_owned <AssignState nv F> asi)
	rval
	end	% do
  end	% match asi


%=============================================================================
% find_more
%=============================================================================

Inductive find_more_t : Fun(nv:word).type :=
| find_more_v : Fun(spec nv:word)(x:ulit)(u:{ (leword (ulit_vnum x) nv) = tt }).<find_more_t nv>

% there's only one free lit. we need one more lit to watch
% assume that this clause has at least one lit that set higher than zero level
% (that's why we are indexing this clause)
Define find_more_h := fun find_more_h
	(spec nv:word)
 	(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (!#unique_owned dls:<uwarray word (inc_nv nv nv_ub)>)
  (spec n:word)
  (!#unique_owned la:<uwarray ulit n>)
	(z:ulit) % except for this lit
	(i:word)
  (u:{ (array_in_bounds nv (vec_nth_tail la (to_nat i))) = tt })
	(max_lev:word) % current max-level (initially word0)
	(max_lit:ulit) % current max-level lit (initially ulit_null)
	(u2:{ (leword (ulit_vnum max_lit) nv) = tt })
	: <find_more_t nv>.
	abbrev nv' = (inc_nv nv nv_ub) in
  % need: (ltword i n) = tt
  cabbrev p1 = [nth_tail_in_bounds_implies_ltword nv n la i u]
  let x = (uwarray_get ulit n la i p1) in
  match (eq_ulit x ulit_null) by q1 Q1 with
    ff => % do more
			abbrev p2 = [ltword_implies_ltword_word_max i n p1] in
			let i' = (word_inc_safe i p2) in
			abbrev u' = [nth_tail_in_bounds_the_rest nv n la i i' x u i'_eq x_eq q1] in
			match (eq_ulit z x) with
				ff => % check decision-level of x
					abbrev p3_1 = [nth_tail_in_bounds_leword_nth nv (word_to_nat n) la (word_to_nat i) u] in
					abbrev p3_2 = hypjoin (leword (ulit_vnum x) nv) tt by p3_1 x_eq end in
					abbrev p3 = [leword_nv_implies_ltword_inc_nv nv nv_ub (ulit_vnum x) p3_2] in
					let lev = (uwarray_get word nv' dls (ulit_vnum x) p3) in
					match (ltword max_lev lev) with
						ff => % skip
							(find_more_h nv nv_ub dls n la z i' u' max_lev max_lit u2)
					| tt => % update
							(find_more_h nv nv_ub dls n la z i' u' lev x p3_2)
					end
			| tt => % skip free lit
					(find_more_h nv nv_ub dls n la z i' u' max_lev max_lit u2)
			end
  | tt => % done
      (find_more_v nv max_lit u2)
  end.

Define find_more := fun
	(spec nv:word)(spec F:formula)
	(!#unique as:<AssignState nv F>)
  (spec n:word)
  (!#unique_owned la:<uwarray ulit n>)
  (u:{ (array_in_bounds nv la) = tt })
	(z:ulit)
  .
	let asi = (inspect_unique <AssignState nv F> as) in
	match asi with assign_state _ _ nv_ub _ _ dls _ _ _ =>
  abbrev u' = hypjoin (array_in_bounds nv (vec_nth_tail la (to_nat word0))) tt by u end in
	cabbrev u2 = hypjoin (leword (ulit_vnum ulit_null) nv) tt by [leword_word0 nv] end
	let rval = (find_more_h nv nv_ub dls n la z word0 u' word0 ulit_null u2)
	do
	(consume_unique_owned <uwarray word (inc_nv nv nv_ub)> dls)
	(consume_unique_owned <AssignState nv F> asi)
	rval
	end
  end.


%=============================================================================
% WatchState type
%=============================================================================

% array-based clause in the index
Inductive iclause : Fun(nv:word)(F:formula).type :=
  mk_iclause : Fun(spec nv:word)(spec F:formula)
									(ac:<aclause nv F>)
                  (w1 w2:word)  % literals being watched
                 .<iclause nv F>

Define type_family_abbrev ClauseList := fun(nv:word)(F:formula).<qlist <ref <iclause nv F>>>.
Define type_family_abbrev ClauseListPair := fun(nv:word)(F:formula).<qqpair <ClauseList nv F> <ClauseList nv F>>.

Define _genDummyPair := fun(spec nv:word)(spec F:formula)(u:Unit): #unique <ClauseListPair nv F>.
	(mkqqpair <ClauseList nv F> <ClauseList nv F>
		(qnil <ref <iclause nv F>>) (qnil <ref <iclause nv F>>))

Inductive WatchState : Fun(nv:word)(F:formula).type :=
  watch_state : Fun(spec nv:word)(spec F:formula)
                   (nv_ub:{ (ltword nv var_upper_bound) = tt })
                   (#unique wl:<qwarray <ClauseListPair nv F> (inc_nv nv nv_ub)>)
                  .#unique <WatchState nv F>

Define newWatchState :=
  fun(nv:word)(spec F:formula)
     (nv_ub:{ (ltword nv var_upper_bound) = tt })
  : #unique <WatchState nv F>.
  abbrev nv' = (inc_nv nv nv_ub) in
	let a = (qwarray_new <ClauseListPair nv F> nv' (_genDummyPair nv F))
  (watch_state nv F nv_ub a)


%=============================================================================
% index helper functions
%=============================================================================

Define remove_index := fun
	(spec nv:word)(spec F:formula)
	(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(^ic:<iclause nv F>)	% reference to remove
	(#unique wl:<qwarray <ClauseListPair nv F> (inc_nv nv nv_ub)>)
	(x:ulit)
	(u:{ (leword (ulit_vnum x) nv) = tt })
	:#unique <qwarray <ClauseListPair nv F> (inc_nv nv nv_ub)>.
	abbrev nv' = (inc_nv nv nv_ub) in
	abbrev p1 = [leword_nv_implies_ltword_inc_nv nv nv_ub (ulit_vnum x) u] in
	let dummy = (_genDummyPair nv F unit)
	match (qwarray_swap <ClauseListPair nv F> nv' wl (ulit_vnum x) dummy p1) with
		qwarray_swap_v _ clp _ wl' =>
	match clp with mkqqpair _ _ wp wn =>
	let clp' =
		match (ulit_sign x) with
			ff =>
				(mkqqpair <ClauseList nv F> <ClauseList nv F> wp (qlist_erase_ref <iclause nv F> ic wn))
		| tt =>
				(mkqqpair <ClauseList nv F> <ClauseList nv F> (qlist_erase_ref <iclause nv F> ic wp) wn)
		end in
	do
	(consume_unowned <iclause nv F> ic)
	(qwarray_set <ClauseListPair nv F> nv' wl' (ulit_vnum x) clp' p1)
	end	% do
	end % match clp
	end % match (qwarray_swap...
	
Define add_index := fun
	(spec nv:word)(spec F:formula)
	(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(ic:<iclause nv F>) % reference to add (should be updated with proper watched lits)
	(#unique wl:<qwarray <ClauseListPair nv F> (inc_nv nv nv_ub)>)
	(x:ulit) % x should be one of the watched lits of ic
	(u:{ (leword (ulit_vnum x) nv) = tt })
	:#unique <qwarray <ClauseListPair nv F> (inc_nv nv nv_ub)>.
	abbrev nv' = (inc_nv nv nv_ub) in
	abbrev r1 = [leword_nv_implies_ltword_inc_nv nv nv_ub (ulit_vnum x) u] in
	let dummy = (_genDummyPair nv F unit)
	match (qwarray_swap <ClauseListPair nv F> nv' wl (ulit_vnum x) dummy r1) with
		qwarray_swap_v _ clp _ wl' =>
	match clp with mkqqpair _ _ wp wn =>
	let clp'' =
		let ic_ref = (mk_ref <iclause nv F> ic)
		match (ulit_sign x) with
			ff =>
				(mkqqpair <ClauseList nv F> <ClauseList nv F>
					wp (qcons <ref <iclause nv F>> ic_ref wn))
		| tt =>
				(mkqqpair <ClauseList nv F> <ClauseList nv F>
					(qcons <ref <iclause nv F>> ic_ref wp) wn)
		end in
	(qwarray_set <ClauseListPair nv F> nv' wl' (ulit_vnum x) clp'' r1)
	end % match clp
	end % match (qwarray_swap...


%=============================================================================
% adding a clause to watch state
%=============================================================================

% assert ac has at least two literals
% assume the first two literals are all distinct (completeness isssue)
Define addInitialClause :=
  fun(spec nv:word)(spec F:formula)
     (#unique ws:<WatchState nv F>)
     (ac:<aclause nv F>) : #unique <WatchState nv F>.
  match ws with watch_state _ _ nv_ub wl =>
  match !ac with mk_aclause n la _ _ u c cp ceq =>
  cabbrev p2 = [array_in_bounds_implies_ltword_word0 nv n la u]
  let x1 = (uwarray_get ulit n la word0 p2) in
  % [assert] l1 is not null
  match (not (eq_ulit x1 ulit_null)) by q1 _ with ff => abort <WatchState nv F> | tt =>
  abbrev q1 = [not_tt (eq_ulit x1 ulit_null) q1] in
  
	% goal: (ltword 0x1 n) = tt
	cabbrev p3 = [aclause_lem3 nv nv_ub n la u x1 x1_eq q1]
	let x2 = (uwarray_get ulit n la 0x1 p3) in
	match (not (eq_ulit x2 ulit_null)) by q2 _ with ff => abort <WatchState nv F> | tt =>
  abbrev q2 = [not_tt (eq_ulit x2 ulit_null) q2] in
	
	% need: (ltword (ulit_vnum x1) nv') = tt
	abbrev r1 = [aclause_lem1 nv nv_ub n la u x1 x1_eq q1] in
	abbrev r2 = [aclause_lem2 nv nv_ub n la u x1 x2 x1_eq q1 x2_eq q2] in

	% index literals
	do
	(consume_unique_owned <uwarray ulit n> la)
	
	% add to index
	let ic1 = (mk_iclause nv F ac x1 x2) in
	let ic2 = (inc <iclause nv F> ic1) in
	let wl' = (add_index nv F nv_ub ic1 wl x1 r1) in
	let wl'' = (add_index nv F nv_ub ic2 wl' x2 r2) in

	% return
	(watch_state nv F nv_ub wl'')
	
	end % do
	end end end end.


Define addWatchedClause :=
  fun(spec nv:word)(spec F:formula)
     (!#unique as:<AssignState nv F>)
     (#unique ws:<WatchState nv F>)
     (ac:<aclause nv F>)
	: #unique <WatchState nv F>.
  match ws with watch_state _ _ nv_ub wl =>
  match !ac with mk_aclause n la _ _ u c cp ceq =>
	match (find_free nv F as n la u) by q2 _ with
		find_free_sat _ _ _ => abort <WatchState nv F>
	| find_free_not_found _ _ _ => abort <WatchState nv F>
	| find_free_found_one _ _ _ x u1 u2 =>
			match (find_more nv F as n la u x) with find_more_v _ y y_b =>
			do
			(consume_unique_owned <uwarray ulit n> la)
			
			% add x and y into index
			% update watched lits with x and y (new aclause needed)
			let icx = (mk_iclause nv F ac x y) in
			let icy = (inc <iclause nv F> icx) in

			% need: (ltword (ulit_vnum x) nv') = tt
			abbrev r1x = u1 in
			abbrev r1y = y_b in

			% add to index
			let wl' = (add_index nv F nv_ub icx wl x r1x) in
			let wl'' = (add_index nv F nv_ub icy wl' y r1y) in

			% return
			(watch_state nv F nv_ub wl'')
			end	% do
			end % match
	| find_free_found_two _ _ _ x y u1 u2 u3 u4 => % update index
			do
			(consume_unique_owned <uwarray ulit n> la)

			% add x and y into index
			% update watched lits with x and y (new aclause needed)
			let icx = (mk_iclause nv F ac x y) in
			let icy = (inc <iclause nv F> icx) in

			% need: (ltword (ulit_vnum x) nv') = tt
			abbrev r1x = u1 in
			abbrev r1y = u3 in

			% add to index
			let wl' = (add_index nv F nv_ub icx wl x r1x) in
			let wl'' = (add_index nv F nv_ub icy wl' y r1y) in

			% return
			(watch_state nv F nv_ub wl'')
			end	% do
	end % match (find_free...)
	end % match ac
	end % match ws


%=============================================================================
% assert one literal and propagate
%=============================================================================

Define as_eval := fun
	(spec nv:word)(spec F:formula)
	(!#unique as:<AssignState nv F>)
	(x:ulit)
	(u:{ (leword (ulit_vnum x) nv) = tt })
	.
	let asi = (inspect_unique <AssignState nv F> as) in
	match asi with assign_state _ _ nv_ub pa _ _ _ _ _ =>
	let rval = (pa_eval nv nv_ub pa x u) in
	do
	(consume_unique_owned <uwarray assignment (inc_nv nv nv_ub)> pa)
	(consume_unique_owned <AssignState nv F> asi)
	rval
	end
	end.

Inductive assert_h_t : Fun(nv:word)(F:formula).type :=
  assert_h_continue : Fun(spec nv:word)(spec F:formula)
 	                   	(nv_ub:{ (ltword nv var_upper_bound) = tt })
                      (#unique as:<AssignState nv F>)
                      (#unique wl:<qwarray <ClauseListPair nv F> (inc_nv nv nv_ub)>)
											(#unique cls':<qlist <ref <iclause nv F>>>) % updated list
                     .#unique <assert_h_t nv F>
| assert_h_conflict : Fun(spec nv:word)(spec F:formula)
 	                   	(nv_ub:{ (ltword nv var_upper_bound) = tt })
                      (#unique as:<AssignState nv F>)
                      (#unique wl:<qwarray <ClauseListPair nv F> (inc_nv nv nv_ub)>)
											(#unique cls':<qlist <ref <iclause nv F>>>) % updated list
                      (cc:<aclause nv F>)
                     .#unique <assert_h_t nv F>
.

Define assert_h := fun assert_h
	(nv:word)(spec F:formula)
 	(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(dl:word)
	(#unique as:<AssignState nv F>)
	(#unique wl:<qwarray <ClauseListPair nv F> (inc_nv nv nv_ub)>)
	(fl:ulit) % the lit just falsified
	(^#unique cls:<qlist <ref <iclause nv F>>>)
	(#unique done:<qlist <ref <iclause nv F>>>)
	:#unique <assert_h_t nv F>.
	match cls with
		qnil _ =>
			(assert_h_continue nv F nv_ub as wl done)
	| qcons _ ic_ref cls' =>
			match ic_ref with mk_ref _ ic =>
      match !ic with mk_iclause _ _ ac w1 w2 =>
      match !ac with mk_aclause n la _ _ u c cp ceq =>
      let other = match (eq_ulit fl w1) with ff => w1 | tt => w2 end in
      % [assert] "other" is in bounds
      match (leword (ulit_vnum other) nv) by q1 _ with ff => abort <assert_h_t nv F> | tt =>
						
			match (as_eval nv F as other q1) with
			  default =>
					match (find_free nv F as n la u) by q2 _ with
						find_free_sat _ _ _ =>
							do
							(consume_unique_owned <uwarray ulit n> la)
							(consume_unowned <aclause nv F> ac)
							let done' = (qcons <ref <iclause nv F>> (mk_ref <iclause nv F> ic) done) in
							(assert_h nv F nv_ub dl as wl fl cls' done')
							end
					| find_free_not_found _ _ _ => % conflict
							let done' = (qcons <ref <iclause nv F>> (mk_ref <iclause nv F> ic) done) in
							let cls'' = (qappend <ref <iclause nv F>> done' cls') in
							do
							(consume_unique_owned <uwarray ulit n> la)
							(assert_h_conflict nv F nv_ub as wl cls'' ac)
							end
					| find_free_found_one _ _ _ x u1 u2 => % unit
							do
							(consume_unique_owned <uwarray ulit n> la)
							abbrev p1 = u2 in
							let reason = (something <aclause nv F> ac) in
							let as' = (assign nv F as x reason dl p1) in
							let done' = (qcons <ref <iclause nv F>> (mk_ref <iclause nv F> ic) done) in
							(assert_h nv F nv_ub dl as' wl fl cls' done')
							end
					| find_free_found_two _ _ _ x y u1 u2 u3 u4 => % update index
							do
							(consume_unique_owned <uwarray ulit n> la)

							% remove the other from index
							% note: even if x or y is same as other, it has to be removed
							%   and added again because ic need to be updated anyway
							let wl' = (remove_index nv F nv_ub ic wl other q1) in
							
							% add x and y into index
							% update watched lits with x and y (new aclause needed)
							let icx = (mk_iclause nv F ac x y) in
							let icy = (inc <iclause nv F> icx) in

							% need: (ltword (ulit_vnum x) nv') = tt
							abbrev r1x = u1 in
							abbrev r1y = u3 in

							% add to index
							let wl'' = (add_index nv F nv_ub icx wl' x r1x) in
							let wl''' = (add_index nv F nv_ub icy wl'' y r1y) in

							% return
							% note: done is passed without including ac
							(assert_h nv F nv_ub dl as wl''' fl cls' done)
							end	% do
					end
					
			|	TT => % satisfied (skip)
					do
					(consume_unique_owned <uwarray ulit n> la)
					(consume_unowned <aclause nv F> ac)
					let done' = (qcons <ref <iclause nv F>> (mk_ref <iclause nv F> ic) done) in
					(assert_h nv F nv_ub dl as wl fl cls' done')
					end
					
			end % match (as_eval...)
			
			end % match (leword ...)
			end % match ac
			end % match ic
			end % match ic_ref
	end.


Inductive assert_t : Fun(nv:word)(F:formula).type :=
  assert_continue : Fun(spec nv:word)(spec F:formula)
 	                   	(nv_ub:{ (ltword nv var_upper_bound) = tt })
                      (#unique as:<AssignState nv F>)
                      (#unique wl:<qwarray <ClauseListPair nv F> (inc_nv nv nv_ub)>)
                     .#unique <assert_t nv F>
| assert_conflict : Fun(spec nv:word)(spec F:formula)
 	                   	(nv_ub:{ (ltword nv var_upper_bound) = tt })
                      (#unique as:<AssignState nv F>)
                      (#unique wl:<qwarray <ClauseListPair nv F> (inc_nv nv nv_ub)>)
                      (cc:<aclause nv F>)
                     .#unique <assert_t nv F>
.

Define assert := fun
	(nv:word)(spec F:formula)
 	(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(dl:word)
	(#unique as:<AssignState nv F>)
	(#unique wl:<qwarray <ClauseListPair nv F> (inc_nv nv nv_ub)>)
	(l:ulit) % the lit assigned
	(lb:{ (leword (ulit_vnum l) nv) = tt })
	: #unique <assert_t nv F>.
	abbrev nv' = (inc_nv nv nv_ub) in
	let v = (ulit_vnum l) in
	abbrev r_1 = hypjoin (leword v nv) tt by lb v_eq end in
	abbrev r = [leword_nv_implies_ltword_inc_nv nv nv_ub v r_1] in
	let dummy = (_genDummyPair nv F unit)
	match (qwarray_swap <ClauseListPair nv F> nv' wl v dummy r) with
		qwarray_swap_v _ w _ wl' =>
	match w with mkqqpair _ _ wp wn =>
	match (ulit_sign l) with
		ff =>
			let cls' = wp in
			match (assert_h nv F nv_ub dl as wl' (unegated l) cls' (qnil <ref <iclause nv F>>)) with
				assert_h_continue _ _ _ as wl'' cls'' =>
					let w = (mkqqpair <ClauseList nv F> <ClauseList nv F> cls'' wn) in
					let wl''' = (qwarray_set <ClauseListPair nv F> nv' wl'' v w r) in
					(assert_continue nv F nv_ub as wl''')
			| assert_h_conflict _ _ _ as wl'' cls'' cc =>
					let w = (mkqqpair <ClauseList nv F> <ClauseList nv F> cls'' wn) in
					let wl''' = (qwarray_set <ClauseListPair nv F> nv' wl'' v w r) in
					(assert_conflict nv F nv_ub as wl''' cc)
			end
			
	| tt =>
			let cls' = wn in
			match (assert_h nv F nv_ub dl as wl' (unegated l) cls' (qnil <ref <iclause nv F>>)) with
				assert_h_continue _ _ _ as wl'' cls'' =>
					let w = (mkqqpair <ClauseList nv F> <ClauseList nv F> wp cls'') in
					let wl''' = (qwarray_set <ClauseListPair nv F> nv' wl'' v w r) in
					(assert_continue nv F nv_ub as wl''')
			| assert_h_conflict _ _ _ as wl'' cls'' cc =>
					let w = (mkqqpair <ClauseList nv F> <ClauseList nv F> wp cls'') in
					let wl''' = (qwarray_set <ClauseListPair nv F> nv' wl'' v w r) in
					(assert_conflict nv F nv_ub as wl''' cc)
			end
	end
	
	end % match w
	end % match (qwarray_swap...


%=============================================================================
% propagate
%=============================================================================

Inductive propagate_t : Fun(nv:word)(F:formula).type :=
  propagate_continue : Fun(spec nv:word)
                      (spec F:formula)
                      (#unique as:<AssignState nv F>)
                      (#unique ws:<WatchState nv F>)
                     .#unique <propagate_t nv F>
| propagate_conflict : Fun(spec nv:word)
                      (spec F:formula)
                      (#unique as:<AssignState nv F>)
                      (#unique ws:<WatchState nv F>)
                      (cc:<aclause nv F>)
                     .#unique <propagate_t nv F>
.

Define ltword_nv_implies_ltword_word_max :
  Forall(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
        (i:word)
        (u:{ (ltword i nv) = tt }).
    { (ltword i word_max) = tt }
  :=
  foralli(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
         (i:word)
         (u:{ (ltword i nv) = tt }).
  % nv < word_max
  abbrev p1 = [ltword_implies_ltword_word_max nv var_upper_bound nv_ub] in
  [ltword_trans i nv word_max u p1]
  .

Define propagate_h :=
  fun propagate_h(nv:word)(spec F:formula)
                 (dl:word)
                 (#unique as:<AssignState nv F>)
                 (#unique ws:<WatchState nv F>)
                 : #unique <propagate_t nv F>.
  match as with assign_state _ _ nv_ub pa why dls hist hist_cur hist_end =>
  match (ltword hist_cur hist_end) with
    ff =>
      let as' = (assign_state nv F nv_ub pa why dls hist hist_cur hist_end) in
      (propagate_continue nv F as' ws)
  | tt =>
      match ws with watch_state _ _ _ wl =>
      % [assert] hist_cur is in bounds
      match (ltword hist_cur nv) by q1 _ with ff => abort <propagate_t nv F> | tt =>
      let hist' = (inspect_unique <uwarray ulit nv> hist) in
      let l = (uwarray_get ulit nv hist' hist_cur q1) in

      % [assert] l is in bounds
      match (leword (ulit_vnum l) nv) by q2 _ with ff => abort <propagate_t nv F> | tt =>
      
      do
      (consume_unique_owned <uwarray ulit nv> hist')
      let as' = (assign_state nv F nv_ub pa why dls hist hist_cur hist_end) in
      match (assert nv F nv_ub dl as' wl l q2) with
        assert_continue _ _ _ as wl =>
        	abbrev p1 = [ltword_nv_implies_ltword_word_max nv nv_ub hist_cur q1] in
        	let hist_cur' = (word_inc_safe hist_cur p1) in
          match as with assign_state _ _ nv_ub pa why dls
                                     hist _ hist_end' =>
          let as = (assign_state nv F nv_ub pa why dls
                     hist hist_cur' hist_end') in
          (propagate_h nv F dl as (watch_state nv F nv_ub wl))
          end
      | assert_conflict _ _ _ as wl cc =>
          (propagate_conflict nv F as (watch_state nv F nv_ub wl) cc)
      end
      end	% do
      end end % assert
      end % match ws
  end
  end.

Define propagate := fun
  (nv:word)(spec F:formula)
  (#unique as:<AssignState nv F>)
  (#unique ws:<WatchState nv F>)
  (dl:word)
  : #unique <propagate_t nv F>.
  (propagate_h nv F dl as ws).
