Include trusted "solver.g".


%=============================================================================
% var
%=============================================================================

% var: a word that MSB is off (reserved for lits)
Inductive var : type :=
  mk_var : Fun(w:word)(u:{ (word_msb w) = ff }).var.
  % maybe we need to specify w cannot be word0
  
Define eq_var :=
  fun(a b:var).
  match a with
    mk_var x _ =>
      match b with
        mk_var y _ => (eqword x y)
      end
  end.

Define var_num :=
  fun(v:var).
  match v with
    mk_var v' _ => v'
  end.

Define vpos :=
  fun(^#owned v:var).
  abbrev u = join (lt (to_nat word0x1f) wordlen) tt in
  match v with
    mk_var w _ => (boxWord (word_set_bit word0x1f u w))
  end.
  
Define vneg :=
  fun(^#owned v:var).
  match v with
    mk_var w _ => (boxWord w)
  end.

Define vlit :=
  fun(b:bool)(^#owned v:var).
  match b with
    ff => (vneg v)
  | tt => (vpos v)
  end.

Define lit_var : Fun(^#owned l:lit).var :=
  fun(^#owned l:lit).
  abbrev u = join (lt (to_nat word0x1f) wordlen) tt in
  let l' = (unboxWord l) in
  let w = (word_clear_bit word0x1f u l') in
  abbrev p = hypjoin (word_msb w) ff
               by w_eq [word_clear_read l' word0x1f u] end in
  (mk_var w p).

%-
Define eq_var_total :=
  foralli(a b:var).
  case a with
    mk_var aw _ =>
      case b with
        mk_var bw _ =>
          existse [eqword_tot aw bw]
          foralli(z:bool)(z_pf:{ (eqword aw bw) = z }).
          existsi z { (eq_var a b) = * }
          hypjoin (eq_var a b) z by a_eq b_eq z_pf end
      end
  end
  .
  
Total eq_var eq_var_total.

Define trusted eq_var_refl : Forall(v:var).{ (eq_var v v) = tt } := truei.

Define trusted var_num_total : Forall(v:var).Exists(w:word).{ (var_num v) = w } := truei.

Total var_num var_num_total.

Define trusted lit_var_total : Forall(l:lit).Exists(v:var).{ (lit_var l) = v } := truei.

%Total lit_sign word_msb_total.
Total lit_var lit_var_total.

Define trusted pos_total : Forall(v:var).Exists(l:lit).{ (pos v) = l } := truei.

Total pos pos_total.

Define trusted neg_total : Forall(v:var).Exists(l:lit).{ (neg v) = l } := truei.
    
Total neg neg_total.
-%


%=============================================================================
% debug solver
%=============================================================================

Define dbg_check_empty_clause :=
  fun(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
     (spec F:formula)
		 (^#unique as:<AssignState nv F>)
		 (^#unique ws:<WatchState nv F>)
     (vt:<uwarray assignment (inc_nv nv nv_ub)>)
     (vt_eq:{ vt = (uwarray_new assignment (inc_nv nv nv_ub) UN) })
		 (cc:<aclause nv F>)
	  : <aclause nv F>.
	match (derive nv nv_ub F as word0 vt vt_eq cc) with derive_return nv' _ _ _ F' cc' _ _ =>
  cast cc' by trans cong <aclause * F'> join nv' nv
                    cong <aclause nv *> join F' F
  end.

Define dbg_solve_main :=
  fun solve_main(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
                (spec F:formula)
								(#unique as:<AssignState nv F>)   % current assignment & history
								% todo: decision heuristic state
								(#unique ws:<WatchState nv F>)    % watched-literals state
                (vt:<uwarray assignment (inc_nv nv nv_ub)>)
                (vt_eq:{ vt = (uwarray_new assignment (inc_nv nv nv_ub) UN) })
								(dl:word)
               : <aclause nv F>.
	match (propagate nv F as ws dl) with
		propagate_continue _ _ as ws => % need decision
		  match (decideLit nv F as) by q1 ign with
			  nothing _ => % no more vars => SAT
          abort <aclause nv F>
			| something _ l => % continue with dl+1
					match (ltword dl nv) by q2 ign with
					  ff => % decision level is bounded by the number of variables
							abort <aclause nv F>
					| tt =>
							abbrev l' = (inspect lit l) in
							abbrev q1' = hypjoin (decideLit nv as) (something l') by q1 end in
							abbrev p1 = [decideLit_lem1 nv F as l' q1'] in
              abbrev p2 = [ltword_implies_ltword_word_max dl nv q2] in
							let dl' = (word_inc_safe dl p2) in
							let as' = (assign nv F as (to_ulit l') (nothing <aclause nv F>) dl' p1) in
							do
							(consume_unowned lit l)
							(solve_main nv nv_ub F as' ws vt vt_eq dl')
							end
					end
		  end

	| propagate_conflict _ _ as ws cc =>
			match (ltword word0 dl) by q_dl ign with
			  ff => % conflict at level 0 => UNSAT
					% The empty clause should be derived.
					% It could be proven statically, but it's checked at run-time for now.
					(dbg_check_empty_clause nv nv_ub F as ws vt vt_eq cc)

			| tt => % continue with backjump
					match (derive nv nv_ub F as dl vt vt_eq cc) with derive_return _ _ vt vt_eq _ cc' uip dl' =>
					let as' = (backtrack nv F as dl') in
					let ws' = % add the learned clause if it's not unit
						match (ltword word0 dl') with
							ff => (addWatchedClause nv F as' ws (inc <aclause nv F> cc'))
						| tt => ws
						end
					in
					let uip' = (to_ulit (inspect lit uip)) in
					match (ltword word0 (ulit_vnum uip')) with ff => abort <aclause nv F> | tt =>
					match (leword (ulit_vnum uip') nv) by q2 _ with ff => abort <aclause nv F> | tt =>
					match (unassigned nv F as' (ulit_vnum uip') q2) by q3 _ with ff => abort <aclause nv F> | tt =>
					abbrev q3' = hypjoin (unassigned as' (ulit_vnum uip')) tt by q3 end in
					let as'' = (assign nv F as' uip' (something <aclause nv F> cc') dl' q3') in
					do
					(consume_unowned lit uip)
					(solve_main nv nv_ub F as'' ws' vt vt_eq dl')
					end end end end end
			end
	end.

Define dbg_solve :=
  fun(nv:word)
     (nv_ub:{ (ltword nv var_upper_bound) = tt })
  	 (F:formula).
  match (initState nv nv_ub F) with
    init_ok _ _ _ as ws vt vt_eq =>
			(dbg_solve_main nv nv_ub F as ws vt vt_eq word0)

  | init_unsat _ _ p =>
      abort <aclause nv F>
  end.


%=============================================================================
% test cases
%=============================================================================

% variables
Define nv := 0x2.
Define trusted nv_ub : { (ltword nv var_upper_bound) = tt } := truei.
Define v1 := (mk_var word1 join (word_msb word1) ff).
Define v2 := (mk_var word2 join (word_msb word2) ff).
Define v3 := (mk_var word3 join (word_msb word3) ff).

% clauses
Define c0 := (nil lit).
Define c1 := (cons lit (vpos v1) (nil lit)).
Define c2 := (cons lit (vneg v1) (nil lit)).
Define c3 := (cons lit (vpos v1)
             (cons lit (vneg v1)
               (nil lit))).
               
Define c4 := (cons lit (vpos v2) (nil lit)).
Define c5 := (cons lit (vneg v2) (nil lit)).
Define c6 := (cons lit (vneg v1)
             (cons lit (vneg v2)
               (nil lit))).
Define c7 := (cons lit (vneg v1)
             (cons lit (vpos v2)
               (nil lit))).


% formulas
Define sat0 := (nil clause).
Define unsat0 := (cons clause c0  % empty clause
                   (nil clause)).
Define sat1 := (cons clause c1		% v1
                 (nil clause)).
Define unsat1 := (cons clause c1	% v1
                 (cons clause c2  % -v1
                   (nil clause))).
Define unsat1' := (cons clause c1
                  (cons clause c1
                  (cons clause c2
                    (nil clause)))).
Define sat1' := (cons clause c3		% v1 -v1
                  (nil clause)).
Define sat1'' := (cons clause c3	% v1 -v1
                 (cons clause c1	% v1
                  (nil clause))).
Define sat2 := (cons clause c1	% v1
               (cons clause c4	% v2
                 (nil clause))).
Define unsat2 := (cons clause c1	% v1
                 (cons clause c4	% v2
                 (cons clause c6	% -v1 -v2
                   (nil clause)))).

Define unsat2' := (cons clause c1	% v1
                 (cons clause c7	% -v1 v2
                 (cons clause c6	% -v1 -v2
                   (nil clause)))).

% unit test
Define test :=
  fun(f:formula).
  (solve_impl nv nv_ub f).

% trivial SAT
%Interpret (test sat0). % empty formula
%Interpret (test sat1). % single variable
%Interpret (test sat2).  % two variables

% tautalogy test
%Interpret (test sat1').
%Interpret (test sat1'').

% UNSAT at init stage
%Interpret (test unsat0). % the empty clause in the formula
%Interpret (test unsat1). % contradictory unit clauses
%Interpret (test unsat1'). % with duplicated clauses

% UNSAT at decision level zero
%Interpret (dbg_solve nv nv_ub unsat2).
Interpret (test unsat2).
Interpret (test unsat2').
